/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpConnectionlessSocket;
import android.nfc.LlcpPacket;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class LlcpConnectionlessSocket {
    private static final String TAG = "LlcpConnectionlessSocket";
    protected int mHandle;
    protected ILlcpConnectionlessSocket mService;

    LlcpConnectionlessSocket(ILlcpConnectionlessSocket iLlcpConnectionlessSocket, int n) {
        this.mService = iLlcpConnectionlessSocket;
        this.mHandle = n;
    }

    public void close() {
        try {
            this.mService.close(this.mHandle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in close(): ", remoteException);
            return;
        }
    }

    public int getSap() {
        try {
            int n = this.mService.getSap(this.mHandle);
            return n;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return 0;
        }
    }

    public LlcpPacket receiveFrom() throws IOException {
        block3: {
            try {
                LlcpPacket llcpPacket = this.mService.receiveFrom(this.mHandle);
                if (llcpPacket == null) break block3;
                return llcpPacket;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in receiveFrom(): ", remoteException);
                return null;
            }
        }
        throw new IOException();
    }

    public void sendTo(LlcpPacket llcpPacket) throws IOException {
        try {
            if (ErrorCodes.isError(this.mService.sendTo(this.mHandle, llcpPacket))) {
                throw new IOException();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in sendTo(): ", remoteException);
        }
    }
}

