/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.ILlcpSocket;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import java.io.IOException;

public class LlcpSocket {
    private static final String TAG = "LlcpSocket";
    protected int mHandle;
    protected ILlcpSocket mService;

    public LlcpSocket(ILlcpSocket iLlcpSocket, int n) {
        this.mService = iLlcpSocket;
        this.mHandle = n;
    }

    static LlcpException convertErrorToLlcpException(int n) {
        return LlcpSocket.convertErrorToLlcpException(n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static LlcpException convertErrorToLlcpException(int n, String string2) {
        String string3 = string2 == null ? "" : " (" + string2 + ")";
        switch (n) {
            default: {
                return new LlcpException("Unkown error code " + n + string3);
            }
            case -10: {
                return new LlcpException("Error during the creation of an Llcp socket" + string3);
            }
            case -9: {
                return new LlcpException("Not enough ressources are available" + string3);
            }
            case -11: 
        }
        return new LlcpException("Socket not connected to an Llcp Service" + string3);
    }

    public void close() throws IOException {
        try {
            if (ErrorCodes.isError(this.mService.close(this.mHandle))) {
                throw new IOException();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in close(): ", remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n) throws IOException, LlcpException {
        try {
            int n2 = this.mService.connect(this.mHandle, n);
            if (!ErrorCodes.isError(n2)) return;
            if (n2 != -1) throw LlcpSocket.convertErrorToLlcpException(n2);
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in accept(): ", remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String string2) throws IOException, LlcpException {
        try {
            int n = this.mService.connectByName(this.mHandle, string2);
            if (!ErrorCodes.isError(n)) return;
            if (n != -1) throw LlcpSocket.convertErrorToLlcpException(n);
            throw new IOException();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in accept(): ", remoteException);
        }
    }

    public int getLocalSap() {
        try {
            int n = this.mService.getLocalSap(this.mHandle);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getLocalSap(): ", remoteException);
            return 0;
        }
    }

    public int getLocalSocketMiu() {
        try {
            int n = this.mService.getLocalSocketMiu(this.mHandle);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getLocalSocketMiu(): ", remoteException);
            return 0;
        }
    }

    public int getLocalSocketRw() {
        try {
            int n = this.mService.getLocalSocketRw(this.mHandle);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getLocalSocketRw(): ", remoteException);
            return 0;
        }
    }

    public int getRemoteSocketMiu() throws LlcpException {
        int n;
        block3: {
            try {
                n = this.mService.getRemoteSocketMiu(this.mHandle);
                if (n == -11) break block3;
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in getRemoteSocketMiu(): ", remoteException);
                return 0;
            }
        }
        throw LlcpSocket.convertErrorToLlcpException(n);
    }

    public int getRemoteSocketRw() throws LlcpException {
        int n;
        block3: {
            try {
                n = this.mService.getRemoteSocketRw(this.mHandle);
                if (n == -11) break block3;
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in getRemoteSocketRw(): ", remoteException);
                return 0;
            }
        }
        throw LlcpSocket.convertErrorToLlcpException(n);
    }

    public int receive(byte[] byArray) throws IOException {
        int n;
        block3: {
            n = 0;
            n = this.mService.receive(this.mHandle, byArray);
            if (n != 0) break block3;
            try {
                throw new IOException();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in receive(): ", remoteException);
            }
        }
        return n;
    }

    public void send(byte[] byArray) throws IOException {
        try {
            if (ErrorCodes.isError(this.mService.send(this.mHandle, byArray))) {
                throw new IOException();
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in send(): ", remoteException);
        }
    }
}

