/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.IP2pInitiator;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pInitiator
extends P2pDevice {
    private static final String TAG = "P2pInitiator";
    private final IP2pInitiator mService;

    P2pInitiator(IP2pInitiator iP2pInitiator, int n) {
        this.mService = iP2pInitiator;
        this.mHandle = n;
    }

    @Override
    public byte[] getGeneralBytes() {
        try {
            byte[] byArray = this.mService.getGeneralBytes(this.mHandle);
            return byArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getGeneralBytes(): ", remoteException);
            return null;
        }
    }

    @Override
    public int getMode() {
        return 1;
    }

    public byte[] receive() throws IOException {
        byte[] byArray;
        block3: {
            try {
                byArray = this.mService.receive(this.mHandle);
                if (byArray != null) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in receive(): ", remoteException);
                return null;
            }
            throw new IOException("Tag has been lost");
        }
        return byArray;
    }

    public void send(byte[] byArray) throws IOException {
        try {
            if (!this.mService.send(this.mHandle, byArray)) {
                throw new IOException("Tag has been lost");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in send(): ", remoteException);
        }
    }
}

