/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.IP2pTarget;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.NfcException;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pTarget
extends P2pDevice {
    private static final String TAG = "P2pTarget";
    private final boolean isClosed;
    private boolean isConnected = false;
    private final IP2pTarget mService;

    P2pTarget(IP2pTarget iP2pTarget, int n) {
        this.isClosed = false;
        this.mService = iP2pTarget;
        this.mHandle = n;
    }

    public void checkState() throws NfcException {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws NfcException {
        this.checkState();
        if (this.isConnected) {
            throw new NfcException("Already connected");
        }
        try {
            int n = this.mService.connect(this.mHandle);
            if (ErrorCodes.isError(n) && n == -1) {
                throw new NfcException("Failed to connect");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in connect(): ", remoteException);
            return;
        }
        {
            this.isConnected = true;
            return;
        }
    }

    public void disconnect() throws NfcException {
        this.checkState();
        try {
            this.mService.disconnect(this.mHandle);
            this.isConnected = true;
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in disconnect(): ", remoteException);
            return;
        }
    }

    @Override
    public byte[] getGeneralBytes() throws IOException {
        try {
            if (this.isConnected) {
                return this.mService.getGeneralBytes(this.mHandle);
            }
            throw new IOException("Target not in connected state");
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getGeneralBytes(): ", remoteException);
            return null;
        }
    }

    @Override
    public int getMode() {
        return 0;
    }

    public byte[] transceive(byte[] byArray) throws IOException, NfcException {
        byte[] byArray2;
        block3: {
            this.checkState();
            try {
                byArray2 = this.mService.transceive(this.mHandle, byArray);
                if (byArray2 != null) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in transceive(): ", remoteException);
                return null;
            }
            throw new IOException("Transceive failed");
        }
        return byArray2;
    }
}

