/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothHeadset;
import android.net.TrafficStats;
import android.os.BatteryStats;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.WorkSource;
import android.telephony.SignalStrength;
import android.util.Log;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.JournaledFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class BatteryStatsImpl
extends BatteryStats {
    private static final String BATCHED_WAKELOCK_NAME = "*overflow*";
    private static final int BATTERY_PLUGGED_NONE = 0;
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_HISTORY = false;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    private static final int MAGIC = -1166707595;
    private static final int MAX_HISTORY_ITEMS = 2000;
    private static final int MAX_MAX_HISTORY_ITEMS = 3000;
    private static final int MAX_WAKELOCKS_PER_UID = 30;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_UPDATE_WAKELOCKS = 1;
    private static final int[] PROC_WAKELOCKS_FORMAT;
    private static final String TAG = "BatteryStatsImpl";
    private static final int VERSION = 52;
    private static int sKernelWakelockUpdateVersion;
    private static int sNumSpeedSteps;
    boolean mAudioOn;
    StopwatchTimer mAudioOnTimer;
    long mBatteryLastRealtime;
    long mBatteryLastUptime;
    long mBatteryRealtime;
    long mBatteryUptime;
    boolean mBluetoothOn;
    StopwatchTimer mBluetoothOnTimer;
    private int mBluetoothPingCount;
    private int mBluetoothPingStart = -1;
    BluetoothHeadset mBtHeadset;
    private BatteryCallback mCallback;
    int mChangedStates = 0;
    int mDischargeCurrentLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    private final JournaledFile mFile;
    final ArrayList<StopwatchTimer> mFullTimers;
    final ArrayList<StopwatchTimer> mFullWifiLockTimers;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mGpsNesting;
    private final MyHandler mHandler;
    boolean mHaveBatteryLevel = false;
    int mHighDischargeAmountSinceCharge;
    BatteryStats.HistoryItem mHistory;
    long mHistoryBaseTime;
    BatteryStats.HistoryItem mHistoryCache;
    final BatteryStats.HistoryItem mHistoryCur;
    BatteryStats.HistoryItem mHistoryEnd;
    private BatteryStats.HistoryItem mHistoryIterator;
    BatteryStats.HistoryItem mHistoryLastEnd;
    Counter mInputEventCounter;
    private final HashMap<String, SamplingTimer> mKernelWakelockStats;
    final ArrayList<StopwatchTimer> mLastPartialTimers;
    long mLastRealtime;
    long mLastUptime;
    long mLastWriteTime = 0L;
    int mLowDischargeAmountSinceCharge;
    private long[] mMobileDataRx;
    private long[] mMobileDataTx;
    int mNumHistoryItems;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    final ArrayList<StopwatchTimer> mPartialTimers;
    Parcel mPendingWrite = null;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer;
    private int mPhoneSimStateRaw = -1;
    private final Map<String, KernelWakelockStats> mProcWakelockFileStats;
    private final long[] mProcWakelocksData;
    private final String[] mProcWakelocksName;
    private long mRadioDataStart;
    private long mRadioDataUptime;
    long mRealtime;
    long mRealtimeStart;
    boolean mRecordingHistory = true;
    final ArrayList<StopwatchTimer> mScanWifiLockTimers;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer;
    boolean mScreenOn;
    StopwatchTimer mScreenOnTimer;
    int mSensorNesting;
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers;
    boolean mShuttingDown;
    int mStartCount;
    private long[] mTotalDataRx;
    private long[] mTotalDataTx;
    long mTrackBatteryPastRealtime;
    long mTrackBatteryPastUptime;
    long mTrackBatteryRealtimeStart;
    long mTrackBatteryUptimeStart;
    private HashMap<String, Integer> mUidCache;
    final SparseArray<Uid> mUidStats = new SparseArray();
    final ArrayList<Unpluggable> mUnpluggables;
    long mUnpluggedBatteryRealtime;
    long mUnpluggedBatteryUptime;
    long mUptime;
    long mUptimeStart;
    boolean mVideoOn;
    StopwatchTimer mVideoOnTimer;
    int mWakeLockNesting;
    int mWifiFullLockNesting = 0;
    int mWifiMulticastNesting = 0;
    final ArrayList<StopwatchTimer> mWifiMulticastTimers;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    int mWifiOnUid = -1;
    final ArrayList<StopwatchTimer> mWifiRunningTimers;
    int mWifiScanLockNesting = 0;
    final ArrayList<StopwatchTimer> mWindowTimers;
    final ReentrantLock mWriteLock;

    static {
        sKernelWakelockUpdateVersion = 0;
        PROC_WAKELOCKS_FORMAT = new int[]{4105, 8201, 9, 9, 9, 8201};
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

            @Override
            public BatteryStatsImpl createFromParcel(Parcel parcel) {
                return new BatteryStatsImpl(parcel);
            }

            public BatteryStatsImpl[] newArray(int n) {
                return new BatteryStatsImpl[n];
            }
        };
    }

    public BatteryStatsImpl() {
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mScanWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mUnpluggables = new ArrayList();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[14];
        this.mMobileDataTx = new long[4];
        this.mMobileDataRx = new long[4];
        this.mTotalDataTx = new long[4];
        this.mTotalDataRx = new long[4];
        this.mKernelWakelockStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mUidCache = new HashMap();
        this.mWriteLock = new ReentrantLock();
        this.mFile = null;
        this.mHandler = null;
    }

    public BatteryStatsImpl(Parcel parcel) {
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mScanWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mUnpluggables = new ArrayList();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[14];
        this.mMobileDataTx = new long[4];
        this.mMobileDataRx = new long[4];
        this.mTotalDataTx = new long[4];
        this.mTotalDataRx = new long[4];
        this.mKernelWakelockStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mUidCache = new HashMap();
        this.mWriteLock = new ReentrantLock();
        this.mFile = null;
        this.mHandler = null;
        this.readFromParcel(parcel);
    }

    public BatteryStatsImpl(String string2) {
        long l;
        long l2;
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mScanWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mUnpluggables = new ArrayList();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[14];
        this.mMobileDataTx = new long[4];
        this.mMobileDataRx = new long[4];
        this.mTotalDataTx = new long[4];
        this.mTotalDataRx = new long[4];
        this.mKernelWakelockStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mUidCache = new HashMap();
        this.mWriteLock = new ReentrantLock();
        this.mFile = new JournaledFile(new File(string2), new File(string2 + ".tmp"));
        this.mHandler = new MyHandler();
        this.mStartCount = 1 + this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mUnpluggables);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mUnpluggables);
        }
        this.mInputEventCounter = new Counter(this.mUnpluggables);
        this.mPhoneOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mUnpluggables);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mUnpluggables);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mUnpluggables);
        }
        this.mWifiOnTimer = new StopwatchTimer(null, -3, null, this.mUnpluggables);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -4, null, this.mUnpluggables);
        this.mBluetoothOnTimer = new StopwatchTimer(null, -5, null, this.mUnpluggables);
        this.mAudioOnTimer = new StopwatchTimer(null, -6, null, this.mUnpluggables);
        this.mVideoOnTimer = new StopwatchTimer(null, -7, null, this.mUnpluggables);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        this.initTimes();
        this.mTrackBatteryPastUptime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mTrackBatteryUptimeStart = l2 = 1000L * SystemClock.uptimeMillis();
        this.mUptimeStart = l2;
        this.mTrackBatteryRealtimeStart = l = 1000L * SystemClock.elapsedRealtime();
        this.mRealtimeStart = l;
        this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(this.mUptimeStart);
        this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(this.mRealtimeStart);
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargeCurrentLevel = 0;
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
    }

    private void doDataPlug(long[] lArray, long l) {
        lArray[1] = lArray[3];
        lArray[3] = -1L;
    }

    private void doDataUnplug(long[] lArray, long l) {
        lArray[3] = l;
    }

    private int fixPhoneServiceState(int n, int n2) {
        if (this.mPhoneSimStateRaw == 1 && n == 1 && n2 > 0) {
            n = 0;
        }
        return n;
    }

    private int getCurrentBluetoothPingCount() {
        if (this.mBtHeadset != null) {
            return this.mBtHeadset.getBatteryUsageHint();
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCurrentRadioDataUptime() {
        File file;
        block5: {
            file = new File("/sys/devices/virtual/net/rmnet0/awake_time_ms");
            if (file.exists()) break block5;
            return 0L;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            long l = Long.parseLong(string2);
            return l * 1000L;
        }
        catch (IOException iOException) {
            return 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private long getTcpBytes(long l, long[] lArray, int n) {
        if (n == 1) {
            return lArray[1];
        }
        if (n == 3) {
            if (lArray[3] < 0L) {
                return lArray[1];
            }
            return l - lArray[3];
        }
        if (n == 0) {
            return l - lArray[2] + lArray[0];
        }
        return l - lArray[2];
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Map<String, KernelWakelockStats> parseProcWakelocks(byte[] byArray, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < n && byArray[n3] != 10 && byArray[n3] != 0; ++n3) {
        }
        int n4 = n2 = n3 + 1;
        synchronized (this) {
            Map<String, KernelWakelockStats> map = this.mProcWakelockFileStats;
            sKernelWakelockUpdateVersion = 1 + sKernelWakelockUpdateVersion;
            int n5 = 0;
            boolean bl = true;
            while (true) {
                if (!bl || (bl = false) || !true) {
                    if (n2 < n && byArray[n2] != 10 && byArray[n2] != 0) {
                        ++n2;
                        continue;
                    }
                    if (n2 < n) {
                        ++n2;
                    }
                    String[] stringArray = this.mProcWakelocksName;
                    long[] lArray = this.mProcWakelocksData;
                    int n6 = n4;
                    while (true) {
                        if (n6 < n2) {
                            if ((0x80 & byArray[n6]) != 0) {
                                byArray[n6] = 63;
                            }
                        } else {
                            boolean bl2 = Process.parseProcLine((byte[])byArray, (int)n4, (int)n2, (int[])PROC_WAKELOCKS_FORMAT, (String[])stringArray, (long[])lArray, null);
                            String string2 = stringArray[0];
                            int n7 = (int)lArray[1];
                            long l = (500L + lArray[2]) / 1000L;
                            if (!bl2 || string2.length() <= 0) break;
                            if (!map.containsKey(string2)) {
                                map.put(string2, new KernelWakelockStats(n7, l, sKernelWakelockUpdateVersion));
                                ++n5;
                                break;
                            }
                            KernelWakelockStats kernelWakelockStats = map.get(string2);
                            if (kernelWakelockStats.mVersion == sKernelWakelockUpdateVersion) {
                                kernelWakelockStats.mCount = n7 + kernelWakelockStats.mCount;
                                kernelWakelockStats.mTotalTime = l + kernelWakelockStats.mTotalTime;
                                break;
                            }
                            kernelWakelockStats.mCount = n7;
                            kernelWakelockStats.mTotalTime = l;
                            kernelWakelockStats.mVersion = sKernelWakelockUpdateVersion;
                            ++n5;
                            break;
                        }
                        ++n6;
                    }
                    n4 = n2;
                }
                if (n2 >= n) break;
                n2 = n4;
            }
            if (map.size() != n5) {
                Iterator<KernelWakelockStats> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().mVersion == sKernelWakelockUpdateVersion) continue;
                    iterator.remove();
                }
            }
            return map;
        }
    }

    static byte[] readFully(FileInputStream fileInputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[fileInputStream.available()];
        int n2;
        while ((n2 = fileInputStream.read(byArray, n, byArray.length - n)) > 0) {
            int n3 = fileInputStream.available();
            if (n3 <= byArray.length - (n += n2)) continue;
            byte[] byArray2 = new byte[n + n3];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Map<String, KernelWakelockStats> readKernelWakelockStats() {
        int n;
        int n2;
        byte[] byArray = new byte[4096];
        try {
            FileInputStream fileInputStream = new FileInputStream("/proc/wakelocks");
            n2 = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n2 <= 0) return this.parseProcWakelocks(byArray, n2);
            n = 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        while (n < n2) {
            block5: {
                byte by = byArray[n];
                if (by != 0) break block5;
                n2 = n;
                return this.parseProcWakelocks(byArray, n2);
            }
            ++n;
        }
        return this.parseProcWakelocks(byArray, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void readSummaryFromParcel(Parcel parcel) {
        int n = parcel.readInt();
        if (n != 52) {
            Slog.w("BatteryStats", "readFromParcel: version got " + n + ", expected " + 52 + "; erasing old stats");
            return;
        }
        this.readHistory(parcel);
        this.mStartCount = parcel.readInt();
        this.mBatteryUptime = parcel.readLong();
        this.mBatteryRealtime = parcel.readLong();
        this.mUptime = parcel.readLong();
        this.mRealtime = parcel.readLong();
        this.mDischargeUnplugLevel = parcel.readInt();
        this.mDischargeCurrentLevel = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = parcel.readInt();
        this.mStartCount = 1 + this.mStartCount;
        this.mScreenOn = false;
        this.mScreenOnTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mInputEventCounter.readSummaryFromParcelLocked(parcel);
        this.mPhoneOn = false;
        this.mPhoneOnTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(parcel);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(parcel);
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer.readSummaryFromParcelLocked(parcel);
        int n2 = parcel.readInt();
        if (n2 > 10000) {
            Slog.w(TAG, "File corrupt: too many kernel wake locks " + n2);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (parcel.readInt() == 0) continue;
            this.getKernelWakelockTimerLocked(parcel.readString()).readSummaryFromParcelLocked(parcel);
        }
        sNumSpeedSteps = parcel.readInt();
        int n3 = parcel.readInt();
        if (n3 > 10000) {
            Slog.w(TAG, "File corrupt: too many uids " + n3);
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = parcel.readInt();
            Uid uid = new Uid(n6);
            this.mUidStats.put(n6, uid);
            uid.mWifiRunning = false;
            if (parcel.readInt() != 0) {
                uid.mWifiRunningTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mFullWifiLockOut = false;
            if (parcel.readInt() != 0) {
                uid.mFullWifiLockTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mScanWifiLockOut = false;
            if (parcel.readInt() != 0) {
                uid.mScanWifiLockTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mWifiMulticastEnabled = false;
            if (parcel.readInt() != 0) {
                uid.mWifiMulticastTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mAudioTurnedOn = false;
            if (parcel.readInt() != 0) {
                uid.mAudioTurnedOnTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mVideoTurnedOn = false;
            if (parcel.readInt() != 0) {
                uid.mVideoTurnedOnTimer.readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                if (uid.mUserActivityCounters == null) {
                    uid.initUserActivityLocked();
                }
                for (int i = 0; i < 7; ++i) {
                    uid.mUserActivityCounters[i].readSummaryFromParcelLocked(parcel);
                }
            }
            if ((n5 = parcel.readInt()) > 100) {
                Slog.w(TAG, "File corrupt: too many wake locks " + n5);
                return;
            }
            for (int i = 0; i < n5; ++i) {
                String string2 = parcel.readString();
                if (parcel.readInt() != 0) {
                    uid.getWakeTimerLocked(string2, 1).readSummaryFromParcelLocked(parcel);
                }
                if (parcel.readInt() != 0) {
                    uid.getWakeTimerLocked(string2, 0).readSummaryFromParcelLocked(parcel);
                }
                if (parcel.readInt() == 0) continue;
                uid.getWakeTimerLocked(string2, 2).readSummaryFromParcelLocked(parcel);
            }
            int n7 = parcel.readInt();
            if (n7 > 1000) {
                Slog.w(TAG, "File corrupt: too many sensors " + n7);
                return;
            }
            for (int i = 0; i < n7; ++i) {
                int n8 = parcel.readInt();
                if (parcel.readInt() == 0) continue;
                uid.getSensorTimerLocked(n8, true).readSummaryFromParcelLocked(parcel);
            }
            int n9 = parcel.readInt();
            if (n9 > 1000) {
                Slog.w(TAG, "File corrupt: too many processes " + n9);
                return;
            }
            for (int i = 0; i < n9; ++i) {
                int n10;
                long l;
                long l2;
                Uid.Proc proc = uid.getProcessStatsLocked(parcel.readString());
                proc.mLoadedUserTime = l2 = parcel.readLong();
                proc.mUserTime = l2;
                proc.mLoadedSystemTime = l = parcel.readLong();
                proc.mSystemTime = l;
                proc.mLoadedStarts = n10 = parcel.readInt();
                proc.mStarts = n10;
                int n11 = parcel.readInt();
                if (n11 > 100) {
                    Slog.w(TAG, "File corrupt: too many speed bins " + n11);
                    return;
                }
                proc.mSpeedBins = new SamplingCounter[n11];
                for (int j = 0; j < n11; ++j) {
                    if (parcel.readInt() == 0) continue;
                    proc.mSpeedBins[j] = new SamplingCounter(this.mUnpluggables);
                    proc.mSpeedBins[j].readSummaryFromParcelLocked(parcel);
                }
                if (!proc.readExcessivePowerFromParcelLocked(parcel)) return;
            }
            int n12 = parcel.readInt();
            if (n12 > 10000) {
                Slog.w(TAG, "File corrupt: too many packages " + n12);
                return;
            }
            for (int i = 0; i < n12; ++i) {
                int n13;
                String string3 = parcel.readString();
                Uid.Pkg pkg = uid.getPackageStatsLocked(string3);
                pkg.mLoadedWakeups = n13 = parcel.readInt();
                pkg.mWakeups = n13;
                int n14 = parcel.readInt();
                if (n14 > 1000) {
                    Slog.w(TAG, "File corrupt: too many services " + n14);
                    return;
                }
                for (int j = 0; j < n14; ++j) {
                    int n15;
                    int n16;
                    long l;
                    Uid.Pkg.Serv serv = uid.getServiceStatsLocked(string3, parcel.readString());
                    serv.mLoadedStartTime = l = parcel.readLong();
                    serv.mStartTime = l;
                    serv.mLoadedStarts = n16 = parcel.readInt();
                    serv.mStarts = n16;
                    serv.mLoadedLaunches = n15 = parcel.readInt();
                    serv.mLaunches = n15;
                }
            }
            uid.mLoadedTcpBytesReceived = parcel.readLong();
            uid.mLoadedTcpBytesSent = parcel.readLong();
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAllPhoneStateLocked(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        this.mPhoneServiceStateRaw = n;
        this.mPhoneSimStateRaw = n2;
        this.mPhoneSignalStrengthBinRaw = n3;
        if (n2 == 1 && n == 1 && n3 > 0) {
            n = 0;
        }
        if (n == 3) {
            n3 = -1;
        } else {
            bl2 = false;
            bl = false;
            if (n != 0) {
                bl2 = false;
                bl = false;
                if (n == 1) {
                    bl = true;
                    boolean bl3 = this.mPhoneSignalScanningTimer.isRunningLocked();
                    bl2 = false;
                    n3 = 0;
                    if (!bl3) {
                        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                        historyItem.states = 0x4000000 | historyItem.states;
                        bl2 = true;
                        this.mPhoneSignalScanningTimer.startRunningLocked(this);
                        n3 = 0;
                    }
                }
            }
        }
        if (!bl && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFBFFFFFF & historyItem.states;
            bl2 = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(this);
        }
        if (this.mPhoneServiceState != n) {
            this.mHistoryCur.states = 0xFFFFF0FF & this.mHistoryCur.states | n << 8;
            bl2 = true;
            this.mPhoneServiceState = n;
        }
        if (this.mPhoneSignalStrengthBin != n3) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(this);
            }
            if (n3 >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[n3].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n3].startRunningLocked(this);
                }
                this.mHistoryCur.states = 0xFFFFFF0F & this.mHistoryCur.states | n3 << 4;
                bl2 = true;
            } else {
                this.stopAllSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = n3;
        }
        if (bl2) {
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHistoryRecordLocked(long l) {
        block7: {
            block6: {
                if (!this.mHaveBatteryLevel || !this.mRecordingHistory) break block6;
                if (this.mHistoryEnd != null && this.mHistoryEnd.cmd == 0 && l + this.mHistoryBaseTime < 2000L + this.mHistoryEnd.time && ((this.mHistoryEnd.states ^ this.mHistoryCur.states) & this.mChangedStates) == 0) {
                    if (this.mHistoryLastEnd != null && this.mHistoryLastEnd.cmd == 0 && this.mHistoryLastEnd.same(this.mHistoryCur)) {
                        this.mHistoryLastEnd.next = null;
                        this.mHistoryEnd.next = this.mHistoryCache;
                        this.mHistoryCache = this.mHistoryEnd;
                        this.mHistoryEnd = this.mHistoryLastEnd;
                        this.mHistoryLastEnd = null;
                        return;
                    }
                    this.mChangedStates |= this.mHistoryEnd.states ^ this.mHistoryCur.states;
                    this.mHistoryEnd.setTo(this.mHistoryEnd.time, (byte)0, this.mHistoryCur);
                    return;
                }
                this.mChangedStates = 0;
                if (this.mNumHistoryItems == 2000 || this.mNumHistoryItems == 3000) {
                    this.addHistoryRecordLocked(l, (byte)2);
                }
                if (this.mNumHistoryItems < 2000 || this.mHistoryEnd == null || this.mHistoryEnd.batteryLevel != this.mHistoryCur.batteryLevel || this.mNumHistoryItems < 3000 && (0x78000000 & (this.mHistoryEnd.states ^ this.mHistoryCur.states)) != 0) break block7;
            }
            return;
        }
        this.addHistoryRecordLocked(l, (byte)0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHistoryRecordLocked(long l, byte by) {
        BatteryStats.HistoryItem historyItem = this.mHistoryCache;
        if (historyItem != null) {
            this.mHistoryCache = historyItem.next;
        } else {
            historyItem = new BatteryStats.HistoryItem();
        }
        historyItem.setTo(l + this.mHistoryBaseTime, by, this.mHistoryCur);
        this.addHistoryRecordLocked(historyItem);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem historyItem) {
        this.mNumHistoryItems = 1 + this.mNumHistoryItems;
        historyItem.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = historyItem;
            this.mHistoryEnd = historyItem;
            return;
        }
        this.mHistoryEnd = historyItem;
        this.mHistory = historyItem;
    }

    void clearHistoryLocked() {
        if (this.mHistory != null) {
            this.mHistoryEnd.next = this.mHistoryCache;
            this.mHistoryCache = this.mHistory;
            this.mHistoryEnd = null;
            this.mHistoryLastEnd = null;
            this.mHistory = null;
        }
        this.mNumHistoryItems = 0;
        this.mHistoryBaseTime = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitPendingDataToDisk() {
        ReentrantLock reentrantLock;
        Parcel parcel;
        synchronized (this) {
            parcel = this.mPendingWrite;
            this.mPendingWrite = null;
            if (parcel == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mFile.chooseForWrite());
            fileOutputStream.write(parcel.marshall());
            fileOutputStream.flush();
            FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            this.mFile.commit();
            parcel.recycle();
            reentrantLock = this.mWriteLock;
        }
        catch (IOException iOException) {
            try {
                Slog.w("BatteryStats", "Error writing battery statistics", iOException);
                this.mFile.rollback();
                parcel.recycle();
                reentrantLock = this.mWriteLock;
            }
            catch (Throwable throwable) {
                parcel.recycle();
                this.mWriteLock.unlock();
                throw throwable;
            }
        }
        reentrantLock.unlock();
    }

    @Override
    public long computeBatteryRealtime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mBatteryRealtime + this.getBatteryRealtimeLocked(l);
            }
            case 1: {
                return this.mBatteryLastRealtime;
            }
            case 2: {
                return this.getBatteryRealtimeLocked(l);
            }
            case 3: 
        }
        return this.getBatteryRealtimeLocked(l) - this.mUnpluggedBatteryRealtime;
    }

    @Override
    public long computeBatteryUptime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mBatteryUptime + this.getBatteryUptime(l);
            }
            case 1: {
                return this.mBatteryLastUptime;
            }
            case 2: {
                return this.getBatteryUptime(l);
            }
            case 3: 
        }
        return this.getBatteryUptimeLocked(l) - this.mUnpluggedBatteryUptime;
    }

    @Override
    public long computeRealtime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mRealtime + (l - this.mRealtimeStart);
            }
            case 1: {
                return this.mLastRealtime;
            }
            case 2: {
                return l - this.mRealtimeStart;
            }
            case 3: 
        }
        return l - this.mTrackBatteryRealtimeStart;
    }

    @Override
    public long computeUptime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mUptime + (l - this.mUptimeStart);
            }
            case 1: {
                return this.mLastUptime;
            }
            case 2: {
                return l - this.mUptimeStart;
            }
            case 3: 
        }
        return l - this.mTrackBatteryUptimeStart;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void distributeWorkLocked(int n) {
        Uid uid = this.mUidStats.get(1010);
        if (uid != null) {
            long l = this.computeBatteryRealtime(1000L * SystemClock.elapsedRealtime(), n);
            for (Uid.Proc proc : uid.mProcessStats.values()) {
                int n2;
                long l2 = this.getGlobalWifiRunningTime(l, n);
                for (int i = 0; i < (n2 = this.mUidStats.size()); ++i) {
                    int n3;
                    long l3;
                    Uid uid2 = this.mUidStats.valueAt(i);
                    if (uid2.mUid == 1010 || (l3 = uid2.getWifiRunningTime(l, n)) <= 0L) continue;
                    Uid.Proc proc2 = uid2.getProcessStatsLocked("*wifi*");
                    long l4 = l3 * proc.getUserTime(n) / l2;
                    proc2.mUserTime = l4 + proc2.mUserTime;
                    proc.mUserTime -= l4;
                    long l5 = l3 * proc.getSystemTime(n) / l2;
                    proc2.mSystemTime = l5 + proc2.mSystemTime;
                    proc.mSystemTime -= l5;
                    long l6 = l3 * proc.getForegroundTime(n) / l2;
                    proc2.mForegroundTime = l6 + proc2.mForegroundTime;
                    proc.mForegroundTime -= l6;
                    for (int j = 0; j < (n3 = proc.mSpeedBins.length); ++j) {
                        SamplingCounter samplingCounter = proc.mSpeedBins[j];
                        if (samplingCounter == null) continue;
                        long l7 = l3 * (long)samplingCounter.getCountLocked(n) / l2;
                        SamplingCounter samplingCounter2 = proc2.mSpeedBins[j];
                        if (samplingCounter2 == null) {
                            ArrayList<Unpluggable> arrayList = this.mUnpluggables;
                            proc2.mSpeedBins[j] = samplingCounter2 = new SamplingCounter(arrayList);
                        }
                        samplingCounter2.mCount.addAndGet((int)l7);
                        samplingCounter.mCount.addAndGet((int)(-l7));
                    }
                    l2 -= l3;
                }
            }
        }
    }

    public void doPlugLocked(long l, long l2) {
        for (int i = this.mUidStats.size() - 1; i >= 0; --i) {
            Uid uid = this.mUidStats.valueAt(i);
            if (uid.mStartedTcpBytesReceived >= 0L) {
                uid.mCurrentTcpBytesReceived = uid.computeCurrentTcpBytesReceived();
                uid.mStartedTcpBytesReceived = -1L;
            }
            if (uid.mStartedTcpBytesSent < 0L) continue;
            uid.mCurrentTcpBytesSent = uid.computeCurrentTcpBytesSent();
            uid.mStartedTcpBytesSent = -1L;
        }
        for (int i = this.mUnpluggables.size() - 1; i >= 0; --i) {
            this.mUnpluggables.get(i).plug(l, l2);
        }
        this.doDataPlug(this.mMobileDataRx, TrafficStats.getMobileRxBytes());
        this.doDataPlug(this.mMobileDataTx, TrafficStats.getMobileTxBytes());
        this.doDataPlug(this.mTotalDataRx, TrafficStats.getTotalRxBytes());
        this.doDataPlug(this.mTotalDataTx, TrafficStats.getTotalTxBytes());
        this.mRadioDataUptime = this.getRadioDataUptime();
        this.mRadioDataStart = -1L;
        this.mBluetoothPingCount = this.getBluetoothPingCount();
        this.mBluetoothPingStart = -1;
    }

    public void doUnplugLocked(long l, long l2) {
        for (int i = this.mUidStats.size() - 1; i >= 0; --i) {
            Uid uid = this.mUidStats.valueAt(i);
            uid.mStartedTcpBytesReceived = TrafficStats.getUidRxBytes(uid.mUid);
            uid.mStartedTcpBytesSent = TrafficStats.getUidTxBytes(uid.mUid);
            uid.mTcpBytesReceivedAtLastUnplug = uid.mCurrentTcpBytesReceived;
            uid.mTcpBytesSentAtLastUnplug = uid.mCurrentTcpBytesSent;
        }
        for (int i = this.mUnpluggables.size() - 1; i >= 0; --i) {
            this.mUnpluggables.get(i).unplug(l, l2);
        }
        this.doDataUnplug(this.mMobileDataRx, TrafficStats.getMobileRxBytes());
        this.doDataUnplug(this.mMobileDataTx, TrafficStats.getMobileTxBytes());
        this.doDataUnplug(this.mTotalDataRx, TrafficStats.getTotalRxBytes());
        this.doDataUnplug(this.mTotalDataTx, TrafficStats.getTotalTxBytes());
        this.mRadioDataStart = this.getCurrentRadioDataUptime();
        this.mRadioDataUptime = 0L;
        this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
        this.mBluetoothPingCount = 0;
    }

    @Override
    public void dumpLocked(PrintWriter printWriter) {
        super.dumpLocked(printWriter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void finishAddingCpuLocked(int n, int n2, int n3, long[] lArray) {
        boolean bl;
        int n4;
        int n5 = this.mPartialTimers.size();
        if (n != 0) {
            Uid uid;
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                Uid uid2;
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                if (!stopwatchTimer.mInList || (uid2 = stopwatchTimer.mUid) == null || uid2.mUid == 1000) continue;
                ++n6;
            }
            if (n6 != 0) {
                for (int i = 0; i < n5; ++i) {
                    Uid uid3;
                    StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                    if (!stopwatchTimer.mInList || (uid3 = stopwatchTimer.mUid) == null || uid3.mUid == 1000) continue;
                    int n7 = n2 / n6;
                    int n8 = n3 / n6;
                    n2 -= n7;
                    n3 -= n8;
                    --n6;
                    Uid.Proc proc = uid3.getProcessStatsLocked("*wakelock*");
                    proc.addCpuTimeLocked(n7, n8);
                    proc.addSpeedStepTimes(lArray);
                }
            }
            if ((n2 != 0 || n3 != 0) && (uid = this.getUidStatsLocked(1000)) != null) {
                Uid.Proc proc = uid.getProcessStatsLocked("*lost*");
                proc.addCpuTimeLocked(n2, n3);
                proc.addSpeedStepTimes(lArray);
            }
        }
        boolean bl2 = n5 != (n4 = this.mLastPartialTimers.size());
        for (int i = 0; i < n4 && !bl2; bl2 |= bl, ++i) {
            bl = this.mPartialTimers.get(i) != this.mLastPartialTimers.get(i);
        }
        if (!bl2) {
            for (int i = 0; i < n4; ++i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
            return;
        } else {
            for (int i = 0; i < n4; ++i) {
                this.mLastPartialTimers.get((int)i).mInList = false;
            }
            this.mLastPartialTimers.clear();
            for (int i = 0; i < n5; ++i) {
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                stopwatchTimer.mInList = true;
                this.mLastPartialTimers.add(stopwatchTimer);
            }
        }
    }

    public long getAwakeTimeBattery() {
        return this.computeBatteryUptime(this.getBatteryUptimeLocked(), 2);
    }

    public long getAwakeTimePlugged() {
        return 1000L * SystemClock.uptimeMillis() - this.getAwakeTimeBattery();
    }

    @Override
    public long getBatteryRealtime(long l) {
        return this.getBatteryRealtimeLocked(l);
    }

    long getBatteryRealtimeLocked(long l) {
        long l2 = this.mTrackBatteryPastRealtime;
        if (this.mOnBatteryInternal) {
            l2 += l - this.mTrackBatteryRealtimeStart;
        }
        return l2;
    }

    @Override
    public long getBatteryUptime(long l) {
        return this.getBatteryUptimeLocked(l);
    }

    long getBatteryUptimeLocked() {
        return this.getBatteryUptime(1000L * SystemClock.uptimeMillis());
    }

    long getBatteryUptimeLocked(long l) {
        long l2 = this.mTrackBatteryPastUptime;
        if (this.mOnBatteryInternal) {
            l2 += l - this.mTrackBatteryUptimeStart;
        }
        return l2;
    }

    @Override
    public long getBluetoothOnTime(long l, int n) {
        return this.mBluetoothOnTimer.getTotalTimeLocked(l, n);
    }

    public int getBluetoothPingCount() {
        if (this.mBluetoothPingStart == -1) {
            return this.mBluetoothPingCount;
        }
        if (this.mBtHeadset != null) {
            return this.getCurrentBluetoothPingCount() - this.mBluetoothPingStart;
        }
        return 0;
    }

    @Override
    public int getCpuSpeedSteps() {
        return sNumSpeedSteps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeCurrentLevel() {
        synchronized (this) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeStartLevel() {
        synchronized (this) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    @Override
    public long getGlobalWifiRunningTime(long l, int n) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(l, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        synchronized (this) {
            int n = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                n += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    @Override
    public BatteryStats.HistoryItem getHistory() {
        return this.mHistory;
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getInputEventCount(int n) {
        return this.mInputEventCounter.getCountLocked(n);
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    public Map<String, ? extends SamplingTimer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String string2) {
        SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
        if (samplingTimer == null) {
            samplingTimer = new SamplingTimer(this.mUnpluggables, this.mOnBatteryInternal, true);
            this.mKernelWakelockStats.put(string2, samplingTimer);
        }
        return samplingTimer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        synchronized (this) {
            int n = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                n += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return n;
        }
    }

    public long getMobileTcpBytesReceived(int n) {
        return this.getTcpBytes(TrafficStats.getMobileRxBytes(), this.mMobileDataRx, n);
    }

    public long getMobileTcpBytesSent(int n) {
        return this.getTcpBytes(TrafficStats.getMobileTxBytes(), this.mMobileDataTx, n);
    }

    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem historyItem) {
        BatteryStats.HistoryItem historyItem2 = this.mHistoryIterator;
        if (historyItem2 == null) {
            return false;
        }
        historyItem.setTo(historyItem2);
        this.mHistoryIterator = historyItem2.next;
        return true;
    }

    public Uid.Pkg getPackageStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(n).getPackageStatsLocked(string2);
    }

    @Override
    public int getPhoneDataConnectionCount(int n, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneDataConnectionTime(int n, long l, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public long getPhoneOnTime(long l, int n) {
        return this.mPhoneOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public long getPhoneSignalScanningTime(long l, int n) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getPhoneSignalStrengthCount(int n, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneSignalStrengthTime(int n, long l, int n2) {
        return this.mPhoneSignalStrengthsTimer[n].getTotalTimeLocked(l, n2);
    }

    public Uid.Proc getProcessStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(n).getProcessStatsLocked(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uid.Proc getProcessStatsLocked(String string2, int n) {
        int n2;
        if (this.mUidCache.containsKey(string2)) {
            n2 = this.mUidCache.get(string2);
            return this.getUidStatsLocked(n2).getProcessStatsLocked(string2);
        }
        n2 = Process.getUidForPid((int)n);
        this.mUidCache.put(string2, n2);
        return this.getUidStatsLocked(n2).getProcessStatsLocked(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getProcessWakeTime(int n, int n2, long l) {
        long l2;
        BatteryStats.Uid.Pid pid;
        Uid uid = this.mUidStats.get(n);
        if (uid == null || (pid = uid.mPids.get(n2)) == null) return 0L;
        long l3 = pid.mWakeSum;
        if (pid.mWakeStart != 0L) {
            l2 = l - pid.mWakeStart;
            return l3 + l2;
        }
        l2 = 0L;
        return l3 + l2;
    }

    @Override
    public long getRadioDataUptime() {
        if (this.mRadioDataStart == -1L) {
            return this.mRadioDataUptime;
        }
        return this.getCurrentRadioDataUptime() - this.mRadioDataStart;
    }

    @Override
    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    @Override
    public long getScreenBrightnessTime(int n, long l, int n2) {
        return this.mScreenBrightnessTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public long getScreenOnTime(long l, int n) {
        return this.mScreenOnTimer.getTotalTimeLocked(l, n);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int n, String string2, String string3) {
        return this.getUidStatsLocked(n).getServiceStatsLocked(string2, string3);
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    public long getTotalTcpBytesReceived(int n) {
        return this.getTcpBytes(TrafficStats.getTotalRxBytes(), this.mTotalDataRx, n);
    }

    public long getTotalTcpBytesSent(int n) {
        return this.getTcpBytes(TrafficStats.getTotalTxBytes(), this.mTotalDataTx, n);
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    public Uid getUidStatsLocked(int n) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            uid = new Uid(n);
            this.mUidStats.put(n, uid);
        }
        return uid;
    }

    @Override
    public long getWifiOnTime(long l, int n) {
        return this.mWifiOnTimer.getTotalTimeLocked(l, n);
    }

    void initTimes() {
        long l;
        long l2;
        this.mTrackBatteryPastUptime = 0L;
        this.mBatteryRealtime = 0L;
        this.mTrackBatteryPastRealtime = 0L;
        this.mBatteryUptime = 0L;
        this.mTrackBatteryUptimeStart = l2 = 1000L * SystemClock.uptimeMillis();
        this.mUptimeStart = l2;
        this.mTrackBatteryRealtimeStart = l = 1000L * SystemClock.elapsedRealtime();
        this.mRealtimeStart = l;
        this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(this.mUptimeStart);
        this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(this.mRealtimeStart);
    }

    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isScreenOn() {
        return this.mScreenOn;
    }

    public void noteAudioOffLocked(int n) {
        if (this.mAudioOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFF7FFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mAudioOn = false;
            this.mAudioOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteAudioTurnedOffLocked();
    }

    public void noteAudioOnLocked(int n) {
        if (!this.mAudioOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x80000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mAudioOn = true;
            this.mAudioOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteAudioTurnedOnLocked();
    }

    public void noteBluetoothOffLocked() {
        if (this.mBluetoothOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFEFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mBluetoothOn = false;
            this.mBluetoothOnTimer.stopRunningLocked(this);
        }
    }

    public void noteBluetoothOnLocked() {
        if (!this.mBluetoothOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x100000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mBluetoothOn = true;
            this.mBluetoothOnTimer.startRunningLocked(this);
        }
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteFullWifiLockAcquiredLocked(workSource.get(i));
        }
    }

    public void noteFullWifiLockAcquiredLocked(int n) {
        if (this.mWifiFullLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x800000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.mWifiFullLockNesting = 1 + this.mWifiFullLockNesting;
        this.getUidStatsLocked(n).noteFullWifiLockAcquiredLocked();
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteFullWifiLockReleasedLocked(workSource.get(i));
        }
    }

    public void noteFullWifiLockReleasedLocked(int n) {
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFF7FFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(n).noteFullWifiLockReleasedLocked();
    }

    public void noteInputEventAtomic() {
        this.mInputEventCounter.stepAtomic();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notePhoneDataConnectionStateLocked(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            switch (n) {
                default: {
                    n2 = 13;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                case 6: {
                    n2 = 6;
                    break;
                }
                case 7: {
                    n2 = 7;
                    break;
                }
                case 8: {
                    n2 = 8;
                    break;
                }
                case 9: {
                    n2 = 9;
                    break;
                }
                case 10: {
                    n2 = 10;
                    break;
                }
                case 11: {
                    n2 = 11;
                    break;
                }
                case 12: {
                    n2 = 12;
                }
            }
        }
        if (this.mPhoneDataConnectionType != n2) {
            this.mHistoryCur.states = 0xFFFF0FFF & this.mHistoryCur.states | n2 << 12;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(this);
            }
            this.mPhoneDataConnectionType = n2;
            this.mPhoneDataConnectionsTimer[n2].startRunningLocked(this);
        }
    }

    public void notePhoneOffLocked() {
        if (this.mPhoneOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xF7FFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(this);
        }
    }

    public void notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x8000000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int n;
        int n2;
        int n3 = !signalStrength.isGsm() ? ((n2 = signalStrength.getCdmaDbm()) >= -75 ? 4 : (n2 >= -85 ? 3 : (n2 >= -95 ? 2 : (n2 >= -100 ? 1 : 0)))) : ((n = signalStrength.getGsmSignalStrength()) < 0 || n >= 99 ? 0 : (n >= 16 ? 4 : (n >= 8 ? 3 : (n >= 4 ? 2 : 1))));
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, n3);
    }

    public void notePhoneStateLocked(int n, int n2) {
        this.updateAllPhoneStateLocked(n, n2, this.mPhoneSignalStrengthBinRaw);
    }

    public void noteProcessDiedLocked(int n, int n2) {
        Uid uid = this.mUidStats.get(n);
        if (uid != null) {
            uid.mPids.remove(n2);
        }
    }

    public void noteScanWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteScanWifiLockAcquiredLocked(workSource.get(i));
        }
    }

    public void noteScanWifiLockAcquiredLocked(int n) {
        if (this.mWifiScanLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x400000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.mWifiScanLockNesting = 1 + this.mWifiScanLockNesting;
        this.getUidStatsLocked(n).noteScanWifiLockAcquiredLocked();
    }

    public void noteScanWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteScanWifiLockReleasedLocked(workSource.get(i));
        }
    }

    public void noteScanWifiLockReleasedLocked(int n) {
        --this.mWifiScanLockNesting;
        if (this.mWifiScanLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFBFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(n).noteScanWifiLockReleasedLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteScreenBrightnessLocked(int n) {
        int n2 = n / 51;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= 5) {
            n2 = 4;
        }
        if (this.mScreenBrightnessBin != n2) {
            this.mHistoryCur.states = 0xFFFFFFF0 & this.mHistoryCur.states | n2 << 0;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            if (this.mScreenOn) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(this);
                }
                this.mScreenBrightnessTimer[n2].startRunningLocked(this);
            }
            this.mScreenBrightnessBin = n2;
        }
    }

    public void noteScreenOffLocked() {
        if (this.mScreenOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xDFFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mScreenOn = false;
            this.mScreenOnTimer.stopRunningLocked(this);
            if (this.mScreenBrightnessBin >= 0) {
                this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(this);
            }
            this.noteStopWakeLocked(-1, -1, "dummy", 0);
        }
    }

    public void noteScreenOnLocked() {
        if (!this.mScreenOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x20000000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mScreenOn = true;
            this.mScreenOnTimer.startRunningLocked(this);
            if (this.mScreenBrightnessBin >= 0) {
                this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(this);
            }
            this.noteStartWakeLocked(-1, -1, "dummy", 0);
        }
    }

    public void noteStartGpsLocked(int n) {
        if (this.mGpsNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x10000000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.mGpsNesting = 1 + this.mGpsNesting;
        this.getUidStatsLocked(n).noteStartGps();
    }

    public void noteStartSensorLocked(int n, int n2) {
        if (this.mSensorNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x10000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.mSensorNesting = 1 + this.mSensorNesting;
        this.getUidStatsLocked(n).noteStartSensor(n2);
    }

    public void noteStartWakeFromSourceLocked(WorkSource workSource, int n, String string2, int n2) {
        int n3 = workSource.size();
        for (int i = 0; i < n3; ++i) {
            this.noteStartWakeLocked(workSource.get(i), n, string2, n2);
        }
    }

    public void noteStartWakeLocked(int n, int n2, String string2, int n3) {
        if (n3 == 0) {
            if (this.mWakeLockNesting == 0) {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0x20000 | historyItem.states;
                this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            }
            this.mWakeLockNesting = 1 + this.mWakeLockNesting;
        }
        if (n >= 0) {
            if (!this.mHandler.hasMessages(1)) {
                Message message = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(message, 5000L);
            }
            this.getUidStatsLocked(n).noteStartWakeLocked(n2, string2, n3);
        }
    }

    public void noteStopGpsLocked(int n) {
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xEFFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(n).noteStopGps();
    }

    public void noteStopSensorLocked(int n, int n2) {
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFFEFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(n).noteStopSensor(n2);
    }

    public void noteStopWakeFromSourceLocked(WorkSource workSource, int n, String string2, int n2) {
        int n3 = workSource.size();
        for (int i = 0; i < n3; ++i) {
            this.noteStopWakeLocked(workSource.get(i), n, string2, n2);
        }
    }

    public void noteStopWakeLocked(int n, int n2, String string2, int n3) {
        if (n3 == 0) {
            --this.mWakeLockNesting;
            if (this.mWakeLockNesting == 0) {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0xFFFDFFFF & historyItem.states;
                this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            }
        }
        if (n >= 0) {
            if (!this.mHandler.hasMessages(1)) {
                Message message = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(message, 5000L);
            }
            this.getUidStatsLocked(n).noteStopWakeLocked(n2, string2, n3);
        }
    }

    public void noteUserActivityLocked(int n, int n2) {
        this.getUidStatsLocked(n).noteUserActivityLocked(n2);
    }

    public void noteVideoOffLocked(int n) {
        if (this.mVideoOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFFBFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mVideoOn = false;
            this.mVideoOnTimer.stopRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteVideoTurnedOffLocked();
    }

    public void noteVideoOnLocked(int n) {
        if (!this.mVideoOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x40000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mVideoOn = true;
            this.mVideoOnTimer.startRunningLocked(this);
        }
        this.getUidStatsLocked(n).noteVideoTurnedOnLocked();
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiMulticastDisabledLocked(workSource.get(i));
        }
    }

    public void noteWifiMulticastDisabledLocked(int n) {
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFDFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.getUidStatsLocked(n).noteWifiMulticastDisabledLocked();
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiMulticastEnabledLocked(workSource.get(i));
        }
    }

    public void noteWifiMulticastEnabledLocked(int n) {
        if (this.mWifiMulticastNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x200000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
        }
        this.mWifiMulticastNesting = 1 + this.mWifiMulticastNesting;
        this.getUidStatsLocked(n).noteWifiMulticastEnabledLocked();
    }

    public void noteWifiOffLocked() {
        if (this.mWifiOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFDFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(this);
        }
        if (this.mWifiOnUid >= 0) {
            this.getUidStatsLocked(this.mWifiOnUid).noteWifiStoppedLocked();
            this.mWifiOnUid = -1;
        }
    }

    public void noteWifiOnLocked() {
        if (!this.mWifiOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x2000000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(this);
        }
    }

    public void noteWifiRunningChangedLocked(WorkSource workSource, WorkSource workSource2) {
        if (this.mGlobalWifiRunning) {
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(workSource.get(i)).noteWifiStoppedLocked();
            }
            int n2 = workSource2.size();
            for (int i = 0; i < n2; ++i) {
                this.getUidStatsLocked(workSource2.get(i)).noteWifiRunningLocked();
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiRunningLocked(WorkSource workSource) {
        if (!this.mGlobalWifiRunning) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x1000000 | historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(this);
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(workSource.get(i)).noteWifiRunningLocked();
            }
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    public void noteWifiStoppedLocked(WorkSource workSource) {
        if (this.mGlobalWifiRunning) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFEFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(this);
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(workSource.get(i)).noteWifiStoppedLocked();
            }
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    public void readFromParcel(Parcel parcel) {
        this.readFromParcelLocked(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    void readFromParcelLocked(Parcel parcel) {
        Counter counter;
        if (parcel.readInt() != -1166707595) {
            throw new ParcelFormatException("Bad magic number");
        }
        this.readHistory(parcel);
        this.mStartCount = parcel.readInt();
        this.mBatteryUptime = parcel.readLong();
        this.mBatteryLastUptime = 0L;
        this.mBatteryRealtime = parcel.readLong();
        this.mBatteryLastRealtime = 0L;
        this.mScreenOn = false;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mUnpluggables, parcel);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mUnpluggables, parcel);
        }
        this.mInputEventCounter = counter = new Counter(this.mUnpluggables, parcel);
        this.mPhoneOn = false;
        this.mPhoneOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, parcel);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mUnpluggables, parcel);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mUnpluggables, parcel);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mUnpluggables, parcel);
        }
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, parcel);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, parcel);
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer = new StopwatchTimer(null, -2, null, this.mUnpluggables, parcel);
        this.mUptime = parcel.readLong();
        this.mUptimeStart = parcel.readLong();
        this.mLastUptime = 0L;
        this.mRealtime = parcel.readLong();
        this.mRealtimeStart = parcel.readLong();
        this.mLastRealtime = 0L;
        boolean bl = parcel.readInt() != 0;
        this.mOnBattery = bl;
        this.mOnBatteryInternal = false;
        this.mTrackBatteryPastUptime = parcel.readLong();
        this.mTrackBatteryUptimeStart = parcel.readLong();
        this.mTrackBatteryPastRealtime = parcel.readLong();
        this.mTrackBatteryRealtimeStart = parcel.readLong();
        this.mUnpluggedBatteryUptime = parcel.readLong();
        this.mUnpluggedBatteryRealtime = parcel.readLong();
        this.mDischargeUnplugLevel = parcel.readInt();
        this.mDischargeCurrentLevel = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = parcel.readInt();
        this.mLastWriteTime = parcel.readLong();
        this.mMobileDataRx[1] = parcel.readLong();
        this.mMobileDataRx[3] = -1L;
        this.mMobileDataTx[1] = parcel.readLong();
        this.mMobileDataTx[3] = -1L;
        this.mTotalDataRx[1] = parcel.readLong();
        this.mTotalDataRx[3] = -1L;
        this.mTotalDataTx[1] = parcel.readLong();
        this.mTotalDataTx[3] = -1L;
        this.mRadioDataUptime = parcel.readLong();
        this.mRadioDataStart = -1L;
        this.mBluetoothPingCount = parcel.readInt();
        this.mBluetoothPingStart = -1;
        this.mKernelWakelockStats.clear();
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            if (parcel.readInt() == 0) continue;
            String string2 = parcel.readString();
            parcel.readInt();
            SamplingTimer samplingTimer = new SamplingTimer(this.mUnpluggables, this.mOnBattery, parcel);
            this.mKernelWakelockStats.put(string2, samplingTimer);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mScanWifiLockTimers.clear();
        this.mWifiMulticastTimers.clear();
        sNumSpeedSteps = parcel.readInt();
        int n2 = parcel.readInt();
        this.mUidStats.clear();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = parcel.readInt();
            Uid uid = new Uid(n4);
            uid.readFromParcelLocked(this.mUnpluggables, parcel);
            this.mUidStats.append(n4, uid);
            ++n3;
        }
        return;
    }

    void readHistory(Parcel parcel) {
        long l;
        this.mHistoryCache = null;
        this.mHistoryEnd = null;
        this.mHistory = null;
        this.mHistoryBaseTime = 0L;
        while ((l = parcel.readLong()) >= 0L) {
            BatteryStats.HistoryItem historyItem = new BatteryStats.HistoryItem(l, parcel);
            this.addHistoryRecordLocked(historyItem);
            if (historyItem.time <= this.mHistoryBaseTime) continue;
            this.mHistoryBaseTime = historyItem.time;
        }
        long l2 = SystemClock.elapsedRealtime() - 30000L;
        if (l2 > 0L) {
            this.mHistoryBaseTime -= l2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLocked() {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) return;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = BatteryStatsImpl.readFully(fileInputStream);
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            fileInputStream.close();
            this.readSummaryFromParcel(parcel);
        }
        catch (IOException iOException) {
            Slog.e("BatteryStats", "Error reading battery statistics", iOException);
        }
        this.addHistoryRecordLocked(SystemClock.elapsedRealtime(), (byte)1);
    }

    public void removeUidStatsLocked(int n) {
        this.mUidStats.remove(n);
    }

    public void reportExcessiveCpuLocked(int n, String string2, long l, long l2) {
        Uid uid = this.mUidStats.get(n);
        if (uid != null) {
            uid.reportExcessiveCpuLocked(string2, l, l2);
        }
    }

    public void reportExcessiveWakeLocked(int n, String string2, long l, long l2) {
        Uid uid = this.mUidStats.get(n);
        if (uid != null) {
            uid.reportExcessiveWakeLocked(string2, l, l2);
        }
    }

    public void resetAllStatsLocked() {
        this.mStartCount = 0;
        this.initTimes();
        this.mScreenOnTimer.reset(this, false);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(this, false);
        }
        this.mInputEventCounter.reset(false);
        this.mPhoneOnTimer.reset(this, false);
        this.mAudioOnTimer.reset(this, false);
        this.mVideoOnTimer.reset(this, false);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(this, false);
        }
        this.mPhoneSignalScanningTimer.reset(this, false);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(this, false);
        }
        this.mWifiOnTimer.reset(this, false);
        this.mGlobalWifiRunningTimer.reset(this, false);
        this.mBluetoothOnTimer.reset(this, false);
        for (int i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer samplingTimer : this.mKernelWakelockStats.values()) {
                this.mUnpluggables.remove(samplingTimer);
            }
            this.mKernelWakelockStats.clear();
        }
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.clearHistoryLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBatteryState(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = n3 == 0;
        int n7 = this.mHistoryCur.batteryStatus;
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            if (bl == this.mOnBattery) {
                if (bl) {
                    BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                    historyItem.states = 0xBFFFFFFF & historyItem.states;
                } else {
                    BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                    historyItem.states = 0x40000000 | historyItem.states;
                }
            }
            n7 = n;
        }
        if (bl) {
            this.mDischargeCurrentLevel = n4;
            this.mRecordingHistory = true;
        }
        if (bl != this.mOnBattery) {
            this.mHistoryCur.batteryLevel = (byte)n4;
            this.mHistoryCur.batteryStatus = (byte)n;
            this.mHistoryCur.batteryHealth = (byte)n2;
            this.mHistoryCur.batteryPlugType = (byte)n3;
            this.mHistoryCur.batteryTemperature = (char)n5;
            this.mHistoryCur.batteryVoltage = (char)n6;
            this.setOnBattery(bl, n7, n4);
        } else {
            byte by = this.mHistoryCur.batteryLevel;
            boolean bl2 = false;
            if (by != n4) {
                this.mHistoryCur.batteryLevel = (byte)n4;
                bl2 = true;
            }
            if (this.mHistoryCur.batteryStatus != n) {
                this.mHistoryCur.batteryStatus = (byte)n;
                bl2 = true;
            }
            if (this.mHistoryCur.batteryHealth != n2) {
                this.mHistoryCur.batteryHealth = (byte)n2;
                bl2 = true;
            }
            if (this.mHistoryCur.batteryPlugType != n3) {
                this.mHistoryCur.batteryPlugType = (byte)n3;
                bl2 = true;
            }
            if (n5 >= 10 + this.mHistoryCur.batteryTemperature || n5 <= this.mHistoryCur.batteryTemperature - 10) {
                this.mHistoryCur.batteryTemperature = (char)n5;
                bl2 = true;
            }
            if (n6 > 20 + this.mHistoryCur.batteryVoltage || n6 < this.mHistoryCur.batteryVoltage - 20) {
                this.mHistoryCur.batteryVoltage = (char)n6;
                bl2 = true;
            }
            if (bl2) {
                this.addHistoryRecordLocked(SystemClock.elapsedRealtime());
            }
        }
        if (!bl && n == 5) {
            this.mRecordingHistory = false;
        }
    }

    public void setBtHeadset(BluetoothHeadset bluetoothHeadset) {
        if (bluetoothHeadset != null && this.mBtHeadset == null && this.isOnBattery() && this.mBluetoothPingStart == -1) {
            this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
        }
        this.mBtHeadset = bluetoothHeadset;
    }

    public void setCallback(BatteryCallback batteryCallback) {
        this.mCallback = batteryCallback;
    }

    public void setNumSpeedSteps(int n) {
        if (sNumSpeedSteps == 0) {
            sNumSpeedSteps = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setOnBattery(boolean bl, int n, int n2) {
        synchronized (this) {
            boolean bl2;
            long l;
            block11: {
                long l2;
                long l3;
                block8: {
                    block10: {
                        block9: {
                            Message message = this.mHandler.obtainMessage(2);
                            int n3 = bl ? 1 : 0;
                            message.arg1 = n3;
                            this.mHandler.sendMessage(message);
                            this.mOnBatteryInternal = bl;
                            this.mOnBattery = bl;
                            l3 = 1000L * SystemClock.uptimeMillis();
                            l = SystemClock.elapsedRealtime();
                            l2 = l * 1000L;
                            if (!bl) break block8;
                            if (n == 5 || n2 >= 90) break block9;
                            int n4 = this.mDischargeCurrentLevel;
                            bl2 = false;
                            if (n4 >= 20) break block10;
                            bl2 = false;
                            if (n2 < 80) break block10;
                        }
                        bl2 = true;
                        this.resetAllStatsLocked();
                        this.mDischargeStartLevel = n2;
                    }
                    this.updateKernelWakelocksLocked();
                    this.mHistoryCur.batteryLevel = (byte)n2;
                    BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                    historyItem.states = 0xBFFFFFFF & historyItem.states;
                    this.addHistoryRecordLocked(l);
                    this.mTrackBatteryUptimeStart = l3;
                    this.mTrackBatteryRealtimeStart = l2;
                    this.mUnpluggedBatteryUptime = this.getBatteryUptimeLocked(l3);
                    this.mUnpluggedBatteryRealtime = this.getBatteryRealtimeLocked(l2);
                    this.mDischargeUnplugLevel = n2;
                    this.mDischargeCurrentLevel = n2;
                    this.doUnplugLocked(this.mUnpluggedBatteryUptime, this.mUnpluggedBatteryRealtime);
                    break block11;
                }
                this.updateKernelWakelocksLocked();
                this.mHistoryCur.batteryLevel = (byte)n2;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0x40000000 | historyItem.states;
                this.addHistoryRecordLocked(l);
                this.mTrackBatteryPastUptime += l3 - this.mTrackBatteryUptimeStart;
                this.mTrackBatteryPastRealtime += l2 - this.mTrackBatteryRealtimeStart;
                this.mDischargeCurrentLevel = n2;
                if (n2 < this.mDischargeUnplugLevel) {
                    this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - n2 - 1;
                    this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - n2;
                }
                this.doPlugLocked(this.getBatteryUptimeLocked(l3), this.getBatteryRealtimeLocked(l2));
                bl2 = false;
            }
            if ((bl2 || 60000L + this.mLastWriteTime < l) && this.mFile != null) {
                this.writeAsyncLocked();
            }
            return;
        }
    }

    public void setRadioScanningTimeout(long l) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(l);
        }
    }

    public void shutdownLocked() {
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    public int startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        if (this.mScreenOn) {
            return 0;
        }
        int n = this.mPartialTimers.size();
        if (n == 0) {
            this.mLastPartialTimers.clear();
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            Uid uid;
            StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
            if (!stopwatchTimer.mInList || (uid = stopwatchTimer.mUid) == null || uid.mUid == 1000) continue;
            return 50;
        }
        return 0;
    }

    @Override
    public boolean startIteratingHistoryLocked() {
        BatteryStats.HistoryItem historyItem;
        this.mHistoryIterator = historyItem = this.mHistory;
        return historyItem != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void stopAllSignalStrengthTimersLocked(int n) {
        int n2 = 0;
        while (n2 < 5) {
            if (n2 != n) {
                while (this.mPhoneSignalStrengthsTimer[n2].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n2].stopRunningLocked(this);
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateKernelWakelocksLocked() {
        Map<String, KernelWakelockStats> map = this.readKernelWakelockStats();
        if (map == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        } else {
            for (Map.Entry<String, KernelWakelockStats> entry : map.entrySet()) {
                String string2 = entry.getKey();
                KernelWakelockStats kernelWakelockStats = entry.getValue();
                SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
                if (samplingTimer == null) {
                    samplingTimer = new SamplingTimer(this.mUnpluggables, this.mOnBatteryInternal, true);
                    this.mKernelWakelockStats.put(string2, samplingTimer);
                }
                samplingTimer.updateCurrentReportedCount(kernelWakelockStats.mCount);
                samplingTimer.updateCurrentReportedTotalTime(kernelWakelockStats.mTotalTime);
                samplingTimer.setUpdateVersion(sKernelWakelockUpdateVersion);
            }
            if (map.size() == this.mKernelWakelockStats.size()) return;
            Iterator<Map.Entry<String, SamplingTimer>> iterator = this.mKernelWakelockStats.entrySet().iterator();
            while (iterator.hasNext()) {
                SamplingTimer samplingTimer = iterator.next().getValue();
                if (samplingTimer.getUpdateVersion() == sKernelWakelockUpdateVersion) continue;
                samplingTimer.setStale();
            }
        }
    }

    public void writeAsyncLocked() {
        this.writeLocked(false);
    }

    void writeHistory(Parcel parcel) {
        BatteryStats.HistoryItem historyItem = this.mHistory;
        while (historyItem != null) {
            if (historyItem.time >= 0L) {
                historyItem.writeToParcel(parcel, 0);
            }
            historyItem = historyItem.next;
        }
        parcel.writeLong(-1L);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeLocked(boolean bl) {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) return;
        Parcel parcel = Parcel.obtain();
        this.writeSummaryToParcel(parcel);
        this.mLastWriteTime = SystemClock.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = parcel;
        if (bl) {
            this.commitPendingDataToDisk();
            return;
        }
        new Thread("BatteryStats-Write"){

            @Override
            public void run() {
                Process.setThreadPriority(10);
                BatteryStatsImpl.this.commitPendingDataToDisk();
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeSummaryToParcel(Parcel parcel) {
        long l = 1000L * SystemClock.uptimeMillis();
        long l2 = 1000L * SystemClock.elapsedRealtime();
        long l3 = this.getBatteryUptimeLocked(l);
        long l4 = this.getBatteryRealtimeLocked(l2);
        parcel.writeInt(52);
        this.writeHistory(parcel);
        parcel.writeInt(this.mStartCount);
        parcel.writeLong(this.computeBatteryUptime(l, 0));
        parcel.writeLong(this.computeBatteryRealtime(l2, 0));
        parcel.writeLong(this.computeUptime(l, 0));
        parcel.writeLong(this.computeRealtime(l2, 0));
        parcel.writeInt(this.mDischargeUnplugLevel);
        parcel.writeInt(this.mDischargeCurrentLevel);
        parcel.writeInt(this.getLowDischargeAmountSinceCharge());
        parcel.writeInt(this.getHighDischargeAmountSinceCharge());
        this.mScreenOnTimer.writeSummaryFromParcelLocked(parcel, l4);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(parcel, l4);
        }
        this.mInputEventCounter.writeSummaryFromParcelLocked(parcel);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(parcel, l4);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(parcel, l4);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(parcel, l4);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(parcel, l4);
        }
        this.mWifiOnTimer.writeSummaryFromParcelLocked(parcel, l4);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(parcel, l4);
        this.mBluetoothOnTimer.writeSummaryFromParcelLocked(parcel, l4);
        parcel.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
            if ((Timer)entry.getValue() != null) {
                parcel.writeInt(1);
                parcel.writeString(entry.getKey());
                entry.getValue().writeSummaryFromParcelLocked(parcel, l4);
                continue;
            }
            parcel.writeInt(0);
        }
        parcel.writeInt(sNumSpeedSteps);
        int n = this.mUidStats.size();
        parcel.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            parcel.writeInt(this.mUidStats.keyAt(n2));
            Uid uid = this.mUidStats.valueAt(n2);
            if (uid.mWifiRunningTimer != null) {
                parcel.writeInt(1);
                uid.mWifiRunningTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mFullWifiLockTimer != null) {
                parcel.writeInt(1);
                uid.mFullWifiLockTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mScanWifiLockTimer != null) {
                parcel.writeInt(1);
                uid.mScanWifiLockTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mWifiMulticastTimer != null) {
                parcel.writeInt(1);
                uid.mWifiMulticastTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mAudioTurnedOnTimer != null) {
                parcel.writeInt(1);
                uid.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mVideoTurnedOnTimer != null) {
                parcel.writeInt(1);
                uid.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(parcel, l4);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mUserActivityCounters == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                for (int i = 0; i < 7; ++i) {
                    uid.mUserActivityCounters[i].writeSummaryFromParcelLocked(parcel);
                }
            }
            int n3 = uid.mWakelockStats.size();
            parcel.writeInt(n3);
            if (n3 > 0) {
                for (Map.Entry<String, Uid.Wakelock> entry : uid.mWakelockStats.entrySet()) {
                    parcel.writeString(entry.getKey());
                    Uid.Wakelock wakelock = entry.getValue();
                    if (wakelock.mTimerFull != null) {
                        parcel.writeInt(1);
                        wakelock.mTimerFull.writeSummaryFromParcelLocked(parcel, l4);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (wakelock.mTimerPartial != null) {
                        parcel.writeInt(1);
                        wakelock.mTimerPartial.writeSummaryFromParcelLocked(parcel, l4);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (wakelock.mTimerWindow != null) {
                        parcel.writeInt(1);
                        wakelock.mTimerWindow.writeSummaryFromParcelLocked(parcel, l4);
                        continue;
                    }
                    parcel.writeInt(0);
                }
            }
            int n4 = uid.mSensorStats.size();
            parcel.writeInt(n4);
            if (n4 > 0) {
                for (Map.Entry<Integer, Uid.Sensor> entry : uid.mSensorStats.entrySet()) {
                    parcel.writeInt(entry.getKey());
                    Uid.Sensor sensor = entry.getValue();
                    if (sensor.mTimer != null) {
                        parcel.writeInt(1);
                        sensor.mTimer.writeSummaryFromParcelLocked(parcel, l4);
                        continue;
                    }
                    parcel.writeInt(0);
                }
            }
            int n5 = uid.mProcessStats.size();
            parcel.writeInt(n5);
            if (n5 > 0) {
                for (Map.Entry<String, Uid.Proc> entry : uid.mProcessStats.entrySet()) {
                    parcel.writeString(entry.getKey());
                    Uid.Proc proc = entry.getValue();
                    parcel.writeLong(proc.mUserTime);
                    parcel.writeLong(proc.mSystemTime);
                    parcel.writeInt(proc.mStarts);
                    int n6 = proc.mSpeedBins.length;
                    parcel.writeInt(n6);
                    for (int i = 0; i < n6; ++i) {
                        if (proc.mSpeedBins[i] != null) {
                            parcel.writeInt(1);
                            proc.mSpeedBins[i].writeSummaryFromParcelLocked(parcel);
                            continue;
                        }
                        parcel.writeInt(0);
                    }
                    proc.writeExcessivePowerToParcelLocked(parcel);
                }
            }
            int n7 = uid.mPackageStats.size();
            parcel.writeInt(n7);
            if (n7 > 0) {
                for (Map.Entry<String, Uid.Pkg> entry : uid.mPackageStats.entrySet()) {
                    parcel.writeString(entry.getKey());
                    Uid.Pkg pkg = entry.getValue();
                    parcel.writeInt(pkg.mWakeups);
                    int n8 = pkg.mServiceStats.size();
                    parcel.writeInt(n8);
                    if (n8 <= 0) continue;
                    for (Map.Entry<String, Uid.Pkg.Serv> entry2 : pkg.mServiceStats.entrySet()) {
                        parcel.writeString(entry2.getKey());
                        Uid.Pkg.Serv serv = entry2.getValue();
                        parcel.writeLong(serv.getStartTimeToNowLocked(l3));
                        parcel.writeInt(serv.mStarts);
                        parcel.writeInt(serv.mLaunches);
                    }
                }
            }
            parcel.writeLong(uid.getTcpBytesReceived(0));
            parcel.writeLong(uid.getTcpBytesSent(0));
            ++n2;
        }
        return;
    }

    public void writeSyncLocked() {
        this.writeLocked(true);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, true, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeToParcelLocked(Parcel parcel, boolean bl, int n) {
        long l = 1000L * SystemClock.uptimeMillis();
        long l2 = 1000L * SystemClock.elapsedRealtime();
        long l3 = this.getBatteryUptimeLocked(l);
        long l4 = this.getBatteryRealtimeLocked(l2);
        parcel.writeInt(-1166707595);
        this.writeHistory(parcel);
        parcel.writeInt(this.mStartCount);
        parcel.writeLong(this.mBatteryUptime);
        parcel.writeLong(this.mBatteryRealtime);
        this.mScreenOnTimer.writeToParcel(parcel, l4);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(parcel, l4);
        }
        this.mInputEventCounter.writeToParcel(parcel);
        this.mPhoneOnTimer.writeToParcel(parcel, l4);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(parcel, l4);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(parcel, l4);
        for (int i = 0; i < 14; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(parcel, l4);
        }
        this.mWifiOnTimer.writeToParcel(parcel, l4);
        this.mGlobalWifiRunningTimer.writeToParcel(parcel, l4);
        this.mBluetoothOnTimer.writeToParcel(parcel, l4);
        parcel.writeLong(this.mUptime);
        parcel.writeLong(this.mUptimeStart);
        parcel.writeLong(this.mRealtime);
        parcel.writeLong(this.mRealtimeStart);
        int n2 = this.mOnBattery ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeLong(l3);
        parcel.writeLong(this.mTrackBatteryUptimeStart);
        parcel.writeLong(l4);
        parcel.writeLong(this.mTrackBatteryRealtimeStart);
        parcel.writeLong(this.mUnpluggedBatteryUptime);
        parcel.writeLong(this.mUnpluggedBatteryRealtime);
        parcel.writeInt(this.mDischargeUnplugLevel);
        parcel.writeInt(this.mDischargeCurrentLevel);
        parcel.writeInt(this.mLowDischargeAmountSinceCharge);
        parcel.writeInt(this.mHighDischargeAmountSinceCharge);
        parcel.writeLong(this.mLastWriteTime);
        parcel.writeLong(this.getMobileTcpBytesReceived(3));
        parcel.writeLong(this.getMobileTcpBytesSent(3));
        parcel.writeLong(this.getTotalTcpBytesReceived(3));
        parcel.writeLong(this.getTotalTcpBytesSent(3));
        parcel.writeLong(this.getRadioDataUptime());
        parcel.writeInt(this.getBluetoothPingCount());
        if (!bl) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer samplingTimer = entry.getValue();
                if (samplingTimer != null) {
                    parcel.writeInt(1);
                    parcel.writeString(entry.getKey());
                    Timer.writeTimerToParcel(parcel, samplingTimer, l4);
                    continue;
                }
                parcel.writeInt(0);
            }
        }
        parcel.writeInt(sNumSpeedSteps);
        if (bl) {
            int n3 = this.mUidStats.size();
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                parcel.writeInt(this.mUidStats.keyAt(i));
                this.mUidStats.valueAt(i).writeToParcelLocked(parcel, l4);
            }
            return;
        } else {
            parcel.writeInt(0);
        }
    }

    public void writeToParcelWithoutUids(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, false, n);
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);
    }

    public static class Counter
    extends BatteryStats.Counter
    implements Unpluggable {
        final AtomicInteger mCount = new AtomicInteger();
        int mLastCount;
        int mLoadedCount;
        int mPluggedCount;
        final ArrayList<Unpluggable> mUnpluggables;
        int mUnpluggedCount;

        Counter(ArrayList<Unpluggable> arrayList) {
            this.mUnpluggables = arrayList;
            arrayList.add(this);
        }

        Counter(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            this.mUnpluggables = arrayList;
            this.mPluggedCount = parcel.readInt();
            this.mCount.set(this.mPluggedCount);
            this.mLoadedCount = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = parcel.readInt();
            arrayList.add(this);
        }

        public static void writeCounterToParcel(Parcel parcel, Counter counter) {
            if (counter == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            counter.writeToParcel(parcel);
        }

        void detach() {
            this.mUnpluggables.remove(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCountLocked(int n) {
            if (n == 1) {
                return this.mLastCount;
            }
            int n2 = this.mCount.get();
            if (n == 3) {
                return n2 - this.mUnpluggedCount;
            }
            if (n == 0) return n2;
            return n2 - this.mLoadedCount;
        }

        @Override
        public void logState(Printer printer, String string2) {
            printer.println(string2 + "mCount=" + this.mCount.get() + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        @Override
        public void plug(long l, long l2) {
            this.mPluggedCount = this.mCount.get();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            this.mLoadedCount = parcel.readInt();
            this.mCount.set(this.mLoadedCount);
            this.mLastCount = 0;
            this.mPluggedCount = n = this.mLoadedCount;
            this.mUnpluggedCount = n;
        }

        void reset(boolean bl) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (bl) {
                this.detach();
            }
        }

        void stepAtomic() {
            this.mCount.incrementAndGet();
        }

        @Override
        public void unplug(long l, long l2) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount.set(this.mPluggedCount);
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            parcel.writeInt(this.mCount.get());
        }

        public void writeToParcel(Parcel parcel) {
            parcel.writeInt(this.mCount.get());
            parcel.writeInt(this.mLoadedCount);
            parcel.writeInt(this.mUnpluggedCount);
        }
    }

    private class KernelWakelockStats {
        public int mCount;
        public long mTotalTime;
        public int mVersion;

        KernelWakelockStats(int n, long l, int n2) {
            this.mCount = n;
            this.mTotalTime = l;
            this.mVersion = n2;
        }
    }

    final class MyHandler
    extends Handler {
        MyHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            boolean bl;
            BatteryCallback batteryCallback = BatteryStatsImpl.this.mCallback;
            switch (message.what) {
                case 1: {
                    if (batteryCallback == null) return;
                    batteryCallback.batteryNeedsCpuUpdate();
                    return;
                }
                default: {
                    return;
                }
                case 2: {
                    if (batteryCallback == null) return;
                    bl = message.arg1 != 0;
                }
            }
            batteryCallback.batteryPowerChanged(bl);
        }
    }

    public static class SamplingCounter
    extends Counter {
        SamplingCounter(ArrayList<Unpluggable> arrayList) {
            super(arrayList);
        }

        SamplingCounter(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            super(arrayList, parcel);
        }

        public void addCountAtomic(long l) {
            this.mCount.addAndGet((int)l);
        }
    }

    public static final class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        long mCurrentReportedTotalTime;
        boolean mInDischarge;
        boolean mTrackingReportedValues;
        int mUnpluggedReportedCount;
        long mUnpluggedReportedTotalTime;
        int mUpdateVersion;

        /*
         * Enabled aggressive block sorting
         */
        SamplingTimer(ArrayList<Unpluggable> arrayList, boolean bl, Parcel parcel) {
            super(0, arrayList, parcel);
            this.mCurrentReportedCount = parcel.readInt();
            this.mUnpluggedReportedCount = parcel.readInt();
            this.mCurrentReportedTotalTime = parcel.readLong();
            this.mUnpluggedReportedTotalTime = parcel.readLong();
            boolean bl2 = parcel.readInt() == 1;
            this.mTrackingReportedValues = bl2;
            this.mInDischarge = bl;
        }

        SamplingTimer(ArrayList<Unpluggable> arrayList, boolean bl, boolean bl2) {
            super(0, arrayList);
            this.mTrackingReportedValues = bl2;
            this.mInDischarge = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected int computeCurrentCountLocked() {
            int n;
            int n2 = this.mCount;
            if (this.mInDischarge && this.mTrackingReportedValues) {
                n = this.mCurrentReportedCount - this.mUnpluggedReportedCount;
                return n2 + n;
            }
            n = 0;
            return n2 + n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2;
            long l3 = this.mTotalTime;
            if (this.mInDischarge && this.mTrackingReportedValues) {
                l2 = this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime;
                return l3 + l2;
            }
            l2 = 0L;
            return l3 + l2;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            printer.println(string2 + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        @Override
        public void plug(long l, long l2) {
            super.plug(l, l2);
            this.mInDischarge = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            long l;
            super.readSummaryFromParcelLocked(parcel);
            this.mCurrentReportedTotalTime = l = parcel.readLong();
            this.mUnpluggedReportedTotalTime = l;
            this.mCurrentReportedCount = n = parcel.readInt();
            this.mUnpluggedReportedCount = n;
            boolean bl = parcel.readInt() == 1;
            this.mTrackingReportedValues = bl;
        }

        @Override
        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            super.reset(batteryStatsImpl, bl);
            this.setStale();
            return true;
        }

        public void setStale() {
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
        }

        public void setUpdateVersion(int n) {
            this.mUpdateVersion = n;
        }

        @Override
        public void unplug(long l, long l2) {
            super.unplug(l, l2);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mInDischarge = true;
        }

        public void updateCurrentReportedCount(int n) {
            if (this.mInDischarge && this.mUnpluggedReportedCount == 0) {
                this.mUnpluggedReportedCount = n;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedCount = n;
        }

        public void updateCurrentReportedTotalTime(long l) {
            if (this.mInDischarge && this.mUnpluggedReportedTotalTime == 0L) {
                this.mUnpluggedReportedTotalTime = l;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedTotalTime = l;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            super.writeSummaryFromParcelLocked(parcel, l);
            parcel.writeLong(this.mCurrentReportedTotalTime);
            parcel.writeInt(this.mCurrentReportedCount);
            int n = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            parcel.writeInt(this.mCurrentReportedCount);
            parcel.writeInt(this.mUnpluggedReportedCount);
            parcel.writeLong(this.mCurrentReportedTotalTime);
            parcel.writeLong(this.mUnpluggedReportedTotalTime);
            int n = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n);
        }
    }

    public static final class StopwatchTimer
    extends Timer {
        long mAcquireTime;
        boolean mInList;
        int mNesting;
        long mTimeout;
        final ArrayList<StopwatchTimer> mTimerPool;
        final Uid mUid;
        long mUpdateTime;

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2) {
            super(n, arrayList2);
            this.mUid = uid;
            this.mTimerPool = arrayList;
        }

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2, Parcel parcel) {
            super(n, arrayList2, parcel);
            this.mUid = uid;
            this.mTimerPool = arrayList;
            this.mUpdateTime = parcel.readLong();
        }

        private static void refreshTimersLocked(BatteryStatsImpl batteryStatsImpl, ArrayList<StopwatchTimer> arrayList) {
            long l = batteryStatsImpl.getBatteryRealtimeLocked(1000L * SystemClock.elapsedRealtime());
            int n = arrayList.size();
            for (int i = n - 1; i >= 0; --i) {
                StopwatchTimer stopwatchTimer = arrayList.get(i);
                long l2 = l - stopwatchTimer.mUpdateTime;
                if (l2 > 0L) {
                    stopwatchTimer.mTotalTime += l2 / (long)n;
                }
                stopwatchTimer.mUpdateTime = l;
            }
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2;
            if (this.mTimeout > 0L && l > this.mUpdateTime + this.mTimeout) {
                l = this.mUpdateTime + this.mTimeout;
            }
            long l3 = this.mTotalTime;
            if (this.mNesting <= 0) {
                l2 = 0L;
                return l3 + l2;
            }
            long l4 = l - this.mUpdateTime;
            int n = this.mTimerPool != null ? this.mTimerPool.size() : 1;
            l2 = l4 / (long)n;
            return l3 + l2;
        }

        @Override
        void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            printer.println(string2 + "mNesting=" + this.mNesting + "mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        @Override
        public void plug(long l, long l2) {
            if (this.mNesting > 0) {
                super.plug(l, l2);
                this.mUpdateTime = l2;
            }
        }

        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            super.readSummaryFromParcelLocked(parcel);
            this.mNesting = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            boolean bl2 = this.mNesting <= 0;
            boolean bl3 = bl2 && bl;
            super.reset(batteryStatsImpl, bl3);
            if (this.mNesting > 0) {
                this.mUpdateTime = batteryStatsImpl.getBatteryRealtimeLocked(1000L * SystemClock.elapsedRealtime());
            }
            this.mAcquireTime = this.mTotalTime;
            return bl2;
        }

        void setTimeout(long l) {
            this.mTimeout = l;
        }

        void startRunningLocked(BatteryStatsImpl batteryStatsImpl) {
            int n = this.mNesting;
            this.mNesting = n + 1;
            if (n == 0) {
                this.mUpdateTime = batteryStatsImpl.getBatteryRealtimeLocked(1000L * SystemClock.elapsedRealtime());
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryStatsImpl, this.mTimerPool);
                    this.mTimerPool.add(this);
                }
                this.mCount = 1 + this.mCount;
                this.mAcquireTime = this.mTotalTime;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void stopRunningLocked(BatteryStatsImpl batteryStatsImpl) {
            block6: {
                block5: {
                    int n;
                    if (this.mNesting == 0) break block5;
                    this.mNesting = n = this.mNesting - 1;
                    if (n != 0) break block5;
                    if (this.mTimerPool != null) {
                        StopwatchTimer.refreshTimersLocked(batteryStatsImpl, this.mTimerPool);
                        this.mTimerPool.remove(this);
                    } else {
                        long l = batteryStatsImpl.getBatteryRealtimeLocked(1000L * SystemClock.elapsedRealtime());
                        this.mNesting = 1;
                        this.mTotalTime = this.computeRunTimeLocked(l);
                        this.mNesting = 0;
                    }
                    if (this.mTotalTime == this.mAcquireTime) break block6;
                }
                return;
            }
            --this.mCount;
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            parcel.writeLong(this.mUpdateTime);
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements Unpluggable {
        int mCount;
        int mLastCount;
        long mLastTime;
        int mLoadedCount;
        long mLoadedTime;
        long mTotalTime;
        final int mType;
        final ArrayList<Unpluggable> mUnpluggables;
        int mUnpluggedCount;
        long mUnpluggedTime;

        Timer(int n, ArrayList<Unpluggable> arrayList) {
            this.mType = n;
            this.mUnpluggables = arrayList;
            arrayList.add(this);
        }

        Timer(int n, ArrayList<Unpluggable> arrayList, Parcel parcel) {
            this.mType = n;
            this.mUnpluggables = arrayList;
            this.mCount = parcel.readInt();
            this.mLoadedCount = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = parcel.readInt();
            this.mTotalTime = parcel.readLong();
            this.mLoadedTime = parcel.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = parcel.readLong();
            arrayList.add(this);
        }

        public static void writeTimerToParcel(Parcel parcel, Timer timer, long l) {
            if (timer == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            timer.writeToParcel(parcel, l);
        }

        protected abstract int computeCurrentCountLocked();

        protected abstract long computeRunTimeLocked(long var1);

        void detach() {
            this.mUnpluggables.remove(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCountLocked(int n) {
            if (n == 1) {
                return this.mLastCount;
            }
            int n2 = this.computeCurrentCountLocked();
            if (n == 3) {
                return n2 - this.mUnpluggedCount;
            }
            if (n == 0) return n2;
            return n2 - this.mLoadedCount;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getTotalTimeLocked(long l, int n) {
            if (n == 1) {
                return this.mLastTime;
            }
            long l2 = this.computeRunTimeLocked(l);
            if (n == 3) {
                return l2 - this.mUnpluggedTime;
            }
            if (n == 0) return l2;
            return l2 - this.mLoadedTime;
        }

        @Override
        public void logState(Printer printer, String string2) {
            printer.println(string2 + " mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount);
            printer.println(string2 + "mTotalTime=" + this.mTotalTime + " mLoadedTime=" + this.mLoadedTime);
            printer.println(string2 + "mLastTime=" + this.mLastTime + " mUnpluggedTime=" + this.mUnpluggedTime);
        }

        @Override
        public void plug(long l, long l2) {
            this.mTotalTime = this.computeRunTimeLocked(l2);
            this.mCount = this.computeCurrentCountLocked();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            long l;
            this.mLoadedTime = l = 1000L * parcel.readLong();
            this.mTotalTime = l;
            this.mLastTime = 0L;
            this.mUnpluggedTime = this.mTotalTime;
            this.mLoadedCount = n = parcel.readInt();
            this.mCount = n;
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mCount;
        }

        boolean reset(BatteryStatsImpl batteryStatsImpl, boolean bl) {
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            if (bl) {
                this.detach();
            }
            return true;
        }

        @Override
        public void unplug(long l, long l2) {
            this.mUnpluggedTime = this.computeRunTimeLocked(l2);
            this.mUnpluggedCount = this.mCount;
        }

        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            parcel.writeLong((500L + this.computeRunTimeLocked(l)) / 1000L);
            parcel.writeInt(this.mCount);
        }

        public void writeToParcel(Parcel parcel, long l) {
            parcel.writeInt(this.mCount);
            parcel.writeInt(this.mLoadedCount);
            parcel.writeInt(this.mUnpluggedCount);
            parcel.writeLong(this.computeRunTimeLocked(l));
            parcel.writeLong(this.mLoadedTime);
            parcel.writeLong(this.mUnpluggedTime);
        }
    }

    public final class Uid
    extends BatteryStats.Uid {
        boolean mAudioTurnedOn;
        StopwatchTimer mAudioTurnedOnTimer;
        long mCurrentTcpBytesReceived;
        long mCurrentTcpBytesSent;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        long mLoadedTcpBytesReceived;
        long mLoadedTcpBytesSent;
        final HashMap<String, Pkg> mPackageStats;
        final SparseArray<BatteryStats.Uid.Pid> mPids;
        final HashMap<String, Proc> mProcessStats;
        boolean mScanWifiLockOut;
        StopwatchTimer mScanWifiLockTimer;
        final HashMap<Integer, Sensor> mSensorStats;
        long mStartedTcpBytesReceived = -1L;
        long mStartedTcpBytesSent = -1L;
        long mTcpBytesReceivedAtLastUnplug;
        long mTcpBytesSentAtLastUnplug;
        final int mUid;
        Counter[] mUserActivityCounters;
        boolean mVideoTurnedOn;
        StopwatchTimer mVideoTurnedOnTimer;
        final HashMap<String, Wakelock> mWakelockStats = new HashMap();
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;

        public Uid(int n) {
            this.mSensorStats = new HashMap();
            this.mProcessStats = new HashMap();
            this.mPackageStats = new HashMap();
            this.mPids = new SparseArray();
            this.mUid = n;
            this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mScanWifiLockTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mScanWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables);
            this.mAudioTurnedOnTimer = new StopwatchTimer(this, 7, null, BatteryStatsImpl.this.mUnpluggables);
            this.mVideoTurnedOnTimer = new StopwatchTimer(this, 8, null, BatteryStatsImpl.this.mUnpluggables);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long computeCurrentTcpBytesReceived() {
            long l;
            long l2 = this.mCurrentTcpBytesReceived;
            if (this.mStartedTcpBytesReceived >= 0L) {
                l = TrafficStats.getUidRxBytes(this.mUid) - this.mStartedTcpBytesReceived;
                return l2 + l;
            }
            l = 0L;
            return l2 + l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long computeCurrentTcpBytesSent() {
            long l;
            long l2 = this.mCurrentTcpBytesSent;
            if (this.mStartedTcpBytesSent >= 0L) {
                l = TrafficStats.getUidTxBytes(this.mUid) - this.mStartedTcpBytesSent;
                return l2 + l;
            }
            l = 0L;
            return l2 + l;
        }

        @Override
        public long getAudioTurnedOnTime(long l, int n) {
            if (this.mAudioTurnedOnTimer == null) {
                return 0L;
            }
            return this.mAudioTurnedOnTimer.getTotalTimeLocked(l, n);
        }

        public BatteryStatsImpl getBatteryStats() {
            return BatteryStatsImpl.this;
        }

        @Override
        public long getFullWifiLockTime(long l, int n) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        public Pkg getPackageStatsLocked(String string2) {
            Pkg pkg = this.mPackageStats.get(string2);
            if (pkg == null) {
                pkg = new Pkg();
                this.mPackageStats.put(string2, pkg);
            }
            return pkg;
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int n) {
            BatteryStats.Uid.Pid pid = this.mPids.get(n);
            if (pid == null) {
                pid = new BatteryStats.Uid.Pid();
                this.mPids.put(n, pid);
            }
            return pid;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        public Proc getProcessStatsLocked(String string2) {
            Proc proc = this.mProcessStats.get(string2);
            if (proc == null) {
                proc = new Proc();
                this.mProcessStats.put(string2, proc);
            }
            return proc;
        }

        @Override
        public long getScanWifiLockTime(long l, int n) {
            if (this.mScanWifiLockTimer == null) {
                return 0L;
            }
            return this.mScanWifiLockTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public Map<Integer, ? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        public StopwatchTimer getSensorTimerLocked(int n, boolean bl) {
            StopwatchTimer stopwatchTimer;
            StopwatchTimer stopwatchTimer2;
            Sensor sensor = this.mSensorStats.get(n);
            if (sensor == null) {
                if (!bl) {
                    return null;
                }
                sensor = new Sensor(n);
                this.mSensorStats.put(n, sensor);
            }
            if ((stopwatchTimer2 = sensor.mTimer) != null) {
                return stopwatchTimer2;
            }
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mSensorTimers.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList();
                BatteryStatsImpl.this.mSensorTimers.put(n, arrayList);
            }
            sensor.mTimer = stopwatchTimer = new StopwatchTimer(this, 3, arrayList, BatteryStatsImpl.this.mUnpluggables);
            return stopwatchTimer;
        }

        public Pkg.Serv getServiceStatsLocked(String string2, String string3) {
            Pkg pkg = this.getPackageStatsLocked(string2);
            Pkg.Serv serv = pkg.mServiceStats.get(string3);
            if (serv == null) {
                serv = pkg.newServiceStatsLocked();
                pkg.mServiceStats.put(string3, serv);
            }
            return serv;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getTcpBytesReceived(int n) {
            if (n == 1) {
                return this.mLoadedTcpBytesReceived;
            }
            long l = this.computeCurrentTcpBytesReceived();
            if (n == 3) {
                l -= this.mTcpBytesReceivedAtLastUnplug;
                return l;
            }
            if (n != 0) return l;
            return l += this.mLoadedTcpBytesReceived;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getTcpBytesSent(int n) {
            if (n == 1) {
                return this.mLoadedTcpBytesSent;
            }
            long l = this.computeCurrentTcpBytesSent();
            if (n == 3) {
                l -= this.mTcpBytesSentAtLastUnplug;
                return l;
            }
            if (n != 0) return l;
            return l += this.mLoadedTcpBytesSent;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        @Override
        public int getUserActivityCount(int n, int n2) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[n].getCountLocked(n2);
        }

        @Override
        public long getVideoTurnedOnTime(long l, int n) {
            if (this.mVideoTurnedOnTimer == null) {
                return 0L;
            }
            return this.mVideoTurnedOnTimer.getTotalTimeLocked(l, n);
        }

        public StopwatchTimer getWakeTimerLocked(String string2, int n) {
            Wakelock wakelock = this.mWakelockStats.get(string2);
            if (wakelock == null) {
                if (this.mWakelockStats.size() > 30) {
                    string2 = BatteryStatsImpl.BATCHED_WAKELOCK_NAME;
                    wakelock = this.mWakelockStats.get(string2);
                }
                if (wakelock == null) {
                    wakelock = new Wakelock();
                    this.mWakelockStats.put(string2, wakelock);
                }
            }
            switch (n) {
                default: {
                    throw new IllegalArgumentException("type=" + n);
                }
                case 0: {
                    StopwatchTimer stopwatchTimer = wakelock.mTimerPartial;
                    if (stopwatchTimer == null) {
                        wakelock.mTimerPartial = stopwatchTimer = new StopwatchTimer(this, 0, BatteryStatsImpl.this.mPartialTimers, BatteryStatsImpl.this.mUnpluggables);
                    }
                    return stopwatchTimer;
                }
                case 1: {
                    StopwatchTimer stopwatchTimer = wakelock.mTimerFull;
                    if (stopwatchTimer == null) {
                        wakelock.mTimerFull = stopwatchTimer = new StopwatchTimer(this, 1, BatteryStatsImpl.this.mFullTimers, BatteryStatsImpl.this.mUnpluggables);
                    }
                    return stopwatchTimer;
                }
                case 2: 
            }
            StopwatchTimer stopwatchTimer = wakelock.mTimerWindow;
            if (stopwatchTimer == null) {
                wakelock.mTimerWindow = stopwatchTimer = new StopwatchTimer(this, 2, BatteryStatsImpl.this.mWindowTimers, BatteryStatsImpl.this.mUnpluggables);
            }
            return stopwatchTimer;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats;
        }

        @Override
        public long getWifiMulticastTime(long l, int n) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public long getWifiRunningTime(long l, int n) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        void initUserActivityLocked() {
            this.mUserActivityCounters = new Counter[7];
            for (int i = 0; i < 7; ++i) {
                this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mUnpluggables);
            }
        }

        @Override
        public void noteAudioTurnedOffLocked() {
            if (this.mAudioTurnedOn) {
                this.mAudioTurnedOn = false;
                this.mAudioTurnedOnTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteAudioTurnedOnLocked() {
            if (!this.mAudioTurnedOn) {
                this.mAudioTurnedOn = true;
                if (this.mAudioTurnedOnTimer == null) {
                    this.mAudioTurnedOnTimer = new StopwatchTimer(this, 7, null, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mAudioTurnedOnTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteFullWifiLockAcquiredLocked() {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mFullWifiLockTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked() {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteScanWifiLockAcquiredLocked() {
            if (!this.mScanWifiLockOut) {
                this.mScanWifiLockOut = true;
                if (this.mScanWifiLockTimer == null) {
                    this.mScanWifiLockTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mScanWifiLockTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mScanWifiLockTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteScanWifiLockReleasedLocked() {
            if (this.mScanWifiLockOut) {
                this.mScanWifiLockOut = false;
                this.mScanWifiLockTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStartGps() {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(-10000, true);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStartSensor(int n) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, true);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStartWakeLocked(int n, String string2, int n2) {
            StopwatchTimer stopwatchTimer = this.getWakeTimerLocked(string2, n2);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(BatteryStatsImpl.this);
            }
            if (n >= 0 && n2 == 0) {
                BatteryStats.Uid.Pid pid = this.getPidStatsLocked(n);
                if (pid.mWakeStart == 0L) {
                    pid.mWakeStart = SystemClock.elapsedRealtime();
                }
            }
        }

        public void noteStopGps() {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(-10000, false);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStopSensor(int n) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, false);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        public void noteStopWakeLocked(int n, String string2, int n2) {
            BatteryStats.Uid.Pid pid;
            StopwatchTimer stopwatchTimer = this.getWakeTimerLocked(string2, n2);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
            if (n >= 0 && n2 == 0 && (pid = this.mPids.get(n)) != null && pid.mWakeStart != 0L) {
                pid.mWakeSum += SystemClock.elapsedRealtime() - pid.mWakeStart;
                pid.mWakeStart = 0L;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void noteUserActivityLocked(int n) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (n < 0) {
                n = 0;
            } else if (n >= 7) {
                n = 6;
            }
            this.mUserActivityCounters[n].stepAtomic();
        }

        @Override
        public void noteVideoTurnedOffLocked() {
            if (this.mVideoTurnedOn) {
                this.mVideoTurnedOn = false;
                this.mVideoTurnedOnTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteVideoTurnedOnLocked() {
            if (!this.mVideoTurnedOn) {
                this.mVideoTurnedOn = true;
                if (this.mVideoTurnedOnTimer == null) {
                    this.mVideoTurnedOnTimer = new StopwatchTimer(this, 8, null, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mVideoTurnedOnTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiMulticastDisabledLocked() {
            if (this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = false;
                this.mWifiMulticastTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked() {
            if (!this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = true;
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mWifiMulticastTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiRunningLocked() {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables);
                }
                this.mWifiRunningTimer.startRunningLocked(BatteryStatsImpl.this);
            }
        }

        @Override
        public void noteWifiStoppedLocked() {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(BatteryStatsImpl.this);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
            int n = parcel.readInt();
            this.mWakelockStats.clear();
            for (int i = 0; i < n; ++i) {
                String string2 = parcel.readString();
                Wakelock wakelock = new Wakelock();
                wakelock.readFromParcelLocked(arrayList, parcel);
                if (this.mWakelockStats.size() >= 30) continue;
                this.mWakelockStats.put(string2, wakelock);
            }
            int n2 = parcel.readInt();
            this.mSensorStats.clear();
            for (int i = 0; i < n2; ++i) {
                int n3 = parcel.readInt();
                Sensor sensor = new Sensor(n3);
                sensor.readFromParcelLocked(BatteryStatsImpl.this.mUnpluggables, parcel);
                this.mSensorStats.put(n3, sensor);
            }
            int n4 = parcel.readInt();
            this.mProcessStats.clear();
            for (int i = 0; i < n4; ++i) {
                String string3 = parcel.readString();
                Proc proc = new Proc();
                proc.readFromParcelLocked(parcel);
                this.mProcessStats.put(string3, proc);
            }
            int n5 = parcel.readInt();
            this.mPackageStats.clear();
            for (int i = 0; i < n5; ++i) {
                String string4 = parcel.readString();
                Pkg pkg = new Pkg();
                pkg.readFromParcelLocked(parcel);
                this.mPackageStats.put(string4, pkg);
            }
            this.mLoadedTcpBytesReceived = parcel.readLong();
            this.mLoadedTcpBytesSent = parcel.readLong();
            this.mCurrentTcpBytesReceived = parcel.readLong();
            this.mCurrentTcpBytesSent = parcel.readLong();
            this.mTcpBytesReceivedAtLastUnplug = parcel.readLong();
            this.mTcpBytesSentAtLastUnplug = parcel.readLong();
            this.mWifiRunning = false;
            this.mWifiRunningTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            this.mScanWifiLockOut = false;
            this.mScanWifiLockTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 6, BatteryStatsImpl.this.mScanWifiLockTimers, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            this.mWifiMulticastEnabled = false;
            this.mWifiMulticastTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            this.mAudioTurnedOn = false;
            this.mAudioTurnedOnTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 7, null, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            this.mVideoTurnedOn = false;
            this.mVideoTurnedOnTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 8, null, BatteryStatsImpl.this.mUnpluggables, parcel) : null;
            if (parcel.readInt() != 0) {
                this.mUserActivityCounters = new Counter[7];
                for (int i = 0; i < 7; ++i) {
                    Counter counter;
                    Counter[] counterArray = this.mUserActivityCounters;
                    counterArray[i] = counter = new Counter(BatteryStatsImpl.this.mUnpluggables, parcel);
                }
                return;
            } else {
                this.mUserActivityCounters = null;
            }
        }

        public void reportExcessiveCpuLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc != null) {
                proc.addExcessiveCpu(l, l2);
            }
        }

        public void reportExcessiveWakeLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc != null) {
                proc.addExcessiveWake(l, l2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean reset() {
            StopwatchTimer stopwatchTimer = this.mWifiRunningTimer;
            boolean bl = false;
            if (stopwatchTimer != null) {
                boolean bl2 = !this.mWifiRunningTimer.reset(BatteryStatsImpl.this, false);
                bl = false | bl2 | this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                boolean bl3 = !this.mFullWifiLockTimer.reset(BatteryStatsImpl.this, false);
                bl = bl | bl3 | this.mFullWifiLockOut;
            }
            if (this.mScanWifiLockTimer != null) {
                boolean bl4 = !this.mScanWifiLockTimer.reset(BatteryStatsImpl.this, false);
                bl = bl | bl4 | this.mScanWifiLockOut;
            }
            if (this.mWifiMulticastTimer != null) {
                boolean bl5 = !this.mWifiMulticastTimer.reset(BatteryStatsImpl.this, false);
                bl = bl | bl5 | this.mWifiMulticastEnabled;
            }
            if (this.mAudioTurnedOnTimer != null) {
                boolean bl6 = !this.mAudioTurnedOnTimer.reset(BatteryStatsImpl.this, false);
                bl = bl | bl6 | this.mAudioTurnedOn;
            }
            if (this.mVideoTurnedOnTimer != null) {
                boolean bl7 = !this.mVideoTurnedOnTimer.reset(BatteryStatsImpl.this, false);
                bl = bl | bl7 | this.mVideoTurnedOn;
            }
            this.mLoadedTcpBytesSent = 0L;
            this.mLoadedTcpBytesReceived = 0L;
            this.mCurrentTcpBytesSent = 0L;
            this.mCurrentTcpBytesReceived = 0L;
            if (this.mUserActivityCounters != null) {
                for (int i = 0; i < 7; ++i) {
                    this.mUserActivityCounters[i].reset(false);
                }
            }
            if (this.mWakelockStats.size() > 0) {
                Iterator<Map.Entry<String, Wakelock>> iterator = this.mWakelockStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getValue().reset()) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                }
            }
            if (this.mSensorStats.size() > 0) {
                Iterator<Map.Entry<Integer, Sensor>> iterator = this.mSensorStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getValue().reset()) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                }
            }
            if (this.mProcessStats.size() > 0) {
                Iterator<Map.Entry<String, Proc>> iterator = this.mProcessStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().getValue().detach();
                }
                this.mProcessStats.clear();
            }
            if (this.mPids.size() > 0) {
                int n;
                for (int i = 0; !bl && i < (n = this.mPids.size()); ++i) {
                    if (this.mPids.valueAt((int)i).mWakeStart == 0L) continue;
                    bl = true;
                }
            }
            if (this.mPackageStats.size() > 0) {
                Iterator<Map.Entry<String, Pkg>> iterator = this.mPackageStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Pkg pkg = iterator.next().getValue();
                    pkg.detach();
                    if (pkg.mServiceStats.size() <= 0) continue;
                    Iterator<Map.Entry<String, Pkg.Serv>> iterator2 = pkg.mServiceStats.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        iterator2.next().getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            this.mPids.clear();
            if (!bl) {
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mScanWifiLockTimer != null) {
                    this.mScanWifiLockTimer.detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                }
                if (this.mUserActivityCounters != null) {
                    for (int i = 0; i < 7; ++i) {
                        this.mUserActivityCounters[i].detach();
                    }
                }
            }
            return !bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcelLocked(Parcel parcel, long l) {
            parcel.writeInt(this.mWakelockStats.size());
            for (Map.Entry<String, Wakelock> entry : this.mWakelockStats.entrySet()) {
                parcel.writeString(entry.getKey());
                entry.getValue().writeToParcelLocked(parcel, l);
            }
            parcel.writeInt(this.mSensorStats.size());
            for (Map.Entry<Integer, Sensor> entry : this.mSensorStats.entrySet()) {
                parcel.writeInt(entry.getKey());
                entry.getValue().writeToParcelLocked(parcel, l);
            }
            parcel.writeInt(this.mProcessStats.size());
            for (Map.Entry<String, Proc> entry : this.mProcessStats.entrySet()) {
                parcel.writeString(entry.getKey());
                entry.getValue().writeToParcelLocked(parcel);
            }
            parcel.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> entry : this.mPackageStats.entrySet()) {
                parcel.writeString(entry.getKey());
                entry.getValue().writeToParcelLocked(parcel);
            }
            parcel.writeLong(this.mLoadedTcpBytesReceived);
            parcel.writeLong(this.mLoadedTcpBytesSent);
            parcel.writeLong(this.computeCurrentTcpBytesReceived());
            parcel.writeLong(this.computeCurrentTcpBytesSent());
            parcel.writeLong(this.mTcpBytesReceivedAtLastUnplug);
            parcel.writeLong(this.mTcpBytesSentAtLastUnplug);
            if (this.mWifiRunningTimer != null) {
                parcel.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                parcel.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mScanWifiLockTimer != null) {
                parcel.writeInt(1);
                this.mScanWifiLockTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                parcel.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                parcel.writeInt(1);
                for (int i = 0; i < 7; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(parcel);
                }
                return;
            } else {
                parcel.writeInt(0);
            }
        }

        public final class Pkg
        extends BatteryStats.Uid.Pkg
        implements Unpluggable {
            int mLastWakeups;
            int mLoadedWakeups;
            final HashMap<String, Serv> mServiceStats = new HashMap();
            int mUnpluggedWakeups;
            int mWakeups;

            Pkg() {
                BatteryStatsImpl.this.mUnpluggables.add(this);
            }

            void detach() {
                BatteryStatsImpl.this.mUnpluggables.remove(this);
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            @Override
            public Map<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getWakeups(int n) {
                if (n == 1) {
                    return this.mLastWakeups;
                }
                int n2 = this.mWakeups;
                if (n == 2) {
                    return n2 - this.mLoadedWakeups;
                }
                if (n != 3) return n2;
                return n2 - this.mUnpluggedWakeups;
            }

            public void incWakeupsLocked() {
                this.mWakeups = 1 + this.mWakeups;
            }

            final Serv newServiceStatsLocked() {
                return new Serv();
            }

            @Override
            public void plug(long l, long l2) {
            }

            void readFromParcelLocked(Parcel parcel) {
                this.mWakeups = parcel.readInt();
                this.mLoadedWakeups = parcel.readInt();
                this.mLastWakeups = 0;
                this.mUnpluggedWakeups = parcel.readInt();
                int n = parcel.readInt();
                this.mServiceStats.clear();
                for (int i = 0; i < n; ++i) {
                    String string2 = parcel.readString();
                    Serv serv = new Serv();
                    this.mServiceStats.put(string2, serv);
                    serv.readFromParcelLocked(parcel);
                }
            }

            @Override
            public void unplug(long l, long l2) {
                this.mUnpluggedWakeups = this.mWakeups;
            }

            void writeToParcelLocked(Parcel parcel) {
                parcel.writeInt(this.mWakeups);
                parcel.writeInt(this.mLoadedWakeups);
                parcel.writeInt(this.mUnpluggedWakeups);
                parcel.writeInt(this.mServiceStats.size());
                for (Map.Entry<String, Serv> entry : this.mServiceStats.entrySet()) {
                    parcel.writeString(entry.getKey());
                    entry.getValue().writeToParcelLocked(parcel);
                }
            }

            public final class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements Unpluggable {
                int mLastLaunches;
                long mLastStartTime;
                int mLastStarts;
                boolean mLaunched;
                long mLaunchedSince;
                long mLaunchedTime;
                int mLaunches;
                int mLoadedLaunches;
                long mLoadedStartTime;
                int mLoadedStarts;
                boolean mRunning;
                long mRunningSince;
                long mStartTime;
                int mStarts;
                int mUnpluggedLaunches;
                long mUnpluggedStartTime;
                int mUnpluggedStarts;

                Serv() {
                    BatteryStatsImpl.this.mUnpluggables.add(this);
                }

                void detach() {
                    BatteryStatsImpl.this.mUnpluggables.remove(this);
                }

                public BatteryStatsImpl getBatteryStats() {
                    return BatteryStatsImpl.this;
                }

                long getLaunchTimeToNowLocked(long l) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return l + this.mLaunchedTime - this.mLaunchedSince;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public int getLaunches(int n) {
                    if (n == 1) {
                        return this.mLastLaunches;
                    }
                    int n2 = this.mLaunches;
                    if (n == 2) {
                        return n2 - this.mLoadedLaunches;
                    }
                    if (n != 3) return n2;
                    return n2 - this.mUnpluggedLaunches;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public long getStartTime(long l, int n) {
                    if (n == 1) {
                        return this.mLastStartTime;
                    }
                    long l2 = this.getStartTimeToNowLocked(l);
                    if (n == 2) {
                        return l2 - this.mLoadedStartTime;
                    }
                    if (n != 3) return l2;
                    return l2 - this.mUnpluggedStartTime;
                }

                long getStartTimeToNowLocked(long l) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return l + this.mStartTime - this.mRunningSince;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public int getStarts(int n) {
                    if (n == 1) {
                        return this.mLastStarts;
                    }
                    int n2 = this.mStarts;
                    if (n == 2) {
                        return n2 - this.mLoadedStarts;
                    }
                    if (n != 3) return n2;
                    return n2 - this.mUnpluggedStarts;
                }

                @Override
                public void plug(long l, long l2) {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void readFromParcelLocked(Parcel parcel) {
                    this.mStartTime = parcel.readLong();
                    this.mRunningSince = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    this.mRunning = bl;
                    this.mStarts = parcel.readInt();
                    this.mLaunchedTime = parcel.readLong();
                    this.mLaunchedSince = parcel.readLong();
                    boolean bl2 = parcel.readInt() != 0;
                    this.mLaunched = bl2;
                    this.mLaunches = parcel.readInt();
                    this.mLoadedStartTime = parcel.readLong();
                    this.mLoadedStarts = parcel.readInt();
                    this.mLoadedLaunches = parcel.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = parcel.readLong();
                    this.mUnpluggedStarts = parcel.readInt();
                    this.mUnpluggedLaunches = parcel.readInt();
                }

                public void startLaunchedLocked() {
                    if (!this.mLaunched) {
                        this.mLaunches = 1 + this.mLaunches;
                        this.mLaunchedSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                public void startRunningLocked() {
                    if (!this.mRunning) {
                        this.mStarts = 1 + this.mStarts;
                        this.mRunningSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long l = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (l > 0L) {
                            this.mLaunchedTime = l + this.mLaunchedTime;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopRunningLocked() {
                    if (this.mRunning) {
                        long l = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mRunningSince;
                        if (l > 0L) {
                            this.mStartTime = l + this.mStartTime;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                @Override
                public void unplug(long l, long l2) {
                    this.mUnpluggedStartTime = this.getStartTimeToNowLocked(l);
                    this.mUnpluggedStarts = this.mStarts;
                    this.mUnpluggedLaunches = this.mLaunches;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void writeToParcelLocked(Parcel parcel) {
                    parcel.writeLong(this.mStartTime);
                    parcel.writeLong(this.mRunningSince);
                    int n = this.mRunning ? 1 : 0;
                    parcel.writeInt(n);
                    parcel.writeInt(this.mStarts);
                    parcel.writeLong(this.mLaunchedTime);
                    parcel.writeLong(this.mLaunchedSince);
                    int n2 = this.mLaunched ? 1 : 0;
                    parcel.writeInt(n2);
                    parcel.writeInt(this.mLaunches);
                    parcel.writeLong(this.mLoadedStartTime);
                    parcel.writeInt(this.mLoadedStarts);
                    parcel.writeInt(this.mLoadedLaunches);
                    parcel.writeLong(this.mUnpluggedStartTime);
                    parcel.writeInt(this.mUnpluggedStarts);
                    parcel.writeInt(this.mUnpluggedLaunches);
                }
            }
        }

        public final class Proc
        extends BatteryStats.Uid.Proc
        implements Unpluggable {
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;
            long mForegroundTime;
            long mLastForegroundTime;
            int mLastStarts;
            long mLastSystemTime;
            long mLastUserTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            long mLoadedSystemTime;
            long mLoadedUserTime;
            SamplingCounter[] mSpeedBins;
            int mStarts;
            long mSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            long mUnpluggedSystemTime;
            long mUnpluggedUserTime;
            long mUserTime;

            Proc() {
                BatteryStatsImpl.this.mUnpluggables.add(this);
                this.mSpeedBins = new SamplingCounter[BatteryStatsImpl.this.getCpuSpeedSteps()];
            }

            public void addCpuTimeLocked(int n, int n2) {
                this.mUserTime += (long)n;
                this.mSystemTime += (long)n2;
            }

            public void addExcessiveCpu(long l, long l2) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 2;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                this.mExcessivePower.add(excessivePower);
            }

            public void addExcessiveWake(long l, long l2) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 1;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                this.mExcessivePower.add(excessivePower);
            }

            public void addForegroundTimeLocked(long l) {
                this.mForegroundTime = l + this.mForegroundTime;
            }

            public void addSpeedStepTimes(long[] lArray) {
                for (int i = 0; i < this.mSpeedBins.length && i < lArray.length; ++i) {
                    if (lArray[i] == 0L) continue;
                    SamplingCounter samplingCounter = this.mSpeedBins[i];
                    if (samplingCounter == null) {
                        SamplingCounter[] samplingCounterArray = this.mSpeedBins;
                        samplingCounterArray[i] = samplingCounter = new SamplingCounter(BatteryStatsImpl.this.mUnpluggables);
                    }
                    samplingCounter.addCountAtomic(lArray[i]);
                }
            }

            @Override
            public int countExcessivePowers() {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.size();
                }
                return 0;
            }

            void detach() {
                BatteryStatsImpl.this.mUnpluggables.remove(this);
                for (int i = 0; i < this.mSpeedBins.length; ++i) {
                    SamplingCounter samplingCounter = this.mSpeedBins[i];
                    if (samplingCounter == null) continue;
                    BatteryStatsImpl.this.mUnpluggables.remove(samplingCounter);
                    this.mSpeedBins[i] = null;
                }
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int n) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(n);
                }
                return null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getForegroundTime(int n) {
                if (n == 1) {
                    return this.mLastForegroundTime;
                }
                long l = this.mForegroundTime;
                if (n == 2) {
                    return l - this.mLoadedForegroundTime;
                }
                if (n != 3) return l;
                return l - this.mUnpluggedForegroundTime;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getStarts(int n) {
                if (n == 1) {
                    return this.mLastStarts;
                }
                int n2 = this.mStarts;
                if (n == 2) {
                    return n2 - this.mLoadedStarts;
                }
                if (n != 3) return n2;
                return n2 - this.mUnpluggedStarts;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getSystemTime(int n) {
                if (n == 1) {
                    return this.mLastSystemTime;
                }
                long l = this.mSystemTime;
                if (n == 2) {
                    return l - this.mLoadedSystemTime;
                }
                if (n != 3) return l;
                return l - this.mUnpluggedSystemTime;
            }

            @Override
            public long getTimeAtCpuSpeedStep(int n, int n2) {
                if (n < this.mSpeedBins.length) {
                    SamplingCounter samplingCounter = this.mSpeedBins[n];
                    if (samplingCounter != null) {
                        return samplingCounter.getCountLocked(n2);
                    }
                    return 0L;
                }
                return 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public long getUserTime(int n) {
                if (n == 1) {
                    return this.mLastUserTime;
                }
                long l = this.mUserTime;
                if (n == 2) {
                    return l - this.mLoadedUserTime;
                }
                if (n != 3) return l;
                return l - this.mUnpluggedUserTime;
            }

            public void incStartsLocked() {
                this.mStarts = 1 + this.mStarts;
            }

            @Override
            public void plug(long l, long l2) {
            }

            boolean readExcessivePowerFromParcelLocked(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    this.mExcessivePower = null;
                    return true;
                }
                if (n > 10000) {
                    Slog.w(BatteryStatsImpl.TAG, "File corrupt: too many excessive power entries " + n);
                    return false;
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                    excessivePower.type = parcel.readInt();
                    excessivePower.overTime = parcel.readLong();
                    excessivePower.usedTime = parcel.readLong();
                    this.mExcessivePower.add(excessivePower);
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            void readFromParcelLocked(Parcel parcel) {
                int n;
                this.mUserTime = parcel.readLong();
                this.mSystemTime = parcel.readLong();
                this.mForegroundTime = parcel.readLong();
                this.mStarts = parcel.readInt();
                this.mLoadedUserTime = parcel.readLong();
                this.mLoadedSystemTime = parcel.readLong();
                this.mLoadedForegroundTime = parcel.readLong();
                this.mLoadedStarts = parcel.readInt();
                this.mLastUserTime = 0L;
                this.mLastSystemTime = 0L;
                this.mLastForegroundTime = 0L;
                this.mLastStarts = 0;
                this.mUnpluggedUserTime = parcel.readLong();
                this.mUnpluggedSystemTime = parcel.readLong();
                this.mUnpluggedForegroundTime = parcel.readLong();
                this.mUnpluggedStarts = parcel.readInt();
                int n2 = parcel.readInt();
                int n3 = n2 >= (n = BatteryStatsImpl.this.getCpuSpeedSteps()) ? n2 : n;
                this.mSpeedBins = new SamplingCounter[n3];
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) {
                        this.readExcessivePowerFromParcelLocked(parcel);
                        return;
                    }
                    if (parcel.readInt() != 0) {
                        this.mSpeedBins[n4] = new SamplingCounter(BatteryStatsImpl.this.mUnpluggables, parcel);
                    }
                    ++n4;
                }
            }

            @Override
            public void unplug(long l, long l2) {
                this.mUnpluggedUserTime = this.mUserTime;
                this.mUnpluggedSystemTime = this.mSystemTime;
                this.mUnpluggedStarts = this.mStarts;
                this.mUnpluggedForegroundTime = this.mForegroundTime;
            }

            /*
             * Enabled aggressive block sorting
             */
            void writeExcessivePowerToParcelLocked(Parcel parcel) {
                if (this.mExcessivePower == null) {
                    parcel.writeInt(0);
                    return;
                } else {
                    int n = this.mExcessivePower.size();
                    parcel.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        BatteryStats.Uid.Proc.ExcessivePower excessivePower = this.mExcessivePower.get(i);
                        parcel.writeInt(excessivePower.type);
                        parcel.writeLong(excessivePower.overTime);
                        parcel.writeLong(excessivePower.usedTime);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            void writeToParcelLocked(Parcel parcel) {
                parcel.writeLong(this.mUserTime);
                parcel.writeLong(this.mSystemTime);
                parcel.writeLong(this.mForegroundTime);
                parcel.writeInt(this.mStarts);
                parcel.writeLong(this.mLoadedUserTime);
                parcel.writeLong(this.mLoadedSystemTime);
                parcel.writeLong(this.mLoadedForegroundTime);
                parcel.writeInt(this.mLoadedStarts);
                parcel.writeLong(this.mUnpluggedUserTime);
                parcel.writeLong(this.mUnpluggedSystemTime);
                parcel.writeLong(this.mUnpluggedForegroundTime);
                parcel.writeInt(this.mUnpluggedStarts);
                parcel.writeInt(this.mSpeedBins.length);
                int n = 0;
                while (true) {
                    if (n >= this.mSpeedBins.length) {
                        this.writeExcessivePowerToParcelLocked(parcel);
                        return;
                    }
                    SamplingCounter samplingCounter = this.mSpeedBins[n];
                    if (samplingCounter != null) {
                        parcel.writeInt(1);
                        samplingCounter.writeToParcel(parcel);
                    } else {
                        parcel.writeInt(0);
                    }
                    ++n;
                }
            }
        }

        public final class Sensor
        extends BatteryStats.Uid.Sensor {
            final int mHandle;
            StopwatchTimer mTimer;

            public Sensor(int n) {
                this.mHandle = n;
            }

            private StopwatchTimer readTimerFromParcel(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                if (parcel.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> arrayList2 = BatteryStatsImpl.this.mSensorTimers.get(this.mHandle);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                    BatteryStatsImpl.this.mSensorTimers.put(this.mHandle, arrayList2);
                }
                return new StopwatchTimer(Uid.this, 0, arrayList2, arrayList, parcel);
            }

            @Override
            public int getHandle() {
                return this.mHandle;
            }

            @Override
            public Timer getSensorTime() {
                return this.mTimer;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                this.mTimer = this.readTimerFromParcel(arrayList, parcel);
            }

            boolean reset() {
                if (this.mTimer.reset(BatteryStatsImpl.this, true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                Timer.writeTimerToParcel(parcel, this.mTimer, l);
            }
        }

        public final class Wakelock
        extends BatteryStats.Uid.Wakelock {
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerWindow;

            private StopwatchTimer readTimerFromParcel(int n, ArrayList<StopwatchTimer> arrayList, ArrayList<Unpluggable> arrayList2, Parcel parcel) {
                if (parcel.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(Uid.this, n, arrayList, arrayList2, parcel);
            }

            @Override
            public Timer getWakeTime(int n) {
                switch (n) {
                    default: {
                        throw new IllegalArgumentException("type = " + n);
                    }
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: 
                }
                return this.mTimerWindow;
            }

            void readFromParcelLocked(ArrayList<Unpluggable> arrayList, Parcel parcel) {
                this.mTimerPartial = this.readTimerFromParcel(0, BatteryStatsImpl.this.mPartialTimers, arrayList, parcel);
                this.mTimerFull = this.readTimerFromParcel(1, BatteryStatsImpl.this.mFullTimers, arrayList, parcel);
                this.mTimerWindow = this.readTimerFromParcel(2, BatteryStatsImpl.this.mWindowTimers, arrayList, parcel);
            }

            /*
             * Enabled aggressive block sorting
             */
            boolean reset() {
                StopwatchTimer stopwatchTimer = this.mTimerFull;
                boolean bl = false;
                if (stopwatchTimer != null) {
                    boolean bl2 = !this.mTimerFull.reset(BatteryStatsImpl.this, false);
                    bl = false | bl2;
                }
                if (this.mTimerPartial != null) {
                    boolean bl3 = !this.mTimerPartial.reset(BatteryStatsImpl.this, false);
                    bl |= bl3;
                }
                if (this.mTimerWindow != null) {
                    boolean bl4 = !this.mTimerWindow.reset(BatteryStatsImpl.this, false);
                    bl |= bl4;
                }
                if (!bl) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                }
                return !bl;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                Timer.writeTimerToParcel(parcel, this.mTimerPartial, l);
                Timer.writeTimerToParcel(parcel, this.mTimerFull, l);
                Timer.writeTimerToParcel(parcel, this.mTimerWindow, l);
            }
        }
    }

    public static interface Unpluggable {
        public void plug(long var1, long var3);

        public void unplug(long var1, long var3);
    }
}

