/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public class HandlerCaller {
    static final int ARGS_POOL_MAX_SIZE = 10;
    private static final boolean DEBUG = false;
    private static final String TAG = "HandlerCaller";
    SomeArgs mArgsPool;
    int mArgsPoolSize;
    final Callback mCallback;
    public final Context mContext;
    final Handler mH;
    final Looper mMainLooper;

    public HandlerCaller(Context context, Looper looper, Callback callback) {
        this.mContext = context;
        this.mMainLooper = looper;
        this.mH = new MyHandler(this.mMainLooper);
        this.mCallback = callback;
    }

    public HandlerCaller(Context context, Callback callback) {
        this.mContext = context;
        this.mMainLooper = context.getMainLooper();
        this.mH = new MyHandler(this.mMainLooper);
        this.mCallback = callback;
    }

    public void executeOrSendMessage(Message message) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.mCallback.executeMessage(message);
            message.recycle();
            return;
        }
        this.mH.sendMessage(message);
    }

    public boolean hasMessages(int n) {
        return this.mH.hasMessages(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SomeArgs obtainArgs() {
        Handler handler = this.mH;
        synchronized (handler) {
            SomeArgs someArgs = this.mArgsPool;
            if (someArgs != null) {
                this.mArgsPool = someArgs.next;
                someArgs.next = null;
                --this.mArgsPoolSize;
                return someArgs;
            }
            return new SomeArgs();
        }
    }

    public Message obtainMessage(int n) {
        return this.mH.obtainMessage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message obtainMessageBO(int n, boolean bl, Object object) {
        int n2;
        Handler handler = this.mH;
        if (bl) {
            n2 = 1;
            return handler.obtainMessage(n, n2, 0, object);
        }
        n2 = 0;
        return handler.obtainMessage(n, n2, 0, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message obtainMessageBOO(int n, boolean bl, Object object, Object object2) {
        int n2;
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        Handler handler = this.mH;
        if (bl) {
            n2 = 1;
            return handler.obtainMessage(n, n2, 0, someArgs);
        }
        n2 = 0;
        return handler.obtainMessage(n, n2, 0, someArgs);
    }

    public Message obtainMessageI(int n, int n2) {
        return this.mH.obtainMessage(n, n2, 0);
    }

    public Message obtainMessageII(int n, int n2, int n3) {
        return this.mH.obtainMessage(n, n2, n3);
    }

    public Message obtainMessageIIII(int n, int n2, int n3, int n4, int n5) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.argi1 = n2;
        someArgs.argi2 = n3;
        someArgs.argi3 = n4;
        someArgs.argi4 = n5;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    public Message obtainMessageIIIIII(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.argi1 = n2;
        someArgs.argi2 = n3;
        someArgs.argi3 = n4;
        someArgs.argi4 = n5;
        someArgs.argi5 = n6;
        someArgs.argi6 = n7;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    public Message obtainMessageIIIIO(int n, int n2, int n3, int n4, int n5, Object object) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.argi1 = n2;
        someArgs.argi2 = n3;
        someArgs.argi3 = n4;
        someArgs.argi4 = n5;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    public Message obtainMessageIIO(int n, int n2, int n3, Object object) {
        return this.mH.obtainMessage(n, n2, n3, object);
    }

    public Message obtainMessageIIOO(int n, int n2, int n3, Object object, Object object2) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        return this.mH.obtainMessage(n, n2, n3, someArgs);
    }

    public Message obtainMessageIO(int n, int n2, Object object) {
        return this.mH.obtainMessage(n, n2, 0, object);
    }

    public Message obtainMessageIOO(int n, int n2, Object object, Object object2) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        return this.mH.obtainMessage(n, n2, 0, someArgs);
    }

    public Message obtainMessageO(int n, Object object) {
        return this.mH.obtainMessage(n, 0, 0, object);
    }

    public Message obtainMessageOO(int n, Object object, Object object2) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    public Message obtainMessageOOO(int n, Object object, Object object2, Object object3) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        someArgs.arg3 = object3;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    public Message obtainMessageOOOO(int n, Object object, Object object2, Object object3, Object object4) {
        SomeArgs someArgs = this.obtainArgs();
        someArgs.arg1 = object;
        someArgs.arg2 = object2;
        someArgs.arg3 = object3;
        someArgs.arg4 = object4;
        return this.mH.obtainMessage(n, 0, 0, someArgs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recycleArgs(SomeArgs someArgs) {
        Handler handler = this.mH;
        synchronized (handler) {
            if (this.mArgsPoolSize < 10) {
                someArgs.next = this.mArgsPool;
                this.mArgsPool = someArgs;
                this.mArgsPoolSize = 1 + this.mArgsPoolSize;
            }
            return;
        }
    }

    public void removeMessages(int n) {
        this.mH.removeMessages(n);
    }

    public void removeMessages(int n, Object object) {
        this.mH.removeMessages(n, object);
    }

    public void sendMessage(Message message) {
        this.mH.sendMessage(message);
    }

    public static interface Callback {
        public void executeMessage(Message var1);
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            HandlerCaller.this.mCallback.executeMessage(message);
        }
    }

    public static class SomeArgs {
        public Object arg1;
        public Object arg2;
        public Object arg3;
        public Object arg4;
        public int argi1;
        public int argi2;
        public int argi3;
        public int argi4;
        public int argi5;
        public int argi6;
        SomeArgs next;
    }
}

