/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    private static final String ATTR_NAME = "name";
    public static final String POWER_AUDIO = "dsp.audio";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    public static final String POWER_CPU_AWAKE = "cpu.awake";
    public static final String POWER_CPU_IDLE = "cpu.idle";
    public static final String POWER_CPU_SPEEDS = "cpu.speeds";
    public static final String POWER_GPS_ON = "gps.on";
    public static final String POWER_NONE = "none";
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    public static final String POWER_RADIO_ON = "radio.on";
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_SCREEN_ON = "screen.on";
    public static final String POWER_VIDEO = "dsp.video";
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_WIFI_ON = "wifi.on";
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    static final HashMap<String, Object> sPowerMap = new HashMap();

    public PowerProfile(Context context) {
        if (sPowerMap.size() == 0) {
            this.readPowerValuesFromXml(context);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPowerValuesFromXml(Context var1_1) {
        var2_2 = var1_1.getResources().getXml(17498122);
        var3_3 = false;
        var4_4 = new ArrayList<Double>();
        var5_5 = null;
        try {
            XmlUtils.beginDocument(var2_2, "device");
            while (true) {
                XmlUtils.nextElement(var2_2);
                var9_7 = var2_2.getName();
                if (var9_7 == null) {
                    if (var3_3 == false) return;
                    PowerProfile.sPowerMap.put(var5_5, var4_4.toArray(new Double[var4_4.size()]));
                    return;
                }
                if (!var3_3) ** GOTO lbl21
                if (!var9_7.equals("value")) {
                    PowerProfile.sPowerMap.put(var5_5, var4_4.toArray(new Double[var4_4.size()]));
                    var3_3 = false;
                }
lbl21:
                // 4 sources

                if (var9_7.equals("array")) {
                    var3_3 = true;
                    var4_4.clear();
                    var5_5 = var2_2.getAttributeValue(null, "name");
                    continue;
                }
                if (!var9_7.equals("item") && !var9_7.equals("value")) continue;
                var10_8 = null;
                if (!var3_3) {
                    var10_8 = var2_2.getAttributeValue(null, "name");
                }
                if (var2_2.next() != 4) continue;
                var11_9 = var2_2.getText();
                var12_10 = 0.0;
                try {
                    var12_10 = var17_6 = Double.valueOf(var11_9).doubleValue();
                }
                catch (NumberFormatException var14_11) {}
                if (var9_7.equals("item")) {
                    PowerProfile.sPowerMap.put(var10_8, var12_10);
                    continue;
                }
                if (!var3_3) continue;
                var4_4.add(var12_10);
                continue;
                break;
            }
        }
        catch (XmlPullParserException var8_12) {
            throw new RuntimeException(var8_12);
        }
        catch (IOException var6_14) {
            throw new RuntimeException(var6_14);
        }
        finally {
            var2_2.close();
        }
    }

    public double getAveragePower(String string2) {
        if (sPowerMap.containsKey(string2)) {
            Object object = sPowerMap.get(string2);
            if (object instanceof Double[]) {
                return ((Double[])object)[0];
            }
            return (Double)sPowerMap.get(string2);
        }
        return 0.0;
    }

    public double getAveragePower(String string2, int n) {
        if (sPowerMap.containsKey(string2)) {
            Object object = sPowerMap.get(string2);
            if (object instanceof Double[]) {
                Double[] doubleArray = (Double[])object;
                if (doubleArray.length > n && n >= 0) {
                    return doubleArray[n];
                }
                if (n < 0) {
                    return 0.0;
                }
                return doubleArray[doubleArray.length - 1];
            }
            return (Double)object;
        }
        return 0.0;
    }

    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public int getNumSpeedSteps() {
        Object object = sPowerMap.get(POWER_CPU_SPEEDS);
        if (object != null && object instanceof Double[]) {
            return ((Double[])object).length;
        }
        return 1;
    }
}

