/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.ApplicationErrorReport;
import android.ddm.DdmRegister;
import android.os.Build;
import android.os.Debug;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import dalvik.system.VMRuntime;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    private static final String TAG = "AndroidRuntime";
    private static boolean initialized;
    private static IBinder mApplicationObject;
    private static volatile boolean mCrashing;
    private static final AtomicInteger sInReportException;

    static {
        mCrashing = false;
        sInReportException = new AtomicInteger();
        DdmRegister.registerHandlers();
    }

    static /* synthetic */ boolean access$002(boolean bl) {
        mCrashing = bl;
        return bl;
    }

    private static final void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        if (RuntimeInit.getQwertyKeyboard() == 1) {
            System.setProperty("qwerty", "1");
        }
        TimezoneGetter.setInstance((TimezoneGetter)new TimezoneGetter(){

            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        new AndroidConfig();
        System.setProperty("http.agent", RuntimeInit.getDefaultUserAgent());
        if (SystemProperties.get("ro.kernel.android.tracing").equals("1")) {
            Slog.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    public static final native void finishInit();

    public static final IBinder getApplicationObject() {
        return mApplicationObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDefaultUserAgent() {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Dalvik/");
        stringBuilder.append(System.getProperty("java.vm.version"));
        stringBuilder.append(" (Linux; U; Android ");
        String string4 = Build.VERSION.RELEASE;
        String string5 = string4.length() > 0 ? string4 : "1.0";
        stringBuilder.append(string5);
        if ("REL".equals(Build.VERSION.CODENAME) && (string3 = Build.MODEL).length() > 0) {
            stringBuilder.append("; ");
            stringBuilder.append(string3);
        }
        if ((string2 = Build.ID).length() > 0) {
            stringBuilder.append(" Build/");
            stringBuilder.append(string2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static native int getQwertyKeyboard();

    private static void invokeStaticMain(String string2, String[] stringArray) throws ZygoteInit.MethodAndArgsCaller {
        Method method;
        Class<?> clazz;
        VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Missing class when invoking static main " + string2, classNotFoundException);
        }
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Missing static main on " + string2, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("Problem getting static main on " + string2, securityException);
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            throw new RuntimeException("Main method is not public and static on " + string2);
        }
        throw new ZygoteInit.MethodAndArgsCaller(method, stringArray);
    }

    public static final native int isComputerOn();

    public static final void main(String[] stringArray) {
        RuntimeInit.commonInit();
        RuntimeInit.finishInit();
    }

    public static final void setApplicationObject(IBinder iBinder) {
        mApplicationObject = iBinder;
    }

    public static final native void turnComputerOn();

    public static void wtf(String string2, Throwable throwable) {
        try {
            if (ActivityManagerNative.getDefault().handleApplicationWtf(mApplicationObject, string2, new ApplicationErrorReport.CrashInfo(throwable))) {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
            return;
        }
        catch (Throwable throwable2) {
            Slog.e(TAG, "Error reporting WTF", throwable2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void zygoteInit(String[] stringArray) throws ZygoteInit.MethodAndArgsCaller {
        int n;
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.setErr(new AndroidPrintStream(5, "System.err"));
        RuntimeInit.commonInit();
        RuntimeInit.zygoteInitNative();
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string2.equals("--")) {
                ++n;
                break;
            }
            if (!string2.startsWith("--")) break;
            if (!string2.startsWith("--nice-name=")) continue;
            Process.setArgV0((String)string2.substring(1 + string2.indexOf(61)));
        }
        if (n == stringArray.length) {
            Slog.e(TAG, "Missing classname argument to RuntimeInit!");
            return;
        }
        int n2 = n + 1;
        String string3 = stringArray[n];
        String[] stringArray2 = new String[stringArray.length - n2];
        System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
        RuntimeInit.invokeStaticMain(string3, stringArray2);
    }

    public static final native void zygoteInitNative();

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            block11: {
                boolean bl = mCrashing;
                if (!bl) break block11;
                Process.killProcess(Process.myPid());
                System.exit(10);
                return;
            }
            try {
                RuntimeInit.access$002(true);
                if (mApplicationObject == null) {
                    Slog.e(RuntimeInit.TAG, "*** FATAL EXCEPTION IN SYSTEM PROCESS: " + thread.getName(), throwable);
                } else {
                    Slog.e(RuntimeInit.TAG, "FATAL EXCEPTION: " + thread.getName(), throwable);
                }
                ActivityManagerNative.getDefault().handleApplicationCrash(mApplicationObject, new ApplicationErrorReport.CrashInfo(throwable));
                return;
            }
            catch (Throwable throwable2) {
                try {
                    Slog.e(RuntimeInit.TAG, "Error reporting crash", throwable2);
                    return;
                }
                catch (Throwable throwable3) {
                    return;
                }
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
    }
}

