/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SamplingProfilerIntegration {
    private static SamplingProfiler INSTANCE;
    private static final String TAG = "SamplingProfilerIntegration";
    static boolean dirMade;
    private static final boolean enabled;
    static volatile boolean pending;
    private static final Executor snapshotWriter;

    /*
     * Enabled aggressive block sorting
     */
    static {
        enabled = "1".equals(SystemProperties.get("persist.sampling_profiler"));
        if (enabled) {
            snapshotWriter = Executors.newSingleThreadExecutor();
            Log.i(TAG, "Profiler is enabled.");
        } else {
            snapshotWriter = null;
            Log.i(TAG, "Profiler is disabled.");
        }
        dirMade = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        INSTANCE = new SamplingProfiler(4, SamplingProfiler.newThreadGroupTheadSet((ThreadGroup)Thread.currentThread().getThreadGroup()));
        INSTANCE.start(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeSnapshot(final String string2) {
        if (!enabled || pending) {
            return;
        }
        pending = true;
        snapshotWriter.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    block5: {
                        if (dirMade) break block5;
                        new File("/sdcard/snapshots").mkdirs();
                        if (!new File("/sdcard/snapshots").isDirectory()) break block6;
                        dirMade = true;
                    }
                    SamplingProfilerIntegration.writeSnapshot("/sdcard/snapshots", string2);
                    return;
                }
                Log.w(SamplingProfilerIntegration.TAG, "Creation of " + "/sdcard/snapshots" + " failed.");
                return;
                finally {
                    pending = false;
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private static void writeSnapshot(String var0, String var1_1) {
        block11: {
            if (!SamplingProfilerIntegration.enabled) {
                return;
            }
            SamplingProfilerIntegration.INSTANCE.stop();
            var2_2 = System.currentTimeMillis();
            var4_3 = var0 + "/" + var1_1.replace(':', '.') + "-" + System.currentTimeMillis() + ".snapshot";
            var5_4 = 0;
            while (true) {
                try {
                    var6_5 = new PrintStream(new BufferedOutputStream(new FileOutputStream(var4_3)));
                }
                catch (FileNotFoundException var12_6) {
                    if (++var5_4 > 3) {
                        Log.e("SamplingProfilerIntegration", "Could not open " + var4_3 + ".");
                        return;
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException var13_7) {}
                    continue;
                }
                SamplingProfilerIntegration.INSTANCE.writeHprofData(var6_5);
                ** if (!var6_5.checkError()) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    Log.e("SamplingProfilerIntegration", "Error writing snapshot.");
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    break block11;
                }
                break;
            }
            finally {
                var6_5.close();
            }
        }
        var8_9 = System.currentTimeMillis() - var2_2;
        Log.i("SamplingProfilerIntegration", "Wrote snapshot for " + var1_1 + " in " + var8_9 + "ms.");
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        new File("/data/zygote/snapshots").mkdirs();
        SamplingProfilerIntegration.writeSnapshot("/data/zygote/snapshots", "zygote");
        INSTANCE.shutdown();
        INSTANCE = null;
    }
}

