/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import dalvik.system.Zygote;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

class ZygoteConnection {
    private static final int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static final int MAX_ZYGOTE_ARGC = 1024;
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d;
    private static LocalSocket sPeerWaitSocket;
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;

    static {
        int[] nArray = new int[]{0, 0};
        intArray2d = (int[][])Array.newInstance(Integer.TYPE, nArray);
        sPeerWaitSocket = null;
    }

    ZygoteConnection(LocalSocket localSocket) throws IOException {
        this.mSocket = localSocket;
        this.mSocketOutStream = new DataOutputStream(localSocket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(localSocket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Cannot read peer credentials", iOException);
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void applyCapabilitiesSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        block8: {
            block7: {
                long l;
                if (arguments.permittedCapabilities == 0L && arguments.effectiveCapabilities == 0L || credentials.getUid() == 0) break block7;
                try {
                    l = ZygoteInit.capgetPermitted(credentials.getPid());
                    if (((0xFFFFFFFFFFFFFFFFL ^ arguments.permittedCapabilities) & arguments.effectiveCapabilities) != 0L) {
                        throw new ZygoteSecurityException("Effective capabilities cannot be superset of  permitted capabilities");
                    }
                }
                catch (IOException iOException) {
                    throw new ZygoteSecurityException("Error retrieving peer's capabilities.");
                }
                if (((l ^ 0xFFFFFFFFFFFFFFFFL) & arguments.permittedCapabilities) != 0L) break block8;
            }
            return;
        }
        throw new ZygoteSecurityException("Peer specified unpermitted capabilities");
    }

    private static void applyDebuggerSecurityPolicy(Arguments arguments) {
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            arguments.debugFlags = 1 | arguments.debugFlags;
        }
    }

    private static void applyRlimitSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (n != 0 && n != 1000 && arguments.rlimits != null) {
            throw new ZygoteSecurityException("This UID may not specify rlimits.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void applyUidSecurityPolicy(Arguments arguments, Credentials credentials) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (n != 0) {
            if (n == 1000) {
                String string2 = SystemProperties.get("ro.factorytest");
                boolean bl = !string2.equals("1") && !string2.equals("2");
                if (bl && arguments.uidSpecified && arguments.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (arguments.uidSpecified || arguments.gidSpecified || arguments.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if (!arguments.uidSpecified) {
            arguments.uid = credentials.getUid();
            arguments.uidSpecified = true;
        }
        if (!arguments.gidSpecified) {
            arguments.gid = credentials.getGid();
            arguments.gidSpecified = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleChildProc(Arguments arguments, FileDescriptor[] fileDescriptorArray, PrintStream printStream) throws ZygoteInit.MethodAndArgsCaller {
        String string2;
        if (arguments.peerWait) {
            try {
                ZygoteInit.setCloseOnExec(this.mSocket.getFileDescriptor(), true);
                sPeerWaitSocket = this.mSocket;
            }
            catch (IOException iOException) {
                Log.e(TAG, "Zygote Child: error setting peer wait socket to be close-on-exec", iOException);
            }
        } else {
            this.closeSocket();
            ZygoteInit.closeServerSocket();
        }
        if (fileDescriptorArray != null) {
            try {
                ZygoteInit.reopenStdio(fileDescriptorArray[0], fileDescriptorArray[1], fileDescriptorArray[2]);
                int n = fileDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    ZygoteInit.closeDescriptor(fileDescriptorArray[i]);
                }
                printStream = System.err;
            }
            catch (IOException iOException) {
                Log.e(TAG, "Error reopening stdio", iOException);
            }
        }
        if (arguments.runtimeInit) {
            RuntimeInit.zygoteInit(arguments.remainingArgs);
            return;
        }
        ClassLoader classLoader = arguments.classpath != null ? new PathClassLoader(arguments.classpath, ClassLoader.getSystemClassLoader()) : ClassLoader.getSystemClassLoader();
        try {
            string2 = arguments.remainingArgs[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ZygoteConnection.logAndPrintError(printStream, "Missing required class name argument", null);
            return;
        }
        String[] stringArray = new String[arguments.remainingArgs.length - 1];
        System.arraycopy(arguments.remainingArgs, 1, stringArray, 0, stringArray.length);
        try {
            ZygoteInit.invokeStaticMain(classLoader, string2, stringArray);
            return;
        }
        catch (RuntimeException runtimeException) {
            ZygoteConnection.logAndPrintError(printStream, "Error starting. ", runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleParentProc(int n, FileDescriptor[] fileDescriptorArray, Arguments arguments) {
        if (n > 0) {
            try {
                ZygoteInit.setpgid(n, ZygoteInit.getpgid(this.peer.getPid()));
            }
            catch (IOException iOException) {
                Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
            }
        }
        if (fileDescriptorArray != null) {
            try {
                int n2 = fileDescriptorArray.length;
                for (int i = 0; i < n2; ++i) {
                    ZygoteInit.closeDescriptor(fileDescriptorArray[i]);
                }
            }
            catch (IOException iOException) {
                Log.e(TAG, "Error closing passed descriptors in parent process", iOException);
            }
        }
        try {
            this.mSocketOutStream.writeInt(n);
            if (!arguments.peerWait) return false;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Error reading from command socket", iOException);
            return true;
        }
        try {
            this.mSocket.close();
            return true;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Zygote: error closing sockets", iOException);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void logAndPrintError(PrintStream printStream, String string2, Throwable throwable) {
        Log.e(TAG, string2, throwable);
        if (printStream != null) {
            StringBuilder stringBuilder = new StringBuilder().append(string2);
            Object object = throwable == null ? "" : throwable;
            printStream.println(stringBuilder.append(object).toString());
        }
    }

    private String[] readArgumentList() throws IOException {
        String string2;
        block5: {
            try {
                string2 = this.mSocketReader.readLine();
                if (string2 != null) break block5;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                Log.e(TAG, "invalid Zygote wire format: non-int at argc");
                throw new IOException("invalid wire format");
            }
        }
        int n = Integer.parseInt(string2);
        if (n > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.mSocketReader.readLine();
            if (stringArray[i] != null) continue;
            throw new IOException("truncated request");
        }
        return stringArray;
    }

    void closeSocket() {
        try {
            this.mSocket.close();
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Exception while closing command socket in parent", iOException);
            return;
        }
    }

    FileDescriptor getFileDesciptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * Enabled aggressive block sorting
     */
    void run() throws ZygoteInit.MethodAndArgsCaller {
        int n = 10;
        do {
            if (n <= 0) {
                ZygoteInit.gc();
                n = 10;
                continue;
            }
            --n;
        } while (!this.runOnce());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        int n;
        PrintStream printStream;
        FileDescriptor[] fileDescriptorArray;
        Arguments arguments;
        block13: {
            int n2;
            String[] stringArray;
            arguments = null;
            try {
                stringArray = this.readArgumentList();
                fileDescriptorArray = this.mSocket.getAncillaryFileDescriptors();
                if (stringArray == null) {
                    this.closeSocket();
                    return true;
                }
            }
            catch (IOException iOException) {
                Log.w(TAG, "IOException on command socket " + iOException.getMessage());
                this.closeSocket();
                return true;
            }
            printStream = null;
            if (fileDescriptorArray != null) {
                int n3 = fileDescriptorArray.length;
                printStream = null;
                if (n3 >= 3) {
                    printStream = new PrintStream(new FileOutputStream(fileDescriptorArray[2]));
                }
            }
            Arguments arguments2 = new Arguments(stringArray);
            ZygoteConnection.applyUidSecurityPolicy(arguments2, this.peer);
            ZygoteConnection.applyDebuggerSecurityPolicy(arguments2);
            ZygoteConnection.applyRlimitSecurityPolicy(arguments2, this.peer);
            ZygoteConnection.applyCapabilitiesSecurityPolicy(arguments2, this.peer);
            int[][] nArray = null;
            if (arguments2.rlimits != null) {
                nArray = (int[][])arguments2.rlimits.toArray((T[])intArray2d);
            }
            n = n2 = Zygote.forkAndSpecialize((int)arguments2.uid, (int)arguments2.gid, (int[])arguments2.gids, (int)arguments2.debugFlags, (int[][])nArray);
            arguments = arguments2;
            break block13;
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2;
                block14: {
                    illegalArgumentException2 = illegalArgumentException;
                    break block14;
                    catch (ZygoteSecurityException zygoteSecurityException) {
                        ZygoteSecurityException zygoteSecurityException2;
                        block15: {
                            zygoteSecurityException2 = zygoteSecurityException;
                            break block15;
                            catch (ZygoteSecurityException zygoteSecurityException3) {
                                zygoteSecurityException2 = zygoteSecurityException3;
                                arguments = arguments2;
                            }
                        }
                        ZygoteConnection.logAndPrintError(printStream, "Zygote security policy prevents request: ", zygoteSecurityException2);
                        n = -1;
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        illegalArgumentException2 = illegalArgumentException3;
                        arguments = arguments2;
                    }
                }
                ZygoteConnection.logAndPrintError(printStream, "Invalid zygote arguments", illegalArgumentException2);
                n = -1;
            }
        }
        if (n == 0) {
            this.handleChildProc(arguments, fileDescriptorArray, printStream);
            return true;
        }
        return this.handleParentProc(n, fileDescriptorArray, arguments);
    }

    static class Arguments {
        boolean capabilitiesSpecified;
        String classpath;
        int debugFlags;
        long effectiveCapabilities;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        boolean peerWait;
        long permittedCapabilities;
        String[] remainingArgs;
        ArrayList<int[]> rlimits;
        boolean runtimeInit;
        int uid = 0;
        boolean uidSpecified;

        Arguments(String[] stringArray) throws IllegalArgumentException {
            this.parseArgs(stringArray);
        }

        /*
         * Unable to fully structure code
         */
        private void parseArgs(String[] var1_1) throws IllegalArgumentException {
            block15: {
                block28: {
                    block27: {
                        block25: {
                            block26: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            var2_2 = 0;
                                                            block2: while (true) {
                                                                block17: {
                                                                    block16: {
                                                                        if (var2_2 >= var1_1.length) break block16;
                                                                        var3_3 = var1_1[var2_2];
                                                                        if (!var3_3.equals("--")) break block17;
                                                                        ++var2_2;
                                                                    }
lbl8:
                                                                    // 2 sources

                                                                    while (this.runtimeInit && this.classpath != null) {
                                                                        throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
                                                                    }
                                                                    break block15;
                                                                }
                                                                if (!var3_3.startsWith("--setuid=")) break;
                                                                if (this.uidSpecified) {
                                                                    throw new IllegalArgumentException("Duplicate arg specified");
                                                                }
                                                                this.uidSpecified = true;
                                                                this.uid = Integer.parseInt(var3_3.substring(1 + var3_3.indexOf(61)));
lbl17:
                                                                // 13 sources

                                                                while (true) {
                                                                    ++var2_2;
                                                                    continue block2;
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                            if (!var3_3.startsWith("--setgid=")) break block18;
                                                            if (this.gidSpecified) {
                                                                throw new IllegalArgumentException("Duplicate arg specified");
                                                            }
                                                            this.gidSpecified = true;
                                                            this.gid = Integer.parseInt(var3_3.substring(1 + var3_3.indexOf(61)));
                                                            ** GOTO lbl17
                                                        }
                                                        if (!var3_3.equals("--enable-debugger")) break block19;
                                                        this.debugFlags = 1 | this.debugFlags;
                                                        ** GOTO lbl17
                                                    }
                                                    if (!var3_3.equals("--enable-safemode")) break block20;
                                                    this.debugFlags = 8 | this.debugFlags;
                                                    ** GOTO lbl17
                                                }
                                                if (!var3_3.equals("--enable-checkjni")) break block21;
                                                this.debugFlags = 2 | this.debugFlags;
                                                ** GOTO lbl17
                                            }
                                            if (!var3_3.equals("--enable-assert")) break block22;
                                            this.debugFlags = 4 | this.debugFlags;
                                            ** GOTO lbl17
                                        }
                                        if (!var3_3.equals("--peer-wait")) break block23;
                                        this.peerWait = true;
                                        ** GOTO lbl17
                                    }
                                    if (!var3_3.equals("--runtime-init")) break block24;
                                    this.runtimeInit = true;
                                    ** GOTO lbl17
                                }
                                if (!var3_3.startsWith("--capabilities=")) break block25;
                                if (this.capabilitiesSpecified) {
                                    throw new IllegalArgumentException("Duplicate arg specified");
                                }
                                this.capabilitiesSpecified = true;
                                var11_9 = var3_3.substring(1 + var3_3.indexOf(61)).split(",", 2);
                                if (var11_9.length != 1) break block26;
                                this.permittedCapabilities = this.effectiveCapabilities = Long.decode(var11_9[0]).longValue();
                                ** GOTO lbl17
                            }
                            this.permittedCapabilities = Long.decode(var11_9[0]);
                            this.effectiveCapabilities = Long.decode(var11_9[1]);
                            ** GOTO lbl17
                        }
                        if (!var3_3.startsWith("--rlimit=")) break block27;
                        var7_6 = var3_3.substring(1 + var3_3.indexOf(61)).split(",");
                        if (var7_6.length != 3) {
                            throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                        }
                        var8_7 = new int[var7_6.length];
                        for (var9_8 = 0; var9_8 < var7_6.length; ++var9_8) {
                            var8_7[var9_8] = Integer.parseInt(var7_6[var9_8]);
                        }
                        if (this.rlimits == null) {
                            this.rlimits = new ArrayList<E>();
                        }
                        this.rlimits.add(var8_7);
                        ** GOTO lbl17
                    }
                    if (!var3_3.equals("-classpath")) break block28;
                    if (this.classpath != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    ++var2_2;
                    try {
                        this.classpath = var1_1[var2_2];
                        ** GOTO lbl17
                    }
                    catch (IndexOutOfBoundsException var6_10) {
                        throw new IllegalArgumentException("-classpath requires argument");
                    }
                }
                if (!var3_3.startsWith("--setgroups=")) ** GOTO lbl8
                if (this.gids != null) {
                    throw new IllegalArgumentException("Duplicate arg specified");
                }
                var4_4 = var3_3.substring(1 + var3_3.indexOf(61)).split(",");
                this.gids = new int[var4_4.length];
                var5_5 = var4_4.length - 1;
                while (true) {
                    if (var5_5 >= 0) ** break;
                    ** continue;
                    this.gids[var5_5] = Integer.parseInt(var4_4[var5_5]);
                    --var5_5;
                }
            }
            this.remainingArgs = new String[var1_1.length - var2_2];
            System.arraycopy(var1_1, var2_2, this.remainingArgs, 0, this.remainingArgs.length);
        }
    }
}

