/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.LocalServerSocket;
import android.os.Debug;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.ZygoteConnection;
import dalvik.system.VMRuntime;
import dalvik.system.Zygote;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class ZygoteInit {
    private static final String ANDROID_SOCKET_ENV = "ANDROID_SOCKET_zygote";
    static final int GC_LOOP_COUNT = 10;
    private static final int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static final int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static final String PRELOADED_CLASSES = "preloaded-classes";
    private static final int PRELOAD_GC_THRESHOLD = 50000;
    private static final boolean PRELOAD_RESOURCES = true;
    private static final String[] REGISTER_MAP_METHODS = new String[0];
    private static final int ROOT_GID = 0;
    private static final int ROOT_UID = 0;
    private static final String TAG = "Zygote";
    private static final int UNPRIVILEGED_GID = 9999;
    private static final int UNPRIVILEGED_UID = 9999;
    public static final String USAGE_STRING = " <\"true\"|\"false\" for startSystemServer>";
    private static final boolean ZYGOTE_FORK_MODE;
    private static Resources mResources;
    private static LocalServerSocket sServerSocket;

    private ZygoteInit() {
    }

    private static ZygoteConnection acceptCommandPeer() {
        try {
            ZygoteConnection zygoteConnection = new ZygoteConnection(sServerSocket.accept());
            return zygoteConnection;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException during accept()", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void cacheRegisterMaps() {
        String string2 = null;
        long l = System.nanoTime();
        int n = 0;
        for (int i = 0; i < REGISTER_MAP_METHODS.length; ++i) {
            String string3 = REGISTER_MAP_METHODS[i];
            if (Debug.cacheRegisterMap((String)string3)) continue;
            if (string2 == null) {
                string2 = string3;
            }
            ++n;
        }
        long l2 = System.nanoTime() - l;
        if (n == REGISTER_MAP_METHODS.length) {
            if (REGISTER_MAP_METHODS.length <= 0) return;
            Log.i(TAG, "Register map caching failed (precise GC not enabled?)");
            return;
        }
        Log.i(TAG, "Register map cache: found " + (REGISTER_MAP_METHODS.length - n) + " of " + REGISTER_MAP_METHODS.length + " methods in " + l2 / 1000000L + "ms");
        if (n <= 0) return;
        Log.i(TAG, "  First failure: " + string2);
    }

    static native long capgetPermitted(int var0) throws IOException;

    static native void closeDescriptor(FileDescriptor var0) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void closeServerSocket() {
        try {
            if (sServerSocket != null) {
                sServerSocket.close();
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "Zygote:  error closing sockets", iOException);
        }
        sServerSocket = null;
    }

    static native FileDescriptor createFileDescriptor(int var0) throws IOException;

    static void gc() {
        VMRuntime vMRuntime = VMRuntime.getRuntime();
        vMRuntime.gcSoftReferences();
        vMRuntime.runFinalizationSync();
        vMRuntime.gcSoftReferences();
        vMRuntime.runFinalizationSync();
        vMRuntime.gcSoftReferences();
        vMRuntime.runFinalizationSync();
    }

    static native int getpgid(int var0) throws IOException;

    private static void handleSystemServerProcess(ZygoteConnection.Arguments arguments) throws MethodAndArgsCaller {
        ZygoteInit.closeServerSocket();
        RuntimeInit.zygoteInit(arguments.remainingArgs);
    }

    static void invokeStaticMain(ClassLoader classLoader, String string2, String[] stringArray) throws MethodAndArgsCaller {
        Method method;
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Missing class when invoking static main " + string2, classNotFoundException);
        }
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Missing static main on " + string2, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("Problem getting static main on " + string2, securityException);
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            throw new RuntimeException("Main method is not public and static on " + string2);
        }
        throw new MethodAndArgsCaller(method, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            block8: {
                VMRuntime.getRuntime().setMinimumHeapSize(0x500000L);
                SamplingProfilerIntegration.start();
                ZygoteInit.registerZygoteSocket();
                EventLog.writeEvent(3020, SystemClock.uptimeMillis());
                ZygoteInit.preloadClasses();
                ZygoteInit.preloadResources();
                EventLog.writeEvent(3030, SystemClock.uptimeMillis());
                SamplingProfilerIntegration.writeZygoteSnapshot();
                ZygoteInit.gc();
                if (stringArray.length != 2) {
                    throw new RuntimeException(stringArray[0] + USAGE_STRING);
                }
                if (stringArray[1].equals("true")) {
                    ZygoteInit.startSystemServer();
                } else {
                    if (stringArray[1].equals("false")) break block8;
                    throw new RuntimeException(stringArray[0] + USAGE_STRING);
                }
            }
            Log.i(TAG, "Accepting command socket connections");
            ZygoteInit.runSelectLoopMode();
            ZygoteInit.closeServerSocket();
            return;
        }
        catch (MethodAndArgsCaller methodAndArgsCaller) {
            methodAndArgsCaller.run();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "Zygote died with exception", runtimeException);
            ZygoteInit.closeServerSocket();
            throw runtimeException;
        }
    }

    /*
     * Exception decompiling
     */
    private static void preloadClasses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [13, 14 : 244->293)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int preloadColorStateLists(VMRuntime vMRuntime, TypedArray typedArray) {
        int n = typedArray.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            if (Debug.getGlobalAllocSize() > 50000) {
                vMRuntime.gcSoftReferences();
                vMRuntime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((n2 = typedArray.getResourceId(i, 0)) == 0) continue;
            mResources.getColorStateList(n2);
        }
        return n;
    }

    private static int preloadDrawables(VMRuntime vMRuntime, TypedArray typedArray) {
        int n = typedArray.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            if (Debug.getGlobalAllocSize() > 50000) {
                vMRuntime.gcSoftReferences();
                vMRuntime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((n2 = typedArray.getResourceId(i, 0)) == 0 || (0xBFFFFFFF & mResources.getDrawable(n2).getChangingConfigurations()) == 0) continue;
            Log.w(TAG, "Preloaded drawable resource #0x" + Integer.toHexString(n2) + " (" + typedArray.getString(i) + ") that varies with configuration!!");
        }
        return n;
    }

    private static void preloadResources() {
        VMRuntime vMRuntime = VMRuntime.getRuntime();
        Debug.startAllocCounting();
        try {
            vMRuntime.gcSoftReferences();
            vMRuntime.runFinalizationSync();
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i(TAG, "Preloading resources...");
            long l = SystemClock.uptimeMillis();
            int n = ZygoteInit.preloadDrawables(vMRuntime, mResources.obtainTypedArray(17235973));
            Log.i(TAG, "...preloaded " + n + " resources in " + (SystemClock.uptimeMillis() - l) + "ms.");
            long l2 = SystemClock.uptimeMillis();
            int n2 = ZygoteInit.preloadColorStateLists(vMRuntime, mResources.obtainTypedArray(17235974));
            Log.i(TAG, "...preloaded " + n2 + " resources in " + (SystemClock.uptimeMillis() - l2) + "ms.");
            mResources.finishPreloading();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.w(TAG, "Failure preloading resources", runtimeException);
            return;
        }
        finally {
            Debug.stopAllocCounting();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void registerZygoteSocket() {
        int n;
        if (sServerSocket != null) return;
        try {
            n = Integer.parseInt(System.getenv(ANDROID_SOCKET_ENV));
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("ANDROID_SOCKET_zygote unset or invalid", runtimeException);
        }
        try {
            sServerSocket = new LocalServerSocket(ZygoteInit.createFileDescriptor(n));
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error binding to local socket '" + n + "'", iOException);
        }
    }

    static native void reopenStdio(FileDescriptor var0, FileDescriptor var1, FileDescriptor var2) throws IOException;

    /*
     * Unable to fully structure code
     */
    private static void runForkMode() throws MethodAndArgsCaller {
        while (true) {
            block7: {
                var0 = ZygoteInit.acceptCommandPeer();
                var1_1 = Zygote.fork();
                if (var1_1 != 0) break block7;
                try {
                    ZygoteInit.sServerSocket.close();
lbl7:
                    // 3 sources

                    while (true) {
                        var0.run();
                        return;
                    }
                }
                catch (IOException var3_2) {
                    Log.e("Zygote", "Zygote Child: error closing sockets", var3_2);
                    ** GOTO lbl7
                }
                finally {
                    ZygoteInit.sServerSocket = null;
                    ** continue;
                }
            }
            if (var1_1 <= 0) break;
            var0.closeSocket();
        }
        throw new RuntimeException("Error invoking fork()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runSelectLoopMode() throws MethodAndArgsCaller {
        ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> arrayList2 = new ArrayList<ZygoteConnection>();
        FileDescriptor[] fileDescriptorArray = new FileDescriptor[4];
        arrayList.add(sServerSocket.getFileDescriptor());
        arrayList2.add(null);
        int n = 10;
        while (true) {
            int n2;
            if (n <= 0) {
                ZygoteInit.gc();
                n = 10;
            } else {
                --n;
            }
            try {
                fileDescriptorArray = arrayList.toArray(fileDescriptorArray);
                n2 = ZygoteInit.selectReadable(fileDescriptorArray);
                if (n2 < 0) {
                    throw new RuntimeException("Error in select()");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in select()", iOException);
            }
            if (n2 == 0) {
                ZygoteConnection zygoteConnection = ZygoteInit.acceptCommandPeer();
                arrayList2.add(zygoteConnection);
                arrayList.add(zygoteConnection.getFileDesciptor());
                continue;
            }
            if (!((ZygoteConnection)arrayList2.get(n2)).runOnce()) continue;
            arrayList2.remove(n2);
            arrayList.remove(n2);
        }
    }

    static native int selectReadable(FileDescriptor[] var0) throws IOException;

    static native void setCapabilities(long var0, long var2) throws IOException;

    static native void setCloseOnExec(FileDescriptor var0, boolean var1) throws IOException;

    private static void setEffectiveGroup(int n) {
        int n2 = ZygoteInit.setregid(0, n);
        if (n2 != 0) {
            Log.e(TAG, "setregid() failed. errno: " + n2);
        }
    }

    private static void setEffectiveUser(int n) {
        int n2 = ZygoteInit.setreuid(0, n);
        if (n2 != 0) {
            Log.e(TAG, "setreuid() failed. errno: " + n2);
        }
    }

    static native int setpgid(int var0, int var1);

    static native int setregid(int var0, int var1);

    static native int setreuid(int var0, int var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean startSystemServer() throws MethodAndArgsCaller, RuntimeException {
        int n2;
        IllegalArgumentException illegalArgumentException;
        ZygoteConnection.Arguments arguments;
        String[] stringArray = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,3001,3002,3003", "--capabilities=130104352,130104352", "--runtime-init", "--nice-name=system_server", "com.android.server.SystemServer"};
        try {
            arguments = new ZygoteConnection.Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException3) {
            illegalArgumentException = illegalArgumentException3;
            throw new RuntimeException(illegalArgumentException);
        }
        try {}
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
            throw new RuntimeException(illegalArgumentException);
        }
        int n = arguments.debugFlags;
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            n |= 1;
        }
        if ((n2 = Zygote.forkSystemServer((int)arguments.uid, (int)arguments.gid, (int[])arguments.gids, (int)n, (int[][])null, (long)arguments.permittedCapabilities, (long)arguments.effectiveCapabilities)) != 0) return true;
        ZygoteInit.handleSystemServerProcess(arguments);
        return true;
    }

    public static class MethodAndArgsCaller
    extends Exception
    implements Runnable {
        private final String[] mArgs;
        private final Method mMethod;

        public MethodAndArgsCaller(Method method, String[] stringArray) {
            this.mMethod = method;
            this.mArgs = stringArray;
        }

        @Override
        public void run() {
            try {
                Method method = this.mMethod;
                Object[] objectArray = new Object[]{this.mArgs};
                method.invoke(null, objectArray);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(invocationTargetException);
            }
        }
    }
}

