/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.service.wallpaper;

import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.HandlerThread;
import android.os.Looper;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import com.android.internal.view.WindowManagerPolicyThread;

public class ImageWallpaper
extends WallpaperService {
    private HandlerThread mThread;
    WallpaperManager mWallpaperManager;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mWallpaperManager = (WallpaperManager)this.getSystemService("wallpaper");
        Looper looper = WindowManagerPolicyThread.getLooper();
        if (looper != null) {
            this.setCallbackLooper(looper);
            return;
        }
        this.mThread = new HandlerThread("Wallpaper", -2);
        this.mThread.start();
        this.setCallbackLooper(this.mThread.getLooper());
    }

    @Override
    public WallpaperService.Engine onCreateEngine() {
        return new DrawableEngine();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mThread != null) {
            this.mThread.quit();
        }
    }

    class DrawableEngine
    extends WallpaperService.Engine {
        Drawable mBackground;
        private final Object mLock = new Object();
        private WallpaperObserver mReceiver;
        float mXOffset;
        float mYOffset;

        DrawableEngine() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void drawFrame() {
            SurfaceHolder surfaceHolder = this.getSurfaceHolder();
            Canvas canvas = surfaceHolder.lockCanvas();
            if (canvas != null) {
                Rect rect = surfaceHolder.getSurfaceFrame();
                Object object = this.mLock;
                synchronized (object) {
                    Drawable drawable2 = this.mBackground;
                    int n = rect.width();
                    int n2 = rect.height();
                    int n3 = drawable2 != null ? drawable2.getIntrinsicWidth() : 0;
                    int n4 = drawable2 != null ? drawable2.getIntrinsicHeight() : 0;
                    int n5 = n - n3;
                    int n6 = n2 - n4;
                    int n7 = n5 < 0 ? (int)(0.5f + (float)n5 * this.mXOffset) : n5 / 2;
                    int n8 = n6 < 0 ? (int)(0.5f + (float)n6 * this.mYOffset) : n6 / 2;
                    canvas.translate(n7, n8);
                    if (n5 < 0 || n6 < 0) {
                        canvas.save(2);
                        canvas.clipRect(0.0f, 0.0f, n3, n4, Region.Op.DIFFERENCE);
                        canvas.drawColor(-16777216);
                        canvas.restore();
                    }
                    if (drawable2 != null) {
                        drawable2.draw(canvas);
                    }
                }
                surfaceHolder.unlockCanvasAndPost(canvas);
            }
        }

        @Override
        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            IntentFilter intentFilter = new IntentFilter("android.intent.action.WALLPAPER_CHANGED");
            this.mReceiver = new WallpaperObserver();
            ImageWallpaper.this.registerReceiver(this.mReceiver, intentFilter);
            this.updateWallpaper();
            surfaceHolder.setSizeFromLayout();
        }

        @Override
        public void onDestroy() {
            super.onDestroy();
            ImageWallpaper.this.unregisterReceiver(this.mReceiver);
        }

        @Override
        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
            this.mXOffset = f;
            this.mYOffset = f2;
            this.drawFrame();
        }

        @Override
        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            super.onSurfaceChanged(surfaceHolder, n, n2, n3);
            this.drawFrame();
        }

        @Override
        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            super.onSurfaceCreated(surfaceHolder);
        }

        @Override
        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
            super.onSurfaceDestroyed(surfaceHolder);
        }

        @Override
        public void onTouchEvent(MotionEvent motionEvent) {
            super.onTouchEvent(motionEvent);
        }

        @Override
        public void onVisibilityChanged(boolean bl) {
            this.drawFrame();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void updateWallpaper() {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mBackground = ImageWallpaper.this.mWallpaperManager.getFastDrawable();
                }
                catch (RuntimeException runtimeException) {
                    Log.w("ImageWallpaper", "Unable to load wallpaper!", runtimeException);
                }
                return;
            }
        }

        class WallpaperObserver
        extends BroadcastReceiver {
            WallpaperObserver() {
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                DrawableEngine.this.updateWallpaper();
                DrawableEngine.this.drawFrame();
                System.gc();
            }
        }
    }
}

