/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.statusbar.StatusBarIcon;
import java.io.PrintWriter;

public class StatusBarIconList
implements Parcelable {
    public static final Parcelable.Creator<StatusBarIconList> CREATOR = new Parcelable.Creator<StatusBarIconList>(){

        @Override
        public StatusBarIconList createFromParcel(Parcel parcel) {
            return new StatusBarIconList(parcel);
        }

        public StatusBarIconList[] newArray(int n) {
            return new StatusBarIconList[n];
        }
    };
    private StatusBarIcon[] mIcons;
    private String[] mSlots;

    public StatusBarIconList() {
    }

    public StatusBarIconList(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyFrom(StatusBarIconList statusBarIconList) {
        if (statusBarIconList.mSlots == null) {
            this.mSlots = null;
            this.mIcons = null;
            return;
        }
        int n = statusBarIconList.mSlots.length;
        this.mSlots = new String[n];
        this.mIcons = new StatusBarIcon[n];
        int n2 = 0;
        while (n2 < n) {
            this.mSlots[n2] = statusBarIconList.mSlots[n2];
            StatusBarIcon[] statusBarIconArray = this.mIcons;
            StatusBarIcon statusBarIcon = statusBarIconList.mIcons[n2] != null ? statusBarIconList.mIcons[n2].clone() : null;
            statusBarIconArray[n2] = statusBarIcon;
            ++n2;
        }
        return;
    }

    public void defineSlots(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        this.mSlots = stringArray2;
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        this.mIcons = new StatusBarIcon[n];
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(PrintWriter printWriter) {
        int n = this.mSlots.length;
        printWriter.println("Icon list:");
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{i, this.mSlots[i], this.mIcons[i]};
            printWriter.printf("  %2d: (%s) %s\n", objectArray);
        }
    }

    public StatusBarIcon getIcon(int n) {
        return this.mIcons[n];
    }

    public String getSlot(int n) {
        return this.mSlots[n];
    }

    public int getSlotIndex(String string2) {
        int n = this.mSlots.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(this.mSlots[i])) continue;
            return i;
        }
        return -1;
    }

    public int getViewIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.mIcons[i] == null) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        this.mSlots = parcel.readStringArray();
        int n = parcel.readInt();
        if (n < 0) {
            this.mIcons = null;
            return;
        } else {
            this.mIcons = new StatusBarIcon[n];
            for (int i = 0; i < n; ++i) {
                if (parcel.readInt() == 0) continue;
                this.mIcons[i] = new StatusBarIcon(parcel);
            }
        }
    }

    public void removeIcon(int n) {
        this.mIcons[n] = null;
    }

    public void setIcon(int n, StatusBarIcon statusBarIcon) {
        this.mIcons[n] = statusBarIcon.clone();
    }

    public int size() {
        return this.mSlots.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStringArray(this.mSlots);
        if (this.mIcons == null) {
            parcel.writeInt(-1);
            return;
        }
        int n2 = this.mIcons.length;
        parcel.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            StatusBarIcon statusBarIcon = this.mIcons[n3];
            if (statusBarIcon == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                statusBarIcon.writeToParcel(parcel, n);
            }
            ++n3;
        }
        return;
    }
}

