/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.app.Notification;
import android.os.Parcel;
import android.os.Parcelable;

public class StatusBarNotification
implements Parcelable {
    public static final Parcelable.Creator<StatusBarNotification> CREATOR = new Parcelable.Creator<StatusBarNotification>(){

        @Override
        public StatusBarNotification createFromParcel(Parcel parcel) {
            return new StatusBarNotification(parcel);
        }

        public StatusBarNotification[] newArray(int n) {
            return new StatusBarNotification[n];
        }
    };
    public int id;
    public int initialPid;
    public Notification notification;
    public String pkg;
    public String tag;
    public int uid;

    public StatusBarNotification() {
    }

    public StatusBarNotification(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public StatusBarNotification(String string2, int n, String string3, int n2, int n3, Notification notification) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (notification == null) {
            throw new NullPointerException();
        }
        this.pkg = string2;
        this.id = n;
        this.tag = string3;
        this.uid = n2;
        this.initialPid = n3;
        this.notification = notification;
    }

    public StatusBarNotification clone() {
        return new StatusBarNotification(this.pkg, this.id, this.tag, this.uid, this.initialPid, this.notification.clone());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean isOngoing() {
        return (2 & this.notification.flags) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        this.pkg = parcel.readString();
        this.id = parcel.readInt();
        this.tag = parcel.readInt() != 0 ? parcel.readString() : null;
        this.uid = parcel.readInt();
        this.initialPid = parcel.readInt();
        this.notification = new Notification(parcel);
    }

    public String toString() {
        return "StatusBarNotification(package=" + this.pkg + " id=" + this.id + " tag=" + this.tag + " notification=" + this.notification + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.pkg);
        parcel.writeInt(this.id);
        if (this.tag != null) {
            parcel.writeInt(1);
            parcel.writeString(this.tag);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.uid);
        parcel.writeInt(this.initialPid);
        this.notification.writeToParcel(parcel, n);
    }
}

