/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import java.util.Arrays;

public class AdnRecord
implements Parcelable {
    static final int ADN_BCD_NUMBER_LENGTH = 0;
    static final int ADN_CAPABILITY_ID = 12;
    static final int ADN_DIALING_NUMBER_END = 11;
    static final int ADN_DIALING_NUMBER_START = 2;
    static final int ADN_EXTENSION_ID = 13;
    static final int ADN_TON_AND_NPI = 1;
    public static final Parcelable.Creator<AdnRecord> CREATOR = new Parcelable.Creator<AdnRecord>(){

        @Override
        public AdnRecord createFromParcel(Parcel parcel) {
            return new AdnRecord(parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readString(), parcel.readStringArray());
        }

        public AdnRecord[] newArray(int n) {
            return new AdnRecord[n];
        }
    };
    static final int EXT_RECORD_LENGTH_BYTES = 13;
    static final int EXT_RECORD_TYPE_ADDITIONAL_DATA = 2;
    static final int EXT_RECORD_TYPE_MASK = 3;
    static final int FOOTER_SIZE_BYTES = 14;
    static final String LOG_TAG = "GSM";
    static final int MAX_EXT_CALLED_PARTY_LENGTH = 10;
    static final int MAX_NUMBER_SIZE_BYTES = 11;
    String alphaTag = null;
    int efid;
    String[] emails;
    int extRecord = 255;
    String number = null;
    int recordNumber;

    public AdnRecord(int n, int n2, String string2, String string3) {
        this.efid = n;
        this.recordNumber = n2;
        this.alphaTag = string2;
        this.number = string3;
        this.emails = null;
    }

    public AdnRecord(int n, int n2, String string2, String string3, String[] stringArray) {
        this.efid = n;
        this.recordNumber = n2;
        this.alphaTag = string2;
        this.number = string3;
        this.emails = stringArray;
    }

    public AdnRecord(int n, int n2, byte[] byArray) {
        this.efid = n;
        this.recordNumber = n2;
        this.parseRecord(byArray);
    }

    public AdnRecord(String string2, String string3) {
        this(0, 0, string2, string3);
    }

    public AdnRecord(String string2, String string3, String[] stringArray) {
        this(0, 0, string2, string3, stringArray);
    }

    public AdnRecord(byte[] byArray) {
        this(0, 0, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseRecord(byte[] byArray) {
        try {
            this.alphaTag = IccUtils.adnStringFieldToString(byArray, 0, byArray.length - 14);
            int n = byArray.length - 14;
            int n2 = 0xFF & byArray[n];
            if (n2 > 11) {
                this.number = "";
                return;
            }
            this.number = PhoneNumberUtils.calledPartyBCDToString(byArray, n + 1, n2);
            this.extRecord = 0xFF & byArray[byArray.length - 1];
            this.emails = null;
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Error parsing AdnRecord", runtimeException);
            this.number = "";
            this.alphaTag = "";
            this.emails = null;
            return;
        }
    }

    private static boolean stringCompareNullEqualsEmpty(String string2, String string3) {
        if (string2 == string3) {
            return true;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        return string2.equals(string3);
    }

    public void appendExtRecord(byte[] byArray) {
        try {
            if (byArray.length != 13) {
                return;
            }
            if ((3 & byArray[0]) == 2 && (0xFF & byArray[1]) <= 10) {
                this.number = this.number + PhoneNumberUtils.calledPartyBCDFragmentToString(byArray, 2, 0xFF & byArray[1]);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            Log.w(LOG_TAG, "Error parsing AdnRecord ext record", runtimeException);
        }
    }

    public byte[] buildAdnString(int n) {
        int n2 = n - 14;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = -1;
        }
        if (TextUtils.isEmpty(this.number)) {
            Log.w(LOG_TAG, "[buildAdnString] Empty dialing number");
            return byArray;
        }
        if (this.number.length() > 20) {
            Log.w(LOG_TAG, "[buildAdnString] Max length of dialing number is 20");
            return null;
        }
        if (this.alphaTag != null && this.alphaTag.length() > n2) {
            Log.w(LOG_TAG, "[buildAdnString] Max length of tag is " + n2);
            return null;
        }
        byte[] byArray2 = PhoneNumberUtils.numberToCalledPartyBCD(this.number);
        System.arraycopy(byArray2, 0, byArray, n2 + 1, byArray2.length);
        byArray[n2 + 0] = (byte)byArray2.length;
        byArray[n2 + 12] = -1;
        byArray[n2 + 13] = -1;
        if (!TextUtils.isEmpty(this.alphaTag)) {
            byte[] byArray3 = GsmAlphabet.stringToGsm8BitPacked(this.alphaTag);
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        }
        return byArray;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getAlphaTag() {
        return this.alphaTag;
    }

    public String[] getEmails() {
        return this.emails;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean hasExtendedRecord() {
        return this.extRecord != 0 && this.extRecord != 255;
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty(this.alphaTag) && TextUtils.isEmpty(this.number) && this.emails == null;
    }

    public boolean isEqual(AdnRecord adnRecord) {
        return AdnRecord.stringCompareNullEqualsEmpty(this.alphaTag, adnRecord.alphaTag) && AdnRecord.stringCompareNullEqualsEmpty(this.number, adnRecord.number) && Arrays.equals(this.emails, adnRecord.emails);
    }

    public void setEmails(String[] stringArray) {
        this.emails = stringArray;
    }

    public String toString() {
        return "ADN Record '" + this.alphaTag + "' '" + this.number + " " + this.emails + "'";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.efid);
        parcel.writeInt(this.recordNumber);
        parcel.writeString(this.alphaTag);
        parcel.writeString(this.number);
        parcel.writeStringArray(this.emails);
    }
}

