/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.UsimPhoneBookManager;
import java.util.ArrayList;
import java.util.Iterator;

public final class AdnRecordCache
extends Handler
implements IccConstants {
    static final int EVENT_LOAD_ALL_ADN_LIKE_DONE = 1;
    static final int EVENT_UPDATE_ADN_DONE = 2;
    SparseArray<ArrayList<AdnRecord>> adnLikeFiles = new SparseArray();
    SparseArray<ArrayList<Message>> adnLikeWaiters = new SparseArray();
    private UsimPhoneBookManager mUsimPhoneBookManager;
    PhoneBase phone;
    SparseArray<Message> userWriteResponse = new SparseArray();

    public AdnRecordCache(PhoneBase phoneBase) {
        this.phone = phoneBase;
        this.mUsimPhoneBookManager = new UsimPhoneBookManager(phoneBase, this);
    }

    private void clearUserWriters() {
        int n = this.userWriteResponse.size();
        for (int i = 0; i < n; ++i) {
            this.sendErrorResponse(this.userWriteResponse.valueAt(i), "AdnCace reset");
        }
        this.userWriteResponse.clear();
    }

    private void clearWaiters() {
        int n = this.adnLikeWaiters.size();
        for (int i = 0; i < n; ++i) {
            this.notifyWaiters(this.adnLikeWaiters.valueAt(i), new AsyncResult(null, null, new RuntimeException("AdnCache reset")));
        }
        this.adnLikeWaiters.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifyWaiters(ArrayList<Message> arrayList, AsyncResult asyncResult) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Message message = arrayList.get(i);
                AsyncResult.forMessage(message, asyncResult.result, asyncResult.exception);
                message.sendToTarget();
            }
        }
    }

    private void sendErrorResponse(Message message, String string2) {
        if (message != null) {
            RuntimeException runtimeException = new RuntimeException(string2);
            AsyncResult.forMessage((Message)message).exception = runtimeException;
            message.sendToTarget();
        }
    }

    int extensionEfForEf(int n) {
        int n2 = 28490;
        switch (n) {
            default: {
                n2 = -1;
            }
            case 28474: 
            case 28480: {
                return n2;
            }
            case 28615: {
                return 28616;
            }
            case 28489: {
                return 28492;
            }
            case 28475: {
                return 28491;
            }
            case 20272: 
        }
        return 0;
    }

    public ArrayList<AdnRecord> getRecordsIfLoaded(int n) {
        return this.adnLikeFiles.get(n);
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                int n = message.arg1;
                ArrayList<Message> arrayList = this.adnLikeWaiters.get(n);
                this.adnLikeWaiters.delete(n);
                if (asyncResult.exception == null) {
                    this.adnLikeFiles.put(n, (ArrayList)asyncResult.result);
                }
                this.notifyWaiters(arrayList, asyncResult);
                return;
            }
            case 2: 
        }
        AsyncResult asyncResult = (AsyncResult)message.obj;
        int n = message.arg1;
        int n2 = message.arg2;
        AdnRecord adnRecord = (AdnRecord)asyncResult.userObj;
        if (asyncResult.exception == null) {
            this.adnLikeFiles.get(n).set(n2 - 1, adnRecord);
        }
        Message message2 = this.userWriteResponse.get(n);
        this.userWriteResponse.delete(n);
        AsyncResult.forMessage(message2, null, asyncResult.exception);
        message2.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void requestLoadAllAdnLike(int n, int n2, Message message) {
        ArrayList<AdnRecord> arrayList = n == 20272 ? this.mUsimPhoneBookManager.loadEfFilesFromUsim() : this.getRecordsIfLoaded(n);
        if (arrayList != null) {
            if (message == null) return;
            AsyncResult.forMessage((Message)message).result = arrayList;
            message.sendToTarget();
            return;
        }
        ArrayList<Message> arrayList2 = this.adnLikeWaiters.get(n);
        if (arrayList2 != null) {
            arrayList2.add(message);
            return;
        }
        ArrayList<Message> arrayList3 = new ArrayList<Message>();
        arrayList3.add(message);
        this.adnLikeWaiters.put(n, arrayList3);
        if (n2 >= 0) {
            new AdnRecordLoader(this.phone).loadAllFromEF(n, n2, this.obtainMessage(1, n, 0));
            return;
        }
        if (message == null) return;
        AsyncResult.forMessage((Message)message).exception = new RuntimeException("EF is not known ADN-like EF:" + n);
        message.sendToTarget();
    }

    public void reset() {
        this.adnLikeFiles.clear();
        this.mUsimPhoneBookManager.reset();
        this.clearWaiters();
        this.clearUserWriters();
    }

    public void updateAdnByIndex(int n, AdnRecord adnRecord, int n2, String string2, Message message) {
        int n3 = this.extensionEfForEf(n);
        if (n3 < 0) {
            this.sendErrorResponse(message, "EF is not known ADN-like EF:" + n);
            return;
        }
        if (this.userWriteResponse.get(n) != null) {
            this.sendErrorResponse(message, "Have pending update for EF:" + n);
            return;
        }
        this.userWriteResponse.put(n, message);
        new AdnRecordLoader(this.phone).updateEF(adnRecord, n, n3, n2, string2, this.obtainMessage(2, n, n2, adnRecord));
    }

    public void updateAdnBySearch(int n, AdnRecord adnRecord, AdnRecord adnRecord2, String string2, Message message) {
        int n2 = this.extensionEfForEf(n);
        if (n2 < 0) {
            this.sendErrorResponse(message, "EF is not known ADN-like EF:" + n);
            return;
        }
        ArrayList<AdnRecord> arrayList = this.getRecordsIfLoaded(n);
        if (arrayList == null) {
            this.sendErrorResponse(message, "Adn list not exist for EF:" + n);
            return;
        }
        int n3 = -1;
        int n4 = 1;
        Iterator<AdnRecord> iterator = arrayList.iterator();
        while (true) {
            block8: {
                block7: {
                    if (!iterator.hasNext()) break block7;
                    if (!adnRecord.isEqual(iterator.next())) break block8;
                    n3 = n4;
                }
                if (n3 != -1) break;
                this.sendErrorResponse(message, "Adn record don't exist for " + adnRecord);
                return;
            }
            ++n4;
        }
        if (this.userWriteResponse.get(n) != null) {
            this.sendErrorResponse(message, "Have pending update for EF:" + n);
            return;
        }
        this.userWriteResponse.put(n, message);
        new AdnRecordLoader(this.phone).updateEF(adnRecord2, n, n2, n3, string2, this.obtainMessage(2, n, n3, adnRecord2));
    }
}

