/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import java.util.List;

public abstract class Call {
    protected final String LOG_TAG;
    protected boolean isGeneric = false;
    public State state = State.IDLE;

    public Call() {
        this.LOG_TAG = "Call";
    }

    public abstract List<Connection> getConnections();

    public long getEarliestConnectTime() {
        long l = Long.MAX_VALUE;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return 0L;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            long l2 = list.get(i).getConnectTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public Connection getEarliestConnection() {
        long l = Long.MAX_VALUE;
        Connection connection = null;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Connection connection2 = list.get(i);
            long l2 = connection2.getCreateTime();
            if (l2 >= l) continue;
            connection = connection2;
            l = l2;
        }
        return connection;
    }

    public long getEarliestCreateTime() {
        long l = Long.MAX_VALUE;
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return 0L;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            long l2 = list.get(i).getCreateTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public Connection getLatestConnection() {
        List<Connection> list = this.getConnections();
        if (list.size() == 0) {
            return null;
        }
        long l = 0L;
        Connection connection = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Connection connection2 = list.get(i);
            long l2 = connection2.getCreateTime();
            if (l2 <= l) continue;
            connection = connection2;
            l = l2;
        }
        return connection;
    }

    public abstract Phone getPhone();

    public State getState() {
        return this.state;
    }

    public abstract void hangup() throws CallStateException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hangupIfAlive() {
        if (!this.getState().isAlive()) return;
        try {
            this.hangup();
            return;
        }
        catch (CallStateException callStateException) {
            Log.w("Call", " hangupIfActive: caught " + callStateException);
            return;
        }
    }

    public boolean hasConnection(Connection connection) {
        return connection.getCall() == this;
    }

    public boolean hasConnections() {
        List<Connection> list = this.getConnections();
        if (list == null) {
            return false;
        }
        return list.size() > 0;
    }

    public boolean isDialingOrAlerting() {
        return this.getState().isDialing();
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public boolean isIdle() {
        return !this.getState().isAlive();
    }

    public abstract boolean isMultiparty();

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public void setGeneric(boolean bl) {
        this.isGeneric = bl;
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE;
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State DISCONNECTED;
        public static final /* enum */ State DISCONNECTING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State IDLE;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;

        static {
            IDLE = new State();
            ACTIVE = new State();
            HOLDING = new State();
            DIALING = new State();
            ALERTING = new State();
            INCOMING = new State();
            WAITING = new State();
            DISCONNECTED = new State();
            DISCONNECTING = new State();
            State[] stateArray = new State[]{IDLE, ACTIVE, HOLDING, DIALING, ALERTING, INCOMING, WAITING, DISCONNECTED, DISCONNECTING};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public boolean isAlive() {
            return this != IDLE && this != DISCONNECTED && this != DISCONNECTING;
        }

        public boolean isDialing() {
            return this == DIALING || this == ALERTING;
        }

        public boolean isRinging() {
            return this == INCOMING || this == WAITING;
        }
    }
}

