/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.media.AudioManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipPhone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CallManager {
    private static final boolean DBG = true;
    private static final int EVENT_CALL_WAITING = 108;
    private static final int EVENT_CDMA_OTA_STATUS_CHANGE = 111;
    private static final int EVENT_DISCONNECT = 100;
    private static final int EVENT_DISPLAY_INFO = 109;
    private static final int EVENT_ECM_TIMER_RESET = 115;
    private static final int EVENT_INCOMING_RING = 104;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_OFF = 107;
    private static final int EVENT_IN_CALL_VOICE_PRIVACY_ON = 106;
    private static final int EVENT_MMI_COMPLETE = 114;
    private static final int EVENT_MMI_INITIATE = 113;
    private static final int EVENT_NEW_RINGING_CONNECTION = 102;
    private static final int EVENT_POST_DIAL_CHARACTER = 119;
    private static final int EVENT_PRECISE_CALL_STATE_CHANGED = 101;
    private static final int EVENT_RESEND_INCALL_MUTE = 112;
    private static final int EVENT_RINGBACK_TONE = 105;
    private static final int EVENT_SERVICE_STATE_CHANGED = 118;
    private static final int EVENT_SIGNAL_INFO = 110;
    private static final int EVENT_SUBSCRIPTION_INFO_READY = 116;
    private static final int EVENT_SUPP_SERVICE_FAILED = 117;
    private static final int EVENT_UNKNOWN_CONNECTION = 103;
    private static final CallManager INSTANCE = new CallManager();
    private static final String LOG_TAG = "CallManager";
    private static final boolean VDBG;
    private final ArrayList<Connection> emptyConnections = new ArrayList();
    private final ArrayList<Call> mBackgroundCalls;
    protected final RegistrantList mCallWaitingRegistrants;
    protected final RegistrantList mCdmaOtaStatusChangeRegistrants;
    private Phone mDefaultPhone = null;
    protected final RegistrantList mDisconnectRegistrants;
    protected final RegistrantList mDisplayInfoRegistrants;
    protected final RegistrantList mEcmTimerResetRegistrants;
    private final ArrayList<Call> mForegroundCalls;
    private Handler mHandler;
    protected final RegistrantList mInCallVoicePrivacyOffRegistrants;
    protected final RegistrantList mInCallVoicePrivacyOnRegistrants;
    protected final RegistrantList mIncomingRingRegistrants;
    protected final RegistrantList mMmiCompleteRegistrants;
    protected final RegistrantList mMmiInitiateRegistrants;
    protected final RegistrantList mMmiRegistrants;
    protected final RegistrantList mNewRingingConnectionRegistrants;
    private final ArrayList<Phone> mPhones;
    protected final RegistrantList mPostDialCharacterRegistrants;
    protected final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    protected final RegistrantList mResendIncallMuteRegistrants;
    protected final RegistrantList mRingbackToneRegistrants;
    private final ArrayList<Call> mRingingCalls;
    protected final RegistrantList mServiceStateChangedRegistrants;
    protected final RegistrantList mSignalInfoRegistrants;
    protected final RegistrantList mSubscriptionInfoReadyRegistrants;
    protected final RegistrantList mSuppServiceFailedRegistrants;
    protected final RegistrantList mUnknownConnectionRegistrants;

    private CallManager() {
        this.mNewRingingConnectionRegistrants = new RegistrantList();
        this.mIncomingRingRegistrants = new RegistrantList();
        this.mDisconnectRegistrants = new RegistrantList();
        this.mMmiRegistrants = new RegistrantList();
        this.mUnknownConnectionRegistrants = new RegistrantList();
        this.mRingbackToneRegistrants = new RegistrantList();
        this.mInCallVoicePrivacyOnRegistrants = new RegistrantList();
        this.mInCallVoicePrivacyOffRegistrants = new RegistrantList();
        this.mCallWaitingRegistrants = new RegistrantList();
        this.mDisplayInfoRegistrants = new RegistrantList();
        this.mSignalInfoRegistrants = new RegistrantList();
        this.mCdmaOtaStatusChangeRegistrants = new RegistrantList();
        this.mResendIncallMuteRegistrants = new RegistrantList();
        this.mMmiInitiateRegistrants = new RegistrantList();
        this.mMmiCompleteRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mSubscriptionInfoReadyRegistrants = new RegistrantList();
        this.mSuppServiceFailedRegistrants = new RegistrantList();
        this.mServiceStateChangedRegistrants = new RegistrantList();
        this.mPostDialCharacterRegistrants = new RegistrantList();
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 100: {
                        CallManager.this.mDisconnectRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 101: {
                        CallManager.this.mPreciseCallStateRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 102: {
                        if (!CallManager.this.getActiveFgCallState().isDialing() && !CallManager.this.hasMoreThanOneRingingCall()) {
                            CallManager.this.mNewRingingConnectionRegistrants.notifyRegistrants((AsyncResult)message.obj);
                            return;
                        }
                        Connection connection = (Connection)((AsyncResult)message.obj).result;
                        try {
                            Log.d(CallManager.LOG_TAG, "silently drop incoming call: " + connection.getCall());
                            connection.getCall().hangup();
                            return;
                        }
                        catch (CallStateException callStateException) {
                            Log.w(CallManager.LOG_TAG, "new ringing connection", callStateException);
                            return;
                        }
                    }
                    case 103: {
                        CallManager.this.mUnknownConnectionRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 104: {
                        if (CallManager.this.hasActiveFgCall()) return;
                        CallManager.this.mIncomingRingRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    default: {
                        return;
                    }
                    case 105: {
                        CallManager.this.mRingbackToneRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 106: {
                        CallManager.this.mInCallVoicePrivacyOnRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 107: {
                        CallManager.this.mInCallVoicePrivacyOffRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 108: {
                        CallManager.this.mCallWaitingRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 109: {
                        CallManager.this.mDisplayInfoRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 110: {
                        CallManager.this.mSignalInfoRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 111: {
                        CallManager.this.mCdmaOtaStatusChangeRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 112: {
                        CallManager.this.mResendIncallMuteRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 113: {
                        CallManager.this.mMmiInitiateRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 114: {
                        CallManager.this.mMmiCompleteRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 115: {
                        CallManager.this.mEcmTimerResetRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 116: {
                        CallManager.this.mSubscriptionInfoReadyRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 117: {
                        CallManager.this.mSuppServiceFailedRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 118: {
                        CallManager.this.mServiceStateChangedRegistrants.notifyRegistrants((AsyncResult)message.obj);
                        return;
                    }
                    case 119: {
                        for (int i = 0; i < CallManager.this.mPostDialCharacterRegistrants.size(); ++i) {
                            Message message2 = ((Registrant)CallManager.this.mPostDialCharacterRegistrants.get(i)).messageForRegistrant();
                            message2.obj = message.obj;
                            message2.arg1 = message.arg1;
                            message2.sendToTarget();
                        }
                    }
                }
            }
        };
        this.mPhones = new ArrayList();
        this.mRingingCalls = new ArrayList();
        this.mBackgroundCalls = new ArrayList();
        this.mForegroundCalls = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canDial(Phone phone) {
        int n = phone.getServiceState().getState();
        boolean bl = this.hasActiveRingingCall();
        boolean bl2 = this.hasActiveFgCall();
        boolean bl3 = this.hasActiveBgCall();
        boolean bl4 = bl2 && bl3;
        Call.State state = this.getActiveFgCallState();
        return n != 3 && !bl && !bl4 && (state == Call.State.ACTIVE || state == Call.State.IDLE || state == Call.State.DISCONNECTED);
    }

    private Context getContext() {
        Phone phone = this.getDefaultPhone();
        if (phone == null) {
            return null;
        }
        return phone.getContext();
    }

    private Call getFirstActiveCall(ArrayList<Call> arrayList) {
        for (Call call : arrayList) {
            if (call.isIdle()) continue;
            return call;
        }
        return null;
    }

    private Call getFirstCallOfState(ArrayList<Call> arrayList, Call.State state) {
        for (Call call : arrayList) {
            if (call.getState() != state) continue;
            return call;
        }
        return null;
    }

    private Call getFirstNonIdleCall(List<Call> list) {
        Call call = null;
        for (Call call2 : list) {
            if (!call2.isIdle()) {
                return call2;
            }
            if (call2.getState() == Call.State.IDLE || call != null) continue;
            call = call2;
        }
        return call;
    }

    public static CallManager getInstance() {
        return INSTANCE;
    }

    private static Phone getPhoneBase(Phone phone) {
        if (phone instanceof PhoneProxy) {
            return phone.getForegroundCall().getPhone();
        }
        return phone;
    }

    private boolean hasMoreThanOneRingingCall() {
        int n = 0;
        Iterator<Call> iterator = this.mRingingCalls.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getState().isRinging() || ++n <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isSamePhone(Phone phone, Phone phone2) {
        return CallManager.getPhoneBase(phone) == CallManager.getPhoneBase(phone2);
    }

    private void registerForPhoneStates(Phone phone) {
        phone.registerForPreciseCallStateChanged(this.mHandler, 101, null);
        phone.registerForDisconnect(this.mHandler, 100, null);
        phone.registerForNewRingingConnection(this.mHandler, 102, null);
        phone.registerForUnknownConnection(this.mHandler, 103, null);
        phone.registerForIncomingRing(this.mHandler, 104, null);
        phone.registerForRingbackTone(this.mHandler, 105, null);
        phone.registerForInCallVoicePrivacyOn(this.mHandler, 106, null);
        phone.registerForInCallVoicePrivacyOff(this.mHandler, 107, null);
        phone.registerForDisplayInfo(this.mHandler, 109, null);
        phone.registerForSignalInfo(this.mHandler, 110, null);
        phone.registerForResendIncallMute(this.mHandler, 112, null);
        phone.registerForMmiInitiate(this.mHandler, 113, null);
        phone.registerForMmiComplete(this.mHandler, 114, null);
        phone.registerForSuppServiceFailed(this.mHandler, 117, null);
        phone.registerForServiceStateChanged(this.mHandler, 118, null);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            phone.setOnPostDialCharacter(this.mHandler, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.registerForCdmaOtaStatusChange(this.mHandler, 111, null);
            phone.registerForSubscriptionInfoReady(this.mHandler, 116, null);
            phone.registerForCallWaiting(this.mHandler, 108, null);
            phone.registerForEcmTimerReset(this.mHandler, 115, null);
        }
    }

    private void unregisterForPhoneStates(Phone phone) {
        phone.unregisterForPreciseCallStateChanged(this.mHandler);
        phone.unregisterForDisconnect(this.mHandler);
        phone.unregisterForNewRingingConnection(this.mHandler);
        phone.unregisterForUnknownConnection(this.mHandler);
        phone.unregisterForIncomingRing(this.mHandler);
        phone.unregisterForRingbackTone(this.mHandler);
        phone.unregisterForInCallVoicePrivacyOn(this.mHandler);
        phone.unregisterForInCallVoicePrivacyOff(this.mHandler);
        phone.unregisterForDisplayInfo(this.mHandler);
        phone.unregisterForSignalInfo(this.mHandler);
        phone.unregisterForResendIncallMute(this.mHandler);
        phone.unregisterForMmiInitiate(this.mHandler);
        phone.unregisterForMmiComplete(this.mHandler);
        phone.unregisterForSuppServiceFailed(this.mHandler);
        phone.unregisterForServiceStateChanged(this.mHandler);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2) {
            phone.setOnPostDialCharacter(null, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.unregisterForCdmaOtaStatusChange(this.mHandler);
            phone.unregisterForSubscriptionInfoReady(this.mHandler);
            phone.unregisterForCallWaiting(this.mHandler);
            phone.unregisterForEcmTimerReset(this.mHandler);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void acceptCall(Call call) throws CallStateException {
        Phone phone = call.getPhone();
        if (this.hasActiveFgCall()) {
            Phone phone2 = this.getActiveFgCall().getPhone();
            boolean bl = !phone2.getBackgroundCall().isIdle();
            boolean bl2 = phone2 == phone;
            if (bl2 && bl) {
                this.getActiveFgCall().hangup();
            } else if (!bl2 && !bl) {
                phone2.switchHoldingAndActive();
            } else if (!bl2 && bl) {
                this.getActiveFgCall().hangup();
            }
        }
        phone.acceptCall();
    }

    public boolean canConference(Call call) {
        boolean bl = this.hasActiveFgCall();
        Phone phone = null;
        if (bl) {
            phone = this.getActiveFgCall().getPhone();
        }
        Object object = null;
        if (call != null) {
            object = call.getPhone();
        }
        return object.getClass().equals(phone.getClass());
    }

    public boolean canTransfer(Call call) {
        boolean bl = this.hasActiveFgCall();
        Phone phone = null;
        if (bl) {
            phone = this.getActiveFgCall().getPhone();
        }
        Phone phone2 = null;
        if (call != null) {
            phone2 = call.getPhone();
        }
        return phone2 == phone && phone.canTransfer();
    }

    public void clearDisconnected() {
        Iterator<Phone> iterator = this.mPhones.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearDisconnected();
        }
    }

    public void conference(Call call) throws CallStateException {
        Phone phone = this.getFgPhone();
        if (phone instanceof SipPhone) {
            ((SipPhone)phone).conference(call);
            return;
        }
        if (this.canConference(call)) {
            phone.conference();
            return;
        }
        throw new CallStateException("Can't conference foreground and selected background call");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Connection dial(Phone phone, String string2) throws CallStateException {
        Phone phone2 = CallManager.getPhoneBase(phone);
        if (!this.canDial(phone)) {
            throw new CallStateException("cannot dial in current state");
        }
        if (!this.hasActiveFgCall()) return phone2.dial(string2);
        Phone phone3 = this.getActiveFgCall().getPhone();
        boolean bl = !phone3.getBackgroundCall().isIdle();
        StringBuilder stringBuilder = new StringBuilder().append("hasBgCall: ").append(bl).append(" sameChannel:");
        boolean bl2 = phone3 == phone2;
        Log.d(LOG_TAG, stringBuilder.append(bl2).toString());
        if (phone3 == phone2) return phone2.dial(string2);
        if (bl) {
            Log.d(LOG_TAG, "Hangup");
            this.getActiveFgCall().hangup();
            return phone2.dial(string2);
        }
        Log.d(LOG_TAG, "Switch");
        phone3.switchHoldingAndActive();
        return phone2.dial(string2);
    }

    public Connection dial(Phone phone, String string2, UUSInfo uUSInfo) throws CallStateException {
        return phone.dial(string2, uUSInfo);
    }

    public void explicitCallTransfer(Call call) throws CallStateException {
        if (this.canTransfer(call)) {
            call.getPhone().explicitCallTransfer();
        }
    }

    public Call getActiveFgCall() {
        block3: {
            Call call;
            block2: {
                call = this.getFirstNonIdleCall(this.mForegroundCalls);
                if (call != null) break block2;
                if (this.mDefaultPhone != null) break block3;
                call = null;
            }
            return call;
        }
        return this.mDefaultPhone.getForegroundCall();
    }

    public Call.State getActiveFgCallState() {
        Call call = this.getActiveFgCall();
        if (call != null) {
            return call.getState();
        }
        return Call.State.IDLE;
    }

    public List<Phone> getAllPhones() {
        return Collections.unmodifiableList(this.mPhones);
    }

    public List<Call> getBackgroundCalls() {
        return Collections.unmodifiableList(this.mBackgroundCalls);
    }

    public List<Connection> getBgCallConnections() {
        Call call = this.getFirstActiveBgCall();
        if (call != null) {
            return call.getConnections();
        }
        return this.emptyConnections;
    }

    public Phone getBgPhone() {
        return this.getFirstActiveBgCall().getPhone();
    }

    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    public List<Connection> getFgCallConnections() {
        Call call = this.getActiveFgCall();
        if (call != null) {
            return call.getConnections();
        }
        return this.emptyConnections;
    }

    public Connection getFgCallLatestConnection() {
        Call call = this.getActiveFgCall();
        if (call != null) {
            return call.getLatestConnection();
        }
        return null;
    }

    public Phone getFgPhone() {
        return this.getActiveFgCall().getPhone();
    }

    public Call getFirstActiveBgCall() {
        block3: {
            Call call;
            block2: {
                call = this.getFirstNonIdleCall(this.mBackgroundCalls);
                if (call != null) break block2;
                if (this.mDefaultPhone != null) break block3;
                call = null;
            }
            return call;
        }
        return this.mDefaultPhone.getBackgroundCall();
    }

    public Call getFirstActiveRingingCall() {
        block3: {
            Call call;
            block2: {
                call = this.getFirstNonIdleCall(this.mRingingCalls);
                if (call != null) break block2;
                if (this.mDefaultPhone != null) break block3;
                call = null;
            }
            return call;
        }
        return this.mDefaultPhone.getRingingCall();
    }

    public List<Call> getForegroundCalls() {
        return Collections.unmodifiableList(this.mForegroundCalls);
    }

    public boolean getMute() {
        if (this.hasActiveFgCall()) {
            return this.getActiveFgCall().getPhone().getMute();
        }
        if (this.hasActiveBgCall()) {
            return this.getFirstActiveBgCall().getPhone().getMute();
        }
        return false;
    }

    public List<? extends MmiCode> getPendingMmiCodes(Phone phone) {
        Log.e(LOG_TAG, "getPendingMmiCodes not implemented");
        return null;
    }

    public List<Call> getRingingCalls() {
        return Collections.unmodifiableList(this.mRingingCalls);
    }

    public Phone getRingingPhone() {
        return this.getFirstActiveRingingCall().getPhone();
    }

    public int getServiceState() {
        int n = 1;
        Iterator<Phone> iterator = this.mPhones.iterator();
        while (true) {
            int n2;
            block6: {
                block5: {
                    if (!iterator.hasNext()) break block5;
                    n2 = iterator.next().getServiceState().getState();
                    if (n2 != 0) break block6;
                    n = n2;
                }
                return n;
            }
            if (n2 == 1) {
                if (n != 2 && n != 3) continue;
                n = n2;
                continue;
            }
            if (n2 != 2 || n != 3) continue;
            n = n2;
        }
    }

    public Phone.State getState() {
        Phone.State state = Phone.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getState() == Phone.State.RINGING) {
                state = Phone.State.RINGING;
                continue;
            }
            if (phone.getState() != Phone.State.OFFHOOK || state != Phone.State.IDLE) continue;
            state = Phone.State.OFFHOOK;
        }
        return state;
    }

    public void hangupForegroundResumeBackground(Call call) throws CallStateException {
        block3: {
            block2: {
                if (!this.hasActiveFgCall()) break block2;
                Phone phone = this.getFgPhone();
                if (call == null) break block2;
                if (phone != call.getPhone()) break block3;
                this.getActiveFgCall().hangup();
            }
            return;
        }
        this.getActiveFgCall().hangup();
        this.switchHoldingAndActive(call);
    }

    public boolean hasActiveBgCall() {
        return this.getFirstActiveCall(this.mBackgroundCalls) != null;
    }

    public boolean hasActiveFgCall() {
        return this.getFirstActiveCall(this.mForegroundCalls) != null;
    }

    public boolean hasActiveRingingCall() {
        return this.getFirstActiveCall(this.mRingingCalls) != null;
    }

    public boolean hasDisconnectedBgCall() {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED) != null;
    }

    public boolean hasDisconnectedFgCall() {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED) != null;
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.mCallWaitingRegistrants.addUnique(handler, n, object);
    }

    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.mCdmaOtaStatusChangeRegistrants.addUnique(handler, n, object);
    }

    public void registerForDisconnect(Handler handler, int n, Object object) {
        this.mDisconnectRegistrants.addUnique(handler, n, object);
    }

    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        this.mDisplayInfoRegistrants.addUnique(handler, n, object);
    }

    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.mEcmTimerResetRegistrants.addUnique(handler, n, object);
    }

    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        this.mInCallVoicePrivacyOffRegistrants.addUnique(handler, n, object);
    }

    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        this.mInCallVoicePrivacyOnRegistrants.addUnique(handler, n, object);
    }

    public void registerForIncomingRing(Handler handler, int n, Object object) {
        this.mIncomingRingRegistrants.addUnique(handler, n, object);
    }

    public void registerForMmiComplete(Handler handler, int n, Object object) {
        this.mMmiCompleteRegistrants.addUnique(handler, n, object);
    }

    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        this.mMmiInitiateRegistrants.addUnique(handler, n, object);
    }

    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        this.mNewRingingConnectionRegistrants.addUnique(handler, n, object);
    }

    public void registerForPostDialCharacter(Handler handler, int n, Object object) {
        this.mPostDialCharacterRegistrants.addUnique(handler, n, object);
    }

    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        this.mPreciseCallStateRegistrants.addUnique(handler, n, object);
    }

    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        this.mResendIncallMuteRegistrants.addUnique(handler, n, object);
    }

    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mRingbackToneRegistrants.addUnique(handler, n, object);
    }

    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        this.mServiceStateChangedRegistrants.addUnique(handler, n, object);
    }

    public void registerForSignalInfo(Handler handler, int n, Object object) {
        this.mSignalInfoRegistrants.addUnique(handler, n, object);
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.mSubscriptionInfoReadyRegistrants.addUnique(handler, n, object);
    }

    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        this.mSuppServiceFailedRegistrants.addUnique(handler, n, object);
    }

    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        this.mUnknownConnectionRegistrants.addUnique(handler, n, object);
    }

    public boolean registerPhone(Phone phone) {
        Phone phone2 = CallManager.getPhoneBase(phone);
        if (phone2 != null && !this.mPhones.contains(phone2)) {
            Log.d(LOG_TAG, "registerPhone(" + phone.getPhoneName() + " " + phone + ")");
            if (this.mPhones.isEmpty()) {
                this.mDefaultPhone = phone2;
            }
            this.mPhones.add(phone2);
            this.mRingingCalls.add(phone2.getRingingCall());
            this.mBackgroundCalls.add(phone2.getBackgroundCall());
            this.mForegroundCalls.add(phone2.getForegroundCall());
            this.registerForPhoneStates(phone2);
            return true;
        }
        return false;
    }

    public void rejectCall(Call call) throws CallStateException {
        call.getPhone().rejectCall();
    }

    public boolean sendBurstDtmf(String string2, int n, int n2, Message message) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendBurstDtmf(string2, n, n2, message);
            return true;
        }
        return false;
    }

    public boolean sendDtmf(char c) {
        boolean bl = this.hasActiveFgCall();
        boolean bl2 = false;
        if (bl) {
            this.getActiveFgCall().getPhone().sendDtmf(c);
            bl2 = true;
        }
        return bl2;
    }

    public boolean sendUssdResponse(Phone phone, String string2) {
        Log.e(LOG_TAG, "sendUssdResponse not implemented");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAudioMode() {
        int n;
        AudioManager audioManager;
        block7: {
            block6: {
                Context context = this.getContext();
                if (context == null) break block6;
                audioManager = (AudioManager)context.getSystemService("audio");
                int n2 = 2.$SwitchMap$com$android$internal$telephony$Phone$State[this.getState().ordinal()];
                n = 0;
                switch (n2) {
                    case 1: {
                        n = 1;
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        Phone phone = this.getFgPhone();
                        Call.State state = this.getActiveFgCallState();
                        Call.State state2 = Call.State.IDLE;
                        n = 0;
                        if (state == state2) break;
                        Call.State state3 = this.getActiveFgCallState();
                        Call.State state4 = Call.State.DISCONNECTED;
                        n = 0;
                        if (state3 == state4) break;
                        n = phone instanceof SipPhone ? 3 : 2;
                    }
                }
                if (audioManager.getMode() != n) break block7;
            }
            return;
        }
        audioManager.setMode(n);
    }

    public void setEchoSuppressionEnabled(boolean bl) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setEchoSuppressionEnabled(bl);
        }
    }

    public void setMute(boolean bl) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setMute(bl);
        }
    }

    public boolean startDtmf(char c) {
        boolean bl = this.hasActiveFgCall();
        boolean bl2 = false;
        if (bl) {
            this.getActiveFgCall().getPhone().startDtmf(c);
            bl2 = true;
        }
        return bl2;
    }

    public void stopDtmf() {
        if (this.hasActiveFgCall()) {
            this.getFgPhone().stopDtmf();
        }
    }

    public void switchHoldingAndActive(Call call) throws CallStateException {
        boolean bl = this.hasActiveFgCall();
        Phone phone = null;
        if (bl) {
            phone = this.getActiveFgCall().getPhone();
        }
        Phone phone2 = null;
        if (call != null) {
            phone2 = call.getPhone();
        }
        if (phone != null) {
            phone.switchHoldingAndActive();
        }
        if (phone2 != null && phone2 != phone) {
            phone2.switchHoldingAndActive();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("########### Dump CallManager ############");
        stringBuilder.append("\nCallManager state = " + (Object)((Object)this.getState()));
        Call call = this.getActiveFgCall();
        stringBuilder.append("\n   - Foreground: " + (Object)((Object)this.getActiveFgCallState()));
        stringBuilder.append(" from " + call.getPhone());
        stringBuilder.append("\n     Conn: ").append(this.getFgCallConnections());
        Call call2 = this.getFirstActiveBgCall();
        stringBuilder.append("\n   - Background: " + (Object)((Object)call2.getState()));
        stringBuilder.append(" from " + call2.getPhone());
        stringBuilder.append("\n     Conn: ").append(this.getBgCallConnections());
        Call call3 = this.getFirstActiveRingingCall();
        stringBuilder.append("\n   - Ringing: " + (Object)((Object)call3.getState()));
        stringBuilder.append(" from " + call3.getPhone());
        for (Phone phone : this.getAllPhones()) {
            if (phone == null) continue;
            stringBuilder.append("\n Phone: " + phone + ", name = " + phone.getPhoneName() + ", state = " + (Object)((Object)phone.getState()));
            Call call4 = phone.getForegroundCall();
            stringBuilder.append("\n   - Foreground: ").append(call4);
            Call call5 = phone.getBackgroundCall();
            stringBuilder.append(" Background: ").append(call5);
            Call call6 = phone.getRingingCall();
            stringBuilder.append(" Ringing: ").append(call6);
        }
        stringBuilder.append("\n########## End Dump CallManager ##########");
        return stringBuilder.toString();
    }

    public void unregisterForCallWaiting(Handler handler) {
        this.mCallWaitingRegistrants.remove(handler);
    }

    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.mCdmaOtaStatusChangeRegistrants.remove(handler);
    }

    public void unregisterForDisconnect(Handler handler) {
        this.mDisconnectRegistrants.remove(handler);
    }

    public void unregisterForDisplayInfo(Handler handler) {
        this.mDisplayInfoRegistrants.remove(handler);
    }

    public void unregisterForEcmTimerReset(Handler handler) {
        this.mEcmTimerResetRegistrants.remove(handler);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        this.mInCallVoicePrivacyOffRegistrants.remove(handler);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        this.mInCallVoicePrivacyOnRegistrants.remove(handler);
    }

    public void unregisterForIncomingRing(Handler handler) {
        this.mIncomingRingRegistrants.remove(handler);
    }

    public void unregisterForMmiComplete(Handler handler) {
        this.mMmiCompleteRegistrants.remove(handler);
    }

    public void unregisterForMmiInitiate(Handler handler) {
        this.mMmiInitiateRegistrants.remove(handler);
    }

    public void unregisterForNewRingingConnection(Handler handler) {
        this.mNewRingingConnectionRegistrants.remove(handler);
    }

    public void unregisterForPostDialCharacter(Handler handler) {
        this.mPostDialCharacterRegistrants.remove(handler);
    }

    public void unregisterForPreciseCallStateChanged(Handler handler) {
        this.mPreciseCallStateRegistrants.remove(handler);
    }

    public void unregisterForResendIncallMute(Handler handler) {
        this.mResendIncallMuteRegistrants.remove(handler);
    }

    public void unregisterForRingbackTone(Handler handler) {
        this.mRingbackToneRegistrants.remove(handler);
    }

    public void unregisterForServiceStateChanged(Handler handler) {
        this.mServiceStateChangedRegistrants.remove(handler);
    }

    public void unregisterForSignalInfo(Handler handler) {
        this.mSignalInfoRegistrants.remove(handler);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.mSubscriptionInfoReadyRegistrants.remove(handler);
    }

    public void unregisterForSuppServiceFailed(Handler handler) {
        this.mSuppServiceFailedRegistrants.remove(handler);
    }

    public void unregisterForUnknownConnection(Handler handler) {
        this.mUnknownConnectionRegistrants.remove(handler);
    }

    public void unregisterPhone(Phone phone) {
        block3: {
            block2: {
                Phone phone2 = CallManager.getPhoneBase(phone);
                if (phone2 == null || !this.mPhones.contains(phone2)) break block2;
                Log.d(LOG_TAG, "unregisterPhone(" + phone.getPhoneName() + " " + phone + ")");
                this.mPhones.remove(phone2);
                this.mRingingCalls.remove(phone2.getRingingCall());
                this.mBackgroundCalls.remove(phone2.getBackgroundCall());
                this.mForegroundCalls.remove(phone2.getForegroundCall());
                this.unregisterForPhoneStates(phone2);
                if (phone2 != this.mDefaultPhone) break block2;
                if (!this.mPhones.isEmpty()) break block3;
                this.mDefaultPhone = null;
            }
            return;
        }
        this.mDefaultPhone = this.mPhones.get(0);
    }
}

