/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;

public abstract class CallTracker
extends Handler {
    private static final boolean DBG_POLL = false;
    protected static final int EVENT_CALL_STATE_CHANGE = 2;
    protected static final int EVENT_CALL_WAITING_INFO_CDMA = 15;
    protected static final int EVENT_CONFERENCE_RESULT = 11;
    protected static final int EVENT_ECT_RESULT = 13;
    protected static final int EVENT_EXIT_ECM_RESPONSE_CDMA = 14;
    protected static final int EVENT_GET_LAST_CALL_FAIL_CAUSE = 5;
    protected static final int EVENT_OPERATION_COMPLETE = 4;
    protected static final int EVENT_POLL_CALLS_RESULT = 1;
    protected static final int EVENT_RADIO_AVAILABLE = 9;
    protected static final int EVENT_RADIO_NOT_AVAILABLE = 10;
    protected static final int EVENT_REPOLL_AFTER_DELAY = 3;
    protected static final int EVENT_SEPARATE_RESULT = 12;
    protected static final int EVENT_SWITCH_RESULT = 8;
    protected static final int EVENT_THREE_WAY_DIAL_L2_RESULT_CDMA = 16;
    static final int POLL_DELAY_MSEC = 250;
    public CommandsInterface cm;
    protected Message lastRelevantPoll;
    protected boolean needsPoll;
    protected int pendingOperations;

    private boolean checkNoOperationsPending() {
        return this.pendingOperations == 0;
    }

    @Override
    public abstract void handleMessage(Message var1);

    protected abstract void handlePollCalls(AsyncResult var1);

    protected void handleRadioAvailable() {
        this.pollCallsWhenSafe();
    }

    protected boolean isCommandExceptionRadioNotAvailable(Throwable throwable) {
        return throwable != null && throwable instanceof CommandException && ((CommandException)throwable).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE;
    }

    protected abstract void log(String var1);

    protected Message obtainNoPollCompleteMessage(int n) {
        this.pendingOperations = 1 + this.pendingOperations;
        this.lastRelevantPoll = null;
        return this.obtainMessage(n);
    }

    protected void pollCallsAfterDelay() {
        Message message = this.obtainMessage();
        message.what = 3;
        this.sendMessageDelayed(message, 250L);
    }

    protected void pollCallsWhenSafe() {
        this.needsPoll = true;
        if (this.checkNoOperationsPending()) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
        }
    }
}

