/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

public class CallerInfo {
    public static final String PAYPHONE_NUMBER = "-3";
    public static final String PRIVATE_NUMBER = "-2";
    private static final String TAG = "CallerInfo";
    public static final String UNKNOWN_NUMBER = "-1";
    private static final boolean VDBG = Log.isLoggable("CallerInfo", 2);
    public Drawable cachedPhoto;
    public String cnapName;
    public boolean contactExists;
    public Uri contactRefUri;
    public Uri contactRingtoneUri;
    public boolean isCachedPhotoCurrent;
    private boolean mIsEmergency = false;
    private boolean mIsVoiceMail = false;
    public String name;
    public int namePresentation;
    public boolean needUpdate;
    public String numberLabel;
    public int numberPresentation;
    public int numberType;
    public long person_id;
    public String phoneLabel;
    public String phoneNumber;
    public int photoResource;
    public boolean shouldSendToVoicemail;

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String string2, CallerInfo callerInfo) {
        String string3;
        if (!callerInfo.contactExists && PhoneNumberUtils.isUriNumber((String)string2) && PhoneNumberUtils.isGlobalPhoneNumber(string3 = string2.substring(0, string2.indexOf(64)))) {
            callerInfo = CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(string3)));
        }
        return callerInfo;
    }

    public static String getCallerId(Context context, String string2) {
        block3: {
            String string3;
            block2: {
                CallerInfo callerInfo = CallerInfo.getCallerInfo(context, string2);
                string3 = null;
                if (callerInfo == null) break block2;
                String string4 = callerInfo.name;
                if (TextUtils.isEmpty(string4)) break block3;
                string3 = string4;
            }
            return string3;
        }
        return string2;
    }

    public static CallerInfo getCallerInfo(Context context, Uri uri) {
        return CallerInfo.getCallerInfo(context, uri, context.getContentResolver().query(uri, null, null, null, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CallerInfo getCallerInfo(Context context, Uri uri, Cursor cursor) {
        CallerInfo callerInfo = new CallerInfo();
        callerInfo.photoResource = 0;
        callerInfo.phoneLabel = null;
        callerInfo.numberType = 0;
        callerInfo.numberLabel = null;
        callerInfo.cachedPhoto = null;
        callerInfo.isCachedPhotoCurrent = false;
        callerInfo.contactExists = false;
        if (VDBG) {
            Log.v(TAG, "construct callerInfo from cursor");
        }
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = cursor.getColumnIndex("display_name");
                if (n6 != -1) {
                    callerInfo.name = cursor.getString(n6);
                }
                if ((n5 = cursor.getColumnIndex("number")) != -1) {
                    callerInfo.phoneNumber = cursor.getString(n5);
                }
                if ((n4 = cursor.getColumnIndex("label")) != -1 && (n3 = cursor.getColumnIndex("type")) != -1) {
                    callerInfo.numberType = cursor.getInt(n3);
                    callerInfo.numberLabel = cursor.getString(n4);
                    callerInfo.phoneLabel = ((Object)ContactsContract.CommonDataKinds.Phone.getDisplayLabel((Context)context, (int)callerInfo.numberType, (CharSequence)callerInfo.numberLabel)).toString();
                }
                if ((n2 = CallerInfo.getColumnIndexForPersonId(uri, cursor)) != -1) {
                    callerInfo.person_id = cursor.getLong(n2);
                    if (VDBG) {
                        Log.v(TAG, "==> got info.person_id: " + callerInfo.person_id);
                    }
                } else {
                    Log.w(TAG, "Couldn't find person_id column for " + uri);
                }
                callerInfo.contactRingtoneUri = (n = cursor.getColumnIndex("custom_ringtone")) != -1 && cursor.getString(n) != null ? Uri.parse(cursor.getString(n)) : null;
                int n7 = cursor.getColumnIndex("send_to_voicemail");
                boolean bl = n7 != -1 && cursor.getInt(n7) == 1;
                callerInfo.shouldSendToVoicemail = bl;
                callerInfo.contactExists = true;
            }
            cursor.close();
        }
        callerInfo.needUpdate = false;
        callerInfo.name = CallerInfo.normalize(callerInfo.name);
        callerInfo.contactRefUri = uri;
        return callerInfo;
    }

    public static CallerInfo getCallerInfo(Context context, String string2) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        if (PhoneNumberUtils.isEmergencyNumber(string2)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber((String)string2)) {
            return new CallerInfo().markAsVoiceMail();
        }
        CallerInfo callerInfo = CallerInfo.doSecondaryLookupIfNecessary(context, string2, CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(string2))));
        if (TextUtils.isEmpty(callerInfo.phoneNumber)) {
            callerInfo.phoneNumber = string2;
        }
        return callerInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getColumnIndexForPersonId(Uri uri, Cursor cursor) {
        String string2;
        String string3;
        if (VDBG) {
            Log.v(TAG, "- getColumnIndexForPersonId: contactRef URI = '" + uri + "'...");
        }
        if ((string3 = uri.toString()).startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                Log.v(TAG, "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            string2 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                Log.v(TAG, "'data' URI; using Data.CONTACT_ID");
            }
            string2 = "contact_id";
        } else if (string3.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                Log.v(TAG, "'phone_lookup' URI; using PhoneLookup._ID");
            }
            string2 = "_id";
        } else {
            Log.w(TAG, "Unexpected prefix for contactRef '" + string3 + "'");
            string2 = null;
        }
        int n = string2 != null ? cursor.getColumnIndex(string2) : -1;
        if (VDBG) {
            Log.v(TAG, "==> Using column '" + string2 + "' (columnIndex = " + n + ") for person_id lookup...");
        }
        return n;
    }

    private static String normalize(String string2) {
        if (string2 == null || string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public boolean isEmergencyNumber() {
        return this.mIsEmergency;
    }

    public boolean isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    CallerInfo markAsEmergency(Context context) {
        this.phoneNumber = context.getString(17039999);
        this.photoResource = 17302080;
        this.mIsEmergency = true;
        return this;
    }

    CallerInfo markAsVoiceMail() {
        this.mIsVoiceMail = true;
        try {
            this.phoneNumber = TelephonyManager.getDefault().getVoiceMailAlphaTag();
            return this;
        }
        catch (SecurityException securityException) {
            Log.e(TAG, "Cannot access VoiceMail.", securityException);
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(128).append("CallerInfo { ");
        StringBuilder stringBuilder2 = new StringBuilder().append("name ");
        String string3 = this.name == null ? "null" : "non-null";
        StringBuilder stringBuilder3 = stringBuilder.append(stringBuilder2.append(string3).toString());
        StringBuilder stringBuilder4 = new StringBuilder().append(", phoneNumber ");
        if (this.phoneNumber == null) {
            string2 = "null";
            return stringBuilder3.append(stringBuilder4.append(string2).toString()).append(" }").toString();
        }
        string2 = "non-null";
        return stringBuilder3.append(stringBuilder4.append(string2).toString()).append(" }").toString();
    }
}

