/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.AsyncQueryHandler;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;

public class CallerInfoAsyncQuery {
    private static final boolean DBG = false;
    private static final int EVENT_ADD_LISTENER = 2;
    private static final int EVENT_EMERGENCY_NUMBER = 4;
    private static final int EVENT_END_OF_QUEUE = 3;
    private static final int EVENT_NEW_QUERY = 1;
    private static final int EVENT_VOICEMAIL_NUMBER = 5;
    private static final String LOG_TAG = "CallerInfoAsyncQuery";
    private CallerInfoAsyncQueryHandler mHandler;

    private CallerInfoAsyncQuery() {
    }

    private void allocate(Context context, Uri uri) {
        if (context == null || uri == null) {
            throw new QueryPoolException("Bad context or query uri.");
        }
        this.mHandler = new CallerInfoAsyncQueryHandler(context);
        CallerInfoAsyncQueryHandler.access$302(this.mHandler, context);
        CallerInfoAsyncQueryHandler.access$402(this.mHandler, uri);
    }

    private void release() {
        CallerInfoAsyncQueryHandler.access$302(this.mHandler, null);
        CallerInfoAsyncQueryHandler.access$402(this.mHandler, null);
        CallerInfoAsyncQueryHandler.access$502(this.mHandler, null);
        this.mHandler = null;
    }

    private static String sanitizeUriToString(Uri uri) {
        if (uri != null) {
            String string2 = uri.toString();
            int n = string2.lastIndexOf(47);
            if (n > 0) {
                return string2.substring(0, n) + "/xxxxxxx";
            }
            return string2;
        }
        return "";
    }

    public static CallerInfoAsyncQuery startQuery(int n, Context context, Uri uri, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        CallerInfoAsyncQuery callerInfoAsyncQuery = new CallerInfoAsyncQuery();
        callerInfoAsyncQuery.allocate(context, uri);
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.event = 1;
        callerInfoAsyncQuery.mHandler.startQuery(n, cookieWrapper, uri, null, null, null, null);
        return callerInfoAsyncQuery;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CallerInfoAsyncQuery startQuery(int n, Context context, String string2, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        String[] stringArray;
        String string3;
        Uri uri;
        if (PhoneNumberUtils.isUriNumber((String)string2)) {
            uri = ContactsContract.Data.CONTENT_URI;
            string3 = "upper(data1)=? AND mimetype='vnd.android.cursor.item/sip_address'";
            stringArray = new String[]{string2.toUpperCase()};
        } else {
            uri = Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(string2));
            string3 = null;
            stringArray = null;
        }
        CallerInfoAsyncQuery callerInfoAsyncQuery = new CallerInfoAsyncQuery();
        callerInfoAsyncQuery.allocate(context, uri);
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.number = string2;
        cookieWrapper.event = PhoneNumberUtils.isEmergencyNumber(string2) ? 4 : (PhoneNumberUtils.isVoiceMailNumber((String)string2) ? 5 : 1);
        callerInfoAsyncQuery.mHandler.startQuery(n, cookieWrapper, uri, null, string3, stringArray, null);
        return callerInfoAsyncQuery;
    }

    public void addQueryListener(int n, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        CookieWrapper cookieWrapper = new CookieWrapper();
        cookieWrapper.listener = onQueryCompleteListener;
        cookieWrapper.cookie = object;
        cookieWrapper.event = 2;
        this.mHandler.startQuery(n, cookieWrapper, null, null, null, null, null);
    }

    private class CallerInfoAsyncQueryHandler
    extends AsyncQueryHandler {
        private CallerInfo mCallerInfo;
        private Context mQueryContext;
        private Uri mQueryUri;

        private CallerInfoAsyncQueryHandler(Context context) {
            super(context.getContentResolver());
        }

        static /* synthetic */ Context access$302(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Context context) {
            callerInfoAsyncQueryHandler.mQueryContext = context;
            return context;
        }

        static /* synthetic */ Uri access$402(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Uri uri) {
            callerInfoAsyncQueryHandler.mQueryUri = uri;
            return uri;
        }

        static /* synthetic */ CallerInfo access$502(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, CallerInfo callerInfo) {
            callerInfoAsyncQueryHandler.mCallerInfo = callerInfo;
            return callerInfo;
        }

        @Override
        protected Handler createHandler(Looper looper) {
            return new CallerInfoWorkerHandler(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onQueryComplete(int n, Object object, Cursor cursor) {
            CookieWrapper cookieWrapper;
            block13: {
                block12: {
                    cookieWrapper = (CookieWrapper)object;
                    if (cookieWrapper == null) break block12;
                    if (cookieWrapper.event == 3) {
                        CallerInfoAsyncQuery.this.release();
                        return;
                    }
                    if (this.mCallerInfo == null) {
                        if (this.mQueryContext == null || this.mQueryUri == null) {
                            throw new QueryPoolException("Bad context or query uri, or CallerInfoAsyncQuery already released.");
                        }
                        if (cookieWrapper.event == 4) {
                            this.mCallerInfo = new CallerInfo().markAsEmergency(this.mQueryContext);
                        } else if (cookieWrapper.event == 5) {
                            this.mCallerInfo = new CallerInfo().markAsVoiceMail();
                        } else {
                            this.mCallerInfo = CallerInfo.getCallerInfo(this.mQueryContext, this.mQueryUri, cursor);
                            CallerInfo callerInfo = CallerInfo.doSecondaryLookupIfNecessary(this.mQueryContext, cookieWrapper.number, this.mCallerInfo);
                            if (callerInfo != this.mCallerInfo) {
                                this.mCallerInfo = callerInfo;
                            }
                            if (!TextUtils.isEmpty(cookieWrapper.number)) {
                                this.mCallerInfo.phoneNumber = PhoneNumberUtils.formatNumber(cookieWrapper.number);
                            }
                        }
                        CookieWrapper cookieWrapper2 = new CookieWrapper();
                        cookieWrapper2.event = 3;
                        this.startQuery(n, cookieWrapper2, null, null, null, null, null);
                    }
                    if (cookieWrapper.listener != null) break block13;
                }
                return;
            }
            cookieWrapper.listener.onQueryComplete(n, cookieWrapper.cookie, this.mCallerInfo);
        }

        protected class CallerInfoWorkerHandler
        extends AsyncQueryHandler.WorkerHandler {
            public CallerInfoWorkerHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message message) {
                AsyncQueryHandler.WorkerArgs workerArgs = (AsyncQueryHandler.WorkerArgs)message.obj;
                CookieWrapper cookieWrapper = (CookieWrapper)workerArgs.cookie;
                if (cookieWrapper == null) {
                    super.handleMessage(message);
                    return;
                }
                switch (cookieWrapper.event) {
                    default: {
                        return;
                    }
                    case 1: {
                        super.handleMessage(message);
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                }
                Message message2 = workerArgs.handler.obtainMessage(message.what);
                message2.obj = workerArgs;
                message2.arg1 = message.arg1;
                message2.sendToTarget();
            }
        }
    }

    private static final class CookieWrapper {
        public Object cookie;
        public int event;
        public OnQueryCompleteListener listener;
        public String number;

        private CookieWrapper() {
        }
    }

    public static interface OnQueryCompleteListener {
        public void onQueryComplete(int var1, Object var2, CallerInfo var3);
    }

    public static class QueryPoolException
    extends SQLException {
        public QueryPoolException(String string2) {
            super(string2);
        }
    }
}

