/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;

public class CommandException
extends RuntimeException {
    private Error e;

    public CommandException(Error error) {
        super(error.toString());
        this.e = error;
    }

    public static CommandException fromRilErrno(int n) {
        switch (n) {
            default: {
                Log.e("GSM", "Unrecognized RIL errno " + n);
                return new CommandException(Error.INVALID_RESPONSE);
            }
            case 0: {
                return null;
            }
            case -1: {
                return new CommandException(Error.INVALID_RESPONSE);
            }
            case 1: {
                return new CommandException(Error.RADIO_NOT_AVAILABLE);
            }
            case 2: {
                return new CommandException(Error.GENERIC_FAILURE);
            }
            case 3: {
                return new CommandException(Error.PASSWORD_INCORRECT);
            }
            case 4: {
                return new CommandException(Error.SIM_PIN2);
            }
            case 5: {
                return new CommandException(Error.SIM_PUK2);
            }
            case 6: {
                return new CommandException(Error.REQUEST_NOT_SUPPORTED);
            }
            case 8: {
                return new CommandException(Error.OP_NOT_ALLOWED_DURING_VOICE_CALL);
            }
            case 9: {
                return new CommandException(Error.OP_NOT_ALLOWED_BEFORE_REG_NW);
            }
            case 10: {
                return new CommandException(Error.SMS_FAIL_RETRY);
            }
            case 11: {
                return new CommandException(Error.SIM_ABSENT);
            }
            case 12: {
                return new CommandException(Error.SUBSCRIPTION_NOT_AVAILABLE);
            }
            case 13: {
                return new CommandException(Error.MODE_NOT_SUPPORTED);
            }
            case 14: {
                return new CommandException(Error.FDN_CHECK_FAILURE);
            }
            case 15: 
        }
        return new CommandException(Error.ILLEGAL_SIM_OR_ME);
    }

    public Error getCommandError() {
        return this.e;
    }

    public static final class Error
    extends Enum<Error> {
        private static final /* synthetic */ Error[] $VALUES;
        public static final /* enum */ Error FDN_CHECK_FAILURE;
        public static final /* enum */ Error GENERIC_FAILURE;
        public static final /* enum */ Error ILLEGAL_SIM_OR_ME;
        public static final /* enum */ Error INVALID_RESPONSE;
        public static final /* enum */ Error MODE_NOT_SUPPORTED;
        public static final /* enum */ Error OP_NOT_ALLOWED_BEFORE_REG_NW;
        public static final /* enum */ Error OP_NOT_ALLOWED_DURING_VOICE_CALL;
        public static final /* enum */ Error PASSWORD_INCORRECT;
        public static final /* enum */ Error RADIO_NOT_AVAILABLE;
        public static final /* enum */ Error REQUEST_NOT_SUPPORTED;
        public static final /* enum */ Error SIM_ABSENT;
        public static final /* enum */ Error SIM_PIN2;
        public static final /* enum */ Error SIM_PUK2;
        public static final /* enum */ Error SMS_FAIL_RETRY;
        public static final /* enum */ Error SUBSCRIPTION_NOT_AVAILABLE;

        static {
            INVALID_RESPONSE = new Error();
            RADIO_NOT_AVAILABLE = new Error();
            GENERIC_FAILURE = new Error();
            PASSWORD_INCORRECT = new Error();
            SIM_PIN2 = new Error();
            SIM_PUK2 = new Error();
            REQUEST_NOT_SUPPORTED = new Error();
            OP_NOT_ALLOWED_DURING_VOICE_CALL = new Error();
            OP_NOT_ALLOWED_BEFORE_REG_NW = new Error();
            SMS_FAIL_RETRY = new Error();
            SIM_ABSENT = new Error();
            SUBSCRIPTION_NOT_AVAILABLE = new Error();
            MODE_NOT_SUPPORTED = new Error();
            FDN_CHECK_FAILURE = new Error();
            ILLEGAL_SIM_OR_ME = new Error();
            Error[] errorArray = new Error[]{INVALID_RESPONSE, RADIO_NOT_AVAILABLE, GENERIC_FAILURE, PASSWORD_INCORRECT, SIM_PIN2, SIM_PUK2, REQUEST_NOT_SUPPORTED, OP_NOT_ALLOWED_DURING_VOICE_CALL, OP_NOT_ALLOWED_BEFORE_REG_NW, SMS_FAIL_RETRY, SIM_ABSENT, SUBSCRIPTION_NOT_AVAILABLE, MODE_NOT_SUPPORTED, FDN_CHECK_FAILURE, ILLEGAL_SIM_OR_ME};
            $VALUES = errorArray;
        }

        public static Error valueOf(String string2) {
            return Enum.valueOf(Error.class, string2);
        }

        public static Error[] values() {
            return (Error[])$VALUES.clone();
        }
    }
}

