/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;

public abstract class Connection {
    private static String LOG_TAG;
    public static int PRESENTATION_ALLOWED;
    public static int PRESENTATION_PAYPHONE;
    public static int PRESENTATION_RESTRICTED;
    public static int PRESENTATION_UNKNOWN;
    Object userData;

    static {
        PRESENTATION_ALLOWED = 1;
        PRESENTATION_RESTRICTED = 2;
        PRESENTATION_UNKNOWN = 3;
        PRESENTATION_PAYPHONE = 4;
        LOG_TAG = "TelephonyConnection";
    }

    public abstract void cancelPostDial();

    public void clearUserData() {
        this.userData = null;
    }

    public abstract String getAddress();

    public abstract Call getCall();

    public String getCnapName() {
        return null;
    }

    public int getCnapNamePresentation() {
        return 0;
    }

    public abstract long getConnectTime();

    public abstract long getCreateTime();

    public abstract DisconnectCause getDisconnectCause();

    public abstract long getDisconnectTime();

    public abstract long getDurationMillis();

    public abstract long getHoldDurationMillis();

    public abstract int getNumberPresentation();

    public String getOrigDialString() {
        return null;
    }

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    public Call.State getState() {
        Call call = this.getCall();
        if (call == null) {
            return Call.State.IDLE;
        }
        return call.getState();
    }

    public abstract UUSInfo getUUSInfo();

    public Object getUserData() {
        return this.userData;
    }

    public abstract void hangup() throws CallStateException;

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public abstract boolean isIncoming();

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void separate() throws CallStateException;

    public void setUserData(Object object) {
        this.userData = object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (Log.isLoggable(LOG_TAG, 3)) {
            stringBuilder.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        stringBuilder.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return stringBuilder.toString();
    }

    public static final class DisconnectCause
    extends Enum<DisconnectCause> {
        private static final /* synthetic */ DisconnectCause[] $VALUES;
        public static final /* enum */ DisconnectCause BUSY;
        public static final /* enum */ DisconnectCause CALL_BARRED;
        public static final /* enum */ DisconnectCause CDMA_ACCESS_BLOCKED;
        public static final /* enum */ DisconnectCause CDMA_ACCESS_FAILURE;
        public static final /* enum */ DisconnectCause CDMA_DROP;
        public static final /* enum */ DisconnectCause CDMA_INTERCEPT;
        public static final /* enum */ DisconnectCause CDMA_LOCKED_UNTIL_POWER_CYCLE;
        public static final /* enum */ DisconnectCause CDMA_NOT_EMERGENCY;
        public static final /* enum */ DisconnectCause CDMA_PREEMPTED;
        public static final /* enum */ DisconnectCause CDMA_REORDER;
        public static final /* enum */ DisconnectCause CDMA_RETRY_ORDER;
        public static final /* enum */ DisconnectCause CDMA_SO_REJECT;
        public static final /* enum */ DisconnectCause CONGESTION;
        public static final /* enum */ DisconnectCause CS_RESTRICTED;
        public static final /* enum */ DisconnectCause CS_RESTRICTED_EMERGENCY;
        public static final /* enum */ DisconnectCause CS_RESTRICTED_NORMAL;
        public static final /* enum */ DisconnectCause ERROR_UNSPECIFIED;
        public static final /* enum */ DisconnectCause FDN_BLOCKED;
        public static final /* enum */ DisconnectCause ICC_ERROR;
        public static final /* enum */ DisconnectCause INCOMING_MISSED;
        public static final /* enum */ DisconnectCause INCOMING_REJECTED;
        public static final /* enum */ DisconnectCause INVALID_CREDENTIALS;
        public static final /* enum */ DisconnectCause INVALID_NUMBER;
        public static final /* enum */ DisconnectCause LIMIT_EXCEEDED;
        public static final /* enum */ DisconnectCause LOCAL;
        public static final /* enum */ DisconnectCause LOST_SIGNAL;
        public static final /* enum */ DisconnectCause MMI;
        public static final /* enum */ DisconnectCause NORMAL;
        public static final /* enum */ DisconnectCause NOT_DISCONNECTED;
        public static final /* enum */ DisconnectCause NUMBER_UNREACHABLE;
        public static final /* enum */ DisconnectCause OUT_OF_NETWORK;
        public static final /* enum */ DisconnectCause OUT_OF_SERVICE;
        public static final /* enum */ DisconnectCause POWER_OFF;
        public static final /* enum */ DisconnectCause SERVER_ERROR;
        public static final /* enum */ DisconnectCause SERVER_UNREACHABLE;
        public static final /* enum */ DisconnectCause TIMED_OUT;
        public static final /* enum */ DisconnectCause UNOBTAINABLE_NUMBER;

        static {
            NOT_DISCONNECTED = new DisconnectCause();
            INCOMING_MISSED = new DisconnectCause();
            NORMAL = new DisconnectCause();
            LOCAL = new DisconnectCause();
            BUSY = new DisconnectCause();
            CONGESTION = new DisconnectCause();
            MMI = new DisconnectCause();
            INVALID_NUMBER = new DisconnectCause();
            NUMBER_UNREACHABLE = new DisconnectCause();
            SERVER_UNREACHABLE = new DisconnectCause();
            INVALID_CREDENTIALS = new DisconnectCause();
            OUT_OF_NETWORK = new DisconnectCause();
            SERVER_ERROR = new DisconnectCause();
            TIMED_OUT = new DisconnectCause();
            LOST_SIGNAL = new DisconnectCause();
            LIMIT_EXCEEDED = new DisconnectCause();
            INCOMING_REJECTED = new DisconnectCause();
            POWER_OFF = new DisconnectCause();
            OUT_OF_SERVICE = new DisconnectCause();
            ICC_ERROR = new DisconnectCause();
            CALL_BARRED = new DisconnectCause();
            FDN_BLOCKED = new DisconnectCause();
            CS_RESTRICTED = new DisconnectCause();
            CS_RESTRICTED_NORMAL = new DisconnectCause();
            CS_RESTRICTED_EMERGENCY = new DisconnectCause();
            UNOBTAINABLE_NUMBER = new DisconnectCause();
            CDMA_LOCKED_UNTIL_POWER_CYCLE = new DisconnectCause();
            CDMA_DROP = new DisconnectCause();
            CDMA_INTERCEPT = new DisconnectCause();
            CDMA_REORDER = new DisconnectCause();
            CDMA_SO_REJECT = new DisconnectCause();
            CDMA_RETRY_ORDER = new DisconnectCause();
            CDMA_ACCESS_FAILURE = new DisconnectCause();
            CDMA_PREEMPTED = new DisconnectCause();
            CDMA_NOT_EMERGENCY = new DisconnectCause();
            CDMA_ACCESS_BLOCKED = new DisconnectCause();
            ERROR_UNSPECIFIED = new DisconnectCause();
            DisconnectCause[] disconnectCauseArray = new DisconnectCause[]{NOT_DISCONNECTED, INCOMING_MISSED, NORMAL, LOCAL, BUSY, CONGESTION, MMI, INVALID_NUMBER, NUMBER_UNREACHABLE, SERVER_UNREACHABLE, INVALID_CREDENTIALS, OUT_OF_NETWORK, SERVER_ERROR, TIMED_OUT, LOST_SIGNAL, LIMIT_EXCEEDED, INCOMING_REJECTED, POWER_OFF, OUT_OF_SERVICE, ICC_ERROR, CALL_BARRED, FDN_BLOCKED, CS_RESTRICTED, CS_RESTRICTED_NORMAL, CS_RESTRICTED_EMERGENCY, UNOBTAINABLE_NUMBER, CDMA_LOCKED_UNTIL_POWER_CYCLE, CDMA_DROP, CDMA_INTERCEPT, CDMA_REORDER, CDMA_SO_REJECT, CDMA_RETRY_ORDER, CDMA_ACCESS_FAILURE, CDMA_PREEMPTED, CDMA_NOT_EMERGENCY, CDMA_ACCESS_BLOCKED, ERROR_UNSPECIFIED};
            $VALUES = disconnectCauseArray;
        }

        public static DisconnectCause valueOf(String string2) {
            return Enum.valueOf(DisconnectCause.class, string2);
        }

        public static DisconnectCause[] values() {
            return (DisconnectCause[])$VALUES.clone();
        }
    }

    public static final class PostDialState
    extends Enum<PostDialState> {
        private static final /* synthetic */ PostDialState[] $VALUES;
        public static final /* enum */ PostDialState CANCELLED;
        public static final /* enum */ PostDialState COMPLETE;
        public static final /* enum */ PostDialState NOT_STARTED;
        public static final /* enum */ PostDialState PAUSE;
        public static final /* enum */ PostDialState STARTED;
        public static final /* enum */ PostDialState WAIT;
        public static final /* enum */ PostDialState WILD;

        static {
            NOT_STARTED = new PostDialState();
            STARTED = new PostDialState();
            WAIT = new PostDialState();
            WILD = new PostDialState();
            COMPLETE = new PostDialState();
            CANCELLED = new PostDialState();
            PAUSE = new PostDialState();
            PostDialState[] postDialStateArray = new PostDialState[]{NOT_STARTED, STARTED, WAIT, WILD, COMPLETE, CANCELLED, PAUSE};
            $VALUES = postDialStateArray;
        }

        public static PostDialState valueOf(String string2) {
            return Enum.valueOf(PostDialState.class, string2);
        }

        public static PostDialState[] values() {
            return (PostDialState[])$VALUES.clone();
        }
    }
}

