/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.util.EventLog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public abstract class DataConnection
extends HierarchicalStateMachine {
    protected static final boolean DBG = true;
    protected static final int EVENT_CONNECT = 2;
    protected static final int EVENT_DEACTIVATE_DONE = 5;
    protected static final int EVENT_DISCONNECT = 6;
    protected static final int EVENT_GET_LAST_FAIL_DONE = 4;
    protected static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    protected static final int EVENT_RESET = 1;
    protected static final int EVENT_SETUP_DATA_CONNECTION_DONE = 3;
    protected static final String NULL_IP = "0.0.0.0";
    protected static int mCount;
    protected static Object mCountLock;
    protected int cid;
    protected long createTime;
    protected String[] dnsServers;
    protected String gatewayAddress;
    protected String interfaceName;
    protected String ipAddress;
    protected FailCause lastFailCause;
    protected long lastFailTime;
    private DcActivatingState mActivatingState;
    private DcActiveState mActiveState;
    private DcDefaultState mDefaultState = new DcDefaultState();
    private DcDisconnectingBadDnsState mDisconnectingBadDnsState;
    private DcDisconnectingState mDisconnectingState;
    private DcInactiveState mInactiveState = new DcInactiveState();
    protected int mTag;
    protected PhoneBase phone;
    Object userData;

    static {
        mCountLock = new Object();
    }

    protected DataConnection(PhoneBase phoneBase, String string2) {
        super(string2);
        this.mActivatingState = new DcActivatingState();
        this.mActiveState = new DcActiveState();
        this.mDisconnectingState = new DcDisconnectingState();
        this.mDisconnectingBadDnsState = new DcDisconnectingBadDnsState();
        this.log("DataConnection constructor E");
        this.phone = phoneBase;
        this.cid = -1;
        this.dnsServers = new String[2];
        this.clearSettings();
        this.setDbg(false);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingBadDnsState, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.log("DataConnection constructor X");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifyConnectCompleted(ConnectionParams connectionParams, FailCause failCause) {
        Message message = connectionParams.onCompletedMsg;
        if (message == null) {
            return;
        }
        long l = System.currentTimeMillis();
        message.arg1 = this.cid;
        if (failCause == FailCause.NONE) {
            this.createTime = l;
            AsyncResult.forMessage(message);
        } else {
            this.lastFailCause = failCause;
            this.lastFailTime = l;
            AsyncResult.forMessage(message, (Object)failCause, new Exception());
        }
        this.log("notifyConnection at " + l + " cause=" + (Object)((Object)failCause));
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyDisconnectCompleted(DisconnectParams disconnectParams) {
        this.log("NotifyDisconnectCompleted");
        if (disconnectParams.onCompletedMsg != null) {
            Message message = disconnectParams.onCompletedMsg;
            Object[] objectArray = new Object[2];
            objectArray[0] = message.what;
            String string2 = message.obj instanceof String ? (String)message.obj : "<no-reason>";
            objectArray[1] = string2;
            this.log(String.format("msg.what=%d msg.obj=%s", objectArray));
            AsyncResult.forMessage(message);
            message.sendToTarget();
        }
        if (disconnectParams.lockObj != null) {
            ResetSynchronouslyLock resetSynchronouslyLock = disconnectParams.lockObj;
            synchronized (resetSynchronouslyLock) {
                disconnectParams.lockObj.notify();
            }
        }
        this.clearSettings();
    }

    /*
     * Enabled aggressive block sorting
     */
    private SetupResult onSetupConnectionCompleted(AsyncResult asyncResult) {
        SetupResult setupResult;
        String[] stringArray = (String[])asyncResult.result;
        ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
        if (asyncResult.exception != null) {
            this.log("DataConnection Init failed " + asyncResult.exception);
            if (asyncResult.exception instanceof CommandException && ((CommandException)asyncResult.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                setupResult = SetupResult.ERR_BadCommand;
                setupResult.mFailCause = FailCause.RADIO_NOT_AVAILABLE;
            } else {
                setupResult = SetupResult.ERR_Other;
            }
        } else if (connectionParams.tag != this.mTag) {
            this.log("BUG: onSetupConnectionCompleted is stale cp.tag=" + connectionParams.tag + ", mtag=" + this.mTag);
            setupResult = SetupResult.ERR_Stale;
        } else if (stringArray.length >= 2) {
            this.cid = Integer.parseInt(stringArray[0]);
            this.interfaceName = stringArray[1];
            if (stringArray.length > 2) {
                this.ipAddress = stringArray[2];
                String string2 = "net." + this.interfaceName + ".";
                this.gatewayAddress = SystemProperties.get(string2 + "gw");
                this.dnsServers[0] = SystemProperties.get(string2 + "dns1");
                this.dnsServers[1] = SystemProperties.get(string2 + "dns2");
                this.log("interface=" + this.interfaceName + " ipAddress=" + this.ipAddress + " gateway=" + this.gatewayAddress + " DNS1=" + this.dnsServers[0] + " DNS2=" + this.dnsServers[1]);
                setupResult = this.isDnsOk(this.dnsServers) ? SetupResult.SUCCESS : SetupResult.ERR_BadDns;
            } else {
                setupResult = SetupResult.SUCCESS;
            }
        } else {
            setupResult = SetupResult.ERR_Other;
        }
        this.log("DataConnection setup result='" + (Object)((Object)setupResult) + "' on cid=" + this.cid);
        return setupResult;
    }

    private void tearDownData(Object object) {
        if (this.phone.mCM.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(5, object));
            return;
        }
        this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
        this.sendMessage(this.obtainMessage(5, new AsyncResult(object, null, null)));
    }

    protected void clearSettings() {
        this.log("clearSettings");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = FailCause.NONE;
        this.interfaceName = null;
        this.ipAddress = null;
        this.gatewayAddress = null;
        this.dnsServers[0] = null;
        this.dnsServers[1] = null;
    }

    public void connect(Message message) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(null, message)));
    }

    public void connect(Message message, ApnSetting apnSetting) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(apnSetting, message)));
    }

    public void disconnect(Message message) {
        this.sendMessage(this.obtainMessage(6, new DisconnectParams(message)));
    }

    public long getConnectionTime() {
        return this.createTime;
    }

    public String[] getDnsServers() {
        return this.dnsServers;
    }

    protected abstract FailCause getFailCauseFromRequest(int var1);

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public FailCause getLastFailCause() {
        return this.lastFailCause;
    }

    public long getLastFailTime() {
        return this.lastFailTime;
    }

    public String getStateAsString() {
        return this.getCurrentState().getName();
    }

    public boolean isActive() {
        return this.getCurrentState() == this.mActiveState;
    }

    protected abstract boolean isDnsOk(String[] var1);

    public boolean isInactive() {
        return this.getCurrentState() == this.mInactiveState;
    }

    protected abstract void log(String var1);

    protected abstract void onConnect(ConnectionParams var1);

    public void reset(Message message) {
        this.sendMessage(this.obtainMessage(1, new DisconnectParams(message)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetSynchronously() {
        ResetSynchronouslyLock resetSynchronouslyLock = new ResetSynchronouslyLock();
        synchronized (resetSynchronouslyLock) {
            this.sendMessage(this.obtainMessage(1, new DisconnectParams(resetSynchronouslyLock)));
            try {
                resetSynchronouslyLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.log("blockingReset: unexpected interrupted of wait()");
            }
            return;
        }
    }

    public abstract String toString();

    protected static class ConnectionParams {
        public ApnSetting apn;
        public Message onCompletedMsg;
        public int tag;

        public ConnectionParams(ApnSetting apnSetting, Message message) {
            this.apn = apnSetting;
            this.onCompletedMsg = message;
        }
    }

    private class DcActivatingState
    extends HierarchicalState {
        private DcActivatingState() {
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcActivatingState not handled msg.what=" + message.what);
                    return false;
                }
                case 6: {
                    DataConnection.this.log("DcActivatingState deferring msg.what=EVENT_DISCONNECT");
                    DataConnection.this.deferMessage(message);
                    return true;
                }
                case 3: {
                    DataConnection.this.log("DcActivatingState msg.what=EVENT_SETUP_DATA_CONNECTION_DONE");
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
                    SetupResult setupResult = DataConnection.this.onSetupConnectionCompleted(asyncResult);
                    int n = 0;
                    block12: do {
                        switch (n == 0 ? 1.$SwitchMap$com$android$internal$telephony$DataConnection$SetupResult[setupResult.ordinal()] : n) {
                            default: {
                                throw new RuntimeException("Unkown SetupResult, should not happen");
                            }
                            case 5: {
                                DataConnection.this.mActiveState.setEnterNotificationParams(connectionParams, FailCause.NONE);
                                DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                                n = 4;
                                continue block12;
                            }
                            case 1: {
                                DataConnection.this.mInactiveState.setEnterNotificationParams(connectionParams, setupResult.mFailCause);
                                DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                                n = 4;
                                continue block12;
                            }
                            case 2: {
                                EventLog.writeEvent(50100, DataConnection.this.dnsServers[0]);
                                DataConnection.this.tearDownData(connectionParams);
                                DataConnection.this.transitionTo(DataConnection.this.mDisconnectingBadDnsState);
                            }
                            case 4: {
                                return true;
                            }
                            case 3: 
                        }
                        break;
                    } while (true);
                    DataConnection.this.phone.mCM.getLastDataCallFailCause(DataConnection.this.obtainMessage(4, connectionParams));
                    return true;
                }
                case 4: 
            }
            AsyncResult asyncResult = (AsyncResult)message.obj;
            ConnectionParams connectionParams = (ConnectionParams)asyncResult.userObj;
            FailCause failCause = FailCause.UNKNOWN;
            if (connectionParams.tag != DataConnection.this.mTag) {
                DataConnection.this.log("DcActivatingState EVENT_GET_LAST_FAIL_DONE is stale cp.tag=" + connectionParams.tag + ", mTag=" + DataConnection.this.mTag);
                return true;
            }
            DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE");
            if (asyncResult.exception == null) {
                int n = ((int[])asyncResult.result)[0];
                failCause = DataConnection.this.getFailCauseFromRequest(n);
            }
            DataConnection.this.mInactiveState.setEnterNotificationParams(connectionParams, failCause);
            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
            return true;
        }
    }

    private class DcActiveState
    extends HierarchicalState {
        private ConnectionParams mConnectionParams = null;
        private FailCause mFailCause = null;

        private DcActiveState() {
        }

        @Override
        public void enter() {
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcActiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
        }

        @Override
        protected void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
        }

        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcActiveState nothandled msg.what=" + message.what);
                    return false;
                }
                case 6: 
            }
            DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT");
            DisconnectParams disconnectParams = (DisconnectParams)message.obj;
            disconnectParams.tag = DataConnection.this.mTag;
            DataConnection.this.tearDownData(disconnectParams);
            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
            return true;
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, FailCause failCause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = connectionParams;
            this.mFailCause = failCause;
        }
    }

    private class DcDefaultState
    extends HierarchicalState {
        private DcDefaultState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=" + message.what);
                    return true;
                }
                case 1: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_RESET");
                    DataConnection.this.clearSettings();
                    if (message.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)message.obj);
                    }
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    return true;
                }
                case 2: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams connectionParams = (ConnectionParams)message.obj;
                    DataConnection.this.notifyConnectCompleted(connectionParams, FailCause.UNKNOWN);
                    return true;
                }
                case 6: 
            }
            DataConnection.this.log("DcDefaultState: msg.what=EVENT_DISCONNECT");
            DataConnection.this.notifyDisconnectCompleted((DisconnectParams)message.obj);
            return true;
        }
    }

    private class DcDisconnectingBadDnsState
    extends HierarchicalState {
        private DcDisconnectingBadDnsState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcDisconnectingBadDnsState not handled msg.what=" + message.what);
                    return false;
                }
                case 5: 
            }
            ConnectionParams connectionParams = (ConnectionParams)((AsyncResult)message.obj).userObj;
            if (connectionParams.tag == DataConnection.this.mTag) {
                DataConnection.this.log("DcDisconnectingBadDnsState msg.what=EVENT_DEACTIVATE_DONE");
                DataConnection.this.mInactiveState.setEnterNotificationParams(connectionParams, FailCause.UNKNOWN);
                DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                return true;
            }
            DataConnection.this.log("DcDisconnectingBadDnsState EVENT_DEACTIVE_DONE stale dp.tag=" + connectionParams.tag + ", mTag=" + DataConnection.this.mTag);
            return true;
        }
    }

    private class DcDisconnectingState
    extends HierarchicalState {
        private DcDisconnectingState() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcDisconnectingState not handled msg.what=" + message.what);
                    return false;
                }
                case 5: 
            }
            DataConnection.this.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE");
            AsyncResult asyncResult = (AsyncResult)message.obj;
            DisconnectParams disconnectParams = (DisconnectParams)asyncResult.userObj;
            if (disconnectParams.tag == DataConnection.this.mTag) {
                DataConnection.this.mInactiveState.setEnterNotificationParams((DisconnectParams)asyncResult.userObj);
                DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                return true;
            }
            DataConnection.this.log("DcDisconnectState EVENT_DEACTIVATE_DONE stale dp.tag=" + disconnectParams.tag + " mTag=" + DataConnection.this.mTag);
            return true;
        }
    }

    private class DcInactiveState
    extends HierarchicalState {
        private ConnectionParams mConnectionParams = null;
        private DisconnectParams mDisconnectParams = null;
        private FailCause mFailCause = null;

        private DcInactiveState() {
        }

        @Override
        protected void enter() {
            DataConnection dataConnection = DataConnection.this;
            dataConnection.mTag = 1 + dataConnection.mTag;
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
            if (this.mDisconnectParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted");
                DataConnection.this.notifyDisconnectCompleted(this.mDisconnectParams);
            }
        }

        @Override
        protected void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
            this.mDisconnectParams = null;
        }

        @Override
        protected boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    DataConnection.this.log("DcInactiveState nothandled msg.what=" + message.what);
                    return false;
                }
                case 1: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_RESET, ignore we're already reset");
                    if (message.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)message.obj);
                    }
                    return true;
                }
                case 2: 
            }
            DataConnection.this.log("DcInactiveState msg.what=EVENT_CONNECT");
            ConnectionParams connectionParams = (ConnectionParams)message.obj;
            connectionParams.tag = DataConnection.this.mTag;
            DataConnection.this.onConnect(connectionParams);
            DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
            return true;
        }

        public void setEnterNotificationParams(ConnectionParams connectionParams, FailCause failCause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = connectionParams;
            this.mFailCause = failCause;
        }

        public void setEnterNotificationParams(DisconnectParams disconnectParams) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams dp");
            this.mDisconnectParams = disconnectParams;
        }
    }

    protected static class DisconnectParams {
        public ResetSynchronouslyLock lockObj;
        public Message onCompletedMsg;
        public int tag;

        public DisconnectParams(Message message) {
            this.onCompletedMsg = message;
        }

        public DisconnectParams(ResetSynchronouslyLock resetSynchronouslyLock) {
            this.lockObj = resetSynchronouslyLock;
        }
    }

    public static final class FailCause
    extends Enum<FailCause> {
        private static final /* synthetic */ FailCause[] $VALUES;
        public static final /* enum */ FailCause ACTIVATION_REJECT_GGSN;
        public static final /* enum */ FailCause ACTIVATION_REJECT_UNSPECIFIED;
        public static final /* enum */ FailCause GPRS_REGISTRATION_FAIL;
        public static final /* enum */ FailCause INSUFFICIENT_RESOURCES;
        public static final /* enum */ FailCause MISSING_UNKNOWN_APN;
        public static final /* enum */ FailCause NONE;
        public static final /* enum */ FailCause NSAPI_IN_USE;
        public static final /* enum */ FailCause OPERATOR_BARRED;
        public static final /* enum */ FailCause PROTOCOL_ERRORS;
        public static final /* enum */ FailCause RADIO_NOT_AVAILABLE;
        public static final /* enum */ FailCause REGISTRATION_FAIL;
        public static final /* enum */ FailCause SERVICE_OPTION_NOT_SUBSCRIBED;
        public static final /* enum */ FailCause SERVICE_OPTION_NOT_SUPPORTED;
        public static final /* enum */ FailCause SERVICE_OPTION_OUT_OF_ORDER;
        public static final /* enum */ FailCause UNKNOWN;
        public static final /* enum */ FailCause UNKNOWN_PDP_ADDRESS;
        public static final /* enum */ FailCause USER_AUTHENTICATION;

        static {
            NONE = new FailCause();
            OPERATOR_BARRED = new FailCause();
            INSUFFICIENT_RESOURCES = new FailCause();
            MISSING_UNKNOWN_APN = new FailCause();
            UNKNOWN_PDP_ADDRESS = new FailCause();
            USER_AUTHENTICATION = new FailCause();
            ACTIVATION_REJECT_GGSN = new FailCause();
            ACTIVATION_REJECT_UNSPECIFIED = new FailCause();
            SERVICE_OPTION_NOT_SUPPORTED = new FailCause();
            SERVICE_OPTION_NOT_SUBSCRIBED = new FailCause();
            SERVICE_OPTION_OUT_OF_ORDER = new FailCause();
            NSAPI_IN_USE = new FailCause();
            PROTOCOL_ERRORS = new FailCause();
            REGISTRATION_FAIL = new FailCause();
            GPRS_REGISTRATION_FAIL = new FailCause();
            UNKNOWN = new FailCause();
            RADIO_NOT_AVAILABLE = new FailCause();
            FailCause[] failCauseArray = new FailCause[]{NONE, OPERATOR_BARRED, INSUFFICIENT_RESOURCES, MISSING_UNKNOWN_APN, UNKNOWN_PDP_ADDRESS, USER_AUTHENTICATION, ACTIVATION_REJECT_GGSN, ACTIVATION_REJECT_UNSPECIFIED, SERVICE_OPTION_NOT_SUPPORTED, SERVICE_OPTION_NOT_SUBSCRIBED, SERVICE_OPTION_OUT_OF_ORDER, NSAPI_IN_USE, PROTOCOL_ERRORS, REGISTRATION_FAIL, GPRS_REGISTRATION_FAIL, UNKNOWN, RADIO_NOT_AVAILABLE};
            $VALUES = failCauseArray;
        }

        public static FailCause valueOf(String string2) {
            return Enum.valueOf(FailCause.class, string2);
        }

        public static FailCause[] values() {
            return (FailCause[])$VALUES.clone();
        }

        public boolean isEventLoggable() {
            return this == OPERATOR_BARRED || this == INSUFFICIENT_RESOURCES || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_OUT_OF_ORDER || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public boolean isPermanentFail() {
            return this == OPERATOR_BARRED || this == MISSING_UNKNOWN_APN || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public String toString() {
            switch (this) {
                default: {
                    return "Unknown Data Error";
                }
                case NONE: {
                    return "No Error";
                }
                case OPERATOR_BARRED: {
                    return "Operator Barred";
                }
                case INSUFFICIENT_RESOURCES: {
                    return "Insufficient Resources";
                }
                case MISSING_UNKNOWN_APN: {
                    return "Missing / Unknown APN";
                }
                case UNKNOWN_PDP_ADDRESS: {
                    return "Unknown PDP Address";
                }
                case USER_AUTHENTICATION: {
                    return "Error User Authentication";
                }
                case ACTIVATION_REJECT_GGSN: {
                    return "Activation Reject GGSN";
                }
                case ACTIVATION_REJECT_UNSPECIFIED: {
                    return "Activation Reject unspecified";
                }
                case SERVICE_OPTION_NOT_SUPPORTED: {
                    return "Data Not Supported";
                }
                case SERVICE_OPTION_NOT_SUBSCRIBED: {
                    return "Data Not subscribed";
                }
                case SERVICE_OPTION_OUT_OF_ORDER: {
                    return "Data Services Out of Order";
                }
                case NSAPI_IN_USE: {
                    return "NSAPI in use";
                }
                case PROTOCOL_ERRORS: {
                    return "Protocol Errors";
                }
                case REGISTRATION_FAIL: {
                    return "Network Registration Failure";
                }
                case GPRS_REGISTRATION_FAIL: {
                    return "Data Network Registration Failure";
                }
                case RADIO_NOT_AVAILABLE: 
            }
            return "Radio Not Available";
        }
    }

    class ResetSynchronouslyLock {
        ResetSynchronouslyLock() {
        }
    }

    protected static final class SetupResult
    extends Enum<SetupResult> {
        private static final /* synthetic */ SetupResult[] $VALUES;
        public static final /* enum */ SetupResult ERR_BadCommand = new SetupResult();
        public static final /* enum */ SetupResult ERR_BadDns = new SetupResult();
        public static final /* enum */ SetupResult ERR_Other = new SetupResult();
        public static final /* enum */ SetupResult ERR_Stale = new SetupResult();
        public static final /* enum */ SetupResult SUCCESS = new SetupResult();
        public FailCause mFailCause;

        static {
            SetupResult[] setupResultArray = new SetupResult[]{ERR_BadCommand, ERR_BadDns, ERR_Other, ERR_Stale, SUCCESS};
            $VALUES = setupResultArray;
        }

        public static SetupResult valueOf(String string2) {
            return Enum.valueOf(SetupResult.class, string2);
        }

        public static SetupResult[] values() {
            return (SetupResult[])$VALUES.clone();
        }

        public String toString() {
            switch (1.$SwitchMap$com$android$internal$telephony$DataConnection$SetupResult[this.ordinal()]) {
                default: {
                    return "unknown";
                }
                case 1: {
                    return "Bad Command";
                }
                case 2: {
                    return "Bad DNS";
                }
                case 3: {
                    return "Other error";
                }
                case 4: {
                    return "Stale command";
                }
                case 5: 
            }
            return "SUCCESS";
        }
    }
}

