/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;

public class DefaultPhoneNotifier
implements PhoneNotifier {
    private static final boolean DBG = true;
    static final String LOG_TAG = "GSM";
    private ITelephonyRegistry mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));

    DefaultPhoneNotifier() {
    }

    public static int convertCallState(Phone.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$Phone$State[state.ordinal()]) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    public static Phone.State convertCallState(int n) {
        switch (n) {
            default: {
                return Phone.State.IDLE;
            }
            case 1: {
                return Phone.State.RINGING;
            }
            case 2: 
        }
        return Phone.State.OFFHOOK;
    }

    public static int convertDataActivityState(Phone.DataActivityState dataActivityState) {
        switch (dataActivityState) {
            default: {
                return 0;
            }
            case DATAIN: {
                return 1;
            }
            case DATAOUT: {
                return 2;
            }
            case DATAINANDOUT: {
                return 3;
            }
            case DORMANT: 
        }
        return 4;
    }

    public static Phone.DataActivityState convertDataActivityState(int n) {
        switch (n) {
            default: {
                return Phone.DataActivityState.NONE;
            }
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: 
        }
        return Phone.DataActivityState.DORMANT;
    }

    public static int convertDataState(Phone.DataState dataState) {
        switch (dataState) {
            default: {
                return 0;
            }
            case CONNECTING: {
                return 1;
            }
            case CONNECTED: {
                return 2;
            }
            case SUSPENDED: 
        }
        return 3;
    }

    public static Phone.DataState convertDataState(int n) {
        switch (n) {
            default: {
                return Phone.DataState.DISCONNECTED;
            }
            case 1: {
                return Phone.DataState.CONNECTING;
            }
            case 2: {
                return Phone.DataState.CONNECTED;
            }
            case 3: 
        }
        return Phone.DataState.SUSPENDED;
    }

    private void log(String string2) {
        Log.d(LOG_TAG, "[PhoneNotifier] " + string2);
    }

    @Override
    public void notifyCallForwardingChanged(Phone phone) {
        try {
            this.mRegistry.notifyCallForwardingChanged(phone.getCallForwardingIndicator());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyCellLocation(Phone phone) {
        Bundle bundle = new Bundle();
        phone.getCellLocation().fillInNotifierBundle(bundle);
        try {
            this.mRegistry.notifyCellLocation(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyDataActivity(Phone phone) {
        try {
            this.mRegistry.notifyDataActivity(DefaultPhoneNotifier.convertDataActivityState(phone.getDataActivityState()));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyDataConnection(Phone phone, String string2) {
        TelephonyManager telephonyManager = TelephonyManager.getDefault();
        try {
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            int n = DefaultPhoneNotifier.convertDataState(phone.getDataConnectionState());
            boolean bl = phone.isDataConnectivityPossible();
            String string3 = phone.getActiveApn();
            String[] stringArray = phone.getActiveApnTypes();
            String string4 = phone.getInterfaceName(null);
            int n2 = telephonyManager != null ? telephonyManager.getNetworkType() : 0;
            iTelephonyRegistry.notifyDataConnection(n, bl, string2, string3, stringArray, string4, n2, phone.getGateway(null));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyDataConnectionFailed(Phone phone, String string2) {
        try {
            this.mRegistry.notifyDataConnectionFailed(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyMessageWaitingChanged(Phone phone) {
        try {
            this.mRegistry.notifyMessageWaitingChanged(phone.getMessageWaitingIndicator());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyPhoneState(Phone phone) {
        Call call = phone.getRingingCall();
        String string2 = "";
        if (call != null && call.getEarliestConnection() != null) {
            string2 = call.getEarliestConnection().getAddress();
        }
        try {
            this.mRegistry.notifyCallState(DefaultPhoneNotifier.convertCallState(phone.getState()), string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifyServiceState(Phone phone) {
        try {
            this.mRegistry.notifyServiceState(phone.getServiceState());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void notifySignalStrength(Phone phone) {
        try {
            this.mRegistry.notifySignalStrength(phone.getSignalStrength());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

