/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.ATResponseParser;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.UUSInfo;

public class DriverCall
implements Comparable {
    static final String LOG_TAG = "RILB";
    public int TOA;
    public int als;
    public int index;
    public boolean isMT;
    public boolean isMpty;
    public boolean isVoice;
    public boolean isVoicePrivacy;
    public String name;
    public int namePresentation;
    public String number;
    public int numberPresentation;
    public State state;
    public UUSInfo uusInfo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DriverCall fromCLCCLine(String string2) {
        DriverCall driverCall = new DriverCall();
        ATResponseParser aTResponseParser = new ATResponseParser(string2);
        try {
            driverCall.index = aTResponseParser.nextInt();
            driverCall.isMT = aTResponseParser.nextBoolean();
            driverCall.state = DriverCall.stateFromCLCC(aTResponseParser.nextInt());
            boolean bl = aTResponseParser.nextInt() == 0;
            driverCall.isVoice = bl;
            driverCall.isMpty = aTResponseParser.nextBoolean();
            driverCall.numberPresentation = Connection.PRESENTATION_ALLOWED;
            if (aTResponseParser.hasMore()) {
                driverCall.number = PhoneNumberUtils.extractNetworkPortionAlt((String)aTResponseParser.nextString());
                if (driverCall.number.length() == 0) {
                    driverCall.number = null;
                }
                driverCall.TOA = aTResponseParser.nextInt();
                driverCall.number = PhoneNumberUtils.stringFromStringAndTOA(driverCall.number, driverCall.TOA);
            }
            return driverCall;
        }
        catch (ATParseEx aTParseEx) {
            Log.e(LOG_TAG, "Invalid CLCC line: '" + string2 + "'");
            return null;
        }
    }

    public static int presentationFromCLIP(int n) throws ATParseEx {
        switch (n) {
            default: {
                throw new ATParseEx("illegal presentation " + n);
            }
            case 0: {
                return Connection.PRESENTATION_ALLOWED;
            }
            case 1: {
                return Connection.PRESENTATION_RESTRICTED;
            }
            case 2: {
                return Connection.PRESENTATION_UNKNOWN;
            }
            case 3: 
        }
        return Connection.PRESENTATION_PAYPHONE;
    }

    public static State stateFromCLCC(int n) throws ATParseEx {
        switch (n) {
            default: {
                throw new ATParseEx("illegal call state " + n);
            }
            case 0: {
                return State.ACTIVE;
            }
            case 1: {
                return State.HOLDING;
            }
            case 2: {
                return State.DIALING;
            }
            case 3: {
                return State.ALERTING;
            }
            case 4: {
                return State.INCOMING;
            }
            case 5: 
        }
        return State.WAITING;
    }

    public int compareTo(Object object) {
        DriverCall driverCall = (DriverCall)object;
        if (this.index < driverCall.index) {
            return -1;
        }
        if (this.index == driverCall.index) {
            return 0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("id=").append(this.index).append(",").append((Object)this.state).append(",").append("toa=").append(this.TOA).append(",");
        String string3 = this.isMpty ? "conf" : "norm";
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(",");
        String string4 = this.isMT ? "mt" : "mo";
        StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(",").append(this.als).append(",");
        String string5 = this.isVoice ? "voc" : "nonvoc";
        StringBuilder stringBuilder4 = stringBuilder3.append(string5).append(",");
        if (this.isVoicePrivacy) {
            string2 = "evp";
            return stringBuilder4.append(string2).append(",").append(",cli=").append(this.numberPresentation).append(",").append(",").append(this.namePresentation).toString();
        }
        string2 = "noevp";
        return stringBuilder4.append(string2).append(",").append(",cli=").append(this.numberPresentation).append(",").append(",").append(this.namePresentation).toString();
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ACTIVE = new State();
        public static final /* enum */ State ALERTING;
        public static final /* enum */ State DIALING;
        public static final /* enum */ State HOLDING;
        public static final /* enum */ State INCOMING;
        public static final /* enum */ State WAITING;

        static {
            HOLDING = new State();
            DIALING = new State();
            ALERTING = new State();
            INCOMING = new State();
            WAITING = new State();
            State[] stateArray = new State[]{ACTIVE, HOLDING, DIALING, ALERTING, INCOMING, WAITING};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

