/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.telephony.SmsRawData;
import java.util.ArrayList;
import java.util.List;

public interface ISms
extends IInterface {
    public boolean copyMessageToIccEf(int var1, byte[] var2, byte[] var3) throws RemoteException;

    public List<SmsRawData> getAllMessagesFromIccEf() throws RemoteException;

    public void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6) throws RemoteException;

    public void sendMultipartText(String var1, String var2, List<String> var3, List<PendingIntent> var4, List<PendingIntent> var5) throws RemoteException;

    public void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5) throws RemoteException;

    public boolean updateMessageOnIccEf(int var1, int var2, byte[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISms {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ISms";
        static final int TRANSACTION_copyMessageToIccEf = 3;
        static final int TRANSACTION_getAllMessagesFromIccEf = 1;
        static final int TRANSACTION_sendData = 4;
        static final int TRANSACTION_sendMultipartText = 6;
        static final int TRANSACTION_sendText = 5;
        static final int TRANSACTION_updateMessageOnIccEf = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISms asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISms) {
                return (ISms)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<SmsRawData> list = this.getAllMessagesFromIccEf();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.updateMessageOnIccEf(parcel.readInt(), parcel.readInt(), parcel.createByteArray());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.copyMessageToIccEf(parcel.readInt(), parcel.createByteArray(), parcel.createByteArray());
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    int n5 = parcel.readInt();
                    byte[] byArray = parcel.createByteArray();
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    PendingIntent pendingIntent2 = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.sendData(string2, string3, n5, byArray, pendingIntent, pendingIntent2);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    String string5 = parcel.readString();
                    String string6 = parcel.readString();
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    PendingIntent pendingIntent3 = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.sendText(string4, string5, string6, pendingIntent, pendingIntent3);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.sendMultipartText(parcel.readString(), parcel.readString(), parcel.createStringArrayList(), parcel.createTypedArrayList(PendingIntent.CREATOR), parcel.createTypedArrayList(PendingIntent.CREATOR));
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements ISms {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean copyMessageToIccEf(int n, byte[] byArray, byte[] byArray2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeByteArray(byArray);
                    parcel.writeByteArray(byArray2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<SmsRawData> getAllMessagesFromIccEf() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<SmsRawData> arrayList = parcel2.createTypedArrayList(SmsRawData.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeInt(n);
                    parcel.writeByteArray(byArray);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (pendingIntent2 != null) {
                        parcel.writeInt(1);
                        pendingIntent2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void sendMultipartText(String string2, String string3, List<String> list, List<PendingIntent> list2, List<PendingIntent> list3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeStringList(list);
                    parcel.writeTypedList(list2);
                    parcel.writeTypedList(list3);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (pendingIntent2 != null) {
                        parcel.writeInt(1);
                        pendingIntent2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean updateMessageOnIccEf(int n, int n2, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = n3 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

