/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.PhoneBase;

public abstract class IccCard {
    private static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    private static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    private static final int EVENT_CHANGE_ICC_PASSWORD_DONE = 9;
    private static final int EVENT_GET_ICC_STATUS_DONE = 2;
    protected static final int EVENT_ICC_LOCKED_OR_ABSENT = 1;
    protected static final int EVENT_ICC_READY = 6;
    private static final int EVENT_PINPUK_DONE = 4;
    private static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    private static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    private static final int EVENT_REPOLL_STATUS_DONE = 5;
    public static final String INTENT_KEY_ICC_STATE = "ss";
    public static final String INTENT_KEY_LOCKED_REASON = "reason";
    public static final String INTENT_VALUE_ICC_ABSENT = "ABSENT";
    public static final String INTENT_VALUE_ICC_IMSI = "IMSI";
    public static final String INTENT_VALUE_ICC_LOADED = "LOADED";
    public static final String INTENT_VALUE_ICC_LOCKED = "LOCKED";
    public static final String INTENT_VALUE_ICC_NOT_READY = "NOT_READY";
    public static final String INTENT_VALUE_ICC_READY = "READY";
    public static final String INTENT_VALUE_LOCKED_NETWORK = "NETWORK";
    public static final String INTENT_VALUE_LOCKED_ON_PIN = "PIN";
    public static final String INTENT_VALUE_LOCKED_ON_PUK = "PUK";
    private RegistrantList mAbsentRegistrants = new RegistrantList();
    protected boolean mDbg;
    private boolean mDesiredFdnEnabled;
    private boolean mDesiredPinLocked;
    protected Handler mHandler;
    private IccCardStatus mIccCardStatus = null;
    private boolean mIccFdnEnabled = false;
    private boolean mIccPinLocked = true;
    protected String mLogTag;
    private RegistrantList mNetworkLockedRegistrants;
    protected PhoneBase mPhone;
    private RegistrantList mPinLockedRegistrants = new RegistrantList();
    protected State mState = null;

    public IccCard(PhoneBase phoneBase, String string2, Boolean bl) {
        this.mNetworkLockedRegistrants = new RegistrantList();
        this.mHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        Log.e(IccCard.this.mLogTag, "[IccCard] Unknown Event " + message.what);
                        return;
                    }
                    case 3: {
                        IccCard.this.mState = null;
                        IccCard.this.updateStateProperty();
                        IccCard.this.broadcastIccStateChangedIntent(IccCard.INTENT_VALUE_ICC_NOT_READY, null);
                        return;
                    }
                    case 6: {
                        IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                        IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", 7, this.obtainMessage(7));
                        IccCard.this.mPhone.mCM.queryFacilityLock("FD", "", 7, this.obtainMessage(10));
                        return;
                    }
                    case 1: {
                        IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                        IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", 7, this.obtainMessage(7));
                        return;
                    }
                    case 2: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.getIccCardStatusDone(asyncResult);
                        return;
                    }
                    case 4: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        AsyncResult.forMessage((Message)((Message)asyncResult.userObj)).exception = asyncResult.exception;
                        IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(5, asyncResult.userObj));
                        return;
                    }
                    case 5: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.getIccCardStatusDone(asyncResult);
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 7: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.onQueryFacilityLock(asyncResult);
                        return;
                    }
                    case 10: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        IccCard.this.onQueryFdnEnabled(asyncResult);
                        return;
                    }
                    case 8: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        if (asyncResult.exception == null) {
                            IccCard.access$302(IccCard.this, IccCard.this.mDesiredPinLocked);
                            if (IccCard.this.mDbg) {
                                IccCard.this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccPinLocked= " + IccCard.this.mIccPinLocked);
                            }
                        } else {
                            Log.e(IccCard.this.mLogTag, "Error change facility lock with exception " + asyncResult.exception);
                        }
                        AsyncResult.forMessage((Message)((Message)asyncResult.userObj)).exception = asyncResult.exception;
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 11: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        if (asyncResult.exception == null) {
                            IccCard.access$602(IccCard.this, IccCard.this.mDesiredFdnEnabled);
                            if (IccCard.this.mDbg) {
                                IccCard.this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=" + IccCard.this.mIccFdnEnabled);
                            }
                        } else {
                            Log.e(IccCard.this.mLogTag, "Error change facility fdn with exception " + asyncResult.exception);
                        }
                        AsyncResult.forMessage((Message)((Message)asyncResult.userObj)).exception = asyncResult.exception;
                        ((Message)asyncResult.userObj).sendToTarget();
                        return;
                    }
                    case 9: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    Log.e(IccCard.this.mLogTag, "Error in change sim password with exception" + asyncResult.exception);
                }
                AsyncResult.forMessage((Message)((Message)asyncResult.userObj)).exception = asyncResult.exception;
                ((Message)asyncResult.userObj).sendToTarget();
            }
        };
        this.mPhone = phoneBase;
        this.mLogTag = string2;
        this.mDbg = bl;
    }

    static /* synthetic */ boolean access$302(IccCard iccCard, boolean bl) {
        iccCard.mIccPinLocked = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(IccCard iccCard, boolean bl) {
        iccCard.mIccFdnEnabled = bl;
        return bl;
    }

    private void getIccCardStatusDone(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            Log.e(this.mLogTag, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", asyncResult.exception);
            return;
        }
        this.handleIccCardStatus((IccCardStatus)asyncResult.result);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleIccCardStatus(IccCardStatus iccCardStatus) {
        State state;
        State state2 = this.mState;
        this.mIccCardStatus = iccCardStatus;
        this.mState = state = this.getIccCardState();
        this.updateStateProperty();
        boolean bl = state2 != State.PIN_REQUIRED && state == State.PIN_REQUIRED || state2 != State.PUK_REQUIRED && state == State.PUK_REQUIRED;
        boolean bl2 = state2 != State.ABSENT && state == State.ABSENT;
        boolean bl3 = state2 != State.NETWORK_LOCKED && state == State.NETWORK_LOCKED;
        if (bl) {
            if (this.mDbg) {
                this.log("Notify SIM pin or puk locked.");
            }
            this.mPinLockedRegistrants.notifyRegistrants();
            String string2 = state == State.PIN_REQUIRED ? INTENT_VALUE_LOCKED_ON_PIN : INTENT_VALUE_LOCKED_ON_PUK;
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, string2);
            return;
        } else {
            if (bl2) {
                if (this.mDbg) {
                    this.log("Notify SIM missing.");
                }
                this.mAbsentRegistrants.notifyRegistrants();
                this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_ABSENT, null);
                return;
            }
            if (!bl3) return;
            if (this.mDbg) {
                this.log("Notify SIM network locked.");
            }
            this.mNetworkLockedRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, INTENT_VALUE_LOCKED_NETWORK);
            return;
        }
    }

    private void log(String string2) {
        Log.d(this.mLogTag, "[IccCard] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryFacilityLock(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            if (!this.mDbg) return;
            this.log("Error in querying facility lock:" + asyncResult.exception);
            return;
        }
        int[] nArray = (int[])asyncResult.result;
        if (nArray.length == 0) {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
            return;
        }
        boolean bl = nArray[0] != 0;
        this.mIccPinLocked = bl;
        if (!this.mDbg) return;
        this.log("Query facility lock : " + this.mIccPinLocked);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onQueryFdnEnabled(AsyncResult asyncResult) {
        if (asyncResult.exception != null) {
            if (!this.mDbg) return;
            this.log("Error in querying facility lock:" + asyncResult.exception);
            return;
        }
        int[] nArray = (int[])asyncResult.result;
        if (nArray.length == 0) {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
            return;
        }
        boolean bl = nArray[0] != 0;
        this.mIccFdnEnabled = bl;
        if (!this.mDbg) return;
        this.log("Query facility lock : " + this.mIccFdnEnabled);
    }

    public void broadcastIccStateChangedIntent(String string2, String string3) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("phoneName", this.mPhone.getPhoneName());
        intent.putExtra(INTENT_KEY_ICC_STATE, string2);
        intent.putExtra(INTENT_KEY_LOCKED_REASON, string3);
        if (this.mDbg) {
            this.log("Broadcasting intent ACTION_SIM_STATE_CHANGED " + string2 + " reason " + string3);
        }
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    public void changeIccFdnPassword(String string2, String string3, Message message) {
        if (this.mDbg) {
            this.log("Change Pin2 old: " + string2 + " new: " + string3);
        }
        this.mPhone.mCM.changeIccPin2(string2, string3, this.mHandler.obtainMessage(9, message));
    }

    public void changeIccLockPassword(String string2, String string3, Message message) {
        if (this.mDbg) {
            this.log("Change Pin1 old: " + string2 + " new: " + string3);
        }
        this.mPhone.mCM.changeIccPin(string2, string3, this.mHandler.obtainMessage(9, message));
    }

    public abstract void dispose();

    protected void finalize() {
        if (this.mDbg) {
            Log.d(this.mLogTag, "IccCard finalized");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public State getIccCardState() {
        if (this.mIccCardStatus == null) {
            Log.e(this.mLogTag, "[IccCard] IccCardStatus is null");
            return State.ABSENT;
        }
        if (!this.mIccCardStatus.getCardState().isCardPresent()) {
            return State.ABSENT;
        }
        CommandsInterface.RadioState radioState = this.mPhone.mCM.getRadioState();
        if (radioState == CommandsInterface.RadioState.RADIO_OFF || radioState == CommandsInterface.RadioState.RADIO_UNAVAILABLE || radioState == CommandsInterface.RadioState.SIM_NOT_READY || radioState == CommandsInterface.RadioState.RUIM_NOT_READY || radioState == CommandsInterface.RadioState.NV_NOT_READY || radioState == CommandsInterface.RadioState.NV_READY) {
            return State.NOT_READY;
        }
        if (radioState != CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT && radioState != CommandsInterface.RadioState.SIM_READY && radioState != CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT && radioState != CommandsInterface.RadioState.RUIM_READY) {
            return State.ABSENT;
        }
        int n = radioState == CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT || radioState == CommandsInterface.RadioState.RUIM_READY ? this.mIccCardStatus.getCdmaSubscriptionAppIndex() : this.mIccCardStatus.getGsmUmtsSubscriptionAppIndex();
        IccCardApplication iccCardApplication = this.mIccCardStatus.getApplication(n);
        if (iccCardApplication == null) {
            Log.e(this.mLogTag, "[IccCard] Subscription Application in not present");
            return State.ABSENT;
        }
        if (iccCardApplication.app_state.isPinRequired()) {
            return State.PIN_REQUIRED;
        }
        if (iccCardApplication.app_state.isPukRequired()) {
            return State.PUK_REQUIRED;
        }
        if (iccCardApplication.app_state.isSubscriptionPersoEnabled()) {
            return State.NETWORK_LOCKED;
        }
        if (iccCardApplication.app_state.isAppReady()) {
            return State.READY;
        }
        if (iccCardApplication.app_state.isAppNotReady()) {
            return State.NOT_READY;
        }
        return State.NOT_READY;
    }

    public boolean getIccFdnEnabled() {
        return this.mIccFdnEnabled;
    }

    public boolean getIccLockEnabled() {
        return this.mIccPinLocked;
    }

    public abstract String getServiceProviderName();

    public State getState() {
        if (this.mState == null) {
            switch (2.$SwitchMap$com$android$internal$telephony$CommandsInterface$RadioState[this.mPhone.mCM.getRadioState().ordinal()]) {
                default: {
                    Log.e(this.mLogTag, "IccCard.getState(): case should never be reached");
                    return State.UNKNOWN;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return State.UNKNOWN;
                }
                case 5: 
                case 6: {
                    return State.UNKNOWN;
                }
                case 7: 
                case 8: 
                case 9: {
                    return State.READY;
                }
                case 10: 
            }
            return State.ABSENT;
        }
        return this.mState;
    }

    public boolean hasIccCard() {
        if (this.mPhone.getPhoneName().equals("GSM")) {
            return this.mIccCardStatus.getCardState().isCardPresent();
        }
        return false;
    }

    public boolean isApplicationOnIcc(IccCardApplication.AppType appType) {
        if (this.mIccCardStatus == null) {
            return false;
        }
        for (int i = 0; i < this.mIccCardStatus.getNumApplications(); ++i) {
            IccCardApplication iccCardApplication = this.mIccCardStatus.getApplication(i);
            if (iccCardApplication == null || iccCardApplication.app_type != appType) continue;
            return true;
        }
        return false;
    }

    public void registerForAbsent(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mAbsentRegistrants.add(registrant);
        if (this.getState() == State.ABSENT) {
            registrant.notifyRegistrant();
        }
    }

    public void registerForLocked(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mPinLockedRegistrants.add(registrant);
        if (this.getState().isPinLocked()) {
            registrant.notifyRegistrant();
        }
    }

    public void registerForNetworkLocked(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mNetworkLockedRegistrants.add(registrant);
        if (this.getState() == State.NETWORK_LOCKED) {
            registrant.notifyRegistrant();
        }
    }

    public void setIccFdnEnabled(boolean bl, String string2, Message message) {
        this.mDesiredFdnEnabled = bl;
        this.mPhone.mCM.setFacilityLock("FD", bl, string2, 15, this.mHandler.obtainMessage(11, message));
    }

    public void setIccLockEnabled(boolean bl, String string2, Message message) {
        this.mDesiredPinLocked = bl;
        this.mPhone.mCM.setFacilityLock("SC", bl, string2, 7, this.mHandler.obtainMessage(8, message));
    }

    public void supplyNetworkDepersonalization(String string2, Message message) {
        if (this.mDbg) {
            this.log("Network Despersonalization: " + string2);
        }
        this.mPhone.mCM.supplyNetworkDepersonalization(string2, this.mHandler.obtainMessage(4, message));
    }

    public void supplyPin(String string2, Message message) {
        this.mPhone.mCM.supplyIccPin(string2, this.mHandler.obtainMessage(4, message));
    }

    public void supplyPin2(String string2, Message message) {
        this.mPhone.mCM.supplyIccPin2(string2, this.mHandler.obtainMessage(4, message));
    }

    public void supplyPuk(String string2, String string3, Message message) {
        this.mPhone.mCM.supplyIccPuk(string2, string3, this.mHandler.obtainMessage(4, message));
    }

    public void supplyPuk2(String string2, String string3, Message message) {
        this.mPhone.mCM.supplyIccPuk2(string2, string3, this.mHandler.obtainMessage(4, message));
    }

    public void unregisterForAbsent(Handler handler) {
        this.mAbsentRegistrants.remove(handler);
    }

    public void unregisterForLocked(Handler handler) {
        this.mPinLockedRegistrants.remove(handler);
    }

    public void unregisterForNetworkLocked(Handler handler) {
        this.mNetworkLockedRegistrants.remove(handler);
    }

    protected void updateStateProperty() {
        this.mPhone.setSystemProperty("gsm.sim.state", this.getState().toString());
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State ABSENT;
        public static final /* enum */ State NETWORK_LOCKED;
        public static final /* enum */ State NOT_READY;
        public static final /* enum */ State PIN_REQUIRED;
        public static final /* enum */ State PUK_REQUIRED;
        public static final /* enum */ State READY;
        public static final /* enum */ State UNKNOWN;

        static {
            UNKNOWN = new State();
            ABSENT = new State();
            PIN_REQUIRED = new State();
            PUK_REQUIRED = new State();
            NETWORK_LOCKED = new State();
            READY = new State();
            NOT_READY = new State();
            State[] stateArray = new State[]{UNKNOWN, ABSENT, PIN_REQUIRED, PUK_REQUIRED, NETWORK_LOCKED, READY, NOT_READY};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public boolean isPinLocked() {
            return this == PIN_REQUIRED || this == PUK_REQUIRED;
        }
    }
}

