/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.IccCardApplication;
import java.util.ArrayList;

public class IccCardStatus {
    static final int CARD_MAX_APPS = 8;
    private ArrayList<IccCardApplication> mApplications = new ArrayList(8);
    private CardState mCardState;
    private int mCdmaSubscriptionAppIndex;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mNumApplications;
    private PinState mUniversalPinState;

    public void addApplication(IccCardApplication iccCardApplication) {
        this.mApplications.add(iccCardApplication);
    }

    public IccCardApplication getApplication(int n) {
        return this.mApplications.get(n);
    }

    public CardState getCardState() {
        return this.mCardState;
    }

    public int getCdmaSubscriptionAppIndex() {
        return this.mCdmaSubscriptionAppIndex;
    }

    public int getGsmUmtsSubscriptionAppIndex() {
        return this.mGsmUmtsSubscriptionAppIndex;
    }

    public int getNumApplications() {
        return this.mNumApplications;
    }

    public void setCardState(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Unrecognized RIL_CardState: " + n);
            }
            case 0: {
                this.mCardState = CardState.CARDSTATE_ABSENT;
                return;
            }
            case 1: {
                this.mCardState = CardState.CARDSTATE_PRESENT;
                return;
            }
            case 2: 
        }
        this.mCardState = CardState.CARDSTATE_ERROR;
    }

    public void setCdmaSubscriptionAppIndex(int n) {
        this.mCdmaSubscriptionAppIndex = n;
    }

    public void setGsmUmtsSubscriptionAppIndex(int n) {
        this.mGsmUmtsSubscriptionAppIndex = n;
    }

    public void setNumApplications(int n) {
        this.mNumApplications = n;
    }

    public void setUniversalPinState(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Unrecognized RIL_PinState: " + n);
            }
            case 0: {
                this.mUniversalPinState = PinState.PINSTATE_UNKNOWN;
                return;
            }
            case 1: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_NOT_VERIFIED;
                return;
            }
            case 2: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_VERIFIED;
                return;
            }
            case 3: {
                this.mUniversalPinState = PinState.PINSTATE_DISABLED;
                return;
            }
            case 4: {
                this.mUniversalPinState = PinState.PINSTATE_ENABLED_BLOCKED;
                return;
            }
            case 5: 
        }
        this.mUniversalPinState = PinState.PINSTATE_ENABLED_PERM_BLOCKED;
    }

    public static final class CardState
    extends Enum<CardState> {
        private static final /* synthetic */ CardState[] $VALUES;
        public static final /* enum */ CardState CARDSTATE_ABSENT = new CardState();
        public static final /* enum */ CardState CARDSTATE_ERROR;
        public static final /* enum */ CardState CARDSTATE_PRESENT;

        static {
            CARDSTATE_PRESENT = new CardState();
            CARDSTATE_ERROR = new CardState();
            CardState[] cardStateArray = new CardState[]{CARDSTATE_ABSENT, CARDSTATE_PRESENT, CARDSTATE_ERROR};
            $VALUES = cardStateArray;
        }

        public static CardState valueOf(String string2) {
            return Enum.valueOf(CardState.class, string2);
        }

        public static CardState[] values() {
            return (CardState[])$VALUES.clone();
        }

        boolean isCardPresent() {
            return this == CARDSTATE_PRESENT;
        }
    }

    public static final class PinState
    extends Enum<PinState> {
        private static final /* synthetic */ PinState[] $VALUES;
        public static final /* enum */ PinState PINSTATE_DISABLED;
        public static final /* enum */ PinState PINSTATE_ENABLED_BLOCKED;
        public static final /* enum */ PinState PINSTATE_ENABLED_NOT_VERIFIED;
        public static final /* enum */ PinState PINSTATE_ENABLED_PERM_BLOCKED;
        public static final /* enum */ PinState PINSTATE_ENABLED_VERIFIED;
        public static final /* enum */ PinState PINSTATE_UNKNOWN;

        static {
            PINSTATE_UNKNOWN = new PinState();
            PINSTATE_ENABLED_NOT_VERIFIED = new PinState();
            PINSTATE_ENABLED_VERIFIED = new PinState();
            PINSTATE_DISABLED = new PinState();
            PINSTATE_ENABLED_BLOCKED = new PinState();
            PINSTATE_ENABLED_PERM_BLOCKED = new PinState();
            PinState[] pinStateArray = new PinState[]{PINSTATE_UNKNOWN, PINSTATE_ENABLED_NOT_VERIFIED, PINSTATE_ENABLED_VERIFIED, PINSTATE_DISABLED, PINSTATE_ENABLED_BLOCKED, PINSTATE_ENABLED_PERM_BLOCKED};
            $VALUES = pinStateArray;
        }

        public static PinState valueOf(String string2) {
            return Enum.valueOf(PinState.class, string2);
        }

        public static PinState[] values() {
            return (PinState[])$VALUES.clone();
        }
    }
}

