/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccFileNotFound;
import com.android.internal.telephony.IccFileTypeMismatch;
import com.android.internal.telephony.IccUtils;

public class IccIoResult {
    public byte[] payload;
    int sw1;
    int sw2;

    public IccIoResult(int n, int n2, String string2) {
        this(n, n2, IccUtils.hexStringToBytes(string2));
    }

    public IccIoResult(int n, int n2, byte[] byArray) {
        this.sw1 = n;
        this.sw2 = n2;
        this.payload = byArray;
    }

    public IccException getException() {
        if (this.success()) {
            return null;
        }
        switch (this.sw1) {
            default: {
                return new IccException("sw1:" + this.sw1 + " sw2:" + this.sw2);
            }
            case 148: 
        }
        if (this.sw2 == 8) {
            return new IccFileTypeMismatch();
        }
        return new IccFileNotFound();
    }

    public boolean success() {
        return this.sw1 == 144 || this.sw1 == 145 || this.sw1 == 158 || this.sw1 == 159;
    }

    public String toString() {
        return "IccIoResponse sw1:0x" + Integer.toHexString(this.sw1) + " sw2:0x" + Integer.toHexString(this.sw2);
    }
}

