/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ServiceManager;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.PhoneBase;
import java.util.List;

public abstract class IccPhoneBookInterfaceManager
extends IIccPhoneBook.Stub {
    protected static final boolean ALLOW_SIM_OP_IN_UI_THREAD = false;
    protected static final boolean DBG = true;
    protected static final int EVENT_GET_SIZE_DONE = 1;
    protected static final int EVENT_LOAD_DONE = 2;
    protected static final int EVENT_UPDATE_DONE = 3;
    protected AdnRecordCache adnCache;
    protected Handler mBaseHandler;
    protected final Object mLock = new Object();
    protected PhoneBase phone;
    protected int[] recordSize;
    protected List<AdnRecord> records;
    protected boolean success;

    public IccPhoneBookInterfaceManager(PhoneBase phoneBase) {
        this.mBaseHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = IccPhoneBookInterfaceManager.this.mLock;
                        synchronized (object) {
                            if (asyncResult.exception == null) {
                                IccPhoneBookInterfaceManager.this.recordSize = (int[])asyncResult.result;
                                IccPhoneBookInterfaceManager.this.logd("GET_RECORD_SIZE Size " + IccPhoneBookInterfaceManager.this.recordSize[0] + " total " + IccPhoneBookInterfaceManager.this.recordSize[1] + " #record " + IccPhoneBookInterfaceManager.this.recordSize[2]);
                                IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                            }
                            return;
                        }
                    }
                    case 3: {
                        AsyncResult asyncResult = (AsyncResult)message.obj;
                        Object object = IccPhoneBookInterfaceManager.this.mLock;
                        synchronized (object) {
                            IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager = IccPhoneBookInterfaceManager.this;
                            boolean bl = asyncResult.exception == null;
                            iccPhoneBookInterfaceManager.success = bl;
                            IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                            return;
                        }
                    }
                    case 2: 
                }
                AsyncResult asyncResult = (AsyncResult)message.obj;
                Object object = IccPhoneBookInterfaceManager.this.mLock;
                synchronized (object) {
                    if (asyncResult.exception == null) {
                        IccPhoneBookInterfaceManager.this.records = (List)asyncResult.result;
                    } else {
                        IccPhoneBookInterfaceManager.this.logd("Cannot load ADN records");
                        if (IccPhoneBookInterfaceManager.this.records != null) {
                            IccPhoneBookInterfaceManager.this.records.clear();
                        }
                    }
                    IccPhoneBookInterfaceManager.this.mLock.notifyAll();
                    return;
                }
            }
        };
        this.phone = phoneBase;
    }

    private int updateEfForIccType(int n) {
        if (n == 28474 && this.phone.getIccCard().isApplicationOnIcc(IccCardApplication.AppType.APPTYPE_USIM)) {
            return 20272;
        }
        return n;
    }

    protected void checkThread() {
        if (this.mBaseHandler.getLooper().equals(Looper.myLooper())) {
            this.loge("query() called on the main UI thread!");
            throw new IllegalStateException("You cannot call query on this provder from the main UI thread.");
        }
    }

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AdnRecord> getAdnRecordsInEf(int n) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.READ_CONTACTS permission");
        }
        int n2 = this.updateEfForIccType(n);
        this.logd("getAdnRecordsInEF: efid=" + n2);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            Message message = this.mBaseHandler.obtainMessage(2);
            this.adnCache.requestLoadAllAdnLike(n2, this.adnCache.extensionEfForEf(n2), message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to load from the SIM");
            }
            return this.records;
        }
    }

    @Override
    public abstract int[] getAdnRecordsSize(int var1);

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    protected void publish() {
        ServiceManager.addService("simphonebook", this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateAdnRecordsInEfByIndex(int n, String string2, String string3, int n2, String string4) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfByIndex: efid=" + n + " Index=" + n2 + " ==> " + "(" + string2 + "," + string3 + ")" + " pin2=" + string4);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.success = false;
            Message message = this.mBaseHandler.obtainMessage(3);
            AdnRecord adnRecord = new AdnRecord(string2, string3);
            this.adnCache.updateAdnByIndex(n, adnRecord, n2, string4, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to update by index");
            }
            return this.success;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateAdnRecordsInEfBySearch(int n, String string2, String string3, String string4, String string5, String string6) {
        if (this.phone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfBySearch: efid=" + n + " (" + string2 + "," + string3 + ")" + "==>" + " (" + string4 + "," + string5 + ")" + " pin2=" + string6);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.success = false;
            Message message = this.mBaseHandler.obtainMessage(3);
            AdnRecord adnRecord = new AdnRecord(string2, string3);
            AdnRecord adnRecord2 = new AdnRecord(string4, string5);
            this.adnCache.updateAdnBySearch(n, adnRecord, adnRecord2, string6, message);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.logd("interrupted while trying to update by search");
            }
            return this.success;
        }
    }
}

