/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.ArrayListCursor;
import com.android.internal.telephony.IIccPhoneBook;
import java.util.ArrayList;
import java.util.List;

public class IccProvider
extends ContentProvider {
    private static final String[] ADDRESS_BOOK_COLUMN_NAMES = new String[]{"name", "number", "emails"};
    private static final int ADN = 1;
    private static final boolean DBG = false;
    private static final int FDN = 2;
    private static final int SDN = 3;
    private static final String STR_EMAILS = "emails";
    private static final String STR_NUMBER = "number";
    private static final String STR_PIN2 = "pin2";
    private static final String STR_TAG = "tag";
    private static final String TAG = "IccProvider";
    private static final UriMatcher URL_MATCHER = new UriMatcher(-1);
    private boolean mSimulator;

    static {
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "fdn", 2);
        URL_MATCHER.addURI("icc", "sdn", 3);
    }

    private boolean addIccRecordToEf(int n, String string2, String string3, String[] stringArray, String string4) {
        boolean bl;
        block4: {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            bl = false;
            if (iIccPhoneBook == null) break block4;
            try {
                boolean bl2;
                bl = bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n, "", "", string2, string3, string4);
            }
            catch (SecurityException securityException) {
                return false;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return bl;
    }

    private boolean deleteIccRecordFromEf(int n, String string2, String string3, String[] stringArray, String string4) {
        boolean bl;
        block4: {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            bl = false;
            if (iIccPhoneBook == null) break block4;
            try {
                boolean bl2;
                bl = bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n, string2, string3, "", "", string4);
            }
            catch (SecurityException securityException) {
                return false;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<ArrayList> loadFromEf(int n) {
        List<AdnRecord> list;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        try {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            list = null;
            if (iIccPhoneBook != null) {
                List<AdnRecord> list2;
                list = list2 = iIccPhoneBook.getAdnRecordsInEf(n);
            }
        }
        catch (SecurityException securityException) {
            list = null;
        }
        catch (RemoteException remoteException) {
            list = null;
        }
        if (list != null) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                this.loadRecord(list.get(i), arrayList);
            }
            return arrayList;
        } else {
            Log.w(TAG, "Cannot load ADN records");
            arrayList.clear();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadRecord(AdnRecord adnRecord, ArrayList<ArrayList> arrayList) {
        if (!adnRecord.isEmpty()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = adnRecord.getAlphaTag();
            String string3 = adnRecord.getNumber();
            String[] stringArray = adnRecord.getEmails();
            arrayList2.add(string2);
            arrayList2.add(string3);
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(",");
                }
                arrayList2.add(stringBuilder.toString());
            } else {
                arrayList2.add(null);
            }
            arrayList.add(arrayList2);
        }
    }

    private void log(String string2) {
        Log.d(TAG, "[IccProvider] " + string2);
    }

    private String normalizeValue(String string2) {
        int n = string2.length();
        String string3 = string2;
        if (string2.charAt(0) == '\'' && string2.charAt(n - 1) == '\'') {
            string3 = string2.substring(1, n - 1);
        }
        return string3;
    }

    private boolean updateIccRecordInEf(int n, String string2, String string3, String string4, String string5, String string6) {
        boolean bl;
        block4: {
            IIccPhoneBook iIccPhoneBook = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            bl = false;
            if (iIccPhoneBook == null) break block4;
            try {
                boolean bl2;
                bl = bl2 = iIccPhoneBook.updateAdnRecordsInEfBySearch(n, string2, string3, string4, string5, string6);
            }
            catch (SecurityException securityException) {
                return false;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        int n;
        switch (URL_MATCHER.match(uri)) {
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + uri);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
            }
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = string2.split("AND");
        int n2 = stringArray2.length;
        while (--n2 >= 0) {
            String string6 = stringArray2[n2];
            String[] stringArray3 = string6.split("=");
            if (stringArray3.length != 2) {
                Log.e(TAG, "resolve: bad whereClause parameter: " + string6);
                continue;
            }
            String string7 = stringArray3[0].trim();
            String string8 = stringArray3[1].trim();
            if (STR_TAG.equals(string7)) {
                string3 = this.normalizeValue(string8);
                continue;
            }
            if (STR_NUMBER.equals(string7)) {
                string4 = this.normalizeValue(string8);
                continue;
            }
            if (STR_EMAILS.equals(string7) || !STR_PIN2.equals(string7)) continue;
            string5 = this.normalizeValue(string8);
        }
        if (TextUtils.isEmpty(string4)) {
            return 0;
        }
        if (n == 28475 && TextUtils.isEmpty(string5)) {
            return 0;
        }
        if (!this.deleteIccRecordFromEf(n, string3, string4, null, string5)) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getType(Uri uri) {
        switch (URL_MATCHER.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unknown URL " + uri);
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return "vnd.android.cursor.dir/sim-contact";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        int n;
        String string2 = null;
        int n2 = URL_MATCHER.match(uri);
        switch (n2) {
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + uri);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
                string2 = contentValues.getAsString(STR_PIN2);
            }
        }
        if (!this.addIccRecordToEf(n, contentValues.getAsString(STR_TAG), contentValues.getAsString(STR_NUMBER), null, string2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("content://icc/");
        switch (n2) {
            case 1: {
                stringBuilder.append("adn/");
            }
            default: {
                break;
            }
            case 2: {
                stringBuilder.append("fdn/");
            }
        }
        stringBuilder.append(0);
        return Uri.parse(stringBuilder.toString());
    }

    @Override
    public boolean onCreate() {
        if (!TextUtils.isEmpty(SystemProperties.get("ro.product.device"))) {
            this.mSimulator = false;
            return true;
        }
        this.mSimulator = true;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        ArrayList<ArrayList> arrayList;
        if (!this.mSimulator) {
            switch (URL_MATCHER.match(uri)) {
                default: {
                    throw new IllegalArgumentException("Unknown URL " + uri);
                }
                case 1: {
                    arrayList = this.loadFromEf(28474);
                    return new ArrayListCursor(ADDRESS_BOOK_COLUMN_NAMES, arrayList);
                }
                case 2: {
                    arrayList = this.loadFromEf(28475);
                    return new ArrayListCursor(ADDRESS_BOOK_COLUMN_NAMES, arrayList);
                }
                case 3: 
            }
            arrayList = this.loadFromEf(28489);
            return new ArrayListCursor(ADDRESS_BOOK_COLUMN_NAMES, arrayList);
        }
        arrayList = new ArrayList(4);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Ron Stevens/H");
        arrayList2.add("512-555-5038");
        arrayList.add(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("Ron Stevens/M");
        arrayList3.add("512-555-8305");
        arrayList.add(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("Melissa Owens");
        arrayList4.add("512-555-8305");
        arrayList.add(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("Directory Assistence");
        arrayList5.add("411");
        arrayList.add(arrayList5);
        return new ArrayListCursor(ADDRESS_BOOK_COLUMN_NAMES, arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n;
        String string3 = null;
        switch (URL_MATCHER.match(uri)) {
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + uri);
            }
            case 1: {
                n = 28474;
                break;
            }
            case 2: {
                n = 28475;
                string3 = contentValues.getAsString(STR_PIN2);
            }
        }
        if (!this.updateIccRecordInEf(n, contentValues.getAsString(STR_TAG), contentValues.getAsString(STR_NUMBER), contentValues.getAsString("newTag"), contentValues.getAsString("newNumber"), string3)) {
            return 0;
        }
        return 1;
    }
}

