/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected static final int EVENT_SET_MSISDN_DONE = 30;
    protected static final int SPN_RULE_SHOW_PLMN = 2;
    protected static final int SPN_RULE_SHOW_SPN = 1;
    protected static final int UNINITIALIZED = -1;
    protected static final int UNKNOWN;
    protected AdnRecordCache adnCache;
    protected int countVoiceMessages = 0;
    public String iccid;
    protected boolean isVoiceMailFixed = false;
    protected int mailboxIndex = 0;
    protected int mncLength = -1;
    protected String msisdn = null;
    protected String msisdnTag = null;
    protected String newVoiceMailNum = null;
    protected String newVoiceMailTag = null;
    protected PhoneBase phone;
    protected RegistrantList recordsLoadedRegistrants = new RegistrantList();
    protected boolean recordsRequested = false;
    protected int recordsToLoad;
    protected String spn;
    protected int spnDisplayCondition;
    protected String voiceMailNum = null;
    protected String voiceMailTag = null;

    public IccRecords(PhoneBase phoneBase) {
        this.phone = phoneBase;
    }

    public AdnRecordCache getAdnCache() {
        return this.adnCache;
    }

    protected abstract int getDisplayRule(String var1);

    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    public String getMsisdnNumber() {
        return this.msisdn;
    }

    public boolean getRecordsLoaded() {
        return this.recordsToLoad == 0 && this.recordsRequested;
    }

    public String getServiceProviderName() {
        return this.spn;
    }

    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    public int getVoiceMessageCount() {
        return this.countVoiceMessages;
    }

    public boolean getVoiceMessageWaiting() {
        return this.countVoiceMessages != 0;
    }

    @Override
    public abstract void handleMessage(Message var1);

    protected abstract void log(String var1);

    protected abstract void onAllRecordsLoaded();

    protected abstract void onRadioOffOrNotAvailable();

    protected abstract void onRecordLoaded();

    public abstract void onRefresh(boolean var1, int[] var2);

    public void registerForRecordsLoaded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.recordsLoadedRegistrants.add(registrant);
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            registrant.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void setMsisdnNumber(String string2, String string3, Message message) {
        this.msisdn = string3;
        this.msisdnTag = string2;
        this.log("Set MSISDN: " + this.msisdnTag + " " + this.msisdn);
        AdnRecord adnRecord = new AdnRecord(this.msisdnTag, this.msisdn);
        new AdnRecordLoader(this.phone).updateEF(adnRecord, 28480, 28490, 1, null, this.obtainMessage(30, message));
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public void unregisterForRecordsLoaded(Handler handler) {
        this.recordsLoadedRegistrants.remove(handler);
    }
}

