/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.util.Log;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.List;

public abstract class IccSmsInterfaceManager
extends ISms.Stub {
    protected Context mContext;
    protected SMSDispatcher mDispatcher;
    protected PhoneBase mPhone;

    protected IccSmsInterfaceManager(PhoneBase phoneBase) {
        this.mPhone = phoneBase;
        this.mContext = phoneBase.getContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> arrayList) {
        int n = arrayList.size();
        ArrayList<SmsRawData> arrayList2 = new ArrayList<SmsRawData>(n);
        int n2 = 0;
        while (n2 < n) {
            if (arrayList.get(n2)[0] == 0) {
                arrayList2.add(null);
            } else {
                arrayList2.add(new SmsRawData(arrayList.get(n2)));
            }
            ++n2;
        }
        return arrayList2;
    }

    protected void enforceReceiveAndSend(String string2) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", string2);
        this.mContext.enforceCallingPermission("android.permission.SEND_SMS", string2);
    }

    protected abstract void log(String var1);

    protected byte[] makeSmsRecordData(int n, byte[] byArray) {
        byte[] byArray2 = new byte[176];
        byArray2[0] = (byte)(n & 7);
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        for (int i = 1 + byArray.length; i < 176; ++i) {
            byArray2[i] = -1;
        }
        return byArray2;
    }

    @Override
    public void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            this.log("sendData: destAddr=" + string2 + " scAddr=" + string3 + " destPort=" + n + " data='" + HexDump.toHexString(byArray) + "' sentIntent=" + pendingIntent + " deliveryIntent=" + pendingIntent2);
        }
        this.mDispatcher.sendData(string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    @Override
    public void sendMultipartText(String string2, String string3, List<String> list, List<PendingIntent> list2, List<PendingIntent> list3) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            int n = 0;
            for (String string4 : list) {
                StringBuilder stringBuilder = new StringBuilder().append("sendMultipartText: destAddr=").append(string2).append(", srAddr=").append(string3).append(", part[");
                int n2 = n + 1;
                this.log(stringBuilder.append(n).append("]=").append(string4).toString());
                n = n2;
            }
        }
        this.mDispatcher.sendMultipartText(string2, string3, (ArrayList)list, (ArrayList)list2, (ArrayList)list3);
    }

    @Override
    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        this.mPhone.getContext().enforceCallingPermission("android.permission.SEND_SMS", "Sending SMS message");
        if (Log.isLoggable("SMS", 2)) {
            this.log("sendText: destAddr=" + string2 + " scAddr=" + string3 + " text='" + string4 + "' sentIntent=" + pendingIntent + " deliveryIntent=" + pendingIntent2);
        }
        this.mDispatcher.sendText(string2, string3, string4, pendingIntent, pendingIntent2);
    }
}

