/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.graphics.Bitmap;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;

public class IccUtils {
    static final String LOG_TAG = "IccUtils";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String adnStringFieldToString(byte[] byArray, int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        if (n2 >= 1 && byArray[n] == -128) {
            String string2;
            int n5 = (n2 - 1) / 2;
            try {
                string2 = new String(byArray, n + 1, n5 * 2, "utf-16be");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e(LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
                string2 = null;
            }
            if (string2 != null) {
                int n6;
                for (n6 = string2.length(); n6 > 0 && string2.charAt(n6 - 1) == '\uffff'; --n6) {
                }
                return string2.substring(0, n6);
            }
        }
        if (n2 >= 3 && byArray[n] == -127) {
            int n7 = 0xFF & byArray[n + 1];
            n4 = n7 > n2 - 3 ? n2 - 3 : n7;
            n3 = (char)((0xFF & byArray[n + 2]) << 7);
            n += 3;
            bl = true;
        } else {
            n3 = 0;
            bl = false;
            n4 = 0;
            if (n2 >= 4) {
                byte by = byArray[n];
                n3 = 0;
                bl = false;
                n4 = 0;
                if (by == -126) {
                    int n8 = 0xFF & byArray[n + 1];
                    n4 = n8 > n2 - 4 ? n2 - 4 : n8;
                    n3 = (char)((0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3]);
                    n += 4;
                    bl = true;
                }
            }
        }
        if (!bl) {
            return GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n9 = n4;
        while (n9 > 0) {
            int n10;
            int n11;
            if (byArray[n] < 0) {
                stringBuilder.append((char)(n3 + (0x7F & byArray[n])));
                ++n;
                n11 = n9 - 1;
            } else {
                n11 = n9;
            }
            for (n10 = 0; n10 < n11 && byArray[n + n10] >= 0; ++n10) {
            }
            stringBuilder.append(GsmAlphabet.gsm8BitUnpackedToString(byArray, n, n10));
            n += n10;
            n9 = n11 - n10;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String bcdToString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        int n3 = n;
        while (true) {
            int n4;
            block4: {
                block3: {
                    int n5;
                    if (n3 >= n + n2 || (n5 = 0xF & byArray[n3]) > 9) break block3;
                    stringBuilder.append((char)(n5 + 48));
                    n4 = 0xF & byArray[n3] >> 4;
                    if (n4 <= 9) break block4;
                }
                return stringBuilder.toString();
            }
            stringBuilder.append((char)(n4 + 48));
            ++n3;
        }
    }

    private static int bitToRGB(int n) {
        if (n == 1) {
            return -1;
        }
        return -16777216;
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append("0123456789abcdef".charAt(0xF & byArray[i] >> 4));
            stringBuilder.append("0123456789abcdef".charAt(0xF & byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static int cdmaBcdByteToInt(byte by) {
        int n = by & 0xF0;
        int n2 = 0;
        if (n <= 144) {
            n2 = 10 * (0xF & by >> 4);
        }
        if ((by & 0xF) <= 9) {
            n2 += by & 0xF;
        }
        return n2;
    }

    private static int[] getCLUT(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[n2];
        int n3 = n + n2 * 3;
        int n4 = n;
        int n5 = 0;
        while (true) {
            int n6 = n5 + 1;
            int n7 = n4 + 1;
            int n8 = 0xFF000000 | (0xFF & byArray[n4]) << 16;
            int n9 = n7 + 1;
            int n10 = n8 | (0xFF & byArray[n7]) << 8;
            int n11 = n9 + 1;
            nArray[n5] = n10 | 0xFF & byArray[n9];
            if (n11 >= n3) {
                return nArray;
            }
            n5 = n6;
            n4 = n11;
        }
    }

    public static int gsmBcdByteToInt(byte by) {
        int n = by & 0xF0;
        int n2 = 0;
        if (n <= 144) {
            n2 = 0xF & by >> 4;
        }
        if ((by & 0xF) <= 9) {
            n2 += 10 * (by & 0xF);
        }
        return n2;
    }

    static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        throw new RuntimeException("invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToBytes(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)(IccUtils.hexCharToInt(string2.charAt(i)) << 4 | IccUtils.hexCharToInt(string2.charAt(i + 1)));
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] mapTo2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        if (8 % n3 != 0) {
            Log.e(LOG_TAG, "not event number of color");
            return IccUtils.mapToNon2OrderBitColor(byArray, n, n2, nArray, n3);
        }
        int n4 = 1;
        switch (n3) {
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 3;
                break;
            }
            case 4: {
                n4 = 15;
                break;
            }
            case 8: {
                n4 = 255;
            }
        }
        int[] nArray2 = new int[n2];
        int n5 = 0;
        int n6 = 8 / n3;
        int n7 = n;
        while (n5 < n2) {
            int n8 = n7 + 1;
            byte by = byArray[n7];
            int n9 = n5;
            for (int i = 0; i < n6; ++i) {
                int n10 = n6 - i - 1;
                int n11 = n9 + 1;
                nArray2[n9] = nArray[n4 & by >> n10 * n3];
                n9 = n11;
            }
            n5 = n9;
            n7 = n8;
        }
        return nArray2;
    }

    private static int[] mapToNon2OrderBitColor(byte[] byArray, int n, int n2, int[] nArray, int n3) {
        if (8 % n3 == 0) {
            Log.e(LOG_TAG, "not odd number of color");
            return IccUtils.mapTo2OrderBitColor(byArray, n, n2, nArray, n3);
        }
        return new int[n2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String networkNameToString(byte[] byArray, int n, int n2) {
        String string2;
        if ((0x80 & byArray[n]) != 128 || n2 < 1) {
            return "";
        }
        switch (7 & byArray[n] >>> 4) {
            default: {
                string2 = "";
                break;
            }
            case 0: {
                int n3 = 7 & byArray[n];
                int n4 = (8 * (n2 - 1) - n3) / 7;
                string2 = GsmAlphabet.gsm7BitPackedToString(byArray, n + 1, n4);
                break;
            }
            case 1: {
                try {
                    string2 = new String(byArray, n + 1, n2 - 1, "utf-16");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = "";
                    Log.e(LOG_TAG, "implausible UnsupportedEncodingException", unsupportedEncodingException);
                }
            }
        }
        if ((0x40 & byArray[n]) != 0) {
            // empty if block
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap parseToBnW(byte[] byArray, int n) {
        int n2 = 0 + 1;
        int n3 = 0xFF & byArray[0];
        int n4 = n2 + 1;
        int n5 = 0xFF & byArray[n2];
        int n6 = n3 * n5;
        int[] nArray = new int[n6];
        int n7 = 7;
        byte by = 0;
        int n8 = 0;
        int n9 = n4;
        while (n8 < n6) {
            int n10;
            if (n8 % 8 == 0) {
                n10 = n9 + 1;
                by = byArray[n9];
                n7 = 7;
            } else {
                n10 = n9;
            }
            int n11 = n8 + 1;
            int n12 = n7 - 1;
            nArray[n8] = IccUtils.bitToRGB(1 & by >> n7);
            n7 = n12;
            n8 = n11;
            n9 = n10;
        }
        if (n8 != n6) {
            Log.e(LOG_TAG, "parse end and size error");
        }
        return Bitmap.createBitmap(nArray, n3, n5, Bitmap.Config.ARGB_8888);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap parseToRGB(byte[] byArray, int n, boolean bl) {
        int[] nArray;
        int n2 = 0 + 1;
        int n3 = 0xFF & byArray[0];
        int n4 = n2 + 1;
        int n5 = 0xFF & byArray[n2];
        int n6 = n4 + 1;
        int n7 = 0xFF & byArray[n4];
        int n8 = n6 + 1;
        int n9 = 0xFF & byArray[n6];
        int n10 = n8 + 1;
        int n11 = (0xFF & byArray[n8]) << 8;
        int n12 = n10 + 1;
        int n13 = n11 | 0xFF & byArray[n10];
        int cfr_ignored_0 = n - 6;
        int[] nArray2 = IccUtils.getCLUT(byArray, n13, n9);
        if (bl) {
            nArray2[n9 - 1] = 0;
        }
        if (8 % n7 == 0) {
            nArray = IccUtils.mapTo2OrderBitColor(byArray, n12, n3 * n5, nArray2, n7);
            return Bitmap.createBitmap(nArray, n3, n5, Bitmap.Config.RGB_565);
        }
        nArray = IccUtils.mapToNon2OrderBitColor(byArray, n12, n3 * n5, nArray2, n7);
        return Bitmap.createBitmap(nArray, n3, n5, Bitmap.Config.RGB_565);
    }
}

