/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.Locale;

public abstract class PhoneBase
extends Handler
implements Phone {
    public static final String CLIR_KEY = "clir_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    protected static final int EVENT_CALL_RING = 14;
    protected static final int EVENT_CALL_RING_CONTINUE = 15;
    protected static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static final int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static final int EVENT_GET_IMEISV_DONE = 10;
    protected static final int EVENT_GET_IMEI_DONE = 9;
    protected static final int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static final int EVENT_MMI_DONE = 4;
    protected static final int EVENT_NV_READY = 23;
    protected static final int EVENT_RADIO_AVAILABLE = 1;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static final int EVENT_RADIO_ON = 5;
    protected static final int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static final int EVENT_SET_CLIR_COMPLETE = 18;
    protected static final int EVENT_SET_ENHANCED_VP = 24;
    protected static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    protected static final int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static final int EVENT_SIM_RECORDS_LOADED = 3;
    protected static final int EVENT_SSN = 2;
    protected static final int EVENT_USSD = 7;
    private static final boolean LOCAL_DEBUG = true;
    private static final String LOG_TAG = "PHONE";
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public CommandsInterface mCM;
    int mCallRingContinueToken = 0;
    int mCallRingDelay;
    protected Context mContext;
    public DataConnectionTracker mDataConnection;
    protected final RegistrantList mDisconnectRegistrants;
    boolean mDnsCheckDisabled = false;
    boolean mDoesRilSendMultipleCallRing;
    protected IccFileHandler mIccFileHandler;
    protected final RegistrantList mIncomingRingRegistrants;
    public boolean mIsTheCurrentActivePhone = true;
    protected Looper mLooper;
    protected final RegistrantList mMmiCompleteRegistrants;
    protected final RegistrantList mMmiRegistrants;
    protected final RegistrantList mNewRingingConnectionRegistrants;
    protected PhoneNotifier mNotifier;
    protected final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    protected final RegistrantList mServiceStateRegistrants;
    protected SimulatedRadioControl mSimulatedRadioControl;
    protected final RegistrantList mSuppServiceFailedRegistrants;
    boolean mUnitTestMode;
    protected final RegistrantList mUnknownConnectionRegistrants;

    protected PhoneBase(PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface) {
        this(phoneNotifier, context, commandsInterface, false);
    }

    protected PhoneBase(PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        this.mNewRingingConnectionRegistrants = new RegistrantList();
        this.mIncomingRingRegistrants = new RegistrantList();
        this.mDisconnectRegistrants = new RegistrantList();
        this.mServiceStateRegistrants = new RegistrantList();
        this.mMmiCompleteRegistrants = new RegistrantList();
        this.mMmiRegistrants = new RegistrantList();
        this.mUnknownConnectionRegistrants = new RegistrantList();
        this.mSuppServiceFailedRegistrants = new RegistrantList();
        this.mNotifier = phoneNotifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCM = commandsInterface;
        this.setPropertiesByCarrier();
        this.setUnitTestMode(bl);
        this.mDnsCheckDisabled = PreferenceManager.getDefaultSharedPreferences(context).getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
        this.mCM.setOnCallRing(this, 14, null);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Log.d(LOG_TAG, "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Log.d(LOG_TAG, "mCallRingDelay=" + this.mCallRingDelay);
    }

    private void checkCorrectThread(Handler handler) {
        if (handler.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    private String getSavedNetworkSelection() {
        return PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(NETWORK_SELECTION_KEY, "");
    }

    private void logUnexpectedCdmaMethodCall(String string2) {
        Log.e(LOG_TAG, "Error! " + string2 + "() in PhoneBase should not be " + "called, CDMAPhone inactive.");
    }

    private void notifyIncomingRing() {
        AsyncResult asyncResult = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(asyncResult);
    }

    private void sendIncomingCallRingNotification(int n) {
        if (!this.mDoesRilSendMultipleCallRing && n == this.mCallRingContinueToken) {
            Log.d(LOG_TAG, "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, n, 0), this.mCallRingDelay);
            return;
        }
        Log.d(LOG_TAG, "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + n + " mCallRingContinueToken=" + this.mCallRingContinueToken);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPropertiesByCarrier() {
        int n;
        block7: {
            String string2 = SystemProperties.get("ro.carrier");
            if (string2 != null && string2.length() != 0 && !"unknown".equals(string2)) {
                CharSequence[] charSequenceArray = this.mContext.getResources().getTextArray(17235997);
                for (int i = 0; i < charSequenceArray.length; i += 3) {
                    if (!string2.equals(((Object)charSequenceArray[i]).toString())) continue;
                    String string3 = ((Object)charSequenceArray[i + 1]).toString();
                    int n2 = i + 2;
                    try {
                        int n3;
                        n = n3 = Integer.parseInt(((Object)charSequenceArray[n2]).toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                    String string4 = string3.substring(0, 2);
                    String string5 = "";
                    if (string3.length() >= 5) {
                        string5 = string3.substring(3, 5);
                    }
                    this.setSystemLocale(string4, string5);
                    if (n != 0) break block7;
                }
            }
            return;
        }
        try {
            Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels");
            return;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            ((WifiManager)this.mContext.getSystemService("wifi")).setNumAllowedChannels(n, false);
            return;
        }
    }

    @Override
    public int disableApnType(String string2) {
        return this.mDataConnection.disableApnType(string2);
    }

    @Override
    public void disableDnsCheck(boolean bl) {
        this.mDnsCheckDisabled = bl;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, bl);
        editor.apply();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            this.mCM.unSetOnCallRing(this);
            this.mDataConnection.onCleanUpConnection(false, "radioTurnedOff");
            this.mIsTheCurrentActivePhone = false;
            return;
        }
    }

    @Override
    public int enableApnType(String string2) {
        return this.mDataConnection.enableApnType(string2);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        this.logUnexpectedCdmaMethodCall("enableEnhancedVoicePrivacy");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        this.logUnexpectedCdmaMethodCall("exitEmergencyCallbackMode");
    }

    @Override
    public String getActiveApn() {
        return this.mDataConnection.getActiveApnString();
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mDataConnection.getActiveApnTypes();
    }

    @Override
    public int getCdmaEriIconIndex() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriIconIndex");
        return -1;
    }

    @Override
    public int getCdmaEriIconMode() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriIconMode");
        return -1;
    }

    @Override
    public String getCdmaEriText() {
        this.logUnexpectedCdmaMethodCall("getCdmaEriText");
        return "GSM nw, no ERI";
    }

    @Override
    public String getCdmaMin() {
        this.logUnexpectedCdmaMethodCall("getCdmaMin");
        return null;
    }

    @Override
    public String getCdmaPrlVersion() {
        this.logUnexpectedCdmaMethodCall("getCdmaPrlVersion");
        return null;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public String[] getDnsServers(String string2) {
        return this.mDataConnection.getDnsServers(string2);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        this.logUnexpectedCdmaMethodCall("getEnhancedVoicePrivacy");
    }

    @Override
    public String getGateway(String string2) {
        return this.mDataConnection.getGateway(string2);
    }

    public Handler getHandler() {
        return this;
    }

    public abstract IccFileHandler getIccFileHandler();

    @Override
    public String getInterfaceName(String string2) {
        return this.mDataConnection.getInterfaceName(string2);
    }

    @Override
    public String getIpAddress(String string2) {
        return this.mDataConnection.getIpAddress(string2);
    }

    @Override
    public abstract String getPhoneName();

    @Override
    public abstract int getPhoneType();

    @Override
    public void getPreferredNetworkType(Message message) {
        this.mCM.getPreferredNetworkType(message);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    @Override
    public void getSmscAddress(Message message) {
        this.mCM.getSmscAddress(message);
    }

    @Override
    public abstract Phone.State getState();

    @Override
    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    @Override
    public int getVoiceMessageCount() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
            case 14: {
                Log.d(LOG_TAG, "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                if (((AsyncResult)message.obj).exception != null) return;
                Phone.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != Phone.State.RINGING && state != Phone.State.IDLE)) {
                    this.mCallRingContinueToken = 1 + this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    return;
                }
                this.notifyIncomingRing();
                return;
            }
            case 15: {
                Log.d(LOG_TAG, "Event EVENT_CALL_RING_CONTINUE Received stat=" + (Object)((Object)this.getState()));
                if (this.getState() != Phone.State.RINGING) return;
                this.sendIncomingCallRingNotification(message.arg1);
                return;
            }
        }
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        this.mCM.invokeOemRilRequestRaw(byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        this.mCM.invokeOemRilRequestStrings(stringArray, message);
    }

    @Override
    public boolean isDataConnectivityEnabled() {
        return this.mDataConnection.getDataEnabled();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @Override
    public boolean isMinInfoReady() {
        this.logUnexpectedCdmaMethodCall("isMinInfoReady");
        return false;
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        this.logUnexpectedCdmaMethodCall("isOtaSpNumber");
        return false;
    }

    @Override
    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    public void notifyDataConnection(String string2) {
        this.mNotifier.notifyDataConnection(this, string2);
    }

    protected void notifyDisconnectP(Connection connection) {
        AsyncResult asyncResult = new AsyncResult(null, connection, null);
        this.mDisconnectRegistrants.notifyRegistrants(asyncResult);
    }

    public void notifyMessageWaitingIndicator() {
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    protected void notifyNewRingingConnectionP(Connection connection) {
        AsyncResult asyncResult = new AsyncResult(null, connection, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(asyncResult);
    }

    protected void notifyPreciseCallStateChangedP() {
        AsyncResult asyncResult = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(asyncResult);
    }

    protected void notifyServiceStateChangedP(ServiceState serviceState) {
        AsyncResult asyncResult = new AsyncResult(null, serviceState, null);
        this.mServiceStateRegistrants.notifyRegistrants(asyncResult);
        this.mNotifier.notifyServiceState(this);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        this.mCM.queryAvailableBandMode(message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        this.mCM.queryCdmaRoamingPreference(message);
    }

    @Override
    public void queryTTYMode(Message message) {
        this.mCM.queryTTYMode(message);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        this.mCM.registerFoT53ClirlInfo(handler, n, object);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForCallWaiting");
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForCdmaOtaStatusChange");
    }

    @Override
    public void registerForDisconnect(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mDisconnectRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        this.mCM.registerForDisplayInfo(handler, n, object);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForEcmTimerReset");
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        this.mCM.registerForInCallVoicePrivacyOff(handler, n, object);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        this.mCM.registerForInCallVoicePrivacyOn(handler, n, object);
    }

    @Override
    public void registerForIncomingRing(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mIncomingRingRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        this.mCM.registerForLineControlInfo(handler, n, object);
    }

    @Override
    public void registerForMmiComplete(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mMmiCompleteRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mMmiRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mNewRingingConnectionRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForNumberInfo(Handler handler, int n, Object object) {
        this.mCM.registerForNumberInfo(handler, n, object);
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mPreciseCallStateRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        this.mCM.registerForRedirectedNumberInfo(handler, n, object);
    }

    @Override
    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        this.mCM.registerForResendIncallMute(handler, n, object);
    }

    @Override
    public void registerForRingbackTone(Handler handler, int n, Object object) {
        this.mCM.registerForRingbackTone(handler, n, object);
    }

    @Override
    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mServiceStateRegistrants.add(handler, n, object);
    }

    @Override
    public void registerForSignalInfo(Handler handler, int n, Object object) {
        this.mCM.registerForSignalInfo(handler, n, object);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("registerForSubscriptionInfoReady");
    }

    @Override
    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mSuppServiceFailedRegistrants.addUnique(handler, n, object);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        this.mCM.registerForT53AudioControlInfo(handler, n, object);
    }

    @Override
    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        this.checkCorrectThread(handler);
        this.mUnknownConnectionRegistrants.addUnique(handler, n, object);
    }

    public void restoreSavedNetworkSelection(Message message) {
        String string2 = this.getSavedNetworkSelection();
        if (TextUtils.isEmpty(string2)) {
            this.mCM.setNetworkSelectionModeAutomatic(message);
            return;
        }
        this.mCM.setNetworkSelectionModeManual(string2, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        this.logUnexpectedCdmaMethodCall("sendBurstDtmf");
    }

    @Override
    public void setBandMode(int n, Message message) {
        this.mCM.setBandMode(n, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        this.mCM.setCdmaRoamingPreference(n, message);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        this.mCM.setCdmaSubscription(n, message);
    }

    @Override
    public void setEchoSuppressionEnabled(boolean bl) {
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        this.logUnexpectedCdmaMethodCall("setOnEcbModeExitResponse");
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        this.mCM.setPreferredNetworkType(n, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        this.mCM.setSmscAddress(string2, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSystemLocale(String string2, String string3) {
        String string4 = SystemProperties.get("persist.sys.language");
        String string5 = SystemProperties.get("persist.sys.country");
        if (string2 == null) return;
        String string6 = string2.toLowerCase();
        if (string3 == null) {
            string3 = "";
        }
        String string7 = string3.toUpperCase();
        if (string4 != null && string4.length() != 0 || string5 != null && string5.length() != 0) return;
        try {
            String[] stringArray = this.mContext.getAssets().getLocales();
            int n = stringArray.length;
            String string8 = null;
            int n2 = 0;
            while (true) {
                block8: {
                    block9: {
                        block7: {
                            if (n2 >= n) break block7;
                            if (stringArray[n2] == null || stringArray[n2].length() < 5 || !stringArray[n2].substring(0, 2).equals(string6)) break block8;
                            if (!stringArray[n2].substring(3, 5).equals(string7)) break block9;
                            string8 = stringArray[n2];
                        }
                        if (string8 == null) return;
                        IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                        Configuration configuration = iActivityManager.getConfiguration();
                        configuration.locale = new Locale(string8.substring(0, 2), string8.substring(3, 5));
                        configuration.userSetLocale = true;
                        iActivityManager.updateConfiguration(configuration);
                        return;
                    }
                    if (string8 == null) {
                        string8 = stringArray[n2];
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setSystemProperty(String string2, String string3) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(string2, string3);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        this.mCM.setTTYMode(n, message);
    }

    @Override
    public void setUnitTestMode(boolean bl) {
        this.mUnitTestMode = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void simulateDataConnection(Phone.DataState dataState) {
        DataConnectionTracker.State state;
        switch (1.$SwitchMap$com$android$internal$telephony$Phone$DataState[dataState.ordinal()]) {
            default: {
                state = DataConnectionTracker.State.CONNECTING;
                break;
            }
            case 1: {
                state = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case 2: {
                state = DataConnectionTracker.State.CONNECTED;
                break;
            }
            case 3: {
                state = DataConnectionTracker.State.FAILED;
            }
        }
        this.mDataConnection.setState(state);
        this.notifyDataConnection(null);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForCallWaiting");
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForCdmaOtaStatusChange");
    }

    @Override
    public void unregisterForDisconnect(Handler handler) {
        this.mDisconnectRegistrants.remove(handler);
    }

    @Override
    public void unregisterForDisplayInfo(Handler handler) {
        this.mCM.unregisterForDisplayInfo(handler);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForEcmTimerReset");
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        this.mCM.unregisterForInCallVoicePrivacyOff(handler);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        this.mCM.unregisterForInCallVoicePrivacyOn(handler);
    }

    @Override
    public void unregisterForIncomingRing(Handler handler) {
        this.mIncomingRingRegistrants.remove(handler);
    }

    @Override
    public void unregisterForLineControlInfo(Handler handler) {
        this.mCM.unregisterForLineControlInfo(handler);
    }

    @Override
    public void unregisterForMmiComplete(Handler handler) {
        this.checkCorrectThread(handler);
        this.mMmiCompleteRegistrants.remove(handler);
    }

    @Override
    public void unregisterForMmiInitiate(Handler handler) {
        this.mMmiRegistrants.remove(handler);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler handler) {
        this.mNewRingingConnectionRegistrants.remove(handler);
    }

    @Override
    public void unregisterForNumberInfo(Handler handler) {
        this.mCM.unregisterForNumberInfo(handler);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler handler) {
        this.mPreciseCallStateRegistrants.remove(handler);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler handler) {
        this.mCM.unregisterForRedirectedNumberInfo(handler);
    }

    @Override
    public void unregisterForResendIncallMute(Handler handler) {
        this.mCM.unregisterForResendIncallMute(handler);
    }

    @Override
    public void unregisterForRingbackTone(Handler handler) {
        this.mCM.unregisterForRingbackTone(handler);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler handler) {
        this.mServiceStateRegistrants.remove(handler);
    }

    @Override
    public void unregisterForSignalInfo(Handler handler) {
        this.mCM.unregisterForSignalInfo(handler);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unregisterForSubscriptionInfoReady");
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler handler) {
        this.mSuppServiceFailedRegistrants.remove(handler);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler handler) {
        this.mCM.unregisterForT53AudioControlInfo(handler);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler handler) {
        this.mCM.unregisterForT53ClirInfo(handler);
    }

    @Override
    public void unregisterForUnknownConnection(Handler handler) {
        this.mUnknownConnectionRegistrants.remove(handler);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        this.logUnexpectedCdmaMethodCall("unsetOnEcbModeExitResponse");
    }
}

