/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.net.LocalServerSocket;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import java.io.IOException;

public class PhoneFactory {
    static final String LOG_TAG = "PHONE";
    static final int SOCKET_OPEN_MAX_RETRY = 3;
    static final int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static final int preferredCdmaSubscription = 1;
    static final int preferredNetworkMode;
    private static CommandsInterface sCommandsInterface;
    private static Context sContext;
    private static Looper sLooper;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Phone sProxyPhone;

    static {
        sProxyPhone = null;
        sCommandsInterface = null;
        sMadeDefaults = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Phone getCdmaPhone() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            return new CDMAPhone(sContext, sCommandsInterface, sPhoneNotifier);
        }
    }

    public static Phone getDefaultPhone() {
        if (sLooper != Looper.myLooper()) {
            throw new RuntimeException("PhoneFactory.getDefaultPhone must be called from Looper thread");
        }
        if (!sMadeDefaults) {
            throw new IllegalStateException("Default phones haven't been made yet!");
        }
        return sProxyPhone;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Phone getGsmPhone() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            return new GSMPhone(sContext, sCommandsInterface, sPhoneNotifier);
        }
    }

    public static int getPhoneType(int n) {
        switch (n) {
            default: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 7: 
        }
        return 2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void makeDefaultPhone(Context var0) {
        synchronized (Phone.class) {
            if (PhoneFactory.sMadeDefaults) ** GOTO lbl37
            PhoneFactory.sLooper = Looper.myLooper();
            PhoneFactory.sContext = var0;
            if (PhoneFactory.sLooper == null) {
                throw new RuntimeException("PhoneFactory.makeDefaultPhone must be called from Looper thread");
            }
            var2_1 = 0;
            while (true) {
                block16: {
                    var3_2 = false;
                    ++var2_1;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException var13_4) {
                        var3_2 = true;
                    }
                    if (var3_2) break block16;
                    PhoneFactory.sPhoneNotifier = new DefaultPhoneNotifier();
                    var6_5 = Settings.Secure.getInt(var0.getContentResolver(), "preferred_network_mode", 0);
                    Log.i("PHONE", "Network Mode set to " + Integer.toString(var6_5));
                    var8_6 = Settings.Secure.getInt(var0.getContentResolver(), "preferred_cdma_subscription", 1);
                    Log.i("PHONE", "Cdma Subscription set to " + Integer.toString(var8_6));
                    PhoneFactory.sCommandsInterface = new RIL(var0, var6_5, var8_6);
                    var10_7 = PhoneFactory.getPhoneType(var6_5);
                    if (var10_7 == 1) {
                        Log.i("PHONE", "Creating GSMPhone");
                        PhoneFactory.sProxyPhone = new PhoneProxy(new GSMPhone(var0, PhoneFactory.sCommandsInterface, PhoneFactory.sPhoneNotifier));
                    } else if (var10_7 == 2) {
                        Log.i("PHONE", "Creating CDMAPhone");
                        PhoneFactory.sProxyPhone = new PhoneProxy(new CDMAPhone(var0, PhoneFactory.sCommandsInterface, PhoneFactory.sPhoneNotifier));
                    }
                    PhoneFactory.sMadeDefaults = true;
lbl37:
                    // 2 sources

                    return;
                }
                if (var2_1 > 3) {
                    throw new RuntimeException("PhoneFactory probably already running");
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException var5_3) {
                }
            }
        }
    }

    public static void makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    public static SipPhone makeSipPhone(String string2) {
        return SipPhoneFactory.makePhone(string2, sContext, sPhoneNotifier);
    }
}

