/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Phone;

@Deprecated
public final class PhoneStateIntentReceiver
extends BroadcastReceiver {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "PHONE";
    private static final int NOTIF_MAX = 32;
    private static final int NOTIF_PHONE = 1;
    private static final int NOTIF_SERVICE = 2;
    private static final int NOTIF_SIGNAL = 4;
    private int mAsuEventWhat;
    private Context mContext;
    private IntentFilter mFilter;
    private int mLocationEventWhat;
    Phone.State mPhoneState = Phone.State.IDLE;
    private int mPhoneStateEventWhat;
    ServiceState mServiceState = new ServiceState();
    private int mServiceStateEventWhat;
    SignalStrength mSignalStrength = new SignalStrength();
    private Handler mTarget;
    private int mWants;

    public PhoneStateIntentReceiver() {
        this.mFilter = new IntentFilter();
    }

    public PhoneStateIntentReceiver(Context context, Handler handler) {
        this();
        this.setContext(context);
        this.setTarget(handler);
    }

    public boolean getNotifyPhoneCallState() {
        return (1 & this.mWants) != 0;
    }

    public boolean getNotifyServiceState() {
        return (2 & this.mWants) != 0;
    }

    public boolean getNotifySignalStrength() {
        return (4 & this.mWants) != 0;
    }

    public Phone.State getPhoneState() {
        if ((1 & this.mWants) == 0) {
            throw new RuntimeException("client must call notifyPhoneCallState(int)");
        }
        return this.mPhoneState;
    }

    public ServiceState getServiceState() {
        if ((2 & this.mWants) == 0) {
            throw new RuntimeException("client must call notifyServiceState(int)");
        }
        return this.mServiceState;
    }

    public int getSignalStrength() {
        if ((4 & this.mWants) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        int n = this.mSignalStrength.getGsmSignalStrength();
        if (n == 99) {
            return -1;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getSignalStrengthDbm() {
        if ((4 & this.mWants) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        int n = -1;
        if (!this.mSignalStrength.isGsm()) {
            return this.mSignalStrength.getCdmaDbm();
        }
        int n2 = this.mSignalStrength.getGsmSignalStrength();
        int n3 = n2 == 99 ? -1 : n2;
        if (n3 == -1) return n;
        return -113 + n3 * 2;
    }

    public void notifyPhoneCallState(int n) {
        this.mWants = 1 | this.mWants;
        this.mPhoneStateEventWhat = n;
        this.mFilter.addAction("android.intent.action.PHONE_STATE");
    }

    public void notifyServiceState(int n) {
        this.mWants = 2 | this.mWants;
        this.mServiceStateEventWhat = n;
        this.mFilter.addAction("android.intent.action.SERVICE_STATE");
    }

    public void notifySignalStrength(int n) {
        this.mWants = 4 | this.mWants;
        this.mAsuEventWhat = n;
        this.mFilter.addAction("android.intent.action.SIG_STR");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getAction();
        try {
            if ("android.intent.action.SIG_STR".equals(string2)) {
                this.mSignalStrength = SignalStrength.newFromBundle((Bundle)intent.getExtras());
                if (this.mTarget == null || !this.getNotifySignalStrength()) return;
                Message message = Message.obtain(this.mTarget, this.mAsuEventWhat);
                this.mTarget.sendMessage(message);
                return;
            }
            if ("android.intent.action.PHONE_STATE".equals(string2)) {
                this.mPhoneState = Enum.valueOf(Phone.State.class, intent.getStringExtra("state"));
                if (this.mTarget == null || !this.getNotifyPhoneCallState()) return;
                Message message = Message.obtain(this.mTarget, this.mPhoneStateEventWhat);
                this.mTarget.sendMessage(message);
                return;
            }
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "[PhoneStateIntentRecv] caught " + exception);
            exception.printStackTrace();
            return;
        }
        {
            if (!"android.intent.action.SERVICE_STATE".equals(string2)) return;
            this.mServiceState = ServiceState.newFromBundle((Bundle)intent.getExtras());
            if (this.mTarget == null || !this.getNotifyServiceState()) return;
            Message message = Message.obtain(this.mTarget, this.mServiceStateEventWhat);
            this.mTarget.sendMessage(message);
        }
    }

    public void registerIntent() {
        this.mContext.registerReceiver(this, this.mFilter);
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setTarget(Handler handler) {
        this.mTarget = handler;
    }

    public void unregisterIntent() {
        this.mContext.unregisterReceiver(this);
    }
}

