/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LocalSocket;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.IccIoResult;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class RIL
extends BaseCommands
implements CommandsInterface {
    private static final int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    private static final int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static final boolean DBG = false;
    private static final int DEFAULT_WAKE_LOCK_TIMEOUT = 30000;
    static final int EVENT_SEND = 1;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static final String LOG_TAG = "RILJ";
    static final int RESPONSE_SOLICITED = 0;
    static final int RESPONSE_UNSOLICITED = 1;
    static final boolean RILJ_LOGD = true;
    static final boolean RILJ_LOGV = false;
    static final int RIL_MAX_COMMAND_BYTES = 8192;
    static final String SOCKET_NAME_RIL = "rild";
    static final int SOCKET_OPEN_RETRY_MILLIS = 4000;
    private Context mContext;
    private boolean mInitialRadioStateChange = true;
    BroadcastReceiver mIntentReceiver;
    Object mLastNITZTimeInfo;
    RILReceiver mReceiver;
    Thread mReceiverThread;
    int mRequestMessagesPending;
    int mRequestMessagesWaiting;
    ArrayList<RILRequest> mRequestsList = new ArrayList();
    RILSender mSender;
    HandlerThread mSenderThread;
    LocalSocket mSocket;
    PowerManager.WakeLock mWakeLock;
    int mWakeLockTimeout;

    public RIL(Context context) {
        this(context, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RIL(Context context, int n, int n2) {
        super(context);
        this.mIntentReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                    RIL.this.sendScreenState(true);
                    return;
                }
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    RIL.this.sendScreenState(false);
                    return;
                }
                Log.w(RIL.LOG_TAG, "RIL received unexpected Intent: " + intent.getAction());
            }
        };
        this.mCdmaSubscription = n2;
        this.mNetworkMode = n;
        switch (n) {
            default: {
                this.mPhoneType = 2;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.mPhoneType = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mPhoneType = 2;
                break;
            }
            case 7: {
                this.mPhoneType = 2;
            }
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 30000);
        this.mRequestMessagesPending = 0;
        this.mRequestMessagesWaiting = 0;
        this.mContext = context;
        this.mSenderThread = new HandlerThread("RILSender");
        this.mSenderThread.start();
        this.mSender = new RILSender(this.mSenderThread.getLooper());
        this.mReceiver = new RILReceiver();
        this.mReceiverThread = new Thread(this.mReceiver, "RILReceiver");
        this.mReceiverThread.start();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, intentFilter);
    }

    static /* synthetic */ RILRequest access$100(RIL rIL, int n) {
        return rIL.findAndRemoveRequestFromList(n);
    }

    static /* synthetic */ int access$200(InputStream inputStream, byte[] byArray) throws IOException {
        return RIL.readRilMessage(inputStream, byArray);
    }

    static /* synthetic */ void access$300(RIL rIL, Parcel parcel) {
        rIL.processResponse(parcel);
    }

    static /* synthetic */ void access$400(RIL rIL, int n, boolean bl) {
        rIL.clearRequestsList(n, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acquireWakeLock() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            this.mWakeLock.acquire();
            this.mRequestMessagesPending = 1 + this.mRequestMessagesPending;
            this.mSender.removeMessages(2);
            Message message = this.mSender.obtainMessage(2);
            this.mSender.sendMessageDelayed(message, this.mWakeLockTimeout);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearRequestsList(int n, boolean bl) {
        ArrayList<RILRequest> arrayList = this.mRequestsList;
        synchronized (arrayList) {
            int n2 = this.mRequestsList.size();
            if (bl) {
                Log.d(LOG_TAG, "WAKE_LOCK_TIMEOUT  mReqPending=" + this.mRequestMessagesPending + " mRequestList=" + n2);
            }
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    this.mRequestsList.clear();
                    this.mRequestMessagesWaiting = 0;
                    return;
                }
                RILRequest rILRequest = this.mRequestsList.get(n3);
                if (bl) {
                    Log.d(LOG_TAG, n3 + ": [" + rILRequest.mSerial + "] " + RIL.requestToString(rILRequest.mRequest));
                }
                rILRequest.onError(n, null);
                rILRequest.release();
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RILRequest findAndRemoveRequestFromList(int n) {
        ArrayList<RILRequest> arrayList = this.mRequestsList;
        synchronized (arrayList) {
            int n2 = 0;
            int n3 = this.mRequestsList.size();
            while (n2 < n3) {
                RILRequest rILRequest = this.mRequestsList.get(n2);
                if (rILRequest.mSerial == n) {
                    this.mRequestsList.remove(n2);
                    if (this.mRequestMessagesWaiting > 0) {
                        --this.mRequestMessagesWaiting;
                    }
                    return rILRequest;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords cdmaInformationRecords) {
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mDisplayInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        }
        if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mSignalInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        } else if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mNumberInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        } else if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mRedirNumInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        } else if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mLineControlInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        } else if (cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mT53ClirInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        } else {
            if (!(cdmaInformationRecords.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec) || this.mT53AudCntrlInfoRegistrants == null) return;
            this.unsljLogRet(1027, cdmaInformationRecords.record);
            this.mT53AudCntrlInfoRegistrants.notifyRegistrants(new AsyncResult(null, cdmaInformationRecords.record, null));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponse(Parcel parcel) {
        int n = parcel.readInt();
        if (n == 1) {
            this.processUnsolicited(parcel);
        } else if (n == 0) {
            this.processSolicited(parcel);
        }
        this.releaseWakeLockIfDone();
    }

    /*
     * Exception decompiling
     */
    private void processSolicited(Parcel var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 625->632)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void processUnsolicited(Parcel parcel) {
        Object object;
        int n = parcel.readInt();
        switch (n) {
            default: {
                throw new RuntimeException("Unrecognized unsol response: " + n);
            }
            case 1000: {
                Object object2;
                object = object2 = this.responseVoid(parcel);
                break;
            }
            case 1001: {
                try {
                    object = this.responseVoid(parcel);
                    break;
                }
                catch (Throwable throwable) {
                    Log.e(LOG_TAG, "Exception processing unsol response: " + n + "Exception:" + throwable.toString());
                    return;
                }
            }
            case 1002: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1003: {
                object = this.responseString(parcel);
                break;
            }
            case 1004: {
                object = this.responseString(parcel);
                break;
            }
            case 1005: {
                object = this.responseInts(parcel);
                break;
            }
            case 1006: {
                object = this.responseStrings(parcel);
                break;
            }
            case 1008: {
                object = this.responseString(parcel);
                break;
            }
            case 1009: {
                object = this.responseSignalStrength(parcel);
                break;
            }
            case 1010: {
                object = this.responseDataCallList(parcel);
                break;
            }
            case 1011: {
                object = this.responseSuppServiceNotification(parcel);
                break;
            }
            case 1012: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1013: {
                object = this.responseString(parcel);
                break;
            }
            case 1014: {
                object = this.responseString(parcel);
                break;
            }
            case 1015: {
                object = this.responseInts(parcel);
                break;
            }
            case 1016: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1017: {
                object = this.responseInts(parcel);
                break;
            }
            case 1018: {
                object = this.responseCallRing(parcel);
                break;
            }
            case 1023: {
                object = this.responseInts(parcel);
                break;
            }
            case 1019: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1020: {
                object = this.responseCdmaSms(parcel);
                break;
            }
            case 1021: {
                object = this.responseString(parcel);
                break;
            }
            case 1022: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1024: {
                object = this.responseVoid(parcel);
                break;
            }
            case 1025: {
                object = this.responseCdmaCallWaiting(parcel);
                break;
            }
            case 1026: {
                object = this.responseInts(parcel);
                break;
            }
            case 1027: {
                object = this.responseCdmaInformationRecord(parcel);
                break;
            }
            case 1028: {
                object = this.responseRaw(parcel);
                break;
            }
            case 1029: {
                object = this.responseInts(parcel);
                break;
            }
            case 1030: {
                Object object3;
                object = object3 = this.responseVoid(parcel);
            }
        }
        switch (n) {
            default: {
                return;
            }
            case 1000: {
                this.setRadioStateFromRILInt(parcel.readInt());
                this.unsljLogMore(n, this.mState.toString());
                return;
            }
            case 1001: {
                this.unsljLog(n);
                this.mCallStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                return;
            }
            case 1002: {
                this.unsljLog(n);
                this.mNetworkStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                return;
            }
            case 1003: {
                this.unsljLog(n);
                String[] stringArray = new String[2];
                stringArray[1] = (String)object;
                SmsMessage smsMessage = SmsMessage.newFromCMT((String[])stringArray);
                if (this.mSMSRegistrant == null) return;
                Registrant registrant = this.mSMSRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, smsMessage, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1004: {
                this.unsljLogRet(n, object);
                if (this.mSmsStatusRegistrant == null) return;
                Registrant registrant = this.mSmsStatusRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1005: {
                this.unsljLogRet(n, object);
                int[] nArray = (int[])object;
                if (nArray.length == 1) {
                    if (this.mSmsOnSimRegistrant == null) return;
                    Registrant registrant = this.mSmsOnSimRegistrant;
                    AsyncResult asyncResult = new AsyncResult(null, nArray, null);
                    registrant.notifyRegistrant(asyncResult);
                    return;
                }
                this.riljLog(" NEW_SMS_ON_SIM ERROR with wrong length " + nArray.length);
                return;
            }
            case 1006: {
                String[] stringArray = (String[])object;
                if (stringArray.length < 2) {
                    stringArray = new String[]{((String[])object)[0], null};
                }
                this.unsljLogMore(n, stringArray[0]);
                if (this.mUSSDRegistrant == null) return;
                Registrant registrant = this.mUSSDRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, stringArray, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1008: {
                this.unsljLogRet(n, object);
                long l = parcel.readLong();
                Object[] objectArray = new Object[]{object, l};
                if (this.mNITZTimeRegistrant != null) {
                    Registrant registrant = this.mNITZTimeRegistrant;
                    AsyncResult asyncResult = new AsyncResult(null, objectArray, null);
                    registrant.notifyRegistrant(asyncResult);
                    return;
                }
                this.mLastNITZTimeInfo = objectArray;
                return;
            }
            case 1009: {
                if (this.mSignalStrengthRegistrant == null) return;
                Registrant registrant = this.mSignalStrengthRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1010: {
                this.unsljLogRet(n, object);
                RegistrantList registrantList = this.mDataConnectionRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1011: {
                this.unsljLogRet(n, object);
                if (this.mSsnRegistrant == null) return;
                Registrant registrant = this.mSsnRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1012: {
                this.unsljLog(n);
                if (this.mStkSessionEndRegistrant == null) return;
                Registrant registrant = this.mStkSessionEndRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1013: {
                this.unsljLogRet(n, object);
                if (this.mStkProCmdRegistrant == null) return;
                Registrant registrant = this.mStkProCmdRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1014: {
                this.unsljLogRet(n, object);
                if (this.mStkEventRegistrant == null) return;
                Registrant registrant = this.mStkEventRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1015: {
                this.unsljLogRet(n, object);
                if (this.mStkCallSetUpRegistrant == null) return;
                Registrant registrant = this.mStkCallSetUpRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1016: {
                this.unsljLog(n);
                if (this.mIccSmsFullRegistrant == null) return;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                return;
            }
            case 1017: {
                this.unsljLogRet(n, object);
                if (this.mIccRefreshRegistrant == null) return;
                Registrant registrant = this.mIccRefreshRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1018: {
                this.unsljLogRet(n, object);
                if (this.mRingRegistrant == null) return;
                Registrant registrant = this.mRingRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1023: {
                this.unsljLogvRet(n, object);
                if (this.mRestrictedStateRegistrant == null) return;
                Registrant registrant = this.mRestrictedStateRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1019: {
                this.unsljLog(n);
                if (this.mIccStatusChangedRegistrants == null) return;
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                return;
            }
            case 1020: {
                this.unsljLog(n);
                SmsMessage smsMessage = (SmsMessage)object;
                if (this.mSMSRegistrant == null) return;
                Registrant registrant = this.mSMSRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, smsMessage, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1021: {
                this.unsljLog(n);
                if (this.mGsmBroadcastSmsRegistrant == null) return;
                Registrant registrant = this.mGsmBroadcastSmsRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1022: {
                this.unsljLog(n);
                if (this.mIccSmsFullRegistrant == null) return;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                return;
            }
            case 1024: {
                this.unsljLog(n);
                if (this.mEmergencyCallbackModeRegistrant == null) return;
                this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                return;
            }
            case 1025: {
                this.unsljLogRet(n, object);
                if (this.mCallWaitingInfoRegistrants == null) return;
                RegistrantList registrantList = this.mCallWaitingInfoRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1026: {
                this.unsljLogRet(n, object);
                if (this.mOtaProvisionRegistrants == null) return;
                RegistrantList registrantList = this.mOtaProvisionRegistrants;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrantList.notifyRegistrants(asyncResult);
                return;
            }
            case 1027: {
                ArrayList arrayList;
                try {
                    arrayList = (ArrayList)object;
                }
                catch (ClassCastException classCastException) {
                    Log.e(LOG_TAG, "Unexpected exception casting to listInfoRecs", classCastException);
                    return;
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    CdmaInformationRecords cdmaInformationRecords = (CdmaInformationRecords)iterator.next();
                    this.unsljLogRet(n, cdmaInformationRecords);
                    this.notifyRegistrantsCdmaInfoRec(cdmaInformationRecords);
                }
                return;
            }
            case 1028: {
                this.unsljLogvRet(n, IccUtils.bytesToHexString((byte[])object));
                if (this.mUnsolOemHookRawRegistrant == null) return;
                Registrant registrant = this.mUnsolOemHookRawRegistrant;
                AsyncResult asyncResult = new AsyncResult(null, object, null);
                registrant.notifyRegistrant(asyncResult);
                return;
            }
            case 1029: {
                this.unsljLogvRet(n, object);
                if (this.mRingbackToneRegistrants == null) return;
                boolean bl = ((int[])object)[0] == 1;
                this.mRingbackToneRegistrants.notifyRegistrants(new AsyncResult(null, bl, null));
                return;
            }
            case 1030: 
        }
        this.unsljLogRet(n, object);
        if (this.mResendIncallMuteRegistrants == null) return;
        RegistrantList registrantList = this.mResendIncallMuteRegistrants;
        AsyncResult asyncResult = new AsyncResult(null, object, null);
        registrantList.notifyRegistrants(asyncResult);
    }

    private static int readRilMessage(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 4;
        do {
            if ((n2 = inputStream.read(byArray, n3, n4)) < 0) {
                Log.e(LOG_TAG, "Hit EOS reading message length");
                return -1;
            }
            n3 += n2;
        } while ((n4 -= n2) > 0);
        int n5 = (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        int n6 = 0;
        int n7 = n5;
        do {
            if ((n = inputStream.read(byArray, n6, n7)) < 0) {
                Log.e(LOG_TAG, "Hit EOS reading message.  messageLength=" + n5 + " remaining=" + n7);
                return -1;
            }
            n6 += n;
        } while ((n7 -= n) > 0);
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseWakeLockIfDone() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (this.mWakeLock.isHeld() && this.mRequestMessagesPending == 0 && this.mRequestMessagesWaiting == 0) {
                this.mSender.removeMessages(2);
                this.mWakeLock.release();
            }
            return;
        }
    }

    static String requestToString(int n) {
        switch (n) {
            default: {
                return "<unknown request>";
            }
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "REGISTRATION_STATE";
            }
            case 21: {
                return "GPRS_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: 
        }
        return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
    }

    private Object responseCallForward(Parcel parcel) {
        int n = parcel.readInt();
        CallForwardInfo[] callForwardInfoArray = new CallForwardInfo[n];
        for (int i = 0; i < n; ++i) {
            callForwardInfoArray[i] = new CallForwardInfo();
            callForwardInfoArray[i].status = parcel.readInt();
            callForwardInfoArray[i].reason = parcel.readInt();
            callForwardInfoArray[i].serviceClass = parcel.readInt();
            callForwardInfoArray[i].toa = parcel.readInt();
            callForwardInfoArray[i].number = parcel.readString();
            callForwardInfoArray[i].timeSeconds = parcel.readInt();
        }
        return callForwardInfoArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseCallList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<DriverCall> arrayList = new ArrayList<DriverCall>(n);
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Collections.sort(arrayList);
                return arrayList;
            }
            DriverCall driverCall = new DriverCall();
            driverCall.state = DriverCall.stateFromCLCC(parcel.readInt());
            driverCall.index = parcel.readInt();
            driverCall.TOA = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            driverCall.isMpty = bl;
            boolean bl2 = parcel.readInt() != 0;
            driverCall.isMT = bl2;
            driverCall.als = parcel.readInt();
            boolean bl3 = parcel.readInt() != 0;
            driverCall.isVoice = bl3;
            boolean bl4 = parcel.readInt() != 0;
            driverCall.isVoicePrivacy = bl4;
            driverCall.number = parcel.readString();
            driverCall.numberPresentation = DriverCall.presentationFromCLIP(parcel.readInt());
            driverCall.name = parcel.readString();
            driverCall.namePresentation = parcel.readInt();
            if (parcel.readInt() == 1) {
                driverCall.uusInfo = new UUSInfo();
                driverCall.uusInfo.setType(parcel.readInt());
                driverCall.uusInfo.setDcs(parcel.readInt());
                byte[] byArray = parcel.createByteArray();
                driverCall.uusInfo.setUserData(byArray);
                Object[] objectArray = new Object[]{driverCall.uusInfo.getType(), driverCall.uusInfo.getDcs(), driverCall.uusInfo.getUserData().length};
                Log.v(LOG_TAG, String.format("Incoming UUS : type=%d, dcs=%d, length=%d", objectArray));
                Log.v(LOG_TAG, "Incoming UUS : data (string)=" + new String(driverCall.uusInfo.getUserData()));
                Log.v(LOG_TAG, "Incoming UUS : data (hex): " + IccUtils.bytesToHexString(driverCall.uusInfo.getUserData()));
            } else {
                Log.v(LOG_TAG, "Incoming UUS : NOT present!");
            }
            driverCall.number = PhoneNumberUtils.stringFromStringAndTOA(driverCall.number, driverCall.TOA);
            arrayList.add(driverCall);
            if (driverCall.isVoicePrivacy) {
                this.mVoicePrivacyOnRegistrants.notifyRegistrants();
                Log.d(LOG_TAG, "InCall VoicePrivacy is enabled");
            } else {
                this.mVoicePrivacyOffRegistrants.notifyRegistrants();
                Log.d(LOG_TAG, "InCall VoicePrivacy is disabled");
            }
            ++n2;
        }
    }

    private Object responseCallRing(Parcel parcel) {
        char[] cArray = new char[]{(char)parcel.readInt(), (char)parcel.readInt(), (char)parcel.readInt(), (char)parcel.readInt()};
        return cArray;
    }

    private Object responseCdmaBroadcastConfig(Parcel parcel) {
        int[] nArray;
        int n = parcel.readInt();
        if (n == 0) {
            nArray = new int[94];
            nArray[0] = 31;
            for (int i = 1; i < 94; i += 3) {
                nArray[i + 0] = i / 3;
                nArray[i + 1] = 1;
                nArray[i + 2] = 0;
            }
        } else {
            int n2 = 1 + n * 3;
            nArray = new int[n2];
            nArray[0] = n;
            for (int i = 1; i < n2; ++i) {
                nArray[i] = parcel.readInt();
            }
        }
        return nArray;
    }

    private Object responseCdmaCallWaiting(Parcel parcel) {
        CdmaCallWaitingNotification cdmaCallWaitingNotification = new CdmaCallWaitingNotification();
        cdmaCallWaitingNotification.number = parcel.readString();
        cdmaCallWaitingNotification.numberPresentation = CdmaCallWaitingNotification.presentationFromCLIP(parcel.readInt());
        cdmaCallWaitingNotification.name = parcel.readString();
        cdmaCallWaitingNotification.namePresentation = cdmaCallWaitingNotification.numberPresentation;
        cdmaCallWaitingNotification.isPresent = parcel.readInt();
        cdmaCallWaitingNotification.signalType = parcel.readInt();
        cdmaCallWaitingNotification.alertPitch = parcel.readInt();
        cdmaCallWaitingNotification.signal = parcel.readInt();
        return cdmaCallWaitingNotification;
    }

    private ArrayList<CdmaInformationRecords> responseCdmaInformationRecord(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<CdmaInformationRecords> arrayList = new ArrayList<CdmaInformationRecords>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new CdmaInformationRecords(parcel));
        }
        return arrayList;
    }

    private Object responseCdmaSms(Parcel parcel) {
        return SmsMessage.newFromParcel((Parcel)parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseCellList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<NeighboringCellInfo> arrayList = new ArrayList<NeighboringCellInfo>();
        String string2 = SystemProperties.get("gsm.network.type", "unknown");
        int n2 = string2.equals("GPRS") ? 1 : (string2.equals("EDGE") ? 2 : (string2.equals("UMTS") ? 3 : (string2.equals("HSDPA") ? 8 : (string2.equals("HSUPA") ? 9 : (string2.equals("HSPA") ? 10 : 0)))));
        if (n2 != 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(new NeighboringCellInfo(parcel.readInt(), parcel.readString(), n2));
            }
        }
        return arrayList;
    }

    private Object responseDataCallList(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<DataCallState> arrayList = new ArrayList<DataCallState>(n);
        for (int i = 0; i < n; ++i) {
            DataCallState dataCallState = new DataCallState();
            dataCallState.cid = parcel.readInt();
            dataCallState.active = parcel.readInt();
            dataCallState.type = parcel.readString();
            dataCallState.apn = parcel.readString();
            dataCallState.address = parcel.readString();
            arrayList.add(dataCallState);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object responseGmsBroadcastConfig(Parcel parcel) {
        int n = parcel.readInt();
        ArrayList<SmsBroadcastConfigInfo> arrayList = new ArrayList<SmsBroadcastConfigInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            boolean bl = parcel.readInt() == 1;
            arrayList.add(new SmsBroadcastConfigInfo(n3, n4, n5, n6, bl));
            ++n2;
        }
        return arrayList;
    }

    private Object responseICC_IO(Parcel parcel) {
        int n = parcel.readInt();
        int n2 = parcel.readInt();
        String string2 = parcel.readString();
        this.riljLog("< iccIO:  0x" + Integer.toHexString(n) + " 0x" + Integer.toHexString(n2) + " " + string2);
        return new IccIoResult(n, n2, string2);
    }

    private Object responseIccCardStatus(Parcel parcel) {
        IccCardStatus iccCardStatus = new IccCardStatus();
        iccCardStatus.setCardState(parcel.readInt());
        iccCardStatus.setUniversalPinState(parcel.readInt());
        iccCardStatus.setGsmUmtsSubscriptionAppIndex(parcel.readInt());
        iccCardStatus.setCdmaSubscriptionAppIndex(parcel.readInt());
        int n = parcel.readInt();
        if (n > 8) {
            n = 8;
        }
        iccCardStatus.setNumApplications(n);
        for (int i = 0; i < n; ++i) {
            IccCardApplication iccCardApplication = new IccCardApplication();
            iccCardApplication.app_type = iccCardApplication.AppTypeFromRILInt(parcel.readInt());
            iccCardApplication.app_state = iccCardApplication.AppStateFromRILInt(parcel.readInt());
            iccCardApplication.perso_substate = iccCardApplication.PersoSubstateFromRILInt(parcel.readInt());
            iccCardApplication.aid = parcel.readString();
            iccCardApplication.app_label = parcel.readString();
            iccCardApplication.pin1_replaced = parcel.readInt();
            iccCardApplication.pin1 = parcel.readInt();
            iccCardApplication.pin2 = parcel.readInt();
            iccCardStatus.addApplication(iccCardApplication);
        }
        return iccCardStatus;
    }

    private Object responseInts(Parcel parcel) {
        int n = parcel.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = parcel.readInt();
        }
        return nArray;
    }

    private Object responseNetworkInfos(Parcel parcel) {
        String[] stringArray = (String[])this.responseStrings(parcel);
        if (stringArray.length % 4 != 0) {
            throw new RuntimeException("RIL_REQUEST_QUERY_AVAILABLE_NETWORKS: invalid response. Got " + stringArray.length + " strings, expected multible of 4");
        }
        ArrayList<NetworkInfo> arrayList = new ArrayList<NetworkInfo>(stringArray.length / 4);
        for (int i = 0; i < stringArray.length; i += 4) {
            arrayList.add(new NetworkInfo(stringArray[i + 0], stringArray[i + 1], stringArray[i + 2], stringArray[i + 3]));
        }
        return arrayList;
    }

    private Object responseRaw(Parcel parcel) {
        return parcel.createByteArray();
    }

    private Object responseSMS(Parcel parcel) {
        return new SmsResponse(parcel.readInt(), parcel.readString(), parcel.readInt());
    }

    private Object responseSignalStrength(Parcel parcel) {
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = parcel.readInt();
        }
        return nArray;
    }

    private Object responseString(Parcel parcel) {
        return parcel.readString();
    }

    private Object responseStrings(Parcel parcel) {
        return parcel.readStringArray();
    }

    private Object responseSuppServiceNotification(Parcel parcel) {
        SuppServiceNotification suppServiceNotification = new SuppServiceNotification();
        suppServiceNotification.notificationType = parcel.readInt();
        suppServiceNotification.code = parcel.readInt();
        suppServiceNotification.index = parcel.readInt();
        suppServiceNotification.type = parcel.readInt();
        suppServiceNotification.number = parcel.readString();
        return suppServiceNotification;
    }

    static String responseToString(int n) {
        switch (n) {
            default: {
                return "<unknown reponse>";
            }
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONG";
            }
            case 1030: 
        }
        return "UNSOL_RESEND_INCALL_MUTE";
    }

    private Object responseVoid(Parcel parcel) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String retToString(int n, Object object) {
        block12: {
            StringBuilder stringBuilder;
            if (object == null) {
                return "";
            }
            switch (n) {
                default: {
                    if (object instanceof int[]) {
                        int[] nArray = (int[])object;
                        int n2 = nArray.length;
                        stringBuilder = new StringBuilder("{");
                        if (n2 <= 0) break;
                        int n3 = 0 + 1;
                        stringBuilder.append(nArray[0]);
                        while (n3 < n2) {
                            StringBuilder stringBuilder2 = stringBuilder.append(", ");
                            int n4 = n3 + 1;
                            stringBuilder2.append(nArray[n3]);
                            n3 = n4;
                        }
                        break;
                    }
                    break block12;
                }
                case 11: 
                case 38: 
                case 39: {
                    return "";
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n5 = stringArray.length;
            StringBuilder stringBuilder = new StringBuilder("{");
            if (n5 > 0) {
                int n6 = 0 + 1;
                stringBuilder.append(stringArray[0]);
                while (n6 < n5) {
                    StringBuilder stringBuilder3 = stringBuilder.append(", ");
                    int n7 = n6 + 1;
                    stringBuilder3.append(stringArray[n6]);
                    n6 = n7;
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        if (n == 9) {
            ArrayList arrayList = (ArrayList)object;
            StringBuilder stringBuilder = new StringBuilder(" ");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DriverCall driverCall = (DriverCall)iterator.next();
                stringBuilder.append("[").append(driverCall).append("] ");
            }
            return stringBuilder.toString();
        }
        if (n != 75) return object.toString();
        ArrayList arrayList = (ArrayList)object;
        StringBuilder stringBuilder = new StringBuilder(" ");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((NeighboringCellInfo)iterator.next()).append(" ");
        }
        return stringBuilder.toString();
    }

    private void riljLog(String string2) {
        Log.d(LOG_TAG, string2);
    }

    private void riljLogv(String string2) {
        Log.v(LOG_TAG, string2);
    }

    private void send(RILRequest rILRequest) {
        Message message = this.mSender.obtainMessage(1, rILRequest);
        this.acquireWakeLock();
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendScreenState(boolean bl) {
        RILRequest rILRequest = RILRequest.obtain(61, null);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + ": " + bl);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRadioStateFromRILInt(int n) {
        CommandsInterface.RadioState radioState;
        switch (n) {
            default: {
                throw new RuntimeException("Unrecognized RIL_RadioState: " + n);
            }
            case 0: {
                radioState = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                radioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 2: {
                radioState = CommandsInterface.RadioState.SIM_NOT_READY;
                break;
            }
            case 3: {
                radioState = CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT;
                break;
            }
            case 4: {
                radioState = CommandsInterface.RadioState.SIM_READY;
                break;
            }
            case 5: {
                radioState = CommandsInterface.RadioState.RUIM_NOT_READY;
                break;
            }
            case 6: {
                radioState = CommandsInterface.RadioState.RUIM_READY;
                break;
            }
            case 7: {
                radioState = CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT;
                break;
            }
            case 8: {
                radioState = CommandsInterface.RadioState.NV_NOT_READY;
                break;
            }
            case 9: {
                radioState = CommandsInterface.RadioState.NV_READY;
            }
        }
        if (this.mInitialRadioStateChange) {
            if (radioState.isOn()) {
                Log.d(LOG_TAG, "Radio ON @ init; reset to OFF");
                this.setRadioPower(false, null);
            } else {
                this.setRadioState(radioState);
            }
            this.mInitialRadioStateChange = false;
            return;
        }
        this.setRadioState(radioState);
    }

    private int translateStatus(int n) {
        switch (n & 7) {
            default: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: 
        }
        return 2;
    }

    private void unsljLog(int n) {
        this.riljLog("[UNSL]< " + RIL.responseToString(n));
    }

    private void unsljLogMore(int n, String string2) {
        this.riljLog("[UNSL]< " + RIL.responseToString(n) + " " + string2);
    }

    private void unsljLogRet(int n, Object object) {
        this.riljLog("[UNSL]< " + RIL.responseToString(n) + " " + this.retToString(n, object));
    }

    private void unsljLogvRet(int n, Object object) {
        this.riljLogv("[UNSL]< " + RIL.responseToString(n) + " " + this.retToString(n, object));
    }

    @Override
    public void acceptCall(Message message) {
        RILRequest rILRequest = RILRequest.obtain(40, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(88, message);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 0 : 1;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + bl + " " + n);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(37, message);
        rILRequest.mp.writeInt(2);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + bl + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        RILRequest rILRequest = RILRequest.obtain(30, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(44, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        this.send(rILRequest);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(6, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(7, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void conference(Message message) {
        RILRequest rILRequest = RILRequest.obtain(16, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void deactivateDataCall(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(41, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(Integer.toString(n));
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void deactivateDefaultPDP(int n, Message message) {
        this.deactivateDataCall(n, message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(97, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(64, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        this.dial(string2, n, null, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        RILRequest rILRequest = RILRequest.obtain(10, message);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(0);
        if (uUSInfo == null) {
            rILRequest.mp.writeInt(0);
        } else {
            rILRequest.mp.writeInt(1);
            rILRequest.mp.writeInt(uUSInfo.getType());
            rILRequest.mp.writeInt(uUSInfo.getDcs());
            rILRequest.mp.writeByteArray(uUSInfo.getUserData());
        }
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(99, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        RILRequest rILRequest = RILRequest.obtain(72, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        RILRequest rILRequest = RILRequest.obtain(48, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getBasebandVersion(Message message) {
        RILRequest rILRequest = RILRequest.obtain(51, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getCDMASubscription(Message message) {
        RILRequest rILRequest = RILRequest.obtain(95, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getCLIR(Message message) {
        RILRequest rILRequest = RILRequest.obtain(31, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        this.send(RILRequest.obtain(92, message));
    }

    @Override
    public void getCurrentCalls(Message message) {
        RILRequest rILRequest = RILRequest.obtain(9, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getDataCallList(Message message) {
        RILRequest rILRequest = RILRequest.obtain(57, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        RILRequest rILRequest = RILRequest.obtain(98, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getGPRSRegistrationState(Message message) {
        RILRequest rILRequest = RILRequest.obtain(21, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        RILRequest rILRequest = RILRequest.obtain(89, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getIMEI(Message message) {
        RILRequest rILRequest = RILRequest.obtain(38, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getIMEISV(Message message) {
        RILRequest rILRequest = RILRequest.obtain(39, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getIMSI(Message message) {
        RILRequest rILRequest = RILRequest.obtain(11, message);
        this.riljLog(rILRequest.serialString() + "> getIMSI:RIL_REQUEST_GET_IMSI " + 11 + " " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getIccCardStatus(Message message) {
        RILRequest rILRequest = RILRequest.obtain(1, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        RILRequest rILRequest = RILRequest.obtain(18, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        RILRequest rILRequest = RILRequest.obtain(56, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getLastPdpFailCause(Message message) {
        this.getLastDataCallFailCause(message);
    }

    @Override
    public void getMute(Message message) {
        RILRequest rILRequest = RILRequest.obtain(54, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getNeighboringCids(Message message) {
        RILRequest rILRequest = RILRequest.obtain(75, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(45, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getOperator(Message message) {
        RILRequest rILRequest = RILRequest.obtain(22, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getPDPContextList(Message message) {
        this.getDataCallList(message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        RILRequest rILRequest = RILRequest.obtain(74, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        this.send(RILRequest.obtain(83, message));
    }

    @Override
    public void getRegistrationState(Message message) {
        RILRequest rILRequest = RILRequest.obtain(20, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getSignalStrength(Message message) {
        RILRequest rILRequest = RILRequest.obtain(19, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void getSmscAddress(Message message) {
        RILRequest rILRequest = RILRequest.obtain(100, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        RILRequest rILRequest = RILRequest.obtain(71, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        int[] nArray = new int[1];
        int n = bl ? 1 : 0;
        nArray[0] = n;
        rILRequest.mp.writeIntArray(nArray);
        this.send(rILRequest);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        this.riljLog("hangupConnection: gsmIndex=" + n);
        RILRequest rILRequest = RILRequest.obtain(12, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        RILRequest rILRequest = RILRequest.obtain(14, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        RILRequest rILRequest = RILRequest.obtain(13, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(28, message);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n3);
        rILRequest.mp.writeInt(n4);
        rILRequest.mp.writeInt(n5);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        this.riljLog(rILRequest.serialString() + "> iccIO: " + RIL.requestToString(rILRequest.mRequest) + " 0x" + Integer.toHexString(n) + " 0x" + Integer.toHexString(n2) + " " + " path: " + string2 + "," + n3 + "," + n4 + "," + n5);
        this.send(rILRequest);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(59, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + "[" + IccUtils.bytesToHexString(byArray) + "]");
        rILRequest.mp.writeByteArray(byArray);
        this.send(rILRequest);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(60, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeStringArray(stringArray);
        this.send(rILRequest);
    }

    @Override
    protected void onRadioAvailable() {
        this.sendScreenState(true);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        RILRequest rILRequest = RILRequest.obtain(66, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void queryCLIP(Message message) {
        RILRequest rILRequest = RILRequest.obtain(55, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(33, message);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeInt(PhoneNumberUtils.toaFromString(string2));
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(0);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n + " " + n2);
        this.send(rILRequest);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(35, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        RILRequest rILRequest = RILRequest.obtain(79, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(42, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(Integer.toString(n));
        this.send(rILRequest);
    }

    @Override
    public void queryTTYMode(Message message) {
        this.send(RILRequest.obtain(81, message));
    }

    @Override
    public void rejectCall(Message message) {
        RILRequest rILRequest = RILRequest.obtain(17, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(102, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + ": " + bl);
        this.send(rILRequest);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        RILRequest rILRequest = RILRequest.obtain(103, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void resetRadio(Message message) {
        RILRequest rILRequest = RILRequest.obtain(58, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(85, message);
        rILRequest.mp.writeInt(3);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(Integer.toString(n));
        rILRequest.mp.writeString(Integer.toString(n2));
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + string2);
        this.send(rILRequest);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(84, message);
        rILRequest.mp.writeString(string2);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + string2);
        this.send(rILRequest);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        RILRequest rILRequest = RILRequest.obtain(87, message);
        rILRequest.mp.writeInt(dataInputStream.readInt());
        rILRequest.mp.writeByte((byte)dataInputStream.readInt());
        rILRequest.mp.writeInt(dataInputStream.readInt());
        rILRequest.mp.writeInt(dataInputStream.read());
        rILRequest.mp.writeInt(dataInputStream.read());
        rILRequest.mp.writeInt(dataInputStream.read());
        rILRequest.mp.writeInt(dataInputStream.read());
        int n = dataInputStream.read();
        rILRequest.mp.writeByte((byte)n);
        for (int i = 0; i < n; ++i) {
            rILRequest.mp.writeByte(dataInputStream.readByte());
            continue;
        }
        rILRequest.mp.writeInt(dataInputStream.read());
        rILRequest.mp.writeByte((byte)dataInputStream.read());
        int n2 = dataInputStream.read();
        rILRequest.mp.writeByte((byte)n2);
        for (int i = 0; i < n2; ++i) {
            rILRequest.mp.writeByte(dataInputStream.readByte());
            continue;
        }
        int n3 = dataInputStream.read();
        rILRequest.mp.writeInt(n3);
        for (int i = 0; i < n3; ++i) {
            try {
                rILRequest.mp.writeByte(dataInputStream.readByte());
                continue;
            }
            catch (IOException iOException) {
                this.riljLog("sendSmsCdma: conversion from input stream to object failed: " + iOException);
                break;
            }
        }
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void sendDtmf(char c, Message message) {
        RILRequest rILRequest = RILRequest.obtain(24, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeString(Character.toString(c));
        this.send(rILRequest);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(69, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(25, message);
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(70, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(29, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + string2);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void separateConnection(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(52, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setBandMode(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(65, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void setCLIR(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(32, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n);
        this.send(rILRequest);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        RILRequest rILRequest = RILRequest.obtain(34, message);
        rILRequest.mp.writeInt(n);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeInt(n3);
        rILRequest.mp.writeInt(PhoneNumberUtils.toaFromString(string2));
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeInt(n4);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n + " " + n2 + " " + n3 + n4);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(36, message);
        rILRequest.mp.writeInt(2);
        Parcel parcel = rILRequest.mp;
        int n2 = bl ? 1 : 0;
        parcel.writeInt(n2);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + bl + ", " + n);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(94, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void setCdmaBroadcastConfig(int[] nArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(93, message);
        for (int i = 0; i < nArray.length; ++i) {
            rILRequest.mp.writeInt(nArray[i]);
        }
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(78, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + n);
        this.send(rILRequest);
    }

    @Override
    public void setCdmaSubscription(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(77, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + n);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(43, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(4);
        rILRequest.mp.writeString(string2);
        String string4 = bl ? "1" : "0";
        rILRequest.mp.writeString(string4);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(Integer.toString(n));
        this.send(rILRequest);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(91, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        RILRequest rILRequest = RILRequest.obtain(90, message);
        int n = smsBroadcastConfigInfoArray.length;
        rILRequest.mp.writeInt(n);
        for (int i = 0; i < n; ++i) {
            rILRequest.mp.writeInt(smsBroadcastConfigInfoArray[i].getFromServiceId());
            rILRequest.mp.writeInt(smsBroadcastConfigInfoArray[i].getToServiceId());
            rILRequest.mp.writeInt(smsBroadcastConfigInfoArray[i].getFromCodeScheme());
            rILRequest.mp.writeInt(smsBroadcastConfigInfoArray[i].getToCodeScheme());
            Parcel parcel = rILRequest.mp;
            int n2 = smsBroadcastConfigInfoArray[i].isSelected() ? 1 : 0;
            parcel.writeInt(n2);
        }
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " with " + n + "configs : ");
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                this.send(rILRequest);
                return;
            }
            this.riljLog(smsBroadcastConfigInfoArray[n3].toString());
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(76, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + ": " + bl);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMute(boolean bl, Message message) {
        RILRequest rILRequest = RILRequest.obtain(53, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + bl);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        RILRequest rILRequest = RILRequest.obtain(46, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(47, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + string2);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void setOnNITZTime(Handler handler, int n, Object object) {
        super.setOnNITZTime(handler, n, object);
        if (this.mLastNITZTimeInfo != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, this.mLastNITZTimeInfo, null));
            this.mLastNITZTimeInfo = null;
        }
    }

    @Override
    public void setPhoneType(int n) {
        this.mPhoneType = n;
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(73, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + n);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(82, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRadioPower(boolean bl, Message message) {
        if (this.mInitialRadioStateChange) {
            Object object = this.mStateMonitor;
            synchronized (object) {
                if (!this.mState.isOn()) {
                    RILRequest rILRequest = RILRequest.obtain(73, null);
                    rILRequest.mp.writeInt(1);
                    rILRequest.mp.writeInt(this.mNetworkMode);
                    this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + this.mNetworkMode);
                    this.send(rILRequest);
                    RILRequest rILRequest2 = RILRequest.obtain(77, null);
                    rILRequest2.mp.writeInt(1);
                    rILRequest2.mp.writeInt(this.mCdmaSubscription);
                    this.riljLog(rILRequest2.serialString() + "> " + RIL.requestToString(rILRequest2.mRequest) + " : " + this.mCdmaSubscription);
                    this.send(rILRequest2);
                }
            }
        }
        RILRequest rILRequest = RILRequest.obtain(23, message);
        rILRequest.mp.writeInt(1);
        Parcel parcel = rILRequest.mp;
        int n = bl ? 1 : 0;
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(101, message);
        rILRequest.mp.writeString(string2);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " : " + string2);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        int n = 1;
        RILRequest rILRequest = RILRequest.obtain(62, message);
        rILRequest.mp.writeInt(n);
        Parcel parcel = rILRequest.mp;
        if (!bl) {
            n = 0;
        }
        parcel.writeInt(n);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        RILRequest rILRequest = RILRequest.obtain(80, message);
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeInt(n);
        this.send(rILRequest);
    }

    @Override
    public void setupDataCall(String string2, String string3, String string4, String string5, String string6, String string7, Message message) {
        RILRequest rILRequest = RILRequest.obtain(27, message);
        rILRequest.mp.writeInt(6);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string4);
        rILRequest.mp.writeString(string5);
        rILRequest.mp.writeString(string6);
        rILRequest.mp.writeString(string7);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6 + " " + string7);
        this.send(rILRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setupDefaultPDP(String string2, String string3, String string4, Message message) {
        int n = string3 != null ? 3 : 0;
        this.setupDataCall(Integer.toString(1), "", string2, string3, string4, Integer.toString(n), message);
    }

    @Override
    public void startDtmf(char c, Message message) {
        RILRequest rILRequest = RILRequest.obtain(49, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeString(Character.toString(c));
        this.send(rILRequest);
    }

    @Override
    public void stopDtmf(Message message) {
        RILRequest rILRequest = RILRequest.obtain(50, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(2, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(4, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(3, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        RILRequest rILRequest = RILRequest.obtain(5, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(2);
        rILRequest.mp.writeString(string2);
        rILRequest.mp.writeString(string3);
        this.send(rILRequest);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        RILRequest rILRequest = RILRequest.obtain(8, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        rILRequest.mp.writeInt(1);
        rILRequest.mp.writeString(string2);
        this.send(rILRequest);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        RILRequest rILRequest = RILRequest.obtain(15, message);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest));
        this.send(rILRequest);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        int n2 = this.translateStatus(n);
        RILRequest rILRequest = RILRequest.obtain(96, message);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string2);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n2);
        this.send(rILRequest);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        int n2 = this.translateStatus(n);
        RILRequest rILRequest = RILRequest.obtain(63, message);
        rILRequest.mp.writeInt(n2);
        rILRequest.mp.writeString(string3);
        rILRequest.mp.writeString(string2);
        this.riljLog(rILRequest.serialString() + "> " + RIL.requestToString(rILRequest.mRequest) + " " + n2);
        this.send(rILRequest);
    }

    class RILReceiver
    implements Runnable {
        byte[] buffer = new byte[8192];

        RILReceiver() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [21 : 279->292)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class RILSender
    extends Handler
    implements Runnable {
        byte[] dataLength;

        public RILSender(Looper looper) {
            super(looper);
            this.dataLength = new byte[4];
        }

        /*
         * Exception decompiling
         */
        @Override
        public void handleMessage(Message var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [15 : 321->324)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void run() {
        }
    }
}

