/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RIL;

class RILRequest {
    static final String LOG_TAG = "RILJ";
    private static final int MAX_POOL_SIZE = 4;
    static int sNextSerial = 0;
    private static RILRequest sPool;
    private static int sPoolSize;
    private static Object sPoolSync;
    static Object sSerialMonitor;
    RILRequest mNext;
    int mRequest;
    Message mResult;
    int mSerial;
    Parcel mp;

    static {
        sSerialMonitor = new Object();
        sPoolSync = new Object();
        sPool = null;
        sPoolSize = 0;
    }

    private RILRequest() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static RILRequest obtain(int n, Message message) {
        Object object = sPoolSync;
        // MONITORENTER : object
        RILRequest rILRequest = sPool;
        RILRequest rILRequest2 = null;
        if (rILRequest != null) {
            rILRequest2 = sPool;
            sPool = rILRequest2.mNext;
            rILRequest2.mNext = null;
            --sPoolSize;
        }
        // MONITOREXIT : object
        if (rILRequest2 == null) {
            rILRequest2 = new RILRequest();
        }
        Object object2 = sSerialMonitor;
        // MONITORENTER : object2
        int n2 = sNextSerial;
        sNextSerial = n2 + 1;
        rILRequest2.mSerial = n2;
        // MONITOREXIT : object2
        rILRequest2.mRequest = n;
        rILRequest2.mResult = message;
        rILRequest2.mp = Parcel.obtain();
        if (message != null && message.getTarget() == null) {
            throw new NullPointerException("Message target must not be null");
        }
        rILRequest2.mp.writeInt(n);
        rILRequest2.mp.writeInt(rILRequest2.mSerial);
        return rILRequest2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void resetSerial() {
        Object object = sSerialMonitor;
        synchronized (object) {
            sNextSerial = 0;
            return;
        }
    }

    void onError(int n, Object object) {
        CommandException commandException = CommandException.fromRilErrno(n);
        Log.d(LOG_TAG, this.serialString() + "< " + RIL.requestToString(this.mRequest) + " error: " + commandException);
        if (this.mResult != null) {
            AsyncResult.forMessage(this.mResult, object, commandException);
            this.mResult.sendToTarget();
        }
        if (this.mp != null) {
            this.mp.recycle();
            this.mp = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void release() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 4) {
                this.mNext = sPool;
                sPool = this;
                sPoolSize = 1 + sPoolSize;
            }
            return;
        }
    }

    String serialString() {
        StringBuilder stringBuilder = new StringBuilder(8);
        String string2 = Integer.toString(this.mSerial);
        stringBuilder.append('[');
        int n = string2.length();
        for (int i = 0; i < 4 - n; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

