/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Random;

public class RetryManager {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "RetryManager";
    private int mMaxRetryCount;
    private ArrayList<RetryRec> mRetryArray = new ArrayList();
    private int mRetryCount;
    private boolean mRetryForever;
    private Random rng = new Random();

    private void log(String string2) {
        Log.d(LOG_TAG, string2);
    }

    private int nextRandomizationTime(int n) {
        int n2 = this.mRetryArray.get((int)n).mRandomizationTime;
        if (n2 == 0) {
            return 0;
        }
        return this.rng.nextInt(n2);
    }

    private Pair<Boolean, Integer> parseNonNegativeInt(String string2, String string3) {
        try {
            int n = Integer.parseInt(string3);
            Pair<Boolean, Integer> pair = new Pair<Boolean, Integer>(this.validateNonNegativeInt(string2, n), n);
            return pair;
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(LOG_TAG, string2 + " bad value: " + string3, numberFormatException);
            return new Pair<Boolean, Integer>(false, 0);
        }
    }

    private boolean validateNonNegativeInt(String string2, int n) {
        if (n < 0) {
            Log.e(LOG_TAG, string2 + " bad value: is < 0");
            return false;
        }
        return true;
    }

    public boolean configure(int n, int n2, int n3) {
        if (!this.validateNonNegativeInt("maxRetryCount", n)) {
            return false;
        }
        if (!this.validateNonNegativeInt("retryTime", n2)) {
            return false;
        }
        if (!this.validateNonNegativeInt("randomizationTime", n3)) {
            return false;
        }
        this.mMaxRetryCount = n;
        this.resetRetryCount();
        this.mRetryArray.clear();
        this.mRetryArray.add(new RetryRec(n2, n3));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean configure(String string2) {
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        int n = 0;
        this.mMaxRetryCount = 0;
        this.resetRetryCount();
        this.mRetryArray.clear();
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=", 2);
            stringArray2[0] = stringArray2[0].trim();
            if (stringArray2.length > 1) {
                stringArray2[1] = stringArray2[1].trim();
                if (TextUtils.equals(stringArray2[0], "default_randomization")) {
                    Pair<Boolean, Integer> pair = this.parseNonNegativeInt(stringArray2[0], stringArray2[1]);
                    if (!((Boolean)pair.first).booleanValue()) {
                        return false;
                    }
                    n = (Integer)pair.second;
                    continue;
                }
                if (!TextUtils.equals(stringArray2[0], "max_retries")) {
                    Log.e(LOG_TAG, "Unrecognized configuration name value pair: " + stringArray[i]);
                    return false;
                }
                if (TextUtils.equals("infinite", stringArray2[1])) {
                    this.mRetryForever = true;
                    continue;
                }
                Pair<Boolean, Integer> pair = this.parseNonNegativeInt(stringArray2[0], stringArray2[1]);
                if (!((Boolean)pair.first).booleanValue()) {
                    return false;
                }
                this.mMaxRetryCount = (Integer)pair.second;
                continue;
            }
            String[] stringArray3 = stringArray[i].split(":", 2);
            stringArray3[0] = stringArray3[0].trim();
            RetryRec retryRec = new RetryRec(0, 0);
            Pair<Boolean, Integer> pair = this.parseNonNegativeInt("delayTime", stringArray3[0]);
            if (!((Boolean)pair.first).booleanValue()) {
                return false;
            }
            retryRec.mDelayTime = (Integer)pair.second;
            if (stringArray3.length > 1) {
                stringArray3[1] = stringArray3[1].trim();
                Pair<Boolean, Integer> pair2 = this.parseNonNegativeInt("randomizationTime", stringArray3[1]);
                if (!((Boolean)pair2.first).booleanValue()) {
                    return false;
                }
                retryRec.mRandomizationTime = (Integer)pair2.second;
            } else {
                retryRec.mRandomizationTime = n;
            }
            this.mRetryArray.add(retryRec);
        }
        if (this.mRetryArray.size() > this.mMaxRetryCount) {
            this.mMaxRetryCount = this.mRetryArray.size();
        }
        return true;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getRetryTimer() {
        int n = this.mRetryCount < this.mRetryArray.size() ? this.mRetryCount : this.mRetryArray.size() - 1;
        if (n >= 0 && n < this.mRetryArray.size()) {
            return this.mRetryArray.get((int)n).mDelayTime + this.nextRandomizationTime(n);
        }
        return 0;
    }

    public void increaseRetryCount() {
        this.mRetryCount = 1 + this.mRetryCount;
        if (this.mRetryCount > this.mMaxRetryCount) {
            this.mRetryCount = this.mMaxRetryCount;
        }
    }

    public boolean isRetryForever() {
        return this.mRetryForever;
    }

    public boolean isRetryNeeded() {
        return this.mRetryForever || this.mRetryCount < this.mMaxRetryCount;
    }

    public void resetRetryCount() {
        this.mRetryCount = 0;
        this.mRetryForever = false;
    }

    public void retryForeverUsingLastTimeout() {
        this.mRetryCount = this.mMaxRetryCount;
        this.mRetryForever = true;
    }

    public void setRetryCount(int n) {
        this.mRetryCount = n;
        if (this.mRetryCount > this.mMaxRetryCount) {
            this.mRetryCount = this.mMaxRetryCount;
        }
        if (this.mRetryCount < 0) {
            this.mRetryCount = 0;
        }
        this.mRetryForever = false;
    }

    private static class RetryRec {
        int mDelayTime;
        int mRandomizationTime;

        RetryRec(int n, int n2) {
            this.mDelayTime = n;
            this.mRandomizationTime = n2;
        }
    }
}

