/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public abstract class SMSDispatcher
extends Handler {
    private static final int DEFAULT_SMS_CHECK_PERIOD = 3600000;
    private static final int DEFAULT_SMS_MAX_COUNT = 100;
    private static final int DEFAULT_SMS_TIMEOUT = 6000;
    protected static final int EVENT_ALERT_TIMEOUT = 9;
    protected static final int EVENT_ICC_FULL = 6;
    protected static final int EVENT_NEW_SMS = 1;
    protected static final int EVENT_NEW_SMS_STATUS_REPORT = 5;
    protected static final int EVENT_POST_ALERT = 7;
    protected static final int EVENT_RADIO_ON = 12;
    protected static final int EVENT_REPORT_MEMORY_STATUS_DONE = 11;
    protected static final int EVENT_SEND_CONFIRMED_SMS = 8;
    protected static final int EVENT_SEND_RETRY = 3;
    protected static final int EVENT_SEND_SMS_COMPLETE = 2;
    protected static final int EVENT_STOP_SENDING = 10;
    private static final int MAX_SEND_RETRIES = 3;
    private static final int MO_MSG_QUEUE_LIMIT = 5;
    protected static final String[] RAW_PROJECTION = new String[]{"pdu", "sequence", "destination_port"};
    private static final String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    private static final int SEND_RETRY_DELAY = 2000;
    private static final int SINGLE_PART_SMS = 1;
    private static final String TAG = "SMS";
    protected static int mRemainingMessages = -1;
    private static int sConcatenatedRef;
    private final int WAKE_LOCK_TIMEOUT;
    protected final ArrayList<SmsTracker> deliveryPendingList;
    protected CommandsInterface mCm;
    protected Context mContext;
    private SmsCounter mCounter;
    private DialogInterface.OnClickListener mListener;
    protected Phone mPhone;
    protected final Uri mRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    protected boolean mReportMemoryStatusPending = false;
    protected ContentResolver mResolver;
    private BroadcastReceiver mResultReceiver;
    private ArrayList<SmsTracker> mSTrackers = new ArrayList(5);
    protected boolean mStorageAvailable = true;
    private PowerManager.WakeLock mWakeLock;
    protected final WapPushOverSms mWapPush;

    protected SMSDispatcher(PhoneBase phoneBase) {
        this.WAKE_LOCK_TIMEOUT = 5000;
        this.deliveryPendingList = new ArrayList();
        this.mListener = new DialogInterface.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(DialogInterface dialogInterface, int n) {
                if (n == -1) {
                    Log.d(SMSDispatcher.TAG, "click YES to send out sms");
                    SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(8));
                    return;
                } else {
                    if (n != -2) return;
                    Log.d(SMSDispatcher.TAG, "click NO to stop sending");
                    SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(10));
                    return;
                }
            }
        };
        this.mResultReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_FULL")) {
                    SMSDispatcher.this.mStorageAvailable = false;
                    SMSDispatcher.this.mCm.reportSmsMemoryStatus(false, SMSDispatcher.this.obtainMessage(11));
                    return;
                }
                if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_NOT_FULL")) {
                    SMSDispatcher.this.mStorageAvailable = true;
                    SMSDispatcher.this.mCm.reportSmsMemoryStatus(true, SMSDispatcher.this.obtainMessage(11));
                    return;
                }
                int n = this.getResultCode();
                boolean bl = n == -1 || n == 1;
                SMSDispatcher.this.acknowledgeLastIncomingSms(bl, n, null);
            }
        };
        this.mPhone = phoneBase;
        this.mWapPush = new WapPushOverSms(phoneBase, this);
        this.mContext = phoneBase.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCm = phoneBase.mCM;
        this.createWakelock();
        int n = Settings.Secure.getInt(this.mResolver, "sms_outgoing_check_interval_ms", 3600000);
        this.mCounter = new SmsCounter(Settings.Secure.getInt(this.mResolver, "sms_outgoing_check_max_count", 100), n);
        this.mCm.setOnNewSMS(this, 1, null);
        this.mCm.setOnSmsStatus(this, 5, null);
        this.mCm.setOnIccSmsFull(this, 6, null);
        this.mCm.registerForOn(this, 12, null);
        sConcatenatedRef = new Random().nextInt(256);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_FULL");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        this.mContext.registerReceiver(this.mResultReceiver, intentFilter);
    }

    private void createWakelock() {
        this.mWakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, "SMSDispatcher");
        this.mWakeLock.setReferenceCounted(true);
    }

    protected static int getNextConcatenatedRef() {
        sConcatenatedRef = 1 + sConcatenatedRef;
        return sConcatenatedRef;
    }

    private void handleIccFull() {
        Intent intent = new Intent("android.provider.Telephony.SIM_FULL");
        this.mWakeLock.acquire(5000L);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    private boolean isMultipartTracker(SmsTracker smsTracker) {
        return smsTracker.mData.get("parts") != null;
    }

    private void notifyAndAcknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        if (!bl) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            intent.putExtra("result", n);
            this.mWakeLock.acquire(5000L);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(bl, n, message);
    }

    protected SmsTracker SmsTrackerFactory(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        return new SmsTracker(hashMap, pendingIntent, pendingIntent2);
    }

    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    protected abstract void activateCellBroadcastSms(int var1, Message var2);

    void dispatch(Intent intent, String string2) {
        this.mWakeLock.acquire(5000L);
        this.mContext.sendOrderedBroadcast(intent, string2, this.mResultReceiver, this, -1, null, null);
    }

    protected abstract int dispatchMessage(SmsMessageBase var1);

    protected void dispatchPdus(byte[][] byArray) {
        Intent intent = new Intent("android.provider.Telephony.SMS_RECEIVED");
        intent.putExtra("pdus", (Serializable)byArray);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    protected void dispatchPortAddressedPdus(byte[][] byArray, int n) {
        Intent intent = new Intent("android.intent.action.DATA_SMS_RECEIVED", Uri.parse("sms://localhost:" + n));
        intent.putExtra("pdus", (Serializable)byArray);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    public void dispose() {
        this.mCm.unSetOnNewSMS(this);
        this.mCm.unSetOnSmsStatus(this);
        this.mCm.unSetOnIccSmsFull(this);
        this.mCm.unregisterForOn(this);
    }

    protected void finalize() {
        Log.d(TAG, "SMSDispatcher finalized");
    }

    protected String getAppNameByIntent(PendingIntent pendingIntent) {
        Resources resources = Resources.getSystem();
        if (pendingIntent != null) {
            return pendingIntent.getTargetPackage();
        }
        return resources.getString(17040151);
    }

    protected abstract void getCellBroadcastSmsConfig(Message var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                boolean bl;
                int n;
                Log.d(TAG, "New SMS Message Received");
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) {
                    Log.e(TAG, "Exception processing incoming SMS. Exception:" + asyncResult.exception);
                    return;
                }
                SmsMessage smsMessage = (SmsMessage)asyncResult.result;
                try {
                    n = this.dispatchMessage(smsMessage.mWrappedSmsMessage);
                    if (n == -1) return;
                    bl = n == 1;
                }
                catch (RuntimeException runtimeException) {
                    Log.e(TAG, "Exception dispatching message", runtimeException);
                    this.notifyAndAcknowledgeLastIncomingSms(false, 2, null);
                    return;
                }
                this.notifyAndAcknowledgeLastIncomingSms(bl, n, null);
                return;
            }
            case 2: {
                this.handleSendComplete((AsyncResult)message.obj);
                return;
            }
            case 3: {
                this.sendSms((SmsTracker)message.obj);
                return;
            }
            case 5: {
                this.handleStatusReport((AsyncResult)message.obj);
                return;
            }
            case 6: {
                this.handleIccFull();
                return;
            }
            case 7: {
                this.handleReachSentLimit((SmsTracker)message.obj);
                return;
            }
            case 9: {
                ((AlertDialog)message.obj).dismiss();
                message.obj = null;
                if (!this.mSTrackers.isEmpty()) {
                    try {
                        this.mSTrackers.remove((int)0).mSentIntent.send(5);
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                    }
                }
                Log.d(TAG, "EVENT_ALERT_TIMEOUT, message stop sending");
                return;
            }
            case 8: {
                if (this.mSTrackers.isEmpty()) return;
                SmsTracker smsTracker = this.mSTrackers.remove(this.mSTrackers.size() - 1);
                if (this.isMultipartTracker(smsTracker)) {
                    this.sendMultipartSms(smsTracker);
                } else {
                    this.sendSms(smsTracker);
                }
                this.removeMessages(9, message.obj);
                return;
            }
            case 10: {
                if (this.mSTrackers.isEmpty()) return;
                try {
                    this.mSTrackers.remove((int)(this.mSTrackers.size() - 1)).mSentIntent.send(5);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                }
                this.removeMessages(9, message.obj);
                return;
            }
            case 11: {
                if (((AsyncResult)message.obj).exception != null) {
                    this.mReportMemoryStatusPending = true;
                    Log.v(TAG, "Memory status report to modem pending : mStorageAvailable = " + this.mStorageAvailable);
                    return;
                }
                this.mReportMemoryStatusPending = false;
                return;
            }
            case 12: 
        }
        if (!this.mReportMemoryStatusPending) return;
        Log.v(TAG, "Sending pending memory status report : mStorageAvailable = " + this.mStorageAvailable);
        this.mCm.reportSmsMemoryStatus(this.mStorageAvailable, this.obtainMessage(11));
    }

    /*
     * Unable to fully structure code
     */
    protected void handleNotInService(int var1_1, SmsTracker var2_2) {
        block2: {
            if (var2_2.mSentIntent == null) break block2;
            if (var1_1 != 3) ** GOTO lbl6
            try {
                var2_2.mSentIntent.send(2);
                return;
lbl6:
                // 1 sources

                var2_2.mSentIntent.send(4);
                return;
            }
            catch (PendingIntent.CanceledException var3_3) {
                // empty catch block
            }
        }
    }

    protected void handleReachSentLimit(SmsTracker smsTracker) {
        if (this.mSTrackers.size() >= 5) {
            try {
                smsTracker.mSentIntent.send(5);
                return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e(TAG, "failed to send back RESULT_ERROR_LIMIT_EXCEEDED");
                return;
            }
        }
        Resources resources = Resources.getSystem();
        String string2 = this.getAppNameByIntent(smsTracker.mSentIntent);
        AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).setTitle(resources.getString(17040152)).setMessage(string2 + " " + resources.getString(17040153)).setPositiveButton(resources.getString(17040154), this.mListener).setNegativeButton(resources.getString(17040155), this.mListener).create();
        alertDialog.getWindow().setType(2003);
        alertDialog.show();
        this.mSTrackers.add(smsTracker);
        this.sendMessageDelayed(this.obtainMessage(9, alertDialog), 6000L);
    }

    protected void handleSendComplete(AsyncResult asyncResult) {
        SmsTracker smsTracker = (SmsTracker)asyncResult.userObj;
        PendingIntent pendingIntent = smsTracker.mSentIntent;
        if (asyncResult.exception == null) {
            Log.d(TAG, "SMS send complete. Broadcasting intent: " + pendingIntent);
            if (smsTracker.mDeliveryIntent != null) {
                smsTracker.mMessageRef = ((SmsResponse)asyncResult.result).messageRef;
                this.deliveryPendingList.add(smsTracker);
            }
            if (pendingIntent != null) {
                try {
                    if (mRemainingMessages > -1) {
                        --mRemainingMessages;
                    }
                    if (mRemainingMessages == 0) {
                        Intent intent = new Intent();
                        intent.putExtra(SEND_NEXT_MSG_EXTRA, true);
                        pendingIntent.send(this.mContext, -1, intent);
                        return;
                    }
                    pendingIntent.send(-1);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    return;
                }
            }
        } else {
            Log.d(TAG, "SMS send failed");
            int n = this.mPhone.getServiceState().getState();
            if (n != 0) {
                this.handleNotInService(n, smsTracker);
                return;
            }
            if (((CommandException)asyncResult.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && smsTracker.mRetryCount < 3) {
                smsTracker.mRetryCount = 1 + smsTracker.mRetryCount;
                this.sendMessageDelayed(this.obtainMessage(3, smsTracker), 2000L);
                return;
            }
            if (smsTracker.mSentIntent != null) {
                int n2 = 1;
                if (((CommandException)asyncResult.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                    n2 = 6;
                }
                try {
                    Intent intent = new Intent();
                    if (asyncResult.result != null) {
                        intent.putExtra("errorCode", ((SmsResponse)asyncResult.result).errorCode);
                    }
                    if (mRemainingMessages > -1) {
                        --mRemainingMessages;
                    }
                    if (mRemainingMessages == 0) {
                        intent.putExtra(SEND_NEXT_MSG_EXTRA, true);
                    }
                    smsTracker.mSentIntent.send(this.mContext, n2, intent);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void handleStatusReport(AsyncResult var1);

    /*
     * Unable to fully structure code
     */
    protected int processMessagePart(SmsMessageBase var1_1, SmsHeader.ConcatRef var2_2, SmsHeader.PortAddrs var3_3) {
        block16: {
            block17: {
                block15: {
                    block14: {
                        var4_4 = new StringBuilder("reference_number =");
                        var4_4.append(var2_2.refNumber);
                        var4_4.append(" AND address = ?");
                        var7_5 = new String[]{var1_1.getOriginatingAddress()};
                        (byte[][])null;
                        var9_6 = null;
                        var9_6 = this.mResolver.query(this.mRawUri, SMSDispatcher.RAW_PROJECTION, var4_4.toString(), var7_5, null);
                        var14_7 = var9_6.getCount();
                        if (var14_7 == var2_2.msgCount - 1) break block14;
                        var15_8 = new ContentValues();
                        var15_8.put("date", new Long(var1_1.getTimestampMillis()));
                        var15_8.put("pdu", HexDump.toHexString(var1_1.getPdu()));
                        var15_8.put("address", var1_1.getOriginatingAddress());
                        var15_8.put("reference_number", var2_2.refNumber);
                        var15_8.put("count", var2_2.msgCount);
                        var15_8.put("sequence", var2_2.seqNumber);
                        if (var3_3 == null) ** GOTO lbl24
                        var15_8.put("destination_port", var3_3.destPort);
lbl24:
                        // 2 sources

                        this.mResolver.insert(this.mRawUri, var15_8);
                        var13_9 = 1;
                        if (var9_6 == null) ** GOTO lbl30
lbl28:
                        // 2 sources

                        while (true) {
                            var9_6.close();
lbl30:
                            // 3 sources

                            return var13_9;
                        }
                    }
                    var17_10 = var9_6.getColumnIndex("pdu");
                    var18_11 = var9_6.getColumnIndex("sequence");
                    var19_12 = new byte[var2_2.msgCount][];
                    for (var20_13 = 0; var20_13 < var14_7; ++var20_13) {
                        var9_6.moveToNext();
                        var19_12[(int)var9_6.getLong((int)var18_11) - 1] = HexDump.hexStringToByteArray(var9_6.getString(var17_10));
                        continue;
                    }
                    try {
                        var19_12[var2_2.seqNumber - 1] = var1_1.getPdu();
                        this.mResolver.delete(this.mRawUri, var4_4.toString(), var7_5);
                        if (var9_6 == null) break block15;
                    }
                    catch (SQLException var11_17) {
                        try {
                            Log.e("SMS", "Can't access multipart SMS database", var11_17);
                            var13_9 = 2;
                            if (var9_6 == null) ** continue;
                            ** continue;
                        }
                        catch (Throwable var10_18) {
                            if (var9_6 != null) {
                                var9_6.close();
                            }
                            throw var10_18;
                        }
                    }
                    var9_6.close();
                }
                if (var3_3 == null) break block16;
                if (var3_3.destPort != 2948) break block17;
                var23_14 = new ByteArrayOutputStream();
                for (var24_15 = 0; var24_15 < var2_2.msgCount; ++var24_15) {
                    var25_16 = SmsMessage.createFromPdu(var19_12[var24_15]).getUserData();
                    var23_14.write(var25_16, 0, var25_16.length);
                }
                return this.mWapPush.dispatchWapPdu(var23_14.toByteArray());
            }
            this.dispatchPortAddressedPdus(var19_12, var3_3.destPort);
lbl73:
            // 2 sources

            return -1;
        }
        this.dispatchPdus(var19_12);
        ** while (true)
    }

    protected abstract void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6);

    protected abstract void sendMultipartSms(SmsTracker var1);

    protected abstract void sendMultipartText(String var1, String var2, ArrayList<String> var3, ArrayList<PendingIntent> var4, ArrayList<PendingIntent> var5);

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendRawPdu(byte[] byArray, byte[] byArray2, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (byArray2 == null) {
            if (pendingIntent == null) return;
            pendingIntent.send(3);
            return;
        }
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("smsc", byArray);
        hashMap.put("pdu", byArray2);
        SmsTracker smsTracker = new SmsTracker(hashMap, pendingIntent, pendingIntent2);
        int n = this.mPhone.getServiceState().getState();
        if (n != 0) {
            this.handleNotInService(n, smsTracker);
            return;
        }
        String string2 = this.getAppNameByIntent(pendingIntent);
        if (this.mCounter.check(string2, 1)) {
            this.sendSms(smsTracker);
            return;
        }
        this.sendMessage(this.obtainMessage(7, smsTracker));
        return;
        catch (PendingIntent.CanceledException canceledException) {
            return;
        }
    }

    protected abstract void sendSms(SmsTracker var1);

    protected abstract void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5);

    protected abstract void setCellBroadcastConfig(int[] var1, Message var2);

    private class SmsCounter {
        private int mCheckPeriod;
        private int mMaxAllowed;
        private HashMap<String, ArrayList<Long>> mSmsStamp;

        SmsCounter(int n, int n2) {
            this.mMaxAllowed = n;
            this.mCheckPeriod = n2;
            this.mSmsStamp = new HashMap();
        }

        private boolean isUnderLimit(ArrayList<Long> arrayList, int n) {
            Long l = System.currentTimeMillis();
            Log.d(SMSDispatcher.TAG, "SMS send size=" + arrayList.size() + "time=" + l);
            while (arrayList.size() > 0 && l - arrayList.get(0) > (long)this.mCheckPeriod) {
                arrayList.remove(0);
            }
            if (n + arrayList.size() <= this.mMaxAllowed) {
                for (int i = 0; i < n; ++i) {
                    arrayList.add(l);
                }
                return true;
            }
            return false;
        }

        boolean check(String string2, int n) {
            if (!this.mSmsStamp.containsKey(string2)) {
                this.mSmsStamp.put(string2, new ArrayList());
            }
            return this.isUnderLimit(this.mSmsStamp.get(string2), n);
        }
    }

    protected static class SmsTracker {
        public HashMap mData;
        public PendingIntent mDeliveryIntent;
        public int mMessageRef;
        public int mRetryCount;
        public PendingIntent mSentIntent;

        SmsTracker(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
            this.mData = hashMap;
            this.mSentIntent = pendingIntent;
            this.mDeliveryIntent = pendingIntent2;
            this.mRetryCount = 0;
        }
    }
}

