/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.provider.Telephony;
import android.telephony.SmsMessage;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsHeader;
import java.util.Arrays;

public abstract class SmsMessageBase {
    private static final String LOG_TAG = "SMS";
    protected String emailBody;
    protected String emailFrom;
    protected int indexOnIcc = -1;
    protected boolean isEmail;
    protected boolean isMwi;
    protected byte[] mPdu;
    protected String messageBody;
    public int messageRef;
    protected boolean mwiDontStore;
    protected boolean mwiSense;
    protected SmsAddress originatingAddress;
    protected String pseudoSubject;
    protected String scAddress;
    protected long scTimeMillis;
    protected int statusOnIcc = -1;
    protected byte[] userData;
    protected SmsHeader userDataHeader;

    protected void extractEmailAddressFromMessageBody() {
        String[] stringArray = this.messageBody.split("( /)|( )", 2);
        if (stringArray.length < 2) {
            return;
        }
        this.emailFrom = stringArray[0];
        this.emailBody = stringArray[1];
        this.isEmail = Telephony.Mms.isEmailAddress(this.emailFrom);
    }

    public String getDisplayMessageBody() {
        if (this.isEmail) {
            return this.emailBody;
        }
        return this.getMessageBody();
    }

    public String getDisplayOriginatingAddress() {
        if (this.isEmail) {
            return this.emailFrom;
        }
        return this.getOriginatingAddress();
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public int getIndexOnIcc() {
        return this.indexOnIcc;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public abstract SmsMessage.MessageClass getMessageClass();

    public String getOriginatingAddress() {
        if (this.originatingAddress == null) {
            return null;
        }
        return this.originatingAddress.getAddressString();
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    public abstract int getProtocolIdentifier();

    public String getPseudoSubject() {
        if (this.pseudoSubject == null) {
            return "";
        }
        return this.pseudoSubject;
    }

    public String getServiceCenterAddress() {
        return this.scAddress;
    }

    public abstract int getStatus();

    public int getStatusOnIcc() {
        return this.statusOnIcc;
    }

    public long getTimestampMillis() {
        return this.scTimeMillis;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public SmsHeader getUserDataHeader() {
        return this.userDataHeader;
    }

    public abstract boolean isCphsMwiMessage();

    public boolean isEmail() {
        return this.isEmail;
    }

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    public abstract boolean isReplace();

    public abstract boolean isReplyPathPresent();

    public abstract boolean isStatusReportMessage();

    protected void parseMessageBody() {
        if (this.originatingAddress != null && this.originatingAddress.couldBeEmailGateway()) {
            this.extractEmailAddressFromMessageBody();
        }
    }

    public static abstract class SubmitPduBase {
        public byte[] encodedMessage;
        public byte[] encodedScAddress;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }
    }

    public static class TextEncodingDetails {
        public int codeUnitCount;
        public int codeUnitSize;
        public int codeUnitsRemaining;
        public int msgCount;

        public String toString() {
            return "TextEncodingDetails { msgCount=" + this.msgCount + ", codeUnitCount=" + this.codeUnitCount + ", codeUnitsRemaining=" + this.codeUnitsRemaining + ", codeUnitSize=" + this.codeUnitSize + " }";
        }
    }
}

