/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.WspTypeDecoder;

public class WapPushOverSms {
    private static final String LOG_TAG = "WAP PUSH";
    private final int WAKE_LOCK_TIMEOUT;
    private final Context mContext;
    private SMSDispatcher mSmsDispatcher;
    private WspTypeDecoder pduDecoder;

    public WapPushOverSms(Phone phone, SMSDispatcher sMSDispatcher) {
        this.WAKE_LOCK_TIMEOUT = 5000;
        this.mSmsDispatcher = sMSDispatcher;
        this.mContext = phone.getContext();
    }

    private void dispatchWapPdu_MMS(byte[] byArray, int n, int n2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        int n5 = n3 + n4;
        byte[] byArray3 = new byte[byArray.length - n5];
        System.arraycopy(byArray, n5, byArray3, 0, byArray3.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType("application/vnd.wap.mms-message");
        intent.putExtra("transactionId", n);
        intent.putExtra("pduType", n2);
        intent.putExtra("header", byArray2);
        intent.putExtra("data", byArray3);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_MMS");
    }

    private void dispatchWapPdu_PushCO(byte[] byArray, int n, int n2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType("application/vnd.wap.coc");
        intent.putExtra("transactionId", n);
        intent.putExtra("pduType", n2);
        intent.putExtra("header", byArray2);
        intent.putExtra("data", byArray);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    private void dispatchWapPdu_default(byte[] byArray, int n, int n2, String string2, int n3, int n4) {
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        int n5 = n3 + n4;
        byte[] byArray3 = new byte[byArray.length - n5];
        System.arraycopy(byArray, n5, byArray3, 0, byArray3.length);
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType(string2);
        intent.putExtra("transactionId", n);
        intent.putExtra("pduType", n2);
        intent.putExtra("header", byArray2);
        intent.putExtra("data", byArray3);
        this.mSmsDispatcher.dispatch(intent, "android.permission.RECEIVE_WAP_PUSH");
    }

    /*
     * Enabled aggressive block sorting
     */
    public int dispatchWapPdu(byte[] byArray) {
        int n;
        WspTypeDecoder wspTypeDecoder;
        Log.d(LOG_TAG, "Rx: " + IccUtils.bytesToHexString(byArray));
        int n2 = 0 + 1;
        int n3 = 0xFF & byArray[0];
        int n4 = n2 + 1;
        int n5 = 0xFF & byArray[n2];
        if (n5 != 6 && n5 != 7) {
            Log.w(LOG_TAG, "Received non-PUSH WAP PDU. Type = " + n5);
            return 1;
        }
        this.pduDecoder = wspTypeDecoder = new WspTypeDecoder(byArray);
        if (!this.pduDecoder.decodeUintvarInteger(n4)) {
            Log.w(LOG_TAG, "Received PDU. Header Length error.");
            return 2;
        }
        int n6 = (int)this.pduDecoder.getValue32();
        int n7 = 2 + this.pduDecoder.getDecodedDataLength();
        if (!this.pduDecoder.decodeContentType(n7)) {
            Log.w(LOG_TAG, "Received PDU. Header Content-Type error.");
            return 2;
        }
        String string2 = this.pduDecoder.getValueString();
        if (string2 == null) {
            n = (int)this.pduDecoder.getValue32();
            switch (n) {
                default: {
                    Log.w(LOG_TAG, "Received PDU. Unsupported Content-Type = " + n);
                    return 1;
                }
                case 74: {
                    string2 = "application/vnd.oma.drm.rights+xml";
                    break;
                }
                case 75: {
                    string2 = "application/vnd.oma.drm.rights+wbxml";
                    break;
                }
                case 46: {
                    string2 = "application/vnd.wap.sic";
                    break;
                }
                case 48: {
                    string2 = "application/vnd.wap.slc";
                    break;
                }
                case 50: {
                    string2 = "application/vnd.wap.coc";
                    break;
                }
                case 62: {
                    string2 = "application/vnd.wap.mms-message";
                    break;
                }
                case 784: {
                    string2 = "application/vnd.docomo.pf";
                    break;
                }
                case 786: {
                    string2 = "application/vnd.omaloc-supl-init";
                    break;
                }
            }
        } else if (string2.equals("application/vnd.oma.drm.rights+xml")) {
            n = 74;
        } else if (string2.equals("application/vnd.oma.drm.rights+wbxml")) {
            n = 75;
        } else if (string2.equals("application/vnd.wap.sic")) {
            n = 46;
        } else if (string2.equals("application/vnd.wap.slc")) {
            n = 48;
        } else if (string2.equals("application/vnd.wap.coc")) {
            n = 50;
        } else if (string2.equals("application/vnd.wap.mms-message")) {
            n = 62;
        } else if (string2.equals("application/vnd.docomo.pf")) {
            n = 784;
        } else {
            if (!string2.equals("application/vnd.omaloc-supl-init")) {
                Log.w(LOG_TAG, "Received PDU. Unknown Content-Type = " + string2);
                return 1;
            }
            n = 786;
        }
        int cfr_ignored_0 = n7 + this.pduDecoder.getDecodedDataLength();
        boolean bl = false;
        switch (n) {
            case 50: {
                this.dispatchWapPdu_PushCO(byArray, n3, n5, n7, n6);
                bl = true;
            }
            default: {
                break;
            }
            case 62: {
                this.dispatchWapPdu_MMS(byArray, n3, n5, n7, n6);
                return -1;
            }
        }
        if (bl) return -1;
        this.dispatchWapPdu_default(byArray, n3, n5, string2, n7, n6);
        return -1;
    }
}

