/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

public class WspTypeDecoder {
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_WBXML = "application/vnd.oma.drm.rights+wbxml";
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_XML = "application/vnd.oma.drm.rights+xml";
    public static final String CONTENT_MIME_TYPE_B_MMS = "application/vnd.wap.mms-message";
    public static final String CONTENT_MIME_TYPE_B_PUSH_CO = "application/vnd.wap.coc";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SI = "application/vnd.wap.sic";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SL = "application/vnd.wap.slc";
    public static final String CONTENT_MIME_TYPE_B_SUPL_INIT = "application/vnd.omaloc-supl-init";
    public static final String CONTENT_MIME_TYPE_B_VND_DOCOMO_PF = "application/vnd.docomo.pf";
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_WBXML = 75;
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_XML = 74;
    public static final int CONTENT_TYPE_B_MMS = 62;
    public static final int CONTENT_TYPE_B_PUSH_CO = 50;
    public static final int CONTENT_TYPE_B_PUSH_SI = 46;
    public static final int CONTENT_TYPE_B_PUSH_SL = 48;
    public static final int CONTENT_TYPE_B_SUPL_INIT = 786;
    public static final int CONTENT_TYPE_B_VND_DOCOMO_PF = 784;
    public static final int PARAMETER_ID_X_WAP_APPLICATION_ID = 47;
    public static final int PDU_TYPE_CONFIRMED_PUSH = 7;
    public static final int PDU_TYPE_PUSH = 6;
    private static final int WAP_PDU_LENGTH_QUOTE = 31;
    private static final int WAP_PDU_SHORT_LENGTH_MAX = 30;
    int dataLength;
    String stringValue;
    long unsigned32bit;
    byte[] wspData;

    public WspTypeDecoder(byte[] byArray) {
        this.wspData = byArray;
    }

    public boolean decodeConstrainedEncoding(int n) {
        if (this.decodeShortInteger(n)) {
            this.stringValue = null;
            return true;
        }
        return this.decodeExtensionMedia(n);
    }

    public boolean decodeContentLength(int n) {
        return this.decodeIntegerValue(n);
    }

    public boolean decodeContentLocation(int n) {
        return this.decodeTextString(n);
    }

    public boolean decodeContentType(int n) {
        if (!this.decodeValueLength(n)) {
            return this.decodeConstrainedEncoding(n);
        }
        int n2 = this.getDecodedDataLength();
        this.getValue32();
        if (this.decodeIntegerValue(n + n2)) {
            this.dataLength = n2 + this.dataLength;
            this.stringValue = null;
            return true;
        }
        if (this.decodeExtensionMedia(n + n2)) {
            this.dataLength = n2 + this.dataLength;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean decodeExtensionMedia(int n) {
        int n2;
        this.dataLength = 0;
        this.stringValue = null;
        int n3 = this.wspData.length;
        boolean bl = n2 < n3;
        for (n2 = n; n2 < n3 && this.wspData[n2] != 0; ++n2) {
        }
        this.dataLength = 1 + (n2 - n);
        this.stringValue = new String(this.wspData, n, this.dataLength - 1);
        return bl;
    }

    public boolean decodeIntegerValue(int n) {
        if (this.decodeShortInteger(n)) {
            return true;
        }
        return this.decodeLongInteger(n);
    }

    public boolean decodeLongInteger(int n) {
        int n2 = 0xFF & this.wspData[n];
        if (n2 > 30) {
            return false;
        }
        this.unsigned32bit = 0L;
        for (int i = 1; i <= n2; ++i) {
            this.unsigned32bit = this.unsigned32bit << 8 | (long)(0xFF & this.wspData[n + i]);
        }
        this.dataLength = n2 + 1;
        return true;
    }

    public boolean decodeShortInteger(int n) {
        if ((0x80 & this.wspData[n]) == 0) {
            return false;
        }
        this.unsigned32bit = 0x7F & this.wspData[n];
        this.dataLength = 1;
        return true;
    }

    public boolean decodeTextString(int n) {
        int n2 = n;
        while (this.wspData[n2] != 0) {
            ++n2;
        }
        this.dataLength = 1 + (n2 - n);
        if (this.wspData[n] == 127) {
            this.stringValue = new String(this.wspData, n + 1, this.dataLength - 2);
            return true;
        }
        this.stringValue = new String(this.wspData, n, this.dataLength - 1);
        return true;
    }

    public boolean decodeUintvarInteger(int n) {
        int n2 = n;
        this.unsigned32bit = 0L;
        while ((0x80 & this.wspData[n2]) != 0) {
            if (n2 - n >= 4) {
                return false;
            }
            this.unsigned32bit = this.unsigned32bit << 7 | (long)(0x7F & this.wspData[n2]);
            ++n2;
        }
        this.unsigned32bit = this.unsigned32bit << 7 | (long)(0x7F & this.wspData[n2]);
        this.dataLength = 1 + (n2 - n);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeValueLength(int n) {
        if ((0xFF & this.wspData[n]) > 31) {
            return false;
        }
        if (this.wspData[n] < 31) {
            this.unsigned32bit = this.wspData[n];
            this.dataLength = 1;
            return true;
        }
        this.decodeUintvarInteger(n + 1);
        this.dataLength = 1 + this.dataLength;
        return true;
    }

    public boolean decodeXWapApplicationId(int n) {
        if (this.decodeIntegerValue(n)) {
            this.stringValue = null;
            return true;
        }
        return this.decodeTextString(n);
    }

    public boolean decodeXWapContentURI(int n) {
        return this.decodeTextString(n);
    }

    public boolean decodeXWapInitiatorURI(int n) {
        return this.decodeTextString(n);
    }

    public int getDecodedDataLength() {
        return this.dataLength;
    }

    public long getValue32() {
        return this.unsigned32bit;
    }

    public String getValueString() {
        return this.stringValue;
    }
}

