/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.ActivityManagerNative;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccException;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaDataConnectionTracker;
import com.android.internal.telephony.cdma.CdmaMmiCode;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.cdma.RuimCard;
import com.android.internal.telephony.cdma.RuimFileHandler;
import com.android.internal.telephony.cdma.RuimPhoneBookInterfaceManager;
import com.android.internal.telephony.cdma.RuimRecords;
import com.android.internal.telephony.cdma.RuimSmsInterfaceManager;
import com.android.internal.telephony.gsm.NetworkInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDMAPhone
extends PhoneBase {
    static final int CANCEL_ECM_TIMER = 1;
    private static final boolean DBG = true;
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    private static final int INVALID_SYSTEM_SELECTION_CODE = -1;
    private static final String IS683A_FEATURE_CODE = "*228";
    private static final int IS683A_FEATURE_CODE_NUM_DIGITS = 4;
    private static final int IS683A_SYS_SEL_CODE_NUM_DIGITS = 2;
    private static final int IS683A_SYS_SEL_CODE_OFFSET = 4;
    private static final int IS683_CONST_1900MHZ_A_BLOCK = 2;
    private static final int IS683_CONST_1900MHZ_B_BLOCK = 3;
    private static final int IS683_CONST_1900MHZ_C_BLOCK = 4;
    private static final int IS683_CONST_1900MHZ_D_BLOCK = 5;
    private static final int IS683_CONST_1900MHZ_E_BLOCK = 6;
    private static final int IS683_CONST_1900MHZ_F_BLOCK = 7;
    private static final int IS683_CONST_800MHZ_A_BAND = 0;
    private static final int IS683_CONST_800MHZ_B_BAND = 1;
    static final String LOG_TAG = "CDMA";
    static final int RESTART_ECM_TIMER = 0;
    private static final String UNACTIVATED_MIN2_VALUE = "000000";
    private static final String UNACTIVATED_MIN_VALUE = "1111110111";
    static final String VM_COUNT_CDMA = "vm_count_key_cdma";
    private static final String VM_NUMBER_CDMA = "vm_number_key_cdma";
    private static Pattern pOtaSpNumSchema = Pattern.compile("[,\\s]+");
    CdmaCallTracker mCT;
    private String mCarrierOtaSpNumSchema;
    private Registrant mEcmExitRespRegistrant;
    private RegistrantList mEcmTimerResetRegistrants;
    private RegistrantList mEriFileLoadedRegistrants;
    EriManager mEriManager;
    private String mEsn;
    private Runnable mExitEcmRunnable;
    private boolean mIsPhoneInEcmState;
    private String mMeid;
    private RegistrantList mNvLoadedRegistrants;
    ArrayList<CdmaMmiCode> mPendingMmis = new ArrayList();
    Registrant mPostDialHandler;
    RuimCard mRuimCard;
    RuimPhoneBookInterfaceManager mRuimPhoneBookInterfaceManager;
    RuimRecords mRuimRecords;
    RuimSmsInterfaceManager mRuimSmsInterfaceManager;
    CdmaSMSDispatcher mSMS;
    CdmaServiceStateTracker mSST;
    PhoneSubInfo mSubInfo;
    private String mVmNumber = null;
    PowerManager.WakeLock mWakeLock;

    public CDMAPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier) {
        this(context, commandsInterface, phoneNotifier, false);
    }

    public CDMAPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl) {
        super(phoneNotifier, context, commandsInterface, bl);
        this.mNvLoadedRegistrants = new RegistrantList();
        this.mEriFileLoadedRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new Runnable(){

            @Override
            public void run() {
                CDMAPhone.this.exitEmergencyCallbackMode();
            }
        };
        this.mCM.setPhoneType(2);
        this.mCT = new CdmaCallTracker(this);
        this.mSST = new CdmaServiceStateTracker(this);
        this.mSMS = new CdmaSMSDispatcher(this);
        this.mIccFileHandler = new RuimFileHandler(this);
        this.mRuimRecords = new RuimRecords(this);
        this.mDataConnection = new CdmaDataConnectionTracker(this);
        this.mRuimCard = new RuimCard(this);
        this.mRuimPhoneBookInterfaceManager = new RuimPhoneBookInterfaceManager(this);
        this.mRuimSmsInterfaceManager = new RuimSmsInterfaceManager(this, this.mSMS);
        this.mSubInfo = new PhoneSubInfo(this);
        this.mEriManager = new EriManager(this, context, 0);
        this.mCM.registerForAvailable(this, 1, null);
        this.mRuimRecords.registerForRecordsLoaded(this, 22, null);
        this.mCM.registerForOffOrNotAvailable(this, 8, null);
        this.mCM.registerForOn(this, 5, null);
        this.mCM.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttach(this, 19, null);
        this.mCM.registerForNVReady(this, 23, null);
        this.mCM.setEmergencyCallbackMode(this, 25, null);
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
        SystemProperties.set("gsm.current.phone-type", new Integer(2).toString());
        this.mIsPhoneInEcmState = SystemProperties.get("ril.cdma.inecmmode", "false").equals("true");
        if (this.mIsPhoneInEcmState) {
            this.mCM.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
        this.mCarrierOtaSpNumSchema = SystemProperties.get("ro.cdma.otaspnumschema", "");
        this.setSystemProperty("gsm.sim.operator.alpha", SystemProperties.get("ro.cdma.home.operator.alpha"));
        String string2 = SystemProperties.get("ro.cdma.home.operator.numeric");
        this.setSystemProperty("gsm.sim.operator.numeric", string2);
        this.setIsoCountryProperty(string2);
        this.updateCurrentCarrierInProvider(string2);
        phoneNotifier.notifyMessageWaitingChanged(this);
    }

    private boolean checkOtaSpNumBasedOnSysSelCode(int n, String[] stringArray) {
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(stringArray[1]);
            n2 = 0;
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(LOG_TAG, "checkOtaSpNumBasedOnSysSelCode, error", numberFormatException);
            return false;
        }
        while (true) {
            block5: {
                boolean bl = false;
                if (n2 < n3) {
                    if (TextUtils.isEmpty(stringArray[n2 + 2]) || TextUtils.isEmpty(stringArray[n2 + 3])) break block5;
                    int n4 = Integer.parseInt(stringArray[n2 + 2]);
                    int n5 = Integer.parseInt(stringArray[n2 + 3]);
                    if (n < n4 || n > n5) break block5;
                    bl = true;
                }
                return bl;
            }
            ++n2;
        }
    }

    private int extractSelCodeFromOtaSpNum(String string2) {
        int n = string2.length();
        int n2 = -1;
        if (string2.regionMatches(0, IS683A_FEATURE_CODE, 0, 4) && n >= 6) {
            n2 = Integer.parseInt(string2.substring(4, 6));
        }
        Log.d(LOG_TAG, "extractSelCodeFromOtaSpNum " + n2);
        return n2;
    }

    private void handleEnterEmergencyCallbackMode(Message message) {
        Log.d(LOG_TAG, "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.mIsPhoneInEcmState);
        if (!this.mIsPhoneInEcmState) {
            this.mIsPhoneInEcmState = true;
            this.sendEmergencyCallbackModeChange();
            this.setSystemProperty("ril.cdma.inecmmode", "true");
            long l = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, l);
            this.mWakeLock.acquire();
        }
    }

    private void handleExitEmergencyCallbackMode(Message message) {
        AsyncResult asyncResult = (AsyncResult)message.obj;
        Log.d(LOG_TAG, "handleExitEmergencyCallbackMode,ar.exception , mIsPhoneInEcmState " + asyncResult.exception + this.mIsPhoneInEcmState);
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyRegistrant(asyncResult);
        }
        if (asyncResult.exception == null) {
            if (this.mIsPhoneInEcmState) {
                this.mIsPhoneInEcmState = false;
                this.setSystemProperty("ril.cdma.inecmmode", "false");
            }
            this.sendEmergencyCallbackModeChange();
            this.mDataConnection.setDataEnabled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCarrierOtaSpNum(String string2) {
        int n = this.extractSelCodeFromOtaSpNum(string2);
        if (n == -1) {
            return false;
        }
        if (!TextUtils.isEmpty(this.mCarrierOtaSpNumSchema)) {
            Matcher matcher = pOtaSpNumSchema.matcher(this.mCarrierOtaSpNumSchema);
            Log.d(LOG_TAG, "isCarrierOtaSpNum,schema" + this.mCarrierOtaSpNumSchema);
            if (matcher.find()) {
                String[] stringArray = pOtaSpNumSchema.split(this.mCarrierOtaSpNumSchema);
                if (!TextUtils.isEmpty(stringArray[0]) && stringArray[0].equals("SELC")) {
                    if (n != -1) {
                        return this.checkOtaSpNumBasedOnSysSelCode(n, stringArray);
                    }
                    Log.d(LOG_TAG, "isCarrierOtaSpNum,sysSelCodeInt is invalid");
                    return false;
                }
                if (!TextUtils.isEmpty(stringArray[0]) && stringArray[0].equals("FC")) {
                    int n2 = Integer.parseInt(stringArray[1]);
                    if (string2.regionMatches(0, stringArray[2], 0, n2)) {
                        return true;
                    }
                    Log.d(LOG_TAG, "isCarrierOtaSpNum,not otasp number");
                    return false;
                }
                Log.d(LOG_TAG, "isCarrierOtaSpNum,ota schema not supported" + stringArray[0]);
                return false;
            }
            Log.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern not right" + this.mCarrierOtaSpNumSchema);
            return false;
        }
        Log.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern empty");
        return false;
    }

    private boolean isIs683OtaSpDialStr(String string2) {
        if (string2.length() == 4) {
            boolean bl = string2.equals(IS683A_FEATURE_CODE);
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
            }
            return bl2;
        }
        switch (this.extractSelCodeFromOtaSpNum(string2)) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIsoCountryProperty(String string2) {
        if (TextUtils.isEmpty(string2)) {
            this.setSystemProperty("gsm.sim.operator.iso-country", "");
            return;
        }
        String string3 = "";
        try {
            String string4;
            string3 = string4 = MccTable.countryCodeForMcc(Integer.parseInt(string2.substring(0, 3)));
        }
        catch (NumberFormatException numberFormatException) {
            Log.w(LOG_TAG, "countryCodeForMcc error" + numberFormatException);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Log.w(LOG_TAG, "countryCodeForMcc error" + stringIndexOutOfBoundsException);
        }
        this.setSystemProperty("gsm.sim.operator.iso-country", string3);
    }

    private void storeVoiceMailNumber(String string2) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit();
        editor.putString(VM_NUMBER_CDMA, string2);
        editor.apply();
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mCT.acceptCall();
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        this.mSMS.activateCellBroadcastSms(n, message);
    }

    @Override
    public boolean canConference() {
        Log.e(LOG_TAG, "canConference: not possible in CDMA");
        return false;
    }

    @Override
    public boolean canTransfer() {
        Log.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public void conference() throws CallStateException {
        Log.e(LOG_TAG, "conference: not possible in CDMA");
    }

    @Override
    public Connection dial(String string2) throws CallStateException {
        String string3 = PhoneNumberUtils.stripSeparators(string2);
        return this.mCT.dial(string3);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo) throws CallStateException {
        throw new CallStateException("Sending UUS information NOT supported in CDMA!");
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(false);
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mRuimRecords.unregisterForRecordsLoaded(this);
            this.mCM.unregisterForAvailable(this);
            this.mCM.unregisterForOffOrNotAvailable(this);
            this.mCM.unregisterForOn(this);
            this.mCM.unregisterForNVReady(this);
            this.mSST.unregisterForNetworkAttach(this);
            this.mCM.unSetOnSuppServiceNotification(this);
            this.mPendingMmis.clear();
            this.mCT.dispose();
            this.mDataConnection.dispose();
            this.mSST.dispose();
            this.mSMS.dispose();
            this.mIccFileHandler.dispose();
            this.mRuimRecords.dispose();
            this.mRuimCard.dispose();
            this.mRuimPhoneBookInterfaceManager.dispose();
            this.mRuimSmsInterfaceManager.dispose();
            this.mSubInfo.dispose();
            this.mEriManager.dispose();
            return;
        }
    }

    @Override
    public boolean enableDataConnectivity() {
        if (this.mIsPhoneInEcmState) {
            ActivityManagerNative.broadcastStickyIntent(new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS"), null);
            return false;
        }
        if (this.mCT.state == Phone.State.OFFHOOK && this.mCT.isInEmergencyCall()) {
            return false;
        }
        return this.mDataConnection.setDataEnabled(true);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        this.mCM.setPreferredVoicePrivacy(bl, message);
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.mCM.exitEmergencyCallbackMode(this.obtainMessage(26));
    }

    @Override
    public void explicitCallTransfer() {
        Log.e(LOG_TAG, "explicitCallTransfer: not possible in CDMA");
    }

    protected void finalize() {
        Log.d(LOG_TAG, "CDMAPhone finalized");
        if (this.mWakeLock.isHeld()) {
            Log.e(LOG_TAG, "UNEXPECTED; mWakeLock is held when finalizing.");
            this.mWakeLock.release();
        }
    }

    @Override
    public void getAvailableNetworks(Message message) {
        Log.e(LOG_TAG, "getAvailableNetworks: not possible in CDMA");
    }

    @Override
    public CdmaCall getBackgroundCall() {
        return this.mCT.backgroundCall;
    }

    @Override
    public boolean getCallForwardingIndicator() {
        Log.e(LOG_TAG, "getCallForwardingIndicator: not possible in CDMA");
        return false;
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        Log.e(LOG_TAG, "getCallForwardingOption: not possible in CDMA");
    }

    @Override
    public void getCallWaiting(Message message) {
        this.mCM.queryCallWaiting(1, message);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return this.getServiceState().getCdmaEriIconIndex();
    }

    @Override
    public int getCdmaEriIconMode() {
        return this.getServiceState().getCdmaEriIconMode();
    }

    @Override
    public String getCdmaEriText() {
        int n = this.getServiceState().getCdmaRoamingIndicator();
        int n2 = this.getServiceState().getCdmaDefaultRoamingIndicator();
        return this.mEriManager.getCdmaEriText(n, n2);
    }

    @Override
    public String getCdmaMin() {
        return this.mSST.getCdmaMin();
    }

    @Override
    public String getCdmaPrlVersion() {
        return this.mSST.getPrlVersion();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        this.mSMS.getCellBroadcastSmsConfig(message);
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mSST.cellLoc;
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mDataConnection.getAllDataConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState dataActivityState = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentCdmaDataConnectionState() != 0) return dataActivityState;
        switch (2.$SwitchMap$com$android$internal$telephony$DataConnectionTracker$Activity[this.mDataConnection.getActivity().ordinal()]) {
            default: {
                return dataActivityState;
            }
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: 
        }
        return Phone.DataActivityState.DORMANT;
    }

    @Override
    public void getDataCallList(Message message) {
        this.mCM.getDataCallList(message);
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        Phone.DataState dataState = Phone.DataState.DISCONNECTED;
        if (this.mSST == null) {
            return Phone.DataState.DISCONNECTED;
        }
        if (this.mSST.getCurrentCdmaDataConnectionState() != 0) {
            return Phone.DataState.DISCONNECTED;
        }
        switch (this.mDataConnection.getState()) {
            default: {
                return dataState;
            }
            case FAILED: 
            case IDLE: {
                return Phone.DataState.DISCONNECTED;
            }
            case CONNECTED: 
            case DISCONNECTING: {
                if (this.mCT.state != Phone.State.IDLE && !this.mSST.isConcurrentVoiceAndData()) {
                    return Phone.DataState.SUSPENDED;
                }
                return Phone.DataState.CONNECTED;
            }
            case INITING: 
            case CONNECTING: 
            case SCANNING: 
        }
        return Phone.DataState.CONNECTING;
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDataConnection.getDataOnRoamingEnabled();
    }

    @Override
    public String getDeviceId() {
        String string2 = this.getMeid();
        if (string2 == null || string2.matches("^0*$")) {
            Log.d(LOG_TAG, "getDeviceId(): MEID is not initialized use ESN");
            string2 = this.getEsn();
        }
        return string2;
    }

    @Override
    public String getDeviceSvn() {
        Log.d(LOG_TAG, "getDeviceSvn(): return 0");
        return "0";
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        this.mCM.getPreferredVoicePrivacy(message);
    }

    @Override
    public String getEsn() {
        return this.mEsn;
    }

    @Override
    public CdmaCall getForegroundCall() {
        return this.mCT.foregroundCall;
    }

    @Override
    public IccCard getIccCard() {
        return this.mRuimCard;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return this.mIccFileHandler;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mRuimPhoneBookInterfaceManager;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mRuimRecords.getRecordsLoaded();
    }

    @Override
    public String getIccSerialNumber() {
        return this.mRuimRecords.iccid;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mRuimSmsInterfaceManager;
    }

    @Override
    public String getLine1AlphaTag() {
        Log.e(LOG_TAG, "getLine1AlphaTag: not possible in CDMA");
        return null;
    }

    @Override
    public String getLine1Number() {
        return this.mSST.getMdnNumber();
    }

    @Override
    public String getMeid() {
        return this.mMeid;
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.getVoiceMessageCount() > 0;
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getNeighboringCids(Message message) {
        if (message != null) {
            CommandException commandException = new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED);
            AsyncResult.forMessage((Message)message).exception = commandException;
            message.sendToTarget();
        }
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        Log.e(LOG_TAG, "getOutgoingCallerIdDisplay: not possible in CDMA");
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMmis;
    }

    @Override
    public String getPhoneName() {
        return LOG_TAG;
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public int getPhoneType() {
        return 2;
    }

    @Override
    public CdmaCall getRingingCall() {
        return this.mCT.ringingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSST.ss;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mSST.mSignalStrength;
    }

    @Override
    public Phone.State getState() {
        return this.mCT.state;
    }

    @Override
    public String getSubscriberId() {
        return this.mSST.getImsi();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        if ("" == null || "".length() == 0) {
            return ((Object)this.mContext.getText(0x1040004)).toString();
        }
        return "";
    }

    @Override
    public String getVoiceMailNumber() {
        return PreferenceManager.getDefaultSharedPreferences(this.getContext()).getString(VM_NUMBER_CDMA, "*86");
    }

    @Override
    public int getVoiceMessageCount() {
        int n = this.mRuimRecords.getVoiceMessageCount();
        if (n == 0) {
            n = PreferenceManager.getDefaultSharedPreferences(this.getContext()).getInt(VM_COUNT_CDMA, 0);
        }
        return n;
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) {
        Log.e(LOG_TAG, "method handleInCallMmiCommands is NOT supported in CDMA!");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                super.handleMessage(message);
                return;
            }
            case 1: {
                this.mCM.getBasebandVersion(this.obtainMessage(6));
                this.mCM.getDeviceIdentity(this.obtainMessage(21));
                return;
            }
            case 6: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) return;
                Log.d(LOG_TAG, "Baseband version: " + asyncResult.result);
                this.setSystemProperty("gsm.version.baseband", (String)asyncResult.result);
                return;
            }
            case 21: {
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (asyncResult.exception != null) return;
                String[] stringArray = (String[])asyncResult.result;
                this.mEsn = stringArray[2];
                this.mMeid = stringArray[3];
                return;
            }
            case 25: {
                this.handleEnterEmergencyCallbackMode(message);
                return;
            }
            case 26: {
                this.handleExitEmergencyCallbackMode(message);
                return;
            }
            case 22: {
                Log.d(LOG_TAG, "Event EVENT_RUIM_RECORDS_LOADED Received");
                return;
            }
            case 8: {
                Log.d(LOG_TAG, "Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                return;
            }
            case 5: {
                Log.d(LOG_TAG, "Event EVENT_RADIO_ON Received");
                return;
            }
            case 2: {
                Log.d(LOG_TAG, "Event EVENT_SSN Received");
                return;
            }
            case 19: {
                Log.d(LOG_TAG, "Event EVENT_REGISTERED_TO_NETWORK Received");
                return;
            }
            case 23: {
                Log.d(LOG_TAG, "Event EVENT_NV_READY Received");
                this.mEriManager.loadEriFile();
                this.mNvLoadedRegistrants.notifyRegistrants();
                if (!this.mEriManager.isEriFileLoaded()) return;
                Log.d(LOG_TAG, "ERI read, notify registrants");
                this.mEriFileLoadedRegistrants.notifyRegistrants();
                return;
            }
            case 20: {
                Message message2;
                AsyncResult asyncResult = (AsyncResult)message.obj;
                if (IccException.class.isInstance(asyncResult.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    asyncResult.exception = null;
                }
                if ((message2 = (Message)asyncResult.userObj) == null) return;
                AsyncResult.forMessage(message2, asyncResult.result, asyncResult.exception);
                message2.sendToTarget();
                return;
            }
        }
    }

    @Override
    public boolean handlePinMmi(String string2) {
        CdmaMmiCode cdmaMmiCode = CdmaMmiCode.newFromDialString(string2, this);
        if (cdmaMmiCode == null) {
            Log.e(LOG_TAG, "Mmi is NULL!");
            return false;
        }
        if (cdmaMmiCode.isPukCommand()) {
            this.mPendingMmis.add(cdmaMmiCode);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, cdmaMmiCode, null));
            cdmaMmiCode.processCode();
            return true;
        }
        Log.e(LOG_TAG, "Unrecognized mmi!");
        return false;
    }

    void handleTimerInEmergencyCallbackMode(int n) {
        switch (n) {
            default: {
                Log.e(LOG_TAG, "handleTimerInEmergencyCallbackMode, unsupported action " + n);
                return;
            }
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                this.mEcmTimerResetRegistrants.notifyResult(new Boolean(true));
                return;
            }
            case 0: 
        }
        long l = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
        this.postDelayed(this.mExitEcmRunnable, l);
        this.mEcmTimerResetRegistrants.notifyResult(new Boolean(false));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDataConnectivityPossible() {
        if (this.mDataConnection.getDataEnabled() && this.getDataConnectionState() == Phone.DataState.DISCONNECTED) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        if (this.getIccCard().getState() != IccCard.State.READY) return false;
        if (this.getServiceState().getState() != 0) return false;
        if (this.mDataConnection.getDataOnRoamingEnabled()) return true;
        if (this.getServiceState().getRoaming()) return false;
        return true;
    }

    boolean isInCall() {
        Call.State state = ((CdmaCall)this.getForegroundCall()).getState();
        Call.State state2 = ((CdmaCall)this.getBackgroundCall()).getState();
        Call.State state3 = ((CdmaCall)this.getRingingCall()).getState();
        return state.isAlive() || state2.isAlive() || state3.isAlive();
    }

    @Override
    public boolean isMinInfoReady() {
        return this.mSST.isMinInfoReady();
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        String string3 = PhoneNumberUtils.extractNetworkPortionAlt((String)string2);
        boolean bl = false;
        if (string3 != null && !(bl = this.isIs683OtaSpDialStr(string3))) {
            bl = this.isCarrierOtaSpNum(string3);
        }
        Log.d(LOG_TAG, "isOtaSpNumber " + bl);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean needsOtaServiceProvisioning() {
        boolean bl;
        String string2 = this.getCdmaMin();
        if (string2 == null || string2.length() < 6) {
            Log.d(LOG_TAG, "needsOtaServiceProvisioning: illegal cdmaMin='" + string2 + "' assume provisioning needed.");
            bl = true;
        } else {
            bl = string2.equals(UNACTIVATED_MIN_VALUE) || string2.substring(0, 6).equals(UNACTIVATED_MIN2_VALUE) || SystemProperties.getBoolean("test_cdma_setup", false);
        }
        Log.d(LOG_TAG, "needsOtaServiceProvisioning: ret=" + bl);
        return bl;
    }

    void notifyDisconnect(Connection connection) {
        this.mDisconnectRegistrants.notifyResult(connection);
    }

    void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    void notifyNewRingingConnection(Connection connection) {
        super.notifyNewRingingConnectionP(connection);
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState serviceState) {
        super.notifyServiceStateChangedP(serviceState);
    }

    void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    void onMMIDone(CdmaMmiCode cdmaMmiCode) {
        if (this.mPendingMmis.remove(cdmaMmiCode)) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, cdmaMmiCode, null));
        }
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        this.mCT.registerForCallWaiting(handler, n, object);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        this.mCM.registerForCdmaOtaProvision(handler, n, object);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        this.mEcmTimerResetRegistrants.addUnique(handler, n, object);
    }

    public void registerForEriFileLoaded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mEriFileLoadedRegistrants.add(registrant);
    }

    public void registerForNvLoaded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.mNvLoadedRegistrants.add(registrant);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        this.mSST.registerForSubscriptionInfoReady(handler, n, object);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        Log.e(LOG_TAG, "method registerForSuppServiceNotification is NOT supported in CDMA!");
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    public void removeReferences() {
        this.mRuimPhoneBookInterfaceManager = null;
        this.mRuimSmsInterfaceManager = null;
        this.mSMS = null;
        this.mSubInfo = null;
        this.mRuimRecords = null;
        this.mIccFileHandler = null;
        this.mRuimCard = null;
        this.mDataConnection = null;
        this.mCT = null;
        this.mSST = null;
        this.mEriManager = null;
    }

    @Override
    public void selectNetworkManually(NetworkInfo networkInfo, Message message) {
        Log.e(LOG_TAG, "selectNetworkManually: not possible in CDMA");
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        boolean bl = true;
        int n3 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n3 >= string2.length()) break block5;
                    if (PhoneNumberUtils.is12Key(string2.charAt(n3))) break block6;
                    Log.e(LOG_TAG, "sendDtmf called with invalid character '" + string2.charAt(n3) + "'");
                    bl = false;
                }
                if (this.mCT.state == Phone.State.OFFHOOK && bl) {
                    this.mCM.sendBurstDtmf(string2, n, n2, message);
                }
                return;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
            return;
        } else {
            if (this.mCT.state != Phone.State.OFFHOOK) return;
            this.mCM.sendDtmf(c, null);
            return;
        }
    }

    void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.mIsPhoneInEcmState);
        ActivityManagerNative.broadcastStickyIntent(intent, null);
        Log.d(LOG_TAG, "sendEmergencyCallbackModeChange");
    }

    @Override
    public void sendUssdResponse(String string2) {
        Log.e(LOG_TAG, "sendUssdResponse: not possible in CDMA");
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        Log.e(LOG_TAG, "setCallForwardingOption: not possible in CDMA");
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        Log.e(LOG_TAG, "method setCallWaiting is NOT supported in CDMA!");
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        this.mSMS.setCellBroadcastConfig(nArray, message);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        this.mDataConnection.setDataOnRoamingEnabled(bl);
    }

    @Override
    public void setLine1Number(String string2, String string3, Message message) {
        Log.e(LOG_TAG, "setLine1Number: not possible in CDMA");
    }

    @Override
    public void setMute(boolean bl) {
        this.mCT.setMute(bl);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        Log.e(LOG_TAG, "method setNetworkSelectionModeAutomatic is NOT supported in CDMA!");
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        this.mEcmExitRespRegistrant = new Registrant(handler, n, object);
    }

    @Override
    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        this.mPostDialHandler = new Registrant(handler, n, object);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        Log.e(LOG_TAG, "setOutgoingCallerIdDisplay: not possible in CDMA");
    }

    @Override
    public void setRadioPower(boolean bl) {
        this.mSST.setRadioPower(bl);
    }

    @Override
    public final void setSystemProperty(String string2, String string3) {
        super.setSystemProperty(string2, string3);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        this.mVmNumber = string3;
        Message message2 = this.obtainMessage(20, 0, 0, message);
        this.mRuimRecords.setVoiceMailNumber(string2, this.mVmNumber, message2);
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
            return;
        }
        this.mCM.startDtmf(c, null);
    }

    @Override
    public void stopDtmf() {
        this.mCM.stopDtmf(null);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        this.mCT.unregisterForCallWaiting(handler);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        this.mCM.unregisterForCdmaOtaProvision(handler);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        this.mEcmTimerResetRegistrants.remove(handler);
    }

    public void unregisterForEriFileLoaded(Handler handler) {
        this.mEriFileLoadedRegistrants.remove(handler);
    }

    public void unregisterForNvLoaded(Handler handler) {
        this.mNvLoadedRegistrants.remove(handler);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        this.mSST.unregisterForSubscriptionInfoReady(handler);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        Log.e(LOG_TAG, "method unregisterForSuppServiceNotification is NOT supported in CDMA!");
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        this.mEcmExitRespRegistrant.clear();
    }

    boolean updateCurrentCarrierInProvider(String string2) {
        if (!TextUtils.isEmpty(string2)) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues contentValues = new ContentValues();
                contentValues.put("numeric", string2);
                this.getContext().getContentResolver().insert(uri, contentValues);
                MccTable.updateMccMncConfiguration(this, string2);
                return true;
            }
            catch (SQLException sQLException) {
                Log.e(LOG_TAG, "Can't store current operator", sQLException);
            }
        }
        return false;
    }

    void updateMessageWaitingIndicator(int n) {
        this.mRuimRecords.setVoiceMessageWaiting(1, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateMessageWaitingIndicator(boolean bl) {
        RuimRecords ruimRecords = this.mRuimRecords;
        int n = bl ? -1 : 0;
        ruimRecords.setVoiceMessageWaiting(1, n);
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }
}

