/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.ArrayList;
import java.util.List;

public final class CdmaCallTracker
extends CallTracker {
    private static final boolean DBG_POLL = false;
    static final String LOG_TAG = "CDMA";
    static final int MAX_CONNECTIONS = 1;
    static final int MAX_CONNECTIONS_PER_CALL = 1;
    private static final boolean REPEAT_POLLING;
    CdmaCall backgroundCall;
    RegistrantList callWaitingRegistrants;
    CdmaConnection[] connections = new CdmaConnection[1];
    boolean desiredMute = false;
    ArrayList<CdmaConnection> droppedDuringPoll;
    CdmaCall foregroundCall;
    boolean hangupPendingMO;
    private boolean mIsEcmTimerCanceled = false;
    boolean mIsInEmergencyCall = false;
    int pendingCallClirMode;
    boolean pendingCallInEcm = false;
    CdmaConnection pendingMO;
    CDMAPhone phone;
    CdmaCall ringingCall;
    Phone.State state;
    RegistrantList voiceCallEndedRegistrants = new RegistrantList();
    RegistrantList voiceCallStartedRegistrants = new RegistrantList();

    CdmaCallTracker(CDMAPhone cDMAPhone) {
        this.callWaitingRegistrants = new RegistrantList();
        this.droppedDuringPoll = new ArrayList(1);
        this.ringingCall = new CdmaCall(this);
        this.foregroundCall = new CdmaCall(this);
        this.backgroundCall = new CdmaCall(this);
        this.state = Phone.State.IDLE;
        this.phone = cDMAPhone;
        this.cm = cDMAPhone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
        this.cm.registerForCallWaitingInfo(this, 15, null);
        this.foregroundCall.setGeneric(false);
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (this.mIsInEmergencyCall) {
            this.mIsInEmergencyCall = false;
            String string2 = SystemProperties.get("ril.cdma.inecmmode", "false");
            this.log("checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + string2);
            if (string2.compareTo("false") == 0) {
                this.phone.mDataConnection.setDataEnabled(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Connection checkMtFindNewRinging(DriverCall driverCall, int n) {
        CdmaConnection cdmaConnection;
        this.connections[n] = new CdmaConnection(this.phone.getContext(), driverCall, this, n);
        if (this.connections[n].getCall() == this.ringingCall) {
            cdmaConnection = this.connections[n];
            this.log("Notify new ring " + driverCall);
            return cdmaConnection;
        } else {
            Log.e(LOG_TAG, "Phantom call appeared " + driverCall);
            DriverCall.State state = driverCall.state;
            DriverCall.State state2 = DriverCall.State.ALERTING;
            cdmaConnection = null;
            if (state == state2) return cdmaConnection;
            DriverCall.State state3 = driverCall.state;
            DriverCall.State state4 = DriverCall.State.DIALING;
            cdmaConnection = null;
            if (state3 == state4) return cdmaConnection;
            this.connections[n].connectTime = System.currentTimeMillis();
            return null;
        }
    }

    private Connection dialThreeWay(String string2) {
        if (!this.foregroundCall.isIdle()) {
            this.disableDataCallInEmergencyCall(string2);
            this.pendingMO = new CdmaConnection(this.phone.getContext(), string2, this, this.foregroundCall);
            this.cm.sendCDMAFeatureCode(this.pendingMO.address, this.obtainMessage(16));
            return this.pendingMO;
        }
        return null;
    }

    private void disableDataCallInEmergencyCall(String string2) {
        if (PhoneNumberUtils.isEmergencyNumber(string2)) {
            this.log("disableDataCallInEmergencyCall");
            this.mIsInEmergencyCall = true;
            this.phone.disableDataConnectivity();
        }
    }

    private void fakeHoldForegroundBeforeDial() {
        List list = (List)this.foregroundCall.connections.clone();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((CdmaConnection)list.get(i)).fakeHoldBeforeDial();
        }
    }

    private void flashAndSetGenericTrue() throws CallStateException {
        this.cm.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.foregroundCall.setGeneric(true);
        this.phone.notifyPreciseCallStateChanged();
    }

    private Phone.SuppService getFailedService(int n) {
        switch (n) {
            default: {
                return Phone.SuppService.UNKNOWN;
            }
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: 
        }
        return Phone.SuppService.TRANSFER;
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        if (this.foregroundCall.connections.size() > 1) {
            this.foregroundCall.setGeneric(true);
        }
        this.ringingCall.setGeneric(false);
        new CdmaConnection(this.phone.getContext(), cdmaCallWaitingNotification, this, this.ringingCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cdmaCallWaitingNotification);
    }

    private void handleEcmTimer(int n) {
        this.phone.handleTimerInEmergencyCallbackMode(n);
        switch (n) {
            default: {
                Log.e(LOG_TAG, "handleEcmTimer, unsupported action " + n);
                return;
            }
            case 1: {
                this.mIsEcmTimerCanceled = true;
                return;
            }
            case 0: 
        }
        this.mIsEcmTimerCanceled = false;
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        if (this.callWaitingRegistrants != null) {
            this.callWaitingRegistrants.notifyRegistrants(new AsyncResult(null, cdmaCallWaitingNotification, null));
        }
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int n) {
        this.pendingOperations = 1 + this.pendingOperations;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void operationComplete() {
        --this.pendingOperations;
        if (this.pendingOperations == 0 && this.needsPoll) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
            return;
        } else {
            if (this.pendingOperations >= 0) return;
            Log.e(LOG_TAG, "CdmaCallTracker.pendingOperations < 0");
            this.pendingOperations = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePhoneState() {
        Phone.State state = this.state;
        this.state = this.ringingCall.isRinging() ? Phone.State.RINGING : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? Phone.State.OFFHOOK : Phone.State.IDLE);
        if (this.state == Phone.State.IDLE && state != this.state) {
            this.voiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (state == Phone.State.IDLE && state != this.state) {
            this.voiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("update phone state, old=" + (Object)((Object)state) + " new=" + (Object)((Object)this.state));
        if (this.state != state) {
            this.phone.notifyPhoneStateChanged();
        }
    }

    void acceptCall() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.cm.acceptCall(this.obtainCompleteMessage());
            return;
        }
        if (this.ringingCall.getState() == Call.State.WAITING) {
            CdmaConnection cdmaConnection = (CdmaConnection)this.ringingCall.getLatestConnection();
            cdmaConnection.updateParent(this.ringingCall, this.foregroundCall);
            cdmaConnection.onConnectedInOrOut();
            this.updatePhoneState();
            this.switchWaitingOrHoldingAndActive();
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    boolean canConference() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING && !this.backgroundCall.isFull() && !this.foregroundCall.isFull();
    }

    boolean canDial() {
        int n = this.phone.getServiceState().getState();
        String string2 = SystemProperties.get("ro.telephony.disable-call", "false");
        return n != 3 && this.pendingMO == null && !this.ringingCall.isRinging() && !string2.equals("true") && (!this.foregroundCall.getState().isAlive() || this.foregroundCall.getState() == Call.State.ACTIVE || !this.backgroundCall.getState().isAlive());
    }

    boolean canTransfer() {
        Log.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
    }

    void conference() throws CallStateException {
        this.flashAndSetGenericTrue();
    }

    Connection dial(String string2) throws CallStateException {
        return this.dial(string2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    Connection dial(String string2, int n) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        boolean bl = SystemProperties.get("ril.cdma.inecmmode", "false").equals("true");
        boolean bl2 = PhoneNumberUtils.isEmergencyNumber(string2);
        if (bl && bl2) {
            this.handleEcmTimer(1);
        }
        this.foregroundCall.setGeneric(false);
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(string2);
        }
        this.pendingMO = new CdmaConnection(this.phone.getContext(), string2, this, this.foregroundCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            this.pendingMO.cause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(string2);
            if (!bl || bl && bl2) {
                this.cm.dial(this.pendingMO.address, n, this.obtainCompleteMessage());
            } else {
                this.phone.exitEmergencyCallbackMode();
                this.phone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = n;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.phone.notifyPreciseCallStateChanged();
        return this.pendingMO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        this.cm.unregisterForCallWaitingInfo(this);
        for (CdmaConnection cdmaConnection : this.connections) {
            if (cdmaConnection == null) continue;
            try {
                this.hangup(cdmaConnection);
            }
            catch (CallStateException callStateException) {
                Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                this.hangup(this.pendingMO);
            }
        }
        catch (CallStateException callStateException) {
            Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    void explicitCallTransfer() throws CallStateException {
        this.cm.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    protected void finalize() {
        Log.d(LOG_TAG, "CdmaCallTracker finalized");
    }

    CdmaConnection getConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        int n2 = cdmaCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            CdmaConnection cdmaConnection = (CdmaConnection)cdmaCall.connections.get(i);
            if (cdmaConnection.getCDMAIndex() != n) continue;
            return cdmaConnection;
        }
        return null;
    }

    boolean getMute() {
        return this.desiredMute;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        int n = 0;
        block12: do {
            switch (n == 0 ? message.what : n) {
                default: {
                    throw new RuntimeException("unexpected event not handled");
                }
                case 1: {
                    Log.d(LOG_TAG, "Event EVENT_POLL_CALLS_RESULT Received");
                    AsyncResult cfr_ignored_1 = (AsyncResult)message.obj;
                    n = 8;
                    if (message != this.lastRelevantPoll) continue block12;
                    this.needsPoll = false;
                    this.lastRelevantPoll = null;
                    this.handlePollCalls((AsyncResult)message.obj);
                    return;
                }
                case 4: {
                    this.operationComplete();
                    return;
                }
                case 5: {
                    int n2;
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    this.operationComplete();
                    if (asyncResult.exception != null) {
                        n2 = 16;
                        Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                    } else {
                        n2 = ((int[])asyncResult.result)[0];
                    }
                    int n3 = 0;
                    int n4 = this.droppedDuringPoll.size();
                    while (true) {
                        if (n3 >= n4) {
                            this.updatePhoneState();
                            this.phone.notifyPreciseCallStateChanged();
                            this.droppedDuringPoll.clear();
                            return;
                        }
                        this.droppedDuringPoll.get(n3).onRemoteDisconnect(n2);
                        ++n3;
                    }
                }
                case 2: 
                case 3: {
                    this.pollCallsWhenSafe();
                    return;
                }
                case 9: {
                    this.handleRadioAvailable();
                    return;
                }
                case 10: {
                    this.handleRadioNotAvailable();
                    return;
                }
                case 14: {
                    if (this.pendingCallInEcm) {
                        this.cm.dial(this.pendingMO.address, this.pendingCallClirMode, this.obtainCompleteMessage());
                        this.pendingCallInEcm = false;
                    }
                    this.phone.unsetOnEcbModeExitResponse(this);
                    return;
                }
                case 15: {
                    AsyncResult asyncResult = (AsyncResult)message.obj;
                    if (asyncResult.exception != null) return;
                    this.handleCallWaitingInfo((CdmaCallWaitingNotification)asyncResult.result);
                    Log.d(LOG_TAG, "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                    return;
                }
                case 8: {
                    return;
                }
                case 16: {
                    if (((AsyncResult)message.obj).exception != null) return;
                    this.pendingMO.onConnectedInOrOut();
                    this.pendingMO = null;
                    return;
                }
            }
        } while (true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        int n;
        ArrayList arrayList;
        if (asyncResult.exception == null) {
            arrayList = (ArrayList)asyncResult.result;
        } else {
            if (!this.isCommandExceptionRadioNotAvailable(asyncResult.exception)) {
                this.pollCallsAfterDelay();
                return;
            }
            arrayList = new ArrayList();
        }
        Connection connection = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < (n = this.connections.length); ++i) {
            CdmaConnection cdmaConnection = this.connections[i];
            DriverCall driverCall = null;
            if (n2 < n3) {
                driverCall = (DriverCall)arrayList.get(n2);
                if (driverCall.index == i + 1) {
                    ++n2;
                } else {
                    driverCall = null;
                }
            }
            if (cdmaConnection == null && driverCall != null) {
                if (this.pendingMO != null && this.pendingMO.compareTo(driverCall)) {
                    this.connections[i] = this.pendingMO;
                    this.pendingMO.index = i;
                    this.pendingMO.update(driverCall);
                    this.pendingMO = null;
                    if (this.hangupPendingMO) {
                        this.hangupPendingMO = false;
                        if (this.mIsEcmTimerCanceled) {
                            this.handleEcmTimer(0);
                        }
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.connections[i]);
                            return;
                        }
                        catch (CallStateException callStateException) {
                            Log.e(LOG_TAG, "unexpected error on hangup");
                            return;
                        }
                    }
                } else {
                    this.log("pendingMo=" + this.pendingMO + ", dc=" + driverCall);
                    connection = this.checkMtFindNewRinging(driverCall, i);
                    if (connection == null) {
                        bl2 = true;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                bl = true;
                continue;
            }
            if (cdmaConnection != null && driverCall == null) {
                int n4 = this.foregroundCall.connections.size();
                for (int j = 0; j < n4; ++j) {
                    this.log("adding fgCall cn " + j + " to droppedDuringPoll");
                    CdmaConnection cdmaConnection2 = (CdmaConnection)this.foregroundCall.connections.get(j);
                    this.droppedDuringPoll.add(cdmaConnection2);
                }
                int n5 = this.ringingCall.connections.size();
                for (int j = 0; j < n5; ++j) {
                    this.log("adding rgCall cn " + j + " to droppedDuringPoll");
                    CdmaConnection cdmaConnection3 = (CdmaConnection)this.ringingCall.connections.get(j);
                    this.droppedDuringPoll.add(cdmaConnection3);
                }
                this.foregroundCall.setGeneric(false);
                this.ringingCall.setGeneric(false);
                if (this.mIsEcmTimerCanceled) {
                    this.handleEcmTimer(0);
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
                this.connections[i] = null;
                continue;
            }
            if (cdmaConnection == null || driverCall == null) continue;
            if (cdmaConnection.isIncoming != driverCall.isMT) {
                if (driverCall.isMT) {
                    this.droppedDuringPoll.add(cdmaConnection);
                    connection = this.checkMtFindNewRinging(driverCall, i);
                    if (connection == null) {
                        bl2 = true;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                Log.e(LOG_TAG, "Error in RIL, Phantom call appeared " + driverCall);
                continue;
            }
            boolean bl3 = cdmaConnection.update(driverCall);
            bl = bl || bl3;
        }
        if (this.pendingMO != null) {
            Log.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.foregroundCall.getState()));
            this.droppedDuringPoll.add(this.pendingMO);
            this.pendingMO = null;
            this.hangupPendingMO = false;
            if (this.pendingCallInEcm) {
                this.pendingCallInEcm = false;
            }
        }
        if (connection != null) {
            this.phone.notifyNewRingingConnection(connection);
        }
        for (int i = this.droppedDuringPoll.size() - 1; i >= 0; --i) {
            CdmaConnection cdmaConnection = this.droppedDuringPoll.get(i);
            if (cdmaConnection.isIncoming() && cdmaConnection.getConnectTime() == 0L) {
                Connection.DisconnectCause disconnectCause = cdmaConnection.cause == Connection.DisconnectCause.LOCAL ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                this.log("missed/rejected call, conn.cause=" + (Object)((Object)cdmaConnection.cause));
                this.log("setting cause to " + (Object)((Object)disconnectCause));
                this.droppedDuringPoll.remove(i);
                cdmaConnection.onDisconnect(disconnectCause);
                continue;
            }
            if (cdmaConnection.cause == Connection.DisconnectCause.LOCAL) {
                this.droppedDuringPoll.remove(i);
                cdmaConnection.onDisconnect(Connection.DisconnectCause.LOCAL);
                continue;
            }
            if (cdmaConnection.cause != Connection.DisconnectCause.INVALID_NUMBER) continue;
            this.droppedDuringPoll.remove(i);
            cdmaConnection.onDisconnect(Connection.DisconnectCause.INVALID_NUMBER);
        }
        if (this.droppedDuringPoll.size() > 0) {
            this.cm.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (connection != null || bl) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (bl2) {
            this.phone.notifyUnknownConnection();
        }
        if (!bl) {
            if (connection == null) return;
        }
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    void hangup(CdmaCall cdmaCall) throws CallStateException {
        if (cdmaCall.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (cdmaCall == this.ringingCall) {
            this.log("(ringing) hangup waiting or background");
            this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (cdmaCall == this.foregroundCall) {
            if (cdmaCall.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((CdmaConnection)cdmaCall.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else {
            if (cdmaCall != this.backgroundCall) {
                throw new RuntimeException("CdmaCall " + cdmaCall + "does not belong to CdmaCallTracker " + this);
            }
            if (this.ringingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(cdmaCall);
            } else {
                this.hangupWaitingOrBackground();
            }
        }
        cdmaCall.onHangupLocal();
        this.phone.notifyPreciseCallStateChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void hangup(CdmaConnection cdmaConnection) throws CallStateException {
        if (cdmaConnection.owner != this) {
            throw new CallStateException("CdmaConnection " + cdmaConnection + "does not belong to CdmaCallTracker " + this);
        }
        if (cdmaConnection == this.pendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            if (cdmaConnection.getCall() == this.ringingCall && this.ringingCall.getState() == Call.State.WAITING) {
                cdmaConnection.onLocalDisconnect();
                this.updatePhoneState();
                this.phone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                this.cm.hangupConnection(cdmaConnection.getCDMAIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException callStateException) {
                Log.w(LOG_TAG, "CdmaCallTracker WARN: hangup() on absent connection " + cdmaConnection);
            }
        }
        cdmaConnection.onHangupLocal();
    }

    void hangupAllConnections(CdmaCall cdmaCall) throws CallStateException {
        int n = cdmaCall.connections.size();
        for (int i = 0; i < n; ++i) {
            try {
                CdmaConnection cdmaConnection = (CdmaConnection)cdmaCall.connections.get(i);
                this.cm.hangupConnection(cdmaConnection.getCDMAIndex(), this.obtainCompleteMessage());
                continue;
            }
            catch (CallStateException callStateException) {
                Log.e(LOG_TAG, "hangupConnectionByIndex caught " + callStateException);
                break;
            }
        }
    }

    void hangupConnectionByIndex(CdmaCall cdmaCall, int n) throws CallStateException {
        int n2 = cdmaCall.connections.size();
        for (int i = 0; i < n2; ++i) {
            if (((CdmaConnection)cdmaCall.connections.get(i)).getCDMAIndex() != n) continue;
            this.cm.hangupConnection(n, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.cm.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[CdmaCallTracker] " + string2);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.callWaitingRegistrants.add(registrant);
    }

    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallEndedRegistrants.add(registrant);
    }

    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        Registrant registrant = new Registrant(handler, n, object);
        this.voiceCallStartedRegistrants.add(registrant);
    }

    void rejectCall() throws CallStateException {
        if (this.ringingCall.getState().isRinging()) {
            this.cm.rejectCall(this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("phone not ringing");
    }

    void separate(CdmaConnection cdmaConnection) throws CallStateException {
        if (cdmaConnection.owner != this) {
            throw new CallStateException("CdmaConnection " + cdmaConnection + "does not belong to CdmaCallTracker " + this);
        }
        try {
            this.cm.separateConnection(cdmaConnection.getCDMAIndex(), this.obtainCompleteMessage(12));
            return;
        }
        catch (CallStateException callStateException) {
            Log.w(LOG_TAG, "CdmaCallTracker WARN: separate() on absent connection " + cdmaConnection);
            return;
        }
    }

    void setMute(boolean bl) {
        this.desiredMute = bl;
        this.cm.setMute(this.desiredMute, null);
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.foregroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
            return;
        }
        this.cm.sendCDMAFeatureCode("", this.obtainMessage(8));
    }

    public void unregisterForCallWaiting(Handler handler) {
        this.callWaitingRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallEnded(Handler handler) {
        this.voiceCallEndedRegistrants.remove(handler);
    }

    public void unregisterForVoiceCallStarted(Handler handler) {
        this.voiceCallStartedRegistrants.remove(handler);
    }
}

