/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;

public class CdmaConnection
extends Connection {
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final String LOG_TAG = "CDMA";
    static final int PAUSE_DELAY_MILLIS = 2000;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;
    String address;
    Connection.DisconnectCause cause;
    String cnapName;
    int cnapNamePresentation;
    long connectTime;
    long connectTimeReal;
    long createTime;
    String dialString;
    long disconnectTime;
    boolean disconnected;
    long duration;
    Handler h;
    long holdingStartTime;
    int index;
    boolean isIncoming;
    private PowerManager.WakeLock mPartialWakeLock;
    int nextPostDialChar;
    int numberPresentation;
    CdmaCallTracker owner;
    CdmaCall parent;
    Connection.PostDialState postDialState;
    String postDialString;

    CdmaConnection(Context context, DriverCall driverCall, CdmaCallTracker cdmaCallTracker, int n) {
        this.cause = Connection.DisconnectCause.NOT_DISCONNECTED;
        this.postDialState = Connection.PostDialState.NOT_STARTED;
        this.numberPresentation = Connection.PRESENTATION_ALLOWED;
        this.cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = cdmaCallTracker;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = driverCall.number;
        this.isIncoming = driverCall.isMT;
        this.createTime = System.currentTimeMillis();
        this.cnapName = driverCall.name;
        this.cnapNamePresentation = driverCall.namePresentation;
        this.numberPresentation = driverCall.numberPresentation;
        this.index = n;
        this.parent = this.parentFromDCState(driverCall.state);
        this.parent.attach(this, driverCall);
    }

    CdmaConnection(Context context, CdmaCallWaitingNotification cdmaCallWaitingNotification, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        this.cause = Connection.DisconnectCause.NOT_DISCONNECTED;
        this.postDialState = Connection.PostDialState.NOT_STARTED;
        this.numberPresentation = Connection.PRESENTATION_ALLOWED;
        this.cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = cdmaCallTracker;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = cdmaCallWaitingNotification.number;
        this.numberPresentation = cdmaCallWaitingNotification.numberPresentation;
        this.cnapName = cdmaCallWaitingNotification.name;
        this.cnapNamePresentation = cdmaCallWaitingNotification.namePresentation;
        this.index = -1;
        this.isIncoming = true;
        this.createTime = System.currentTimeMillis();
        this.connectTime = 0L;
        this.parent = cdmaCall;
        cdmaCall.attachFake(this, Call.State.WAITING);
    }

    CdmaConnection(Context context, String string2, CdmaCallTracker cdmaCallTracker, CdmaCall cdmaCall) {
        block3: {
            block2: {
                this.cause = Connection.DisconnectCause.NOT_DISCONNECTED;
                this.postDialState = Connection.PostDialState.NOT_STARTED;
                this.numberPresentation = Connection.PRESENTATION_ALLOWED;
                this.cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
                this.createWakeLock(context);
                this.acquireWakeLock();
                this.owner = cdmaCallTracker;
                this.h = new MyHandler(this.owner.getLooper());
                this.dialString = string2;
                Log.d(LOG_TAG, "[CDMAConn] CdmaConnection: dialString=" + string2);
                String string3 = CdmaConnection.formatDialString(string2);
                Log.d(LOG_TAG, "[CDMAConn] CdmaConnection:formated dialString=" + string3);
                this.address = PhoneNumberUtils.extractNetworkPortionAlt((String)string3);
                this.postDialString = PhoneNumberUtils.extractPostDialPortion(string3);
                this.index = -1;
                this.isIncoming = false;
                this.cnapName = null;
                this.cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
                this.numberPresentation = Connection.PRESENTATION_ALLOWED;
                this.createTime = System.currentTimeMillis();
                if (cdmaCall == null) break block2;
                this.parent = cdmaCall;
                if (cdmaCall.state != Call.State.ACTIVE) break block3;
                cdmaCall.attachFake(this, Call.State.ACTIVE);
            }
            return;
        }
        cdmaCall.attachFake(this, Call.State.DIALING);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    private void createWakeLock(Context context) {
        this.mPartialWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, LOG_TAG);
    }

    private void doDisconnect() {
        this.index = -1;
        this.disconnectTime = System.currentTimeMillis();
        this.duration = SystemClock.elapsedRealtime() - this.connectTimeReal;
        this.disconnected = true;
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private static int findNextPCharOrNonPOrNonWCharIndex(String string2, int n) {
        boolean bl = CdmaConnection.isWait(string2.charAt(n));
        int n2 = n + 1;
        int n3 = string2.length();
        while (true) {
            block6: {
                block5: {
                    if (n2 >= n3) break block5;
                    char c = string2.charAt(n2);
                    if (CdmaConnection.isWait(c)) {
                        bl = true;
                    }
                    if (CdmaConnection.isWait(c) || CdmaConnection.isPause(c)) break block6;
                }
                if (n2 >= n3 || n2 <= n + 1 || bl || !CdmaConnection.isPause(string2.charAt(n))) break;
                return n + 1;
            }
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static char findPOrWCharToAppend(String string2, int n, int n2) {
        char c = CdmaConnection.isPause(string2.charAt(n)) ? (char)',' : ';';
        if (n2 <= n + 1) return c;
        return ';';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String formatDialString(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            block9: {
                char c;
                block8: {
                    if (n2 >= n) {
                        return PhoneNumberUtils.cdmaCheckAndProcessPlusCode((String)stringBuilder.toString());
                    }
                    c = string2.charAt(n2);
                    if (!CdmaConnection.isPause(c) && !CdmaConnection.isWait(c)) break block8;
                    if (n2 < n - 1) {
                        int n3 = CdmaConnection.findNextPCharOrNonPOrNonWCharIndex(string2, n2);
                        if (n3 < n) {
                            stringBuilder.append(CdmaConnection.findPOrWCharToAppend(string2, n2, n3));
                            if (n3 > n2 + 1) {
                                n2 = n3 - 1;
                            }
                            break block9;
                        } else if (n3 == n) {
                            n2 = n - 1;
                        }
                    }
                    break block9;
                }
                stringBuilder.append(c);
            }
            ++n2;
        }
    }

    private boolean isConnectingInOrOut() {
        return this.parent == null || this.parent == this.owner.ringingCall || this.parent.state == Call.State.DIALING || this.parent.state == Call.State.ALERTING;
    }

    private static boolean isPause(char c) {
        return c == ',';
    }

    private static boolean isWait(char c) {
        return c == ';';
    }

    private void log(String string2) {
        Log.d(LOG_TAG, "[CDMAConn] " + string2);
    }

    private void onStartedHolding() {
        this.holdingStartTime = SystemClock.elapsedRealtime();
    }

    private CdmaCall parentFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            default: {
                throw new RuntimeException("illegal call state: " + (Object)((Object)state));
            }
            case 1: 
            case 2: 
            case 3: {
                return this.owner.foregroundCall;
            }
            case 4: {
                return this.owner.backgroundCall;
            }
            case 5: 
            case 6: 
        }
        return this.owner.ringingCall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.owner.cm.sendDtmf(c, this.h.obtainMessage(1));
            return true;
        }
        if (c == ',') {
            this.setPostDialState(Connection.PostDialState.PAUSE);
            this.h.sendMessageDelayed(this.h.obtainMessage(2), 2000L);
            return true;
        }
        if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
            return true;
        }
        if (c != 'N') return false;
        this.setPostDialState(Connection.PostDialState.WILD);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPostDialState(Connection.PostDialState postDialState) {
        if (postDialState == Connection.PostDialState.STARTED || postDialState == Connection.PostDialState.PAUSE) {
            PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
            synchronized (wakeLock) {
                if (this.mPartialWakeLock.isHeld()) {
                    this.h.removeMessages(4);
                } else {
                    this.acquireWakeLock();
                }
                Message message = this.h.obtainMessage(4);
                this.h.sendMessageDelayed(message, 60000L);
            }
        } else {
            this.h.removeMessages(4);
            this.releaseWakeLock();
        }
        this.postDialState = postDialState;
    }

    @Override
    public void cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    boolean compareTo(DriverCall driverCall) {
        if (!this.isIncoming && !driverCall.isMT) {
            return true;
        }
        String string2 = PhoneNumberUtils.stringFromStringAndTOA(driverCall.number, driverCall.TOA);
        return this.isIncoming == driverCall.isMT && CdmaConnection.equalsHandlesNulls(this.address, string2);
    }

    Connection.DisconnectCause disconnectCauseFromCode(int n) {
        int n2;
        CDMAPhone cDMAPhone;
        switch (n) {
            default: {
                cDMAPhone = this.owner.phone;
                n2 = cDMAPhone.getServiceState().getState();
                if (n2 != 3) break;
                return Connection.DisconnectCause.POWER_OFF;
            }
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1000: {
                return Connection.DisconnectCause.CDMA_LOCKED_UNTIL_POWER_CYCLE;
            }
            case 1001: {
                return Connection.DisconnectCause.CDMA_DROP;
            }
            case 1002: {
                return Connection.DisconnectCause.CDMA_INTERCEPT;
            }
            case 1003: {
                return Connection.DisconnectCause.CDMA_REORDER;
            }
            case 1004: {
                return Connection.DisconnectCause.CDMA_SO_REJECT;
            }
            case 1005: {
                return Connection.DisconnectCause.CDMA_RETRY_ORDER;
            }
            case 1006: {
                return Connection.DisconnectCause.CDMA_ACCESS_FAILURE;
            }
            case 1007: {
                return Connection.DisconnectCause.CDMA_PREEMPTED;
            }
            case 1008: {
                return Connection.DisconnectCause.CDMA_NOT_EMERGENCY;
            }
            case 1009: {
                return Connection.DisconnectCause.CDMA_ACCESS_BLOCKED;
            }
        }
        if (n2 == 1 || n2 == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        if (cDMAPhone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && cDMAPhone.getIccCard().getState() != IccCard.State.READY) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (n == 16) {
            return Connection.DisconnectCause.NORMAL;
        }
        return Connection.DisconnectCause.ERROR_UNSPECIFIED;
    }

    public void dispose() {
    }

    void fakeHoldBeforeDial() {
        if (this.parent != null) {
            this.parent.detach(this);
        }
        this.parent = this.owner.backgroundCall;
        this.parent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Log.e(LOG_TAG, "[CdmaConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    int getCDMAIndex() throws CallStateException {
        if (this.index >= 0) {
            return 1 + this.index;
        }
        throw new CallStateException("CDMA connection index not assigned");
    }

    @Override
    public CdmaCall getCall() {
        return this.parent;
    }

    @Override
    public String getCnapName() {
        return this.cnapName;
    }

    @Override
    public int getCnapNamePresentation() {
        return this.cnapNamePresentation;
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Connection.DisconnectCause getDisconnectCause() {
        return this.cause;
    }

    @Override
    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    @Override
    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration == 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    @Override
    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    @Override
    public int getNumberPresentation() {
        return this.numberPresentation;
    }

    @Override
    public String getOrigDialString() {
        return this.dialString;
    }

    @Override
    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED) return "";
        if (this.postDialState == Connection.PostDialState.COMPLETE) return "";
        if (this.postDialString == null) return "";
        if (this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        String string2 = this.postDialString.substring(this.nextPostDialChar);
        if (string2 == null) return string2;
        int n = string2.indexOf(59);
        int n2 = string2.indexOf(44);
        if (n > 0) {
            if (n < n2) return string2.substring(0, n);
            if (n2 <= 0) {
                return string2.substring(0, n);
            }
        }
        if (n2 <= 0) return string2;
        return string2.substring(0, n2);
    }

    @Override
    public Call.State getState() {
        if (this.disconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    @Override
    public UUSInfo getUUSInfo() {
        return null;
    }

    @Override
    public void hangup() throws CallStateException {
        if (!this.disconnected) {
            this.owner.hangup(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    @Override
    public boolean isIncoming() {
        return this.isIncoming;
    }

    void onConnectedInOrOut() {
        this.connectTime = System.currentTimeMillis();
        this.connectTimeReal = SystemClock.elapsedRealtime();
        this.duration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.connectTime);
        if (!this.isIncoming) {
            this.processNextPostDialChar();
            return;
        }
        this.releaseWakeLock();
    }

    void onDisconnect(Connection.DisconnectCause disconnectCause) {
        this.cause = disconnectCause;
        if (!this.disconnected) {
            this.doDisconnect();
            Log.d(LOG_TAG, "[CDMAConn] onDisconnect: cause=" + (Object)((Object)disconnectCause));
            this.owner.phone.notifyDisconnect(this);
            if (this.parent != null) {
                this.parent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
    }

    void onHangupLocal() {
        this.cause = Connection.DisconnectCause.LOCAL;
    }

    void onLocalDisconnect() {
        if (!this.disconnected) {
            this.doDisconnect();
            Log.d(LOG_TAG, "[CDMAConn] onLoalDisconnect");
            if (this.parent != null) {
                this.parent.detach(this);
            }
        }
        this.releaseWakeLock();
    }

    void onRemoteDisconnect(int n) {
        this.onDisconnect(this.disconnectCauseFromCode(n));
    }

    @Override
    public void proceedAfterWaitChar() {
        if (this.postDialState != Connection.PostDialState.WAIT) {
            Log.w(LOG_TAG, "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        if (this.postDialState != Connection.PostDialState.WILD) {
            Log.w(LOG_TAG, "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(this.postDialString.substring(this.nextPostDialChar));
        this.postDialString = stringBuilder.toString();
        this.nextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.postDialString);
        this.processNextPostDialChar();
    }

    /*
     * Enabled aggressive block sorting
     */
    void processNextPostDialChar() {
        if (this.postDialState == Connection.PostDialState.CANCELLED) {
            this.releaseWakeLock();
            return;
        } else {
            Message message;
            Registrant registrant;
            char c;
            if (this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
                this.setPostDialState(Connection.PostDialState.COMPLETE);
                this.releaseWakeLock();
                c = '\u0000';
            } else {
                this.setPostDialState(Connection.PostDialState.STARTED);
                String string2 = this.postDialString;
                int n = this.nextPostDialChar;
                this.nextPostDialChar = n + 1;
                c = string2.charAt(n);
                if (!this.processPostDialChar(c)) {
                    this.h.obtainMessage(3).sendToTarget();
                    Log.e(LOG_TAG, "processNextPostDialChar: c=" + c + " isn't valid!");
                    return;
                }
            }
            if ((registrant = this.owner.phone.mPostDialHandler) == null || (message = registrant.messageForRegistrant()) == null) return;
            Connection.PostDialState postDialState = this.postDialState;
            AsyncResult asyncResult = AsyncResult.forMessage(message);
            asyncResult.result = this;
            asyncResult.userObj = postDialState;
            message.arg1 = c;
            message.sendToTarget();
            return;
        }
    }

    @Override
    public void separate() throws CallStateException {
        if (!this.disconnected) {
            this.owner.separate(this);
            return;
        }
        throw new CallStateException("disconnected");
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean update(DriverCall driverCall) {
        boolean bl;
        boolean bl2 = this.isConnectingInOrOut();
        boolean bl3 = this.getState() == Call.State.HOLDING;
        CdmaCall cdmaCall = this.parentFromDCState(driverCall.state);
        this.log("parent= " + this.parent + ", newParent= " + cdmaCall);
        boolean bl4 = CdmaConnection.equalsHandlesNulls(this.address, driverCall.number);
        boolean bl5 = false;
        if (!bl4) {
            this.log("update: phone # changed!");
            this.address = driverCall.number;
            bl5 = true;
        }
        if (TextUtils.isEmpty(driverCall.name)) {
            if (!TextUtils.isEmpty(this.cnapName)) {
                bl5 = true;
                this.cnapName = "";
            }
        } else if (!driverCall.name.equals(this.cnapName)) {
            bl5 = true;
            this.cnapName = driverCall.name;
        }
        this.log("--dssds----" + this.cnapName);
        this.cnapNamePresentation = driverCall.namePresentation;
        this.numberPresentation = driverCall.numberPresentation;
        if (cdmaCall != this.parent) {
            if (this.parent != null) {
                this.parent.detach(this);
            }
            cdmaCall.attach(this, driverCall);
            this.parent = cdmaCall;
            bl = true;
        } else {
            boolean bl6 = this.parent.update(this, driverCall);
            bl = bl5 || bl6;
        }
        this.log("Update, wasConnectingInOrOut=" + bl2 + ", wasHolding=" + bl3 + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + bl);
        if (bl2 && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (bl && !bl3 && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return bl;
    }

    public void updateParent(CdmaCall cdmaCall, CdmaCall cdmaCall2) {
        if (cdmaCall2 != cdmaCall) {
            if (cdmaCall != null) {
                cdmaCall.detach(this);
            }
            cdmaCall2.attachFake(this, Call.State.ACTIVE);
            this.parent = cdmaCall2;
        }
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    CdmaConnection.this.processNextPostDialChar();
                    return;
                }
                case 4: 
            }
            CdmaConnection.this.releaseWakeLock();
        }
    }
}

