/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.cdma.CDMAPhone;

public class CdmaDataConnection
extends DataConnection {
    private static final String LOG_TAG = "CDMA";
    private static final int PS_NET_DOWN_REASON_AUTH_FAILED = 29;
    private static final int PS_NET_DOWN_REASON_OPERATOR_DETERMINED_BARRING = 8;
    private static final int PS_NET_DOWN_REASON_OPTION_NOT_SUPPORTED = 32;
    private static final int PS_NET_DOWN_REASON_OPTION_UNSUBSCRIBED = 33;

    private CdmaDataConnection(CDMAPhone cDMAPhone, String string2) {
        super(cDMAPhone, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CdmaDataConnection makeDataConnection(CDMAPhone cDMAPhone) {
        Object object = mCountLock;
        synchronized (object) {
            mCount = 1 + mCount;
        }
        CdmaDataConnection cdmaDataConnection = new CdmaDataConnection(cDMAPhone, "CdmaDataConnection-" + mCount);
        cdmaDataConnection.start();
        cdmaDataConnection.log("Made " + cdmaDataConnection.getName());
        return cdmaDataConnection;
    }

    @Override
    protected DataConnection.FailCause getFailCauseFromRequest(int n) {
        switch (n) {
            default: {
                return DataConnection.FailCause.UNKNOWN;
            }
            case 8: {
                return DataConnection.FailCause.OPERATOR_BARRED;
            }
            case 29: {
                return DataConnection.FailCause.USER_AUTHENTICATION;
            }
            case 32: {
                return DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
            }
            case 33: 
        }
        return DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
    }

    @Override
    protected boolean isDnsOk(String[] stringArray) {
        return !"0.0.0.0".equals(stringArray[0]) || !"0.0.0.0".equals(stringArray[1]) || ((CDMAPhone)this.phone).isDnsCheckDisabled();
    }

    @Override
    protected void log(String string2) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onConnect(DataConnection.ConnectionParams connectionParams) {
        int n;
        this.log("CdmaDataConnection Connecting...");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        if (connectionParams.apn != null && connectionParams.apn.types.length > 0 && connectionParams.apn.types[0] != null && connectionParams.apn.types[0].equals("dun")) {
            this.log("CdmaDataConnection using DUN");
            n = 1;
        } else {
            n = 0;
        }
        Message message = this.obtainMessage(3, connectionParams);
        message.obj = connectionParams;
        this.phone.mCM.setupDataCall(Integer.toString(0), Integer.toString(n), null, null, null, Integer.toString(3), message);
    }

    @Override
    public String toString() {
        return "State=" + this.getCurrentState().getName() + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFasilCause=" + (Object)((Object)this.lastFailCause);
    }
}

