/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.IConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.AsyncResult;
import android.os.Message;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaDataConnection;
import com.android.internal.telephony.gsm.ApnSetting;
import java.util.ArrayList;

public final class CdmaDataConnectionTracker
extends DataConnectionTracker {
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_DOWN = 1;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    private static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    private static final int DATA_CONNECTION_POOL_SIZE = 1;
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.cdma-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    private static final int POLL_CONNECTION_MILLIS = 5000;
    private static final int TIME_DELAYED_TO_RESTART_RADIO = SystemProperties.getInt("ro.cdma.timetoradiorestart", 60000);
    private static final String[] mDefaultApnTypes;
    private static final String[] mSupportedApnTypes;
    protected final String LOG_TAG;
    private ArrayList<DataConnection> dataConnectionList;
    boolean failNextConnect = false;
    protected ApnSetting mActiveApn;
    private CdmaDataConnection mActiveDataConnection;
    private CDMAPhone mCdmaPhone;
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (!string2.equals("android.intent.action.SCREEN_ON")) {
                if (string2.equals("android.intent.action.SCREEN_OFF")) {
                    CdmaDataConnectionTracker.access$002(CdmaDataConnectionTracker.this, false);
                    CdmaDataConnectionTracker.this.stopNetStatPoll();
                    CdmaDataConnectionTracker.this.startNetStatPoll();
                    return;
                }
                if (string2.equals(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                    Log.d("CDMA", "Data reconnect alarm. Previous state was " + (Object)((Object)CdmaDataConnectionTracker.this.state));
                    String string3 = intent.getStringExtra(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                    if (CdmaDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                        CdmaDataConnectionTracker.this.cleanUpConnection(false, string3);
                    }
                    CdmaDataConnectionTracker.this.trySetupData(string3);
                    return;
                }
                if (string2.equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    CdmaDataConnectionTracker cdmaDataConnectionTracker = CdmaDataConnectionTracker.this;
                    boolean bl = networkInfo != null && networkInfo.isConnected();
                    CdmaDataConnectionTracker.access$502(cdmaDataConnectionTracker, bl);
                    return;
                }
                if (!string2.equals("android.net.wifi.WIFI_STATE_CHANGED")) return;
                if (intent.getIntExtra("wifi_state", 4) == 3) {
                    return;
                }
                boolean bl = false;
                if (bl) return;
                CdmaDataConnectionTracker.access$602(CdmaDataConnectionTracker.this, false);
                return;
            }
            CdmaDataConnectionTracker.access$002(CdmaDataConnectionTracker.this, true);
            CdmaDataConnectionTracker.this.stopNetStatPoll();
            CdmaDataConnectionTracker.this.startNetStatPoll();
        }
    };
    private boolean mIsScreenOn = true;
    private boolean mPendingRestartRadio = false;
    private Runnable mPollNetStat = new Runnable(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            long l = CdmaDataConnectionTracker.this.txPkts;
            long l2 = CdmaDataConnectionTracker.this.rxPkts;
            CdmaDataConnectionTracker.access$902(CdmaDataConnectionTracker.this, TrafficStats.getMobileTxPackets());
            CdmaDataConnectionTracker.access$1002(CdmaDataConnectionTracker.this, TrafficStats.getMobileRxPackets());
            if (CdmaDataConnectionTracker.this.netStatPollEnabled && (l > 0L || l2 > 0L)) {
                DataConnectionTracker.Activity activity;
                long l3 = CdmaDataConnectionTracker.this.txPkts - l;
                long l4 = CdmaDataConnectionTracker.this.rxPkts - l2;
                if (l3 > 0L && l4 > 0L) {
                    CdmaDataConnectionTracker.access$1402(CdmaDataConnectionTracker.this, 0L);
                    activity = DataConnectionTracker.Activity.DATAINANDOUT;
                } else if (l3 > 0L && l4 == 0L) {
                    if (CdmaDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                        CdmaDataConnectionTracker.access$1614(CdmaDataConnectionTracker.this, l3);
                    } else {
                        CdmaDataConnectionTracker.access$1702(CdmaDataConnectionTracker.this, 0L);
                    }
                    activity = DataConnectionTracker.Activity.DATAOUT;
                } else if (l3 == 0L && l4 > 0L) {
                    CdmaDataConnectionTracker.access$1802(CdmaDataConnectionTracker.this, 0L);
                    activity = DataConnectionTracker.Activity.DATAIN;
                } else if (l3 == 0L && l4 == 0L) {
                    activity = CdmaDataConnectionTracker.this.activity == DataConnectionTracker.Activity.DORMANT ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                } else {
                    CdmaDataConnectionTracker.access$2102(CdmaDataConnectionTracker.this, 0L);
                    activity = CdmaDataConnectionTracker.this.activity == DataConnectionTracker.Activity.DORMANT ? CdmaDataConnectionTracker.this.activity : DataConnectionTracker.Activity.NONE;
                }
                if (CdmaDataConnectionTracker.this.activity != activity) {
                    CdmaDataConnectionTracker.access$2502(CdmaDataConnectionTracker.this, activity);
                    CdmaDataConnectionTracker.this.phone.notifyDataActivity();
                }
            }
            if (CdmaDataConnectionTracker.this.sentSinceLastRecv >= 10L) {
                if (CdmaDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, CdmaDataConnectionTracker.this.sentSinceLastRecv);
                }
                if (CdmaDataConnectionTracker.this.mNoRecvPollCount < 24) {
                    CdmaDataConnectionTracker.access$3108(CdmaDataConnectionTracker.this);
                    CdmaDataConnectionTracker.access$3202(CdmaDataConnectionTracker.this, 5000);
                } else {
                    CdmaDataConnectionTracker.access$3302(CdmaDataConnectionTracker.this, false);
                    CdmaDataConnectionTracker.this.stopNetStatPoll();
                    CdmaDataConnectionTracker.this.restartRadio();
                    EventLog.writeEvent(50102, 24);
                }
            } else {
                CdmaDataConnectionTracker.access$3402(CdmaDataConnectionTracker.this, 0);
                CdmaDataConnectionTracker.access$3502(CdmaDataConnectionTracker.this, 1000);
            }
            if (CdmaDataConnectionTracker.this.netStatPollEnabled) {
                CdmaDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, CdmaDataConnectionTracker.this.netStatPollPeriod);
            }
        }
    };
    private boolean noAutoAttach = false;

    static {
        mSupportedApnTypes = new String[]{"default", "mms", "dun", "hipri"};
        mDefaultApnTypes = new String[]{"default", "mms", "hipri"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CdmaDataConnectionTracker(CDMAPhone cDMAPhone) {
        super(cDMAPhone);
        this.LOG_TAG = "CDMA";
        this.mCdmaPhone = cDMAPhone;
        cDMAPhone.mCM.registerForAvailable(this, 3, null);
        cDMAPhone.mCM.registerForOffOrNotAvailable(this, 12, null);
        cDMAPhone.mRuimRecords.registerForRecordsLoaded(this, 4, null);
        cDMAPhone.mCM.registerForNVReady(this, 31, null);
        cDMAPhone.mCM.registerForDataStateChanged(this, 6, null);
        cDMAPhone.mCT.registerForVoiceCallEnded(this, 15, null);
        cDMAPhone.mCT.registerForVoiceCallStarted(this, 14, null);
        cDMAPhone.mSST.registerForCdmaDataConnectionAttached(this, 5, null);
        cDMAPhone.mSST.registerForCdmaDataConnectionDetached(this, 30, null);
        cDMAPhone.mSST.registerForRoamingOn(this, 21, null);
        cDMAPhone.mSST.registerForRoamingOff(this, 22, null);
        cDMAPhone.mCM.registerForCdmaOtaProvision(this, 35, null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(INTENT_RECONNECT_ALARM);
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        cDMAPhone.getContext().registerReceiver(this.mIntentReceiver, intentFilter, null, cDMAPhone);
        this.mDataConnectionTracker = this;
        this.createAllDataConnectionList();
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        boolean bl = true;
        try {
            boolean bl2;
            bl = bl2 = IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")).getMobileDataEnabled();
        }
        catch (Exception exception) {}
        boolean[] blArray = this.dataEnabled;
        boolean bl3 = !sharedPreferences.getBoolean("disabled_on_boot_key", false) && bl;
        blArray[0] = bl3;
        if (this.dataEnabled[0]) {
            this.enabledCount = 1 + this.enabledCount;
        }
        boolean bl4 = !this.dataEnabled[0];
        this.noAutoAttach = bl4;
        if (!this.mRetryMgr.configure(SystemProperties.get("ro.cdma.data_retry_config")) && !this.mRetryMgr.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
            Log.e("CDMA", "Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
            this.mRetryMgr.configure(20, 2000, 1000);
        }
    }

    static /* synthetic */ boolean access$002(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsScreenOn = bl;
        return bl;
    }

    static /* synthetic */ long access$1002(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.rxPkts = l;
        return l;
    }

    static /* synthetic */ long access$1402(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1614(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        long l2;
        cdmaDataConnectionTracker.sentSinceLastRecv = l2 = l + cdmaDataConnectionTracker.sentSinceLastRecv;
        return l2;
    }

    static /* synthetic */ long access$1702(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$1802(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ long access$2102(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.sentSinceLastRecv = l;
        return l;
    }

    static /* synthetic */ DataConnectionTracker.Activity access$2502(CdmaDataConnectionTracker cdmaDataConnectionTracker, DataConnectionTracker.Activity activity) {
        cdmaDataConnectionTracker.activity = activity;
        return activity;
    }

    static /* synthetic */ int access$3108(CdmaDataConnectionTracker cdmaDataConnectionTracker) {
        int n = cdmaDataConnectionTracker.mNoRecvPollCount;
        cdmaDataConnectionTracker.mNoRecvPollCount = n + 1;
        return n;
    }

    static /* synthetic */ int access$3202(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$3302(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.netStatPollEnabled = bl;
        return bl;
    }

    static /* synthetic */ int access$3402(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.mNoRecvPollCount = n;
        return n;
    }

    static /* synthetic */ int access$3502(CdmaDataConnectionTracker cdmaDataConnectionTracker, int n) {
        cdmaDataConnectionTracker.netStatPollPeriod = n;
        return n;
    }

    static /* synthetic */ boolean access$502(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(CdmaDataConnectionTracker cdmaDataConnectionTracker, boolean bl) {
        cdmaDataConnectionTracker.mIsWifiConnected = bl;
        return bl;
    }

    static /* synthetic */ long access$902(CdmaDataConnectionTracker cdmaDataConnectionTracker, long l) {
        cdmaDataConnectionTracker.txPkts = l;
        return l;
    }

    private void cleanUpConnection(boolean bl, String string2) {
        if (this.mReconnectIntent != null) {
            ((AlarmManager)this.phone.getContext().getSystemService("alarm")).cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        boolean bl2 = false;
        for (DataConnection dataConnection : this.dataConnectionList) {
            if (dataConnection == null) continue;
            if (bl) {
                dataConnection.disconnect(this.obtainMessage(25, string2));
                bl2 = true;
                continue;
            }
            dataConnection.resetSynchronously();
            bl2 = false;
        }
        this.stopNetStatPoll();
        if (!bl2) {
            this.gotoIdleAndNotifyDataConnection(string2);
        }
    }

    private void createAllDataConnectionList() {
        this.dataConnectionList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            CdmaDataConnection cdmaDataConnection = CdmaDataConnection.makeDataConnection(this.mCdmaPhone);
            this.dataConnectionList.add(cdmaDataConnection);
        }
    }

    private void destroyAllDataConnectionList() {
        if (this.dataConnectionList != null) {
            this.dataConnectionList.removeAll(this.dataConnectionList);
        }
    }

    private CdmaDataConnection findFreeDataConnection() {
        for (CdmaDataConnection cdmaDataConnection : this.dataConnectionList) {
            if (!cdmaDataConnection.isInactive()) continue;
            return cdmaDataConnection;
        }
        return null;
    }

    private void gotoIdleAndNotifyDataConnection(String string2) {
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
    }

    private boolean isDataAllowed() {
        boolean bl = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!bl || this.getDataOnRoamingEnabled()) && this.mMasterDataEnabled;
    }

    private void notifyDefaultData(String string2) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(string2);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
    }

    private void notifyNoData(DataConnection.FailCause failCause) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onCdmaDataDetached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("cdmaDataDetached");
            return;
        }
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, "cdmaDataDetached");
            this.mRetryMgr.resetRetryCount();
            CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)this.phone.getCellLocation();
            Object[] objectArray = new Object[2];
            int n = cdmaCellLocation != null ? cdmaCellLocation.getBaseStationId() : -1;
            objectArray[0] = n;
            objectArray[1] = TelephonyManager.getDefault().getNetworkType();
            EventLog.writeEvent(50110, objectArray);
        }
        this.trySetupData("cdmaDataDetached");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onCdmaOtaProvision(AsyncResult asyncResult) {
        int[] nArray;
        if (asyncResult.exception == null || (nArray = (int[])asyncResult.result) == null || nArray.length <= 1) return;
        switch (nArray[0]) {
            default: {
                return;
            }
            case 8: 
            case 10: 
        }
        this.mRetryMgr.resetRetryCount();
    }

    private void onRestartRadio() {
        if (this.mPendingRestartRadio) {
            Log.d("CDMA", "************TURN OFF RADIO**************");
            this.phone.mCM.setRadioPower(false, null);
            this.mPendingRestartRadio = false;
        }
    }

    private void reconnectAfterFail(DataConnection.FailCause failCause, String string2) {
        block3: {
            block2: {
                if (this.state != DataConnectionTracker.State.FAILED) break block2;
                int n = this.mRetryMgr.getRetryTimer();
                Log.d("CDMA", "Data Connection activate failed. Scheduling next attempt for " + n / 1000 + "s");
                AlarmManager alarmManager = (AlarmManager)this.phone.getContext().getSystemService("alarm");
                Intent intent = new Intent(INTENT_RECONNECT_ALARM);
                intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, string2);
                this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
                alarmManager.set(2, SystemClock.elapsedRealtime() + (long)n, this.mReconnectIntent);
                this.mRetryMgr.increaseRetryCount();
                if (this.shouldPostNotification(failCause)) break block3;
                Log.d("CDMA", "NOT Posting Data Connection Unavailable notification -- likely transient error");
            }
            return;
        }
        this.notifyNoData(failCause);
    }

    private void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    private boolean retryAfterDisconnected(String string2) {
        boolean bl = true;
        if ("radioTurnedOff".equals(string2)) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupData(String string2) {
        CdmaDataConnection cdmaDataConnection = this.findFreeDataConnection();
        if (cdmaDataConnection == null) {
            return false;
        }
        this.mActiveDataConnection = cdmaDataConnection;
        String[] stringArray = this.mRequestedApnType.equals("dun") ? new String[]{"dun"} : mDefaultApnTypes;
        this.mActiveApn = new ApnSetting(0, "", "", "", "", "", "", "", "", "", "", 0, stringArray);
        Message message = this.obtainMessage();
        message.what = 1;
        message.obj = string2;
        cdmaDataConnection.connect(message, this.mActiveApn);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(string2);
        return true;
    }

    private boolean shouldPostNotification(DataConnection.FailCause failCause) {
        return failCause != DataConnection.FailCause.UNKNOWN;
    }

    private void startDelayedRetry(DataConnection.FailCause failCause, String string2) {
        this.notifyNoData(failCause);
        this.reconnectAfterFail(failCause, string2);
    }

    private boolean trySetupData(String string2) {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(string2);
            Log.i("CDMA", "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int n = this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState();
        this.phone.getServiceState().getRoaming();
        boolean bl = this.mCdmaPhone.mSST.getDesiredPowerState();
        if (!(this.state != DataConnectionTracker.State.IDLE && this.state != DataConnectionTracker.State.SCANNING || n != 0 || this.phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && !this.mCdmaPhone.mRuimRecords.getRecordsLoaded() || !this.mCdmaPhone.mSST.isConcurrentVoiceAndData() && this.phone.getState() != Phone.State.IDLE || !this.isDataAllowed() || !bl || this.mPendingRestartRadio || this.mCdmaPhone.needsOtaServiceProvisioning())) {
            return this.setupData(string2);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeEventLogCdmaDataDrop() {
        CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)this.phone.getCellLocation();
        Object[] objectArray = new Object[2];
        int n = cdmaCellLocation != null ? cdmaCellLocation.getBaseStationId() : -1;
        objectArray[0] = n;
        objectArray[1] = TelephonyManager.getDefault().getNetworkType();
        EventLog.writeEvent(50111, objectArray);
    }

    @Override
    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mCdmaPhone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForNVReady(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionAttached(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionDetached(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOn(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOff(this);
        this.phone.mCM.unregisterForCdmaOtaProvision(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.destroyAllDataConnectionList();
    }

    protected void finalize() {
    }

    @Override
    protected String getActiveApnString() {
        return null;
    }

    @Override
    protected String[] getActiveApnTypes() {
        if (this.mActiveApn != null) {
            return this.mActiveApn.types;
        }
        return new String[]{"default"};
    }

    @Override
    public ArrayList<DataConnection> getAllDataConnections() {
        return this.dataConnectionList;
    }

    @Override
    protected String[] getDnsServers(String string2) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getDnsServers();
        }
        return null;
    }

    @Override
    protected String getGateway(String string2) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getGatewayAddress();
        }
        return null;
    }

    @Override
    protected String getInterfaceName(String string2) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getInterface();
        }
        return null;
    }

    @Override
    protected String getIpAddress(String string2) {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getIpAddress();
        }
        return null;
    }

    @Override
    public void handleMessage(Message message) {
        if (!this.phone.mIsTheCurrentActivePhone) {
            Log.d("CDMA", "Ignore CDMA msgs since CDMA phone is inactive");
            return;
        }
        switch (message.what) {
            default: {
                super.handleMessage(message);
                return;
            }
            case 4: {
                this.onRecordsLoaded();
                return;
            }
            case 31: {
                this.onNVReady();
                return;
            }
            case 30: {
                this.onCdmaDataDetached();
                return;
            }
            case 6: {
                this.onDataStateChanged((AsyncResult)message.obj);
                return;
            }
            case 35: {
                this.onCdmaOtaProvision((AsyncResult)message.obj);
                return;
            }
            case 36: 
        }
        this.onRestartRadio();
    }

    @Override
    protected boolean isApnTypeActive(String string2) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(string2);
    }

    @Override
    protected boolean isApnTypeAvailable(String string2) {
        String[] stringArray = mSupportedApnTypes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.equals(string2, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean bl = this.phone.getServiceState().getRoaming();
        if (!(this.phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && !this.mCdmaPhone.mRuimRecords.getRecordsLoaded() || this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState() != 0 || bl && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    protected void log(String string2) {
        Log.d("CDMA", "[CdmaDataConnectionTracker] " + string2);
    }

    @Override
    protected void onCleanUpConnection(boolean bl, String string2) {
        this.cleanUpConnection(bl, string2);
    }

    @Override
    protected void onDataSetupComplete(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        if (asyncResult.exception == null) {
            this.notifyDefaultData(string2);
            return;
        }
        DataConnection.FailCause failCause = (DataConnection.FailCause)((Object)asyncResult.result);
        if (failCause.isPermanentFail()) {
            this.notifyNoData(failCause);
            return;
        }
        this.startDelayedRetry(failCause, string2);
    }

    protected void onDataStateChanged(AsyncResult asyncResult) {
        block9: {
            ArrayList arrayList = (ArrayList)asyncResult.result;
            if (asyncResult.exception != null) {
                return;
            }
            if (this.state != DataConnectionTracker.State.CONNECTED) break block9;
            int n = 0;
            int n2 = 0;
            while (true) {
                block11: {
                    boolean bl;
                    block10: {
                        int n3 = arrayList.size();
                        bl = false;
                        if (n2 >= n3) break block10;
                        n = ((DataCallState)arrayList.get((int)n2)).active;
                        if (n == 0) break block11;
                        bl = true;
                    }
                    if (bl) break;
                    Log.i("CDMA", "onDataStateChanged: No active connectionstate is CONNECTED, disconnecting/cleanup");
                    this.writeEventLogCdmaDataDrop();
                    this.cleanUpConnection(true, null);
                    return;
                }
                ++n2;
            }
            switch (n) {
                default: {
                    Log.v("CDMA", "onDataStateChanged: IGNORE unexpected DataCallState.active=" + n);
                    return;
                }
                case 2: {
                    Log.v("CDMA", "onDataStateChanged: active=LINK_ACTIVE && CONNECTED, ignore");
                    this.activity = DataConnectionTracker.Activity.NONE;
                    this.phone.notifyDataActivity();
                    this.startNetStatPoll();
                    return;
                }
                case 1: 
            }
            Log.v("CDMA", "onDataStateChanged active=LINK_DOWN && CONNECTED, dormant");
            this.activity = DataConnectionTracker.Activity.DORMANT;
            this.phone.notifyDataActivity();
            this.stopNetStatPoll();
            return;
        }
        Log.i("CDMA", "onDataStateChanged: not connected, state=" + (Object)((Object)this.state) + " ignoring");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDisconnectDone(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        if (this.mPendingRestartRadio) {
            this.removeMessages(36);
        }
        if (this.mCdmaPhone.mSST.processPendingRadioPowerOffAfterDataOff()) {
            this.mPendingRestartRadio = false;
        } else {
            this.onRestartRadio();
        }
        this.phone.notifyDataConnection(string2);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(string2)) {
            this.trySetupData(string2);
        }
    }

    @Override
    protected void onEnableNewApn() {
        this.cleanUpConnection(true, "apnSwitched");
    }

    protected void onNVReady() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5));
    }

    @Override
    protected void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i("CDMA", "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    protected void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i("CDMA", "We're on the simulator; assuming radio off is meaningless");
            return;
        }
        this.cleanUpConnection(false, "radioTurnedOff");
    }

    protected void onRecordsLoaded() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    @Override
    protected void onResetDone(AsyncResult asyncResult) {
        boolean bl = asyncResult.userObj instanceof String;
        String string2 = null;
        if (bl) {
            string2 = (String)asyncResult.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(string2);
    }

    @Override
    protected void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    protected void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
            return;
        }
        this.cleanUpConnection(true, "roamingOn");
    }

    @Override
    protected boolean onTrySetupData(String string2) {
        return this.trySetupData(string2);
    }

    @Override
    protected void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
                return;
            }
            this.resetPollStats();
            return;
        }
        this.mRetryMgr.resetRetryCount();
        this.trySetupData("2GVoiceCallEnded");
    }

    @Override
    protected void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    protected void restartRadio() {
        this.cleanUpConnection(true, "radioTurnedOff");
        this.sendEmptyMessageDelayed(36, TIME_DELAYED_TO_RESTART_RADIO);
        this.mPendingRestartRadio = true;
    }

    @Override
    protected void setState(DataConnectionTracker.State state) {
        if (this.state != state) {
            Object[] objectArray = new Object[]{this.state.toString(), state.toString()};
            EventLog.writeEvent(50115, objectArray);
            this.state = state;
        }
    }

    @Override
    protected void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.netStatPollEnabled) {
            Log.d("CDMA", "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    protected void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d("CDMA", "[DataConnection] Stop poll NetStat");
    }
}

